/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimestampWithTimezone {
    private static final TimeZone DEFAULT_TZ = TimeZone.getDefault();
    private static final Calendar CALENDAR = Calendar.getInstance();
    private static final int NANO_DIGITS = 9;

    public static Timestamp createTimestamp(Date date, TimeZone initial, Calendar target) {
        if (target == null) {
            target = Calendar.getInstance();
        }
        long time = target.getTimeInMillis();
        TimestampWithTimezone.adjustCalendar(date, initial, target);
        Timestamp tsInTz = new Timestamp(target.getTimeInMillis());
        if (date instanceof Timestamp) {
            tsInTz.setNanos(((Timestamp)date).getNanos());
        }
        target.setTimeInMillis(time);
        return tsInTz;
    }

    public static Time createTime(Date date, TimeZone initial, Calendar target) {
        if (target == null) {
            target = Calendar.getInstance();
        }
        long time = target.getTimeInMillis();
        TimestampWithTimezone.adjustCalendar(date, initial, target);
        target.set(1, 1970);
        target.set(2, 0);
        target.set(5, 1);
        Time result = new Time(target.getTimeInMillis());
        target.setTimeInMillis(time);
        return result;
    }

    public static Time createTime(Date date) {
        return TimestampWithTimezone.createTime(date, DEFAULT_TZ, null);
    }

    public static java.sql.Date createDate(Date date) {
        return TimestampWithTimezone.createDate(date, DEFAULT_TZ, null);
    }

    public static java.sql.Date createDate(Date date, TimeZone initial, Calendar target) {
        if (target == null) {
            target = Calendar.getInstance();
        }
        long time = target.getTimeInMillis();
        TimestampWithTimezone.adjustCalendar(date, initial, target);
        target.set(11, 0);
        target.set(12, 0);
        target.set(13, 0);
        target.set(14, 0);
        java.sql.Date result = new java.sql.Date(target.getTimeInMillis());
        target.setTimeInMillis(time);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void adjustCalendar(Date date, TimeZone initial, Calendar target) {
        if (initial == null) {
            initial = DEFAULT_TZ;
        }
        long time = date.getTime();
        time -= (long)Math.max((int)(time % 1000L), 0);
        if (!initial.equals(target.getTimeZone())) {
            Calendar calendar = CALENDAR;
            synchronized (calendar) {
                CALENDAR.setTimeZone(initial);
                CALENDAR.setTimeInMillis(time);
                for (int i = 0; i <= 14; ++i) {
                    target.set(i, CALENDAR.get(i));
                }
            }
        } else {
            target.setTimeInMillis(time);
        }
    }

    public static Timestamp parseTimestampWithTimezone(String inStr) throws ParseException {
        int lastSpace = inStr.lastIndexOf(32);
        if (lastSpace < 0) {
            throw new ParseException(inStr, lastSpace);
        }
        String tzOffset = inStr.substring(lastSpace + 1);
        int nanos = 0;
        int decimalIndex = inStr.lastIndexOf(".", lastSpace);
        if (decimalIndex >= 0) {
            String partialSeconds = inStr.substring(decimalIndex + 1, lastSpace);
            nanos = TimestampWithTimezone.parseNanos(partialSeconds.trim());
        } else {
            decimalIndex = lastSpace;
        }
        TimeZone tz = TimestampWithTimezone.parseTimezoneOffset(tzOffset);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        df.setTimeZone(tz);
        Timestamp ts = new Timestamp(df.parse(inStr.substring(0, decimalIndex)).getTime());
        ts.setNanos(nanos);
        return ts;
    }

    private static TimeZone parseTimezoneOffset(String tzOffset) {
        return TimeZone.getTimeZone("GMT" + tzOffset);
    }

    private static int parseNanos(String partialSeconds) {
        int digits = partialSeconds.length();
        int rawValue = Integer.parseInt(partialSeconds);
        return (int)((double)rawValue * Math.pow(10.0, 9 - digits));
    }
}

