/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log.format;

import com.metamatrix.api.exception.MetaMatrixExceptionUtil;
import com.metamatrix.common.log.LogMessage;
import com.metamatrix.common.log.format.LogMessageFormat;
import com.metamatrix.core.util.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class DelimitedLogMessageFormat
implements LogMessageFormat {
    public static final String TIMESTAMP_FORMAT = "yyyy.MM.dd HH:mm:ss.SSS";
    private static DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
    private static final String DEFAULT_FORMATTED_MESSAGE = "";
    private static final char DELIMITER_CHAR = '|';

    public String formatMessage(LogMessage message) {
        if (message == null) {
            return DEFAULT_FORMATTED_MESSAGE;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(DATE_FORMATTER.format(new Date(message.getTimestamp())));
        msg.append('|');
        msg.append(message.getHostName());
        msg.append('|');
        msg.append(message.getVMName());
        msg.append('|');
        msg.append(message.getThreadName());
        msg.append('|');
        msg.append(message.getContext());
        msg.append('|');
        msg.append(message.getMessageType());
        msg.append('|');
        msg.append(message.getText());
        Throwable e = message.getException();
        if (e != null) {
            StringWriter strWriter = new StringWriter();
            PrintWriter strPrinter = new PrintWriter((Writer)strWriter, true);
            e.printStackTrace(strPrinter);
            msg.append(StringUtil.getLineSeparator());
            msg.append(strWriter);
            Iterator children = MetaMatrixExceptionUtil.getChildrenIterator(e);
            while (children.hasNext()) {
                e = (Throwable)children.next();
                strWriter = new StringWriter();
                strPrinter = new PrintWriter((Writer)strWriter, true);
                e.printStackTrace(strPrinter);
                msg.append(StringUtil.getLineSeparator());
                msg.append(strWriter);
            }
        }
        return msg.toString();
    }
}

