/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseSQLScanner;
import com.metamatrix.jdbc.base.BaseSQLToken;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSExecuteRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCParameter;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.SQLException;

public class SQLServerCallAnalyzer {
    private static String footprint = "$Revision:   3.5.2.0  $";
    public BaseExceptions exceptions;
    private BaseSQL sql;
    UtilVectorUnsynced userParameters;
    boolean ignoreReturnParam;
    TDSConnection conn;
    SQLServerByteOrderedDataReader reader;
    SQLServerByteOrderedDataWriter writer;
    TDSExecuteRequest request;
    static final int SQL_PARAM_TYPE_UNKNOWN = 0;
    static final int SQL_PARAM_TYPE_INPUT = 1;
    static final int SQL_PARAM_TYPE_OUTPUT = 2;
    static final int SQL_RESULT_COL = 3;
    static final int SQL_PARAM_OUTPUT = 4;
    static final int SQL_RETURN_VALUE = 5;

    public SQLServerCallAnalyzer(BaseExceptions baseExceptions, TDSConnection tDSConnection, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter, BaseSQL baseSQL, UtilVectorUnsynced utilVectorUnsynced, boolean bl) {
        this.exceptions = baseExceptions;
        this.conn = tDSConnection;
        this.reader = sQLServerByteOrderedDataReader;
        this.writer = sQLServerByteOrderedDataWriter;
        this.sql = baseSQL;
        this.userParameters = utilVectorUnsynced;
        this.ignoreReturnParam = bl;
    }

    protected void describeOuputParams() throws SQLException {
        String string = "";
        try {
            BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
            int n = 1;
            int n2 = 10;
            int n3 = 0;
            boolean bl = false;
            baseSQLScanner.setup(this.sql.getFormatted(), '\'', '\"');
            while (n != 12 && n != 11) {
                BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
                if (baseSQLToken.type == 17) continue;
                switch (n) {
                    case 1: {
                        if (baseSQLToken.type == 9 && (baseSQLToken.value.equalsIgnoreCase("execute") || baseSQLToken.value.equalsIgnoreCase("exec"))) {
                            n2 = 1;
                            n = 2;
                            break;
                        }
                        if (baseSQLToken.type == 9 && baseSQLToken.value.equalsIgnoreCase("dd_exec")) {
                            baseSQLToken.value = "exec";
                            n2 = 1;
                            n = 2;
                            break;
                        }
                        if (baseSQLToken.type == 8) {
                            n2 = 5;
                            n = 1;
                            break;
                        }
                        n2 = 10;
                        n = 1;
                        break;
                    }
                    case 2: {
                        if (baseSQLToken.type == 9 || baseSQLToken.type == 4) {
                            n2 = 8;
                            n = 5;
                            break;
                        }
                        if (baseSQLToken.type == 8) {
                            n2 = 6;
                            n = 3;
                            break;
                        }
                        n2 = 10;
                        n = 11;
                        break;
                    }
                    case 3: {
                        if (baseSQLToken.type == 7) {
                            n2 = 10;
                            n = 4;
                            break;
                        }
                        n2 = 10;
                        n = 11;
                        break;
                    }
                    case 4: {
                        if (baseSQLToken.type == 9 || baseSQLToken.type == 4) {
                            n2 = 8;
                            n = 5;
                            break;
                        }
                        n2 = 10;
                        n = 11;
                        break;
                    }
                    case 5: {
                        if (baseSQLToken.type == 6) {
                            n2 = 3;
                            n = 12;
                            break;
                        }
                        if (baseSQLToken.type == 9 && (baseSQLToken.value.equalsIgnoreCase("execute") || baseSQLToken.value.equalsIgnoreCase("exec"))) {
                            n2 = 2;
                            n = 2;
                            break;
                        }
                        if (baseSQLToken.type == 5) {
                            n2 = 8;
                            n = 6;
                            break;
                        }
                        if (baseSQLToken.type == 15) {
                            n2 = 8;
                            n = 7;
                            break;
                        }
                        if (baseSQLToken.type == 8) {
                            n2 = 4;
                            n = 9;
                            break;
                        }
                        n2 = 3;
                        n = 10;
                        break;
                    }
                    case 6: {
                        if (baseSQLToken.type == 9 || baseSQLToken.type == 4) {
                            n2 = 8;
                            n = 5;
                            break;
                        }
                        if (baseSQLToken.type == 5) {
                            n2 = 8;
                            n = 6;
                            break;
                        }
                        n2 = 10;
                        n = 11;
                        break;
                    }
                    case 7: {
                        if (baseSQLToken.type == 16) {
                            n2 = 7;
                            n = 8;
                            break;
                        }
                        n2 = 10;
                        n = 11;
                        break;
                    }
                    case 8: {
                        if (baseSQLToken.type == 6) {
                            n2 = 3;
                            n = 12;
                            break;
                        }
                        if (baseSQLToken.type == 9 && (baseSQLToken.value.equalsIgnoreCase("execute") || baseSQLToken.value.equalsIgnoreCase("exec"))) {
                            n2 = 2;
                            n = 2;
                            break;
                        }
                        if (baseSQLToken.type == 8) {
                            n2 = 4;
                            n = 9;
                            break;
                        }
                        n2 = 3;
                        n = 10;
                        break;
                    }
                    case 9: {
                        if (baseSQLToken.type == 6) {
                            n2 = 10;
                            n = 12;
                            break;
                        }
                        if (baseSQLToken.type == 9 && (baseSQLToken.value.equalsIgnoreCase("execute") || baseSQLToken.value.equalsIgnoreCase("exec"))) {
                            n2 = 1;
                            n = 2;
                            break;
                        }
                        n2 = 10;
                        n = 10;
                        break;
                    }
                    case 10: {
                        if (baseSQLToken.type == 6) {
                            n2 = 10;
                            n = 12;
                            break;
                        }
                        if (baseSQLToken.type == 9 && (baseSQLToken.value.equalsIgnoreCase("execute") || baseSQLToken.value.equalsIgnoreCase("exec"))) {
                            n2 = 1;
                            n = 2;
                            break;
                        }
                        if (baseSQLToken.type == 8) {
                            n2 = 9;
                            n = 9;
                            break;
                        }
                        n2 = 10;
                        n = 10;
                    }
                }
                switch (n2) {
                    case 1: {
                        bl = false;
                        string = "";
                        if (this.request == null) break;
                        this.request.discardReplyBytes();
                        this.request = null;
                        break;
                    }
                    case 2: {
                        this.queryBackendForParamDescriptions(string);
                        if (!this.ignoreReturnParam && bl) {
                            this.setParamType(n3);
                        } else {
                            this.skipRow();
                        }
                        string = "";
                        if (this.request == null) break;
                        this.request.discardReplyBytes();
                        this.request = null;
                        break;
                    }
                    case 3: {
                        this.queryBackendForParamDescriptions(string);
                        if (!this.ignoreReturnParam && bl) {
                            this.setParamType(n3);
                            break;
                        }
                        this.skipRow();
                        break;
                    }
                    case 4: {
                        this.queryBackendForParamDescriptions(string);
                        if (!this.ignoreReturnParam && bl) {
                            this.setParamType(n3);
                        } else {
                            this.skipRow();
                        }
                        this.setParamType(++n3);
                        break;
                    }
                    case 5: {
                        ++n3;
                        break;
                    }
                    case 6: {
                        if (!this.ignoreReturnParam) {
                            ++n3;
                        }
                        bl = true;
                        break;
                    }
                    case 7: {
                        try {
                            Integer.parseInt(baseSQLToken.value);
                            string = string + baseSQLToken.value;
                        }
                        catch (Exception exception) {
                            n = 11;
                        }
                        break;
                    }
                    case 8: {
                        string = string + baseSQLToken.value;
                        break;
                    }
                    case 9: {
                        this.setParamType(++n3);
                        break;
                    }
                }
            }
            if (this.request != null) {
                this.request.discardReplyBytes();
                this.request = null;
            }
        }
        catch (SQLException sQLException) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(sQLException, 0, 7021, stringArray);
        }
    }

    private void queryBackendForParamDescriptions(String string) throws SQLException {
        this.request = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        this.request.setSQL("sp_sproc_columns @procedure_name = '" + string + "'");
        this.request.submitRequest(null);
        this.request.processReply(1, null);
    }

    private void skipRow() throws SQLException {
        this.request.getRow(null);
    }

    private void setParamType(int n) throws SQLException {
        boolean bl = this.request.getRow(null);
        if (bl) {
            this.request.getColumnDataForRow(7, 10);
            int n2 = this.request.getColumn((int)5).data.getIntegerNoConvert();
            if (n2 == 5 || n2 == 2) {
                TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.userParameters.get(n - 1);
                tDSRPCParameter.serverReportedNativeType = this.request.getColumn((int)7).data.getStringNoConvert();
            }
        }
    }

    class ParameterInfo {
        public boolean returnParameter;
        public String nativeTypeName;
        public int callOrdinal;
        public String callName;

        public ParameterInfo(boolean bl, String string, int n, String string2) {
            this.returnParameter = bl;
            this.nativeTypeName = string;
            this.callOrdinal = n;
            this.callName = string2;
        }
    }
}

