/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BasePreparedStatement;
import com.metamatrix.jdbc.base.BaseResultSetFilterDescriptor;
import com.metamatrix.jdbc.base.BaseResultSetSortDescriptor;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.BatchUpdateException;
import java.sql.SQLException;

public abstract class BaseImplStatement {
    private static String footprint = "$Revision:   3.24.1.1  $";
    public static final int RESULT_TYPE_UNKNOWN = 0;
    public static final int RESULT_NO_MORE_RESULTS = 1;
    public static final int RESULT_RESULTSET = 2;
    public static final int RESULT_ROWS_AFFECTED = 3;
    public BaseImplConnection implConnection;
    protected BaseEscapeTranslator escapeTranslator;
    public BasePreparedStatement pstmt = null;
    protected BaseWarnings warnings;
    protected BaseSQL sql;
    protected UtilVectorUnsynced parameterSets;
    protected static final int PREPARE_EXECUTE_NORMAL = 0;
    protected static final int PREPARE_EXECUTE_GENERATE_KEYSET = 1;
    protected static final int PREPARE_EXECUTE_FOR_ONE_ROW_FETCH = 2;
    protected int prepareExecuteMode = 0;
    protected int fetchSize = 0;
    protected int maxFieldSize = 0;
    protected int maxRows = 0;
    protected int longDataCacheSize;
    public int databaseMetaDataResultSet;
    public BaseResultSetFilterDescriptor filterDescriptor;
    public BaseResultSetSortDescriptor sortDescriptor;
    protected boolean autoGeneratedKeysRequested = false;
    protected String[] requestedKeyColumns = null;
    protected BaseColumns requestedKeyColumnDescriptions = null;
    public static final int CANCEL_TYPE_CANCEL = 0;
    public static final int CANCEL_TYPE_QUERY_TIMEOUT = 1;

    public BaseSQL getSql() {
        return this.sql;
    }

    public void setup(BaseImplConnection baseImplConnection, BaseWarnings baseWarnings) {
        this.implConnection = baseImplConnection;
        this.warnings = baseWarnings;
    }

    public void addWarning(int n, String string, int n2) {
        this.warnings.add(n, string, n2);
    }

    protected void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setLongDataCacheSize(int n) throws SQLException {
        this.longDataCacheSize = n;
        if (this.longDataCacheSize != -1) {
            this.longDataCacheSize *= 1024;
        }
    }

    public int getLongDataCacheSize() {
        return this.longDataCacheSize;
    }

    protected void setSQL(BaseSQL baseSQL) throws SQLException {
        this.sql = baseSQL;
    }

    protected final void setEscapeTranslator(BaseEscapeTranslator baseEscapeTranslator) {
        this.escapeTranslator = baseEscapeTranslator;
    }

    protected final void setupDatabaseMetaDataResultSet(int n, BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        this.databaseMetaDataResultSet = n;
        this.filterDescriptor = baseResultSetFilterDescriptor;
        this.sortDescriptor = baseResultSetSortDescriptor;
    }

    public void prepare() throws SQLException {
    }

    public void prepare(BaseParameters baseParameters) throws SQLException {
        this.prepare();
    }

    protected final void setParameters(UtilVectorUnsynced utilVectorUnsynced) {
        this.parameterSets = utilVectorUnsynced;
    }

    public int getRequiredSQLProcessing(String string) {
        return 4;
    }

    public boolean useStatementConcatenationForBatchEmulation(UtilVectorUnsynced utilVectorUnsynced) {
        return false;
    }

    public char getStatementSeparator() {
        return ' ';
    }

    public boolean supportsBatchStatements() {
        return false;
    }

    public boolean supportsBatchParameters() {
        return false;
    }

    public boolean supportsUpdates() {
        return false;
    }

    public boolean supportsScrolling(int n) {
        return false;
    }

    public String getRowIdColumnName() {
        return null;
    }

    public abstract void execute() throws SQLException;

    public void executeBatch() throws SQLException, BatchUpdateException {
    }

    public abstract int getNextResultType() throws SQLException;

    public abstract BaseColumns describeColumns(BaseColumns var1) throws SQLException;

    public BaseColumns describeAutoGeneratedKeyColumns() throws SQLException {
        return null;
    }

    public void describeParameters(BaseParameters baseParameters) throws SQLException {
    }

    public void getOutParameterData() throws SQLException {
    }

    public int getNextResultSetType() {
        return 0;
    }

    public abstract BaseImplResultSet getNextResultSet() throws SQLException;

    public BaseImplResultSet getNextResultSet(int n) throws SQLException {
        return this.getNextResultSet();
    }

    public BaseImplResultSet getAutoGeneratedKeyResultSet() throws SQLException {
        return null;
    }

    public void setupNextResultSet(BaseImplResultSet baseImplResultSet) throws SQLException {
    }

    public void setupNextResultSet(int n, BaseImplResultSet baseImplResultSet) throws SQLException {
        this.setupNextResultSet(baseImplResultSet);
    }

    public abstract int getNextRowsAffectedCount() throws SQLException;

    public int[] getBatchRowsAffectedCount() throws SQLException {
        return null;
    }

    public void cancel() throws SQLException {
    }

    public void cancel(int n) throws SQLException {
        this.cancel();
    }

    public boolean cancelWithStatus(int n) throws SQLException {
        this.cancel(n);
        return true;
    }

    public void processCancelResponse() throws SQLException {
    }

    public abstract void close() throws SQLException;

    public void reset() throws SQLException {
    }

    public void setQueryTimeout(int n) throws SQLException {
    }
}

