/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseDriverPropertyInfos;
import com.metamatrix.jdbc.base.BaseExceptions;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public class BaseConnectionProperties {
    private static String footprint = "$Revision:   3.6.1.0  $";
    private Properties props = new Properties();
    private boolean debugPropsLoaded;

    public BaseConnectionProperties copy() {
        BaseConnectionProperties baseConnectionProperties = new BaseConnectionProperties();
        baseConnectionProperties.props = (Properties)this.props.clone();
        return baseConnectionProperties;
    }

    public int size() {
        return this.props.size();
    }

    public void put(String string, String string2) {
        try {
            String string3 = string.toUpperCase();
            this.props.put(string3.trim(), string2.trim());
        }
        catch (NullPointerException nullPointerException) {}
    }

    public String get(String string) {
        if (!this.debugPropsLoaded) {
            this.loadDebugProps();
        }
        String string2 = string.toUpperCase();
        return (String)this.props.get(string2);
    }

    public void putDefaults(BaseDriverPropertyInfos baseDriverPropertyInfos) {
        int n = baseDriverPropertyInfos.size();
        int n2 = 0;
        while (n2 < n) {
            DriverPropertyInfo driverPropertyInfo = baseDriverPropertyInfos.get(n2);
            this.put(driverPropertyInfo.name, driverPropertyInfo.value);
            ++n2;
        }
    }

    public void validate(BaseDriverPropertyInfos baseDriverPropertyInfos, BaseExceptions baseExceptions) throws SQLException {
        int n = baseDriverPropertyInfos.size();
        int n2 = 0;
        while (n2 < n) {
            String string;
            DriverPropertyInfo driverPropertyInfo = baseDriverPropertyInfos.get(n2);
            String string2 = driverPropertyInfo.name;
            if (driverPropertyInfo.required && ((string = this.get(driverPropertyInfo.name)) == null || string.length() == 0)) {
                String[] stringArray = new String[]{driverPropertyInfo.name};
                throw baseExceptions.getException(6097, stringArray, "08001");
            }
            if (driverPropertyInfo.choices != null && (string = this.get(driverPropertyInfo.name)) != null) {
                boolean bl = false;
                int n3 = 0;
                while (n3 < driverPropertyInfo.choices.length) {
                    if (driverPropertyInfo.choices[n3].compareToIgnoreCase(string) == 0) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    String[] stringArray = new String[]{driverPropertyInfo.name + "=" + string};
                    throw baseExceptions.getException(6103, stringArray, "08001");
                }
            }
            ++n2;
        }
    }

    public void putUserSpecifed(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.put(string, string2);
        }
    }

    Enumeration propertyNames() {
        return this.props.propertyNames();
    }

    public Properties getSocketDebugProperties() {
        String string;
        if (!this.debugPropsLoaded) {
            this.loadDebugProps();
        }
        if ((string = this.get("ddtdbg.ProtocolTraceEnable")) != null && string.equalsIgnoreCase("true")) {
            Properties properties = new Properties();
            Enumeration<?> enumeration = this.props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.toUpperCase().startsWith("DDTDBG.PROTOCOLTRACE")) continue;
                String string3 = this.props.getProperty(string2);
                properties.put(string2, string3);
            }
            return properties;
        }
        return null;
    }

    private void loadDebugProps() {
        this.debugPropsLoaded = true;
        this.loadFileDebugProps();
        this.loadSystemDebugProps();
    }

    private void loadFileDebugProps() {
        String string = BaseConnectionProperties.getDebugAttrFileLocation();
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string + File.separator + "ddtdbg_attr.properties");
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            return;
        }
        this.setDebugProps(properties);
    }

    private void loadSystemDebugProps() {
        Properties properties = BaseConnectionProperties.getSystemProperties();
        if (properties != null) {
            this.setDebugProps(properties);
        }
    }

    private void setDebugProps(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.toUpperCase().startsWith("DDTDBG.")) continue;
            String string2 = properties.getProperty(string);
            this.put(string, string2);
        }
    }

    static Properties getSystemProperties() {
        Properties properties = null;
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        };
        try {
            properties = (Properties)AccessController.doPrivileged(privilegedAction);
        }
        catch (Exception exception) {}
        return properties;
    }

    static String getDebugAttrFileLocation() {
        String string = null;
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                String string = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
                boolean bl = false;
                int n = string.length();
                if (n > 4) {
                    String string2 = string.substring(n - 4, n);
                    bl = string2.equalsIgnoreCase(".jar");
                }
                int n2 = 0;
                if (System.getProperty("os.name").indexOf("Windows") != -1) {
                    n2 = 1;
                }
                int n3 = n;
                if (bl) {
                    n3 = string.lastIndexOf(47) + 1;
                }
                string = string.substring(n2, n3);
                if (!bl) {
                    String string3 = this.getClass().getPackage().getName();
                    string = string + string3.replace('.', '/');
                }
                return string;
            }
        };
        try {
            string = (String)AccessController.doPrivileged(privilegedAction);
        }
        catch (Throwable throwable) {}
        return string;
    }
}

