/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseBatchUpdateException;
import com.metamatrix.jdbc.slbase.BaseClassUtility;
import com.metamatrix.jdbc.slbase.BaseColumn;
import com.metamatrix.jdbc.slbase.BaseColumns;
import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbc.slbase.BaseEscapeTranslator;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseImplResultSet;
import com.metamatrix.jdbc.slbase.BaseImplResultSetClientSideEmpty;
import com.metamatrix.jdbc.slbase.BaseImplResultSetClientSideFilter;
import com.metamatrix.jdbc.slbase.BaseImplResultSetClientSideInsensitive;
import com.metamatrix.jdbc.slbase.BaseImplResultSetClientSideInsensitiveMemory;
import com.metamatrix.jdbc.slbase.BaseImplResultSetClientSideSensitive;
import com.metamatrix.jdbc.slbase.BaseImplResultSetClientSideSorter;
import com.metamatrix.jdbc.slbase.BaseImplResultSetClientSideUpdatable;
import com.metamatrix.jdbc.slbase.BaseImplResultSetService;
import com.metamatrix.jdbc.slbase.BaseImplStatement;
import com.metamatrix.jdbc.slbase.BaseQueryTimeoutEnforcer;
import com.metamatrix.jdbc.slbase.BaseResultSet;
import com.metamatrix.jdbc.slbase.BaseResultSetFilterDescriptor;
import com.metamatrix.jdbc.slbase.BaseResultSetSortDescriptor;
import com.metamatrix.jdbc.slbase.BaseSQL;
import com.metamatrix.jdbc.slbase.BaseTableTypes;
import com.metamatrix.jdbc.slbase.BaseTableTypesImplResultSet;
import com.metamatrix.jdbc.slbase.BaseTypeInfoImplResultSet;
import com.metamatrix.jdbc.slbase.BaseTypeInfos;
import com.metamatrix.jdbc.slbase.BaseWarnings;
import com.metamatrix.slutil.UtilVectorUnsynced;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Stack;

public class BaseStatement
implements Statement {
    BaseConnection connection;
    protected boolean nativeBatchExecute = false;
    protected BaseSQL batchSQL;
    protected BaseImplStatement implStatement;
    protected BaseEscapeTranslator escapeTranslator;
    protected static final int STATE_UNPREPARED = 1;
    protected static final int STATE_PREPARED = 2;
    protected static final int STATE_EXECUTED = 3;
    protected static final int STATE_CLOSED = 4;
    protected volatile int state = 1;
    protected static final int EXECUTE_STATE_IDLE = 1;
    protected static final int EXECUTE_STATE_EXECUTING = 2;
    protected int executeState = 1;
    protected static final int CS_NOT_SET = 0;
    protected static final int CS_READONLY = 1;
    protected static final int CS_NATIVE = 2;
    protected static final int CS_FRWK_ADD_ROWID = 3;
    protected static final int CS_FRWK_ALL_COLUMNS_IN_BASE_TABLE = 4;
    protected int concurrencyStrategy = 0;
    protected static final int SS_NOT_SET = 0;
    protected static final int SS_FORWARD_ONLY = 1;
    protected static final int SS_FRWK_INSENSITIVE = 2;
    protected static final int SS_NATIVE_INSENSITIVE = 3;
    protected static final int SS_FRWK_SENSITIVE_REPLACE_WITH_ROWID = 4;
    protected static final int SS_FRWK_SENSITIVE_ADD_ROWID = 5;
    protected static final int SS_NATIVE_SENSITIVE = 6;
    protected int scrollingStrategy = 0;
    private int numberOfColumnsInBaseTable = 0;
    private String tableSpecification;
    private String originalSelectList;
    int resultSetScrollType;
    int resultSetConcurrency;
    int resultSetFetchSize = 0;
    int fetchDirection = 1002;
    int maxRows = 0;
    int currentResultType = 1;
    final int ROWS_AFFECTED_UNINITIALIZED = -2;
    final int ROWS_AFFECTED_NONE = -1;
    int currentRowsAffectedCount = -2;
    Stack currentResultSets = new Stack();
    BaseColumns currentColumns;
    private boolean multipleResultsReturned = false;
    private int databaseMetaDataResultSet = 0;
    private boolean generateEmptyDatabaseMetaDataResultSet = false;
    private Object databaseMetaDataResultSetInfo;
    private int maxFieldSize = 0;
    protected BaseResultSetFilterDescriptor filterDescriptor;
    protected BaseResultSetSortDescriptor sortDescriptor;
    private int queryTimeout = 0;
    BaseQueryTimeoutEnforcer queryTimeoutEnforcer;
    Socket queryTimeoutSocket;
    boolean timeoutEnforcerCanceledExecution = false;
    protected BaseWarnings warnings;
    protected BaseExceptions exceptions;
    protected Object synchronizer;
    Object cancelSyncObject = this;
    boolean isCancelPending = false;
    protected boolean autoGeneratedKeysRequested = false;
    public boolean cleanUpDuringFinalization = true;

    public BaseStatement(BaseConnection baseConnection, int n2, int n3) throws SQLException {
        this.connection = baseConnection;
        this.resultSetScrollType = n2;
        this.resultSetConcurrency = n3;
        this.exceptions = baseConnection.exceptions;
        this.warnings = new BaseWarnings(this.exceptions.getMessages());
        this.setupImplStatement();
        this.synchronizer = baseConnection;
    }

    void setAutoGeneratedKeysRequested(boolean bl) {
        this.autoGeneratedKeysRequested = bl;
    }

    final ResultSet executeDatabaseMetaDataQuery(String string, BaseColumns baseColumns, int n2, BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor, Object object) throws SQLException {
        this.currentColumns = baseColumns;
        this.databaseMetaDataResultSet = n2;
        this.filterDescriptor = baseResultSetFilterDescriptor;
        this.sortDescriptor = baseResultSetSortDescriptor;
        this.databaseMetaDataResultSetInfo = object;
        this.implStatement.setupDatabaseMetaDataResultSet(n2, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
        if (string != null) {
            this.preProcessSQL(string);
        }
        return this.executeQueryInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (this.implStatement == null) {
            super.finalize();
            return;
        }
        try {
            if (this.cleanUpDuringFinalization) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void commonTransitionToState(int n2) throws SQLException {
        try {
            switch (n2) {
                case 1: {
                    switch (this.state) {
                        case 3: {
                            this.closeCurrentResults(3, true);
                            this.currentResultType = 0;
                            this.concurrencyStrategy = 0;
                            this.scrollingStrategy = 0;
                        }
                        case 2: {
                            this.currentColumns = null;
                            this.timeoutEnforcerCanceledExecution = false;
                            this.nativeBatchExecute = false;
                            this.autoGeneratedKeysRequested = false;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.state) {
                        case 1: {
                            break;
                        }
                        case 3: {
                            this.closeCurrentResults(3, this.multipleResultsReturned);
                            this.timeoutEnforcerCanceledExecution = false;
                            this.nativeBatchExecute = false;
                            this.multipleResultsReturned = false;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.state) {
                        case 1: {
                            if (this.databaseMetaDataResultSet == 0) {
                                this.currentColumns = null;
                            }
                        }
                        case 2: {
                            this.currentResultType = this.implStatement.getNextResultType();
                            this.implStatement.prepareExecuteMode = 0;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (this.state) {
                        case 3: {
                            this.closeCurrentResults(3, true);
                        }
                        case 1: 
                        case 2: {
                            if (this.queryTimeout > 0) {
                                this.setQueryTimeout(0);
                            }
                            this.implStatement.close();
                            this.implStatement = null;
                        }
                    }
                }
            }
            this.state = n2;
        }
        finally {
            if (n2 == 4) {
                this.state = 4;
            }
        }
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public final int getFetchSize() throws SQLException {
        return this.resultSetFetchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFetchSize(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateNotNegativeParameter("Statement.setFetchSize", n2);
            this.implStatement.setFetchSize(n2);
            this.resultSetFetchSize = n2;
        }
    }

    public final int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxFieldSize(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateNotNegativeParameter("Statement.setMaxFieldSize", n2);
            this.implStatement.setMaxFieldSize(n2);
            this.maxFieldSize = n2;
        }
    }

    public final int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxRows(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateNotNegativeParameter("Statement.setMaxRows", n2);
            this.implStatement.setMaxRows(n2);
            this.maxRows = n2;
        }
    }

    public final int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setQueryTimeout(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.connection.implConnection.supportsQueryTimeout()) {
                this.validateNotNegativeParameter("Statement.setQueryTimeout", n2);
                this.queryTimeout = n2;
                this.implStatement.setQueryTimeout(this.queryTimeout);
            } else if (this.connection.implConnection.supportsCancel()) {
                this.validateNotNegativeParameter("Statement.setQueryTimeout", n2);
                this.queryTimeout = n2;
                this.queryTimeoutSocket = this.connection.implConnection.getQueryTimeoutSocket();
                if (this.queryTimeoutSocket != null) {
                    if (this.queryTimeout == 0) {
                        this.queryTimeoutSocket = null;
                    }
                } else if (this.queryTimeout == 0) {
                    if (this.queryTimeoutEnforcer != null) {
                        this.queryTimeoutEnforcer.exit();
                        this.queryTimeoutEnforcer = null;
                    }
                } else if (this.queryTimeoutEnforcer == null) {
                    this.queryTimeoutEnforcer = (BaseQueryTimeoutEnforcer)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return new BaseQueryTimeoutEnforcer();
                        }
                    });
                }
            } else {
                String[] stringArray = new String[]{"Statement.setQueryTimeout"};
                throw this.connection.exceptions.getException(6003, stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResultSet getResultSet() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.state != 3) {
                return null;
            }
            this.commonGetNextResultSet();
            if (!this.currentResultSets.empty()) {
                return (ResultSet)this.currentResultSets.peek();
            }
            return null;
        }
    }

    public final void setCursorName(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            String[] stringArray = new String[]{"Statement.setCursorName"};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    public final void setEscapeProcessing(boolean bl) throws SQLException {
    }

    public final int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public final void setFetchDirection(int n2) throws SQLException {
        switch (n2) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                String[] stringArray = new String[]{"setFetchDirection"};
                throw this.exceptions.getException(6002, stringArray);
            }
        }
        this.fetchDirection = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getResultSetType() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.resultSetScrollType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getResultSetConcurrency() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.resultSetConcurrency;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLWarning getWarnings() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.warnings.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearWarnings() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.warnings.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.commonTransitionToState(4);
        }
    }

    final void validateNotNegativeParameter(String string, int n2) throws SQLException {
        if (n2 < 0) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(6002, stringArray);
        }
    }

    final void validateInExecutedState() throws SQLException {
        if (this.state != 3) {
            throw this.exceptions.getException(6014);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.commonTransitionToState(1);
            this.commonValidateSQL(string);
            this.preProcessSQL(string);
            return this.executeInternal();
        }
    }

    protected final boolean executeInternal() throws SQLException {
        this.clearBatchInternal();
        try {
            this.commonExecute();
        }
        catch (SQLException sQLException) {
            this.postProcessExceptionFromCommonExecute(sQLException);
            Object[] objectArray = this.downgradeAndRetryExecute(sQLException, 0);
            return (Boolean)objectArray[0];
        }
        return this.currentResultType == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean postProcessExceptionFromCommonExecute(SQLException sQLException) throws SQLException {
        boolean bl = false;
        try {
            if (sQLException.getMessage().indexOf("SOCKETTIMEOUT") != -1) {
                if (this.sendCancelRequest(0)) {
                    int n2 = this.queryTimeout;
                    String string = this.connection.connectProps.get("enableCancelTimeout");
                    if (string == null || string.equalsIgnoreCase("false")) {
                        n2 = 0;
                    }
                    this.connection.implConnection.setCancelResponsePending(this.connection, this.implStatement, n2);
                }
                throw this.exceptions.getException(6085, "HYT00");
            }
            if (sQLException.getMessage().indexOf("DDTEK1") != -1) {
                this.connection.close();
                this.state = 4;
                throw this.exceptions.getException(6099, "08000");
            }
            if (sQLException.getSQLState().equals("HYT00")) {
                throw sQLException;
            }
            if (sQLException.getSQLState().equals("HY008")) {
                if (this.timeoutEnforcerCanceledExecution) {
                    sQLException = this.exceptions.getException(6085, "HYT00");
                }
                throw sQLException;
            }
            if (this.databaseMetaDataResultSet != 0) {
                if (this.connection.implConnection.exposeEmptyDBMDResultSetOnExecutionError()) {
                    this.generateEmptyDatabaseMetaDataResultSet = true;
                    this.currentResultType = 2;
                    bl = true;
                } else {
                    throw sQLException;
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.postImplExecute(false);
        }
    }

    private Object[] downgradeAndRetryExecute(SQLException sQLException, int n2) throws SQLException {
        if (!this.downgrade()) {
            throw sQLException;
        }
        int n3 = this.concurrencyStrategy;
        int n4 = this.scrollingStrategy;
        this.commonTransitionToState(1);
        this.concurrencyStrategy = n3;
        this.scrollingStrategy = n4;
        String string = this.implStatement.sql.getOriginal();
        this.preProcessSQL(string);
        Object[] objectArray = new Object[1];
        switch (n2) {
            case 0: {
                objectArray[0] = new Boolean(this.executeInternal());
                break;
            }
            case 1: {
                objectArray[0] = this.executeQueryInternal();
            }
        }
        return objectArray;
    }

    protected final boolean downgrade() {
        boolean bl = false;
        switch (this.concurrencyStrategy) {
            case 3: {
                this.concurrencyStrategy = 4;
                bl = true;
                break;
            }
            case 4: {
                this.concurrencyStrategy = 1;
                bl = true;
            }
        }
        switch (this.scrollingStrategy) {
            case 4: 
            case 5: {
                this.scrollingStrategy = 3;
                bl = true;
            }
        }
        return bl;
    }

    final void preProcessSQL(String string) throws SQLException {
        boolean bl = false;
        try {
            BaseSQL baseSQL;
            this.numberOfColumnsInBaseTable = 0;
            this.tableSpecification = null;
            this.determineConcurrencyStrategy();
            this.determineScrollingStrategy();
            if (this.autoGeneratedKeysRequested) {
                baseSQL = new BaseSQL(string, 4, this.connection.implConnection.quotingChar, this.getEscapeTranslator(string), this.exceptions);
                if (!baseSQL.isStatementSuitableForAutoGeneratedKeys()) {
                    this.autoGeneratedKeysRequested = false;
                }
            } else {
                baseSQL = new BaseSQL(string, this.getRequiredSQLProcessing(string), this.connection.implConnection.quotingChar, this.getEscapeTranslator(string), this.exceptions);
            }
            this.setupConcurrency(baseSQL);
            this.setupScrollingNoAlteringExposedMetaData(baseSQL);
            this.prepareSQL(baseSQL, false);
            this.setupScrollingMayAlterExposedMetaData(baseSQL);
        }
        catch (SQLException sQLException) {
            if (!bl && this.downgrade()) {
                this.preProcessSQL(string);
            }
            throw sQLException;
        }
    }

    void prepareSQL(BaseSQL baseSQL, boolean bl) throws SQLException {
        if (bl) {
            this.commonTransitionToState(1);
            this.implStatement.setAutoGeneratedKeysRequested(this.autoGeneratedKeysRequested);
            this.implStatement.setSQL(baseSQL);
            this.implStatement.prepare(null);
            this.commonTransitionToState(2);
        } else {
            this.implStatement.setAutoGeneratedKeysRequested(this.autoGeneratedKeysRequested);
            this.implStatement.setSQL(baseSQL);
        }
    }

    private void determineConcurrencyStrategy() throws SQLException {
        boolean bl = true;
        if (this.concurrencyStrategy == 0) {
            if (this.resultSetConcurrency == 1007) {
                this.concurrencyStrategy = 1;
                bl = false;
            } else {
                this.concurrencyStrategy = 2;
            }
        }
        while (bl) {
            switch (this.concurrencyStrategy) {
                case 2: {
                    if (this.implStatement.supportsUpdates()) {
                        bl = false;
                        break;
                    }
                    this.concurrencyStrategy = 3;
                    break;
                }
                case 3: {
                    if (this.implStatement.getRowIdColumnName() != null) {
                        bl = false;
                        break;
                    }
                    this.concurrencyStrategy = 4;
                    break;
                }
                case 1: 
                case 4: {
                    bl = false;
                }
            }
        }
    }

    private void determineScrollingStrategy() throws SQLException {
        boolean bl = true;
        if (this.scrollingStrategy == 0) {
            if (this.resultSetScrollType == 1003) {
                this.scrollingStrategy = 1;
            } else if (this.resultSetScrollType == 1004) {
                this.scrollingStrategy = 3;
            } else if (this.resultSetScrollType == 1005) {
                this.scrollingStrategy = 6;
            }
        }
        while (bl) {
            switch (this.scrollingStrategy) {
                case 6: {
                    if (!this.implStatement.supportsScrolling(1005)) break;
                    bl = false;
                    break;
                }
                case 3: {
                    if (!this.implStatement.supportsScrolling(1004)) break;
                    bl = false;
                    break;
                }
                case 4: 
                case 5: {
                    if (this.implStatement.getRowIdColumnName() == null) break;
                    bl = false;
                    break;
                }
                case 1: 
                case 2: {
                    bl = false;
                }
            }
            if (!bl) continue;
            this.downgradeScrolling();
        }
    }

    private void downgradeScrolling() {
        switch (this.scrollingStrategy) {
            case 6: {
                this.scrollingStrategy = 4;
                break;
            }
            case 4: 
            case 5: {
                this.scrollingStrategy = 3;
                break;
            }
            case 3: {
                this.scrollingStrategy = 2;
                break;
            }
            case 2: {
                this.scrollingStrategy = 1;
            }
        }
    }

    private int getRequiredSQLProcessing(String string) throws SQLException {
        int n2;
        switch (this.concurrencyStrategy) {
            case 3: 
            case 4: {
                n2 = 4;
                break;
            }
            default: {
                n2 = this.implStatement.getRequiredSQLProcessing(string);
            }
        }
        if (n2 != 4) {
            switch (this.scrollingStrategy) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 4;
                }
            }
        }
        return n2;
    }

    private void setupConcurrency(BaseSQL baseSQL) throws SQLException {
        if (this.concurrencyStrategy == 3 || this.concurrencyStrategy == 4) {
            this.tableSpecification = baseSQL.getSingleTableFromSpecification();
            if (this.tableSpecification == null || baseSQL.hasAggregateOrParameterInSelectList(this.connection.implConnection.getAggregateFunctions()) || baseSQL.hasGroupBy() || baseSQL.hasHaving() || baseSQL.hasSetOperation() || baseSQL.hasSelectDistinct()) {
                this.concurrencyStrategy = 1;
            } else if (this.concurrencyStrategy == 3) {
                this.addRowIdToSelectList(baseSQL);
            } else if (this.concurrencyStrategy == 4) {
                this.addAllSearchableColumnsToSelectList(baseSQL);
            }
        }
    }

    private boolean addAllSearchableColumnsToSelectList(BaseSQL baseSQL) throws SQLException {
        boolean bl = false;
        int n2 = baseSQL.getSelectColumnSpecificationCount() - 1;
        UtilVectorUnsynced utilVectorUnsynced = baseSQL.getSelectColumnSpecification(n2);
        if (!baseSQL.selectColumnSpecificationContainsValue(utilVectorUnsynced, "*")) {
            int n3 = utilVectorUnsynced.size();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n3; ++i2) {
                stringBuffer.append((String)utilVectorUnsynced.elementAt(i2));
            }
            stringBuffer.append(", ");
            stringBuffer.append(this.getColumnList(this.tableSpecification, baseSQL, true).toString());
            baseSQL.setSelectColumnSpecification(n2, stringBuffer.toString());
            bl = true;
        }
        return bl;
    }

    private void addRowIdToSelectList(BaseSQL baseSQL) throws SQLException {
        String string = this.implStatement.getRowIdColumnName();
        int n2 = baseSQL.getSelectColumnSpecificationCount() - 1;
        UtilVectorUnsynced utilVectorUnsynced = baseSQL.getSelectColumnSpecification(n2);
        if (n2 == 0 && baseSQL.selectColumnSpecificationContainsValue(utilVectorUnsynced, "*") && !this.connection.implConnection.supportsSelectStarCommaColumn()) {
            baseSQL.setSelectColumnSpecification(n2, this.getColumnList(this.tableSpecification, baseSQL, false).toString() + ", " + string);
        } else {
            int n3 = utilVectorUnsynced.size();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n3; ++i2) {
                stringBuffer.append((String)utilVectorUnsynced.elementAt(i2));
            }
            stringBuffer.append(", ");
            stringBuffer.append(string);
            baseSQL.setSelectColumnSpecification(n2, stringBuffer.toString());
        }
    }

    private void setupScrollingNoAlteringExposedMetaData(BaseSQL baseSQL) throws SQLException {
        if (this.concurrencyStrategy == 4 && this.scrollingStrategy == 4) {
            this.downgradeScrolling();
            this.determineScrollingStrategy();
        } else if (this.scrollingStrategy == 4) {
            this.tableSpecification = baseSQL.getSingleTableFromSpecification();
            this.originalSelectList = baseSQL.getSelectList();
            if (this.tableSpecification == null || this.originalSelectList == null || baseSQL.hasAggregateOrParameterInSelectList(this.connection.implConnection.getAggregateFunctions()) || baseSQL.hasGroupBy() || baseSQL.hasHaving() || baseSQL.hasSetOperation() || baseSQL.hasSelectDistinct()) {
                this.downgradeScrolling();
                this.determineScrollingStrategy();
            } else if (baseSQL.hasOrderBy()) {
                if (this.concurrencyStrategy != 3) {
                    this.addRowIdToSelectList(baseSQL);
                }
                this.scrollingStrategy = 5;
            }
        }
    }

    private void setupScrollingMayAlterExposedMetaData(BaseSQL baseSQL) throws SQLException {
        if (this.scrollingStrategy == 4) {
            if (this.state == 1) {
                this.prepareSQL(baseSQL, true);
            }
            this.describeColumns();
            this.originalSelectList = baseSQL.getSelectList();
            baseSQL.replaceSelectListWithString(this.implStatement.getRowIdColumnName());
            this.implStatement.setSQL(baseSQL);
            this.implStatement.prepare(null);
            this.implStatement.describeColumns(null);
            this.implStatement.prepareExecuteMode = 1;
        }
    }

    private boolean expandSelectStar(BaseSQL baseSQL) throws SQLException {
        try {
            this.implStatement.setSQL(baseSQL);
            this.implStatement.prepare(null);
            this.commonTransitionToState(2);
            BaseColumns baseColumns = this.implStatement.describeColumns(null);
            int n2 = baseColumns.count(1);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 1; i2 <= n2; ++i2) {
                if (i2 != 1) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(baseColumns.get((int)i2).name);
            }
            baseSQL.setSelectColumnSpecification(0, stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getColumnList(String string, BaseSQL baseSQL, boolean bl) throws SQLException {
        StringBuffer stringBuffer;
        block5: {
            BaseSQL baseSQL2 = new BaseSQL("select * from " + string + " where 0=1", baseSQL);
            BaseImplResultSet baseImplResultSet = null;
            try {
                this.implStatement.setSQL(baseSQL2);
                this.implStatement.execute();
                this.implStatement.getNextResultType();
                baseImplResultSet = this.implStatement.getNextResultSet();
                baseImplResultSet.setImplStatement(this.implStatement);
                BaseColumns baseColumns = this.implStatement.describeColumns(null);
                int n2 = baseColumns.count(1);
                StringBuffer stringBuffer2 = new StringBuffer();
                int n3 = 0;
                for (int i2 = 1; i2 <= n2; ++i2) {
                    BaseColumn baseColumn = baseColumns.get(i2);
                    if (bl && baseColumn.isSearchable != 4 && baseColumn.isSearchable != 3) continue;
                    if (n3 > 0) {
                        stringBuffer2.append(", ");
                    }
                    stringBuffer2.append(this.connection.getMetaData().getIdentifierQuoteString());
                    stringBuffer2.append(baseColumns.get((int)i2).name);
                    stringBuffer2.append(this.connection.getMetaData().getIdentifierQuoteString());
                    ++n3;
                }
                this.numberOfColumnsInBaseTable = n3;
                stringBuffer = stringBuffer2;
                Object var13_13 = null;
                if (baseImplResultSet == null) break block5;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (baseImplResultSet != null) {
                    baseImplResultSet.close();
                }
                this.implStatement.setSQL(baseSQL);
                throw throwable;
            }
            baseImplResultSet.close();
        }
        this.implStatement.setSQL(baseSQL);
        return stringBuffer;
    }

    protected final void commonValidateSQL(String string) throws SQLException {
        if (string == null) {
            throw this.exceptions.getException(6018);
        }
        if (string.equals("")) {
            String[] stringArray = new String[]{"0", "0", "0"};
            throw this.exceptions.getException(6036, stringArray, "42000");
        }
    }

    final boolean getNextResultType() throws SQLException {
        boolean bl = false;
        this.currentResultType = this.implStatement.getNextResultType();
        switch (this.currentResultType) {
            case 1: {
                this.currentRowsAffectedCount = -1;
                bl = false;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.commonTransitionToState(1);
            this.commonValidateSQL(string);
            this.preProcessSQL(string);
            return this.executeQueryInternal();
        }
    }

    protected final ResultSet executeQueryInternal() throws SQLException {
        block9: {
            this.clearBatchInternal();
            try {
                this.commonExecute();
            }
            catch (SQLException sQLException) {
                if (this.postProcessExceptionFromCommonExecute(sQLException)) break block9;
                Object[] objectArray = this.downgradeAndRetryExecute(sQLException, 1);
                return (ResultSet)objectArray[0];
            }
        }
        while (this.currentResultType == 3) {
            this.warnings.add(6084);
            this.getNextResultType();
        }
        switch (this.currentResultType) {
            case 1: {
                throw this.exceptions.getException(6012);
            }
            case 2: {
                this.commonGetNextResultSet();
            }
        }
        if (!this.currentResultSets.empty()) {
            if (this.databaseMetaDataResultSet != 0) {
                ((BaseResultSet)this.currentResultSets.peek()).databaseMetaDataResultSet = true;
            }
            return (ResultSet)this.currentResultSets.peek();
        }
        return null;
    }

    final void commonExecute() throws SQLException {
        this.connection.transactionableWorkStarting();
        if (this.emulatedDatabaseMetaDataResultSet()) {
            this.currentResultType = 2;
        } else {
            this.preImplExecute();
            if (this.nativeBatchExecute) {
                this.implStatement.executeBatch();
            } else {
                this.implStatement.execute();
            }
            this.postImplExecute(true);
        }
    }

    void preImplExecute() throws SQLException {
        this.warnings.clear();
        this.executeState = 2;
        if (this.queryTimeout != 0) {
            if (this.queryTimeoutSocket != null) {
                try {
                    if (this.connection.implConnection.cancelPending) {
                        this.connection.implConnection.socketActivityPostCancel();
                    }
                    this.queryTimeoutSocket.setSoTimeout(this.queryTimeout * 1000);
                }
                catch (SocketException socketException) {
                    String[] stringArray = new String[]{socketException.getMessage()};
                    throw this.exceptions.getException(6105, stringArray, "08001");
                }
            } else if (this.queryTimeoutEnforcer != null) {
                this.queryTimeoutEnforcer.startTimeoutPeriod(this, this.queryTimeout);
            }
        }
    }

    void postImplExecute(boolean bl) throws SQLException {
        if (bl) {
            this.commonTransitionToState(3);
        }
        this.executeState = 1;
        if (this.queryTimeout != 0) {
            if (this.queryTimeoutSocket != null) {
                try {
                    this.queryTimeoutSocket.setSoTimeout(0);
                }
                catch (SocketException socketException) {}
            } else if (this.queryTimeoutEnforcer != null) {
                this.queryTimeoutEnforcer.resetTimeoutPeriod();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void closeCurrentResults(int n2, boolean bl) throws SQLException {
        this.currentRowsAffectedCount = -2;
        try {
            if (this.currentResultSets.empty()) return;
            switch (n2) {
                case 1: {
                    ((BaseResultSet)this.currentResultSets.peek()).close();
                    return;
                }
                case 3: {
                    while (!this.currentResultSets.empty()) {
                        ((BaseResultSet)this.currentResultSets.peek()).close();
                    }
                    return;
                }
                case 2: {
                    BaseResultSet baseResultSet = (BaseResultSet)this.currentResultSets.peek();
                    BaseImplResultSet baseImplResultSet = baseResultSet.implResultSet;
                    int n3 = 0;
                    if (baseImplResultSet.getColumnAccess() == 1 || baseResultSet.lastColumnAccessed == -1) {
                        n3 = baseResultSet.lastColumnAccessed;
                    }
                    if (baseImplResultSet.setupForNextResultSetInMultipleResult(n3)) return;
                    BaseImplResultSetClientSideInsensitive baseImplResultSetClientSideInsensitive = new BaseImplResultSetClientSideInsensitive();
                    baseImplResultSetClientSideInsensitive.setImplStatement(this.implStatement);
                    baseImplResultSetClientSideInsensitive.setSubResultSet(baseImplResultSet);
                    baseImplResultSetClientSideInsensitive.setColumns(this.currentColumns);
                    int n4 = this.connection.implConnection.getMaxLongDataFieldCacheSize();
                    baseImplResultSetClientSideInsensitive.setMaxLongDataFieldCacheSize(n4 != 0 ? n4 : this.maxFieldSize);
                    ((BaseResultSet)this.currentResultSets.peek()).implResultSet = baseImplResultSetClientSideInsensitive;
                    baseImplResultSetClientSideInsensitive.setWarnings(((BaseResultSet)this.currentResultSets.peek()).warnings);
                    baseImplResultSetClientSideInsensitive.setupForNextResultSetInMultipleResult(n3);
                    return;
                }
            }
            return;
        }
        finally {
            if (bl) {
                this.currentColumns = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonGetNextResultSet() throws SQLException {
        if (this.currentResultType == 2) {
            BaseImplResultSet baseImplResultSet;
            if (this.generateEmptyDatabaseMetaDataResultSet) {
                baseImplResultSet = new BaseImplResultSetClientSideEmpty();
            } else {
                baseImplResultSet = this.getNextImplResultSet();
                if (baseImplResultSet != null) {
                    this.describeColumns();
                }
            }
            baseImplResultSet = this.chainInServiceImplResultSets(baseImplResultSet);
            try {
                this.currentResultSets.push(new BaseResultSet(this, this.currentColumns, baseImplResultSet));
            }
            catch (SQLException sQLException) {
                if (!this.postProcessExceptionFromCommonExecute(sQLException)) {
                    Object[] objectArray = this.downgradeAndRetryExecute(sQLException, 1);
                    this.currentResultSets.push(objectArray[0]);
                }
            }
            finally {
                this.currentResultType = 0;
            }
            BaseResultSet baseResultSet = (BaseResultSet)this.currentResultSets.peek();
            baseResultSet.setMaxFieldSize(this.maxFieldSize);
            if (baseResultSet.getConcurrency() != this.resultSetConcurrency) {
                this.warnings.add(6047);
            }
            if (baseResultSet.getType() != this.resultSetScrollType) {
                this.warnings.add(6046);
            }
        }
    }

    private BaseImplResultSet chainInServiceImplResultSets(BaseImplResultSet baseImplResultSet) throws SQLException {
        int n2;
        BaseImplResultSet baseImplResultSet2 = baseImplResultSet;
        BaseImplResultSetClientSideFilter baseImplResultSetClientSideFilter = null;
        BaseImplResultSetService baseImplResultSetService = null;
        BaseImplResultSetClientSideSorter baseImplResultSetClientSideSorter = null;
        if (baseImplResultSet2 instanceof BaseImplResultSetClientSideEmpty) {
            return baseImplResultSet2;
        }
        if (this.filterDescriptor != null && !this.filterDescriptor.allRestrictionsSatified()) {
            baseImplResultSetClientSideFilter = new BaseImplResultSetClientSideFilter();
            baseImplResultSetClientSideFilter.setImplStatement(this.implStatement);
            baseImplResultSetClientSideFilter.setSubResultSet(baseImplResultSet2);
            baseImplResultSetClientSideFilter.setColumns(this.currentColumns);
            baseImplResultSetClientSideFilter.setFilterCriteria(this.filterDescriptor);
            baseImplResultSet2 = baseImplResultSetClientSideFilter;
        }
        if (this.sortDescriptor != null && !this.sortDescriptor.getSatisfied()) {
            baseImplResultSetService = new BaseImplResultSetClientSideInsensitive();
            baseImplResultSetService.setImplStatement(this.implStatement);
            baseImplResultSetService.setSubResultSet(baseImplResultSet2);
            baseImplResultSetService.setColumns(this.currentColumns);
            baseImplResultSet2 = baseImplResultSetService;
            baseImplResultSetClientSideSorter = new BaseImplResultSetClientSideSorter();
            baseImplResultSetClientSideSorter.setImplStatement(this.implStatement);
            baseImplResultSetClientSideSorter.setSubResultSet(baseImplResultSet2);
            baseImplResultSetClientSideSorter.setColumns(this.currentColumns);
            baseImplResultSetClientSideSorter.setSortCriteria(this.sortDescriptor);
            baseImplResultSet2 = baseImplResultSetClientSideSorter;
        }
        if (this.scrollingStrategy == 6 && baseImplResultSet.getScrollType() != 1005) {
            this.warnings.add(6046);
            this.scrollingStrategy = 2;
        }
        if (this.scrollingStrategy == 3 && baseImplResultSet.getScrollType() == 1003) {
            this.scrollingStrategy = 2;
        }
        if (this.scrollingStrategy == 2) {
            if (baseImplResultSetService == null) {
                n2 = Integer.parseInt(this.connection.connectProps.get("insensitiveResultSetBufferSize"));
                baseImplResultSetService = n2 < 0 ? new BaseImplResultSetClientSideInsensitiveMemory() : new BaseImplResultSetClientSideInsensitive(n2);
                baseImplResultSetService.setImplStatement(this.implStatement);
                baseImplResultSetService.setSubResultSet(baseImplResultSet2);
                baseImplResultSetService.setColumns(this.currentColumns);
                baseImplResultSet2 = baseImplResultSetService;
            }
        } else if (this.scrollingStrategy == 4 || this.scrollingStrategy == 5) {
            BaseImplResultSetClientSideSensitive baseImplResultSetClientSideSensitive = new BaseImplResultSetClientSideSensitive(this.connection, this.tableSpecification, this.originalSelectList, this.implStatement.getRowIdColumnName(), this.scrollingStrategy == 4 ? 1 : this.currentColumns.count(0));
            baseImplResultSetClientSideSensitive.setImplStatement(this.implStatement);
            baseImplResultSetClientSideSensitive.setSubResultSet(baseImplResultSet2);
            baseImplResultSetClientSideSensitive.setColumns(this.currentColumns);
            baseImplResultSet2 = baseImplResultSetClientSideSensitive;
        }
        if (this.concurrencyStrategy == 3 || this.concurrencyStrategy == 4) {
            BaseImplResultSetClientSideUpdatable baseImplResultSetClientSideUpdatable = new BaseImplResultSetClientSideUpdatable(this.connection, this.tableSpecification, this.currentColumns, this.connection.getMetaData().getIdentifierQuoteString());
            baseImplResultSetClientSideUpdatable.setImplStatement(this.implStatement);
            baseImplResultSetClientSideUpdatable.setSubResultSet(baseImplResultSet2);
            baseImplResultSet2 = baseImplResultSetClientSideUpdatable;
        }
        if (baseImplResultSetService != null) {
            n2 = this.connection.implConnection.getMaxLongDataFieldCacheSize();
            baseImplResultSetService.setMaxLongDataFieldCacheSize(n2 != 0 ? n2 : this.maxFieldSize);
        }
        return baseImplResultSet2;
    }

    protected final void describeColumns() throws SQLException {
        if (this.currentColumns == null || this.databaseMetaDataResultSet == 0 && this.implStatement.sql.getType() != 1) {
            this.currentColumns = this.implStatement.describeColumns(null);
            if (this.currentColumns != null) {
                if (this.concurrencyStrategy == 3 || this.scrollingStrategy == 5) {
                    this.currentColumns.markColumnsAsKeyStartingAt(this.currentColumns.count(0), true);
                } else if (this.concurrencyStrategy == 4) {
                    if (this.numberOfColumnsInBaseTable == 0) {
                        this.currentColumns.markColumnsAsKeyStartingAt(1, false);
                    } else {
                        this.currentColumns.markColumnsAsKeyStartingAt(this.currentColumns.count(1) - this.numberOfColumnsInBaseTable + 1, true);
                    }
                }
            }
        } else if (this.databaseMetaDataResultSet != 0 && !this.emulatedDatabaseMetaDataResultSet()) {
            this.currentColumns = this.implStatement.describeColumns(this.currentColumns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.commonTransitionToState(1);
            this.commonValidateSQL(string);
            this.preProcessSQL(string);
            return this.executeUpdateInternal();
        }
    }

    protected int executeUpdateInternal() throws SQLException {
        int n2 = -1;
        this.clearBatchInternal();
        try {
            this.commonExecute();
        }
        catch (SQLException sQLException) {
            this.postProcessExceptionFromCommonExecute(sQLException);
            throw sQLException;
        }
        boolean bl = false;
        while (this.currentResultType != 3 && this.currentResultType != 1) {
            bl = true;
            this.warnings.add(6083);
            this.getNextResultType();
        }
        if (this.currentResultType == 3) {
            n2 = this.commonGetUpdateCount();
        } else if (bl) {
            throw this.exceptions.getException(6013);
        }
        if (n2 == -1) {
            n2 = 0;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getUpdateCount() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state != 3) {
                return -1;
            }
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            switch (this.currentResultType) {
                case 0: 
                case 1: 
                case 2: {
                    this.currentRowsAffectedCount = -1;
                    break;
                }
                case 3: {
                    if (this.currentRowsAffectedCount != -2) break;
                    this.currentRowsAffectedCount = this.commonGetUpdateCount();
                }
            }
            return this.currentRowsAffectedCount;
        }
    }

    private int commonGetUpdateCount() throws SQLException {
        int n2 = -1;
        switch (this.currentResultType) {
            case 1: 
            case 2: {
                n2 = -1;
                break;
            }
            case 3: {
                n2 = this.implStatement.getNextRowsAffectedCount();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray = null;
        Object object = this.synchronizer;
        synchronized (object) {
            block16: {
                try {
                    if (this.implStatement == null || this.connection.implConnection == null) {
                        throw this.exceptions.getException(6009);
                    }
                    this.commonTransitionToState(1);
                    if (this.batchSQL == null || this.batchSQL.batchSize() == 0) {
                        int[] nArray2 = new int[]{};
                        return nArray2;
                    }
                    if (this.implStatement.supportsBatchStatements() && !this.overrideNativeBatchSupport()) {
                        this.implStatement.setSQL(this.batchSQL);
                        this.nativeBatchExecute = true;
                        try {
                            this.commonExecute();
                        }
                        catch (SQLException sQLException) {
                            this.postProcessExceptionFromCommonExecute(sQLException);
                            throw sQLException;
                        }
                        nArray = this.implStatement.getBatchRowsAffectedCount();
                        break block16;
                    }
                    nArray = this.executeBatchEmulation(null);
                }
                catch (SQLException sQLException) {
                    if (sQLException instanceof BatchUpdateException) {
                        throw sQLException;
                    }
                    throw new BaseBatchUpdateException(sQLException, new int[0]);
                }
                finally {
                    this.clearBatchInternal();
                }
            }
        }
        if (nArray == null) {
            throw new BaseBatchUpdateException(this.exceptions.getException(6090), new int[0]);
        }
        return nArray;
    }

    protected final boolean overrideNativeBatchSupport() {
        boolean bl = false;
        if (!this.connection.getBatchIsJDBCCompliant()) {
            if (!BaseClassUtility.exposeCtsIncompatibleOptions()) {
                return true;
            }
            String string = this.connection.connectProps.get("batchPerformanceWorkaround");
            if (string != null && string.equalsIgnoreCase("false")) {
                bl = true;
            }
        }
        return bl;
    }

    protected final int[] executeBatchEmulation(UtilVectorUnsynced utilVectorUnsynced) throws SQLException {
        if (this.implStatement.useStatementConcatenationForBatchEmulation(utilVectorUnsynced)) {
            return this.executeAllStatementsAtOnce();
        }
        return this.executeOneStatementAtATime();
    }

    protected int[] executeOneStatementAtATime() throws SQLException {
        int n2;
        int n3 = this.batchSQL.batchSize();
        int[] nArray = new int[n3];
        try {
            block10: for (n2 = 0; n2 < n3; ++n2) {
                this.batchSQL.nextBatchStatement();
                this.implStatement.setSQL(this.batchSQL);
                this.commonTransitionToState(1);
                try {
                    this.commonExecute();
                }
                catch (SQLException sQLException) {
                    this.postProcessExceptionFromCommonExecute(sQLException);
                    throw sQLException;
                }
                switch (this.currentResultType) {
                    case 3: {
                        nArray[n2] = this.implStatement.getNextRowsAffectedCount();
                        continue block10;
                    }
                    case 0: {
                        nArray[n2] = -2;
                        continue block10;
                    }
                    case 1: {
                        nArray[n2] = 0;
                        continue block10;
                    }
                    case 2: {
                        throw this.exceptions.getException(6053);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            int[] nArray2 = null;
            nArray2 = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray2[i2] = nArray[i2];
            }
            throw new BaseBatchUpdateException(sQLException, nArray2);
        }
        return nArray;
    }

    protected int[] executeAllStatementsAtOnce() throws SQLException {
        int n2 = this.batchSQL.batchSize();
        if (n2 == 0) {
            return new int[0];
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.batchSQL.nextBatchStatement();
            if (i2 != 0) {
                stringBuffer.append(this.implStatement.getStatementSeparator());
            }
            stringBuffer.append(this.batchSQL.getFormatted());
        }
        String string = stringBuffer.toString();
        this.commonTransitionToState(1);
        BaseSQL baseSQL = new BaseSQL(string, this.implStatement.getRequiredSQLProcessing(string), this.connection.implConnection.quotingChar, this.connection.getEscapeTranslator(), this.exceptions);
        this.implStatement.setSQL(baseSQL);
        try {
            this.commonExecute();
        }
        catch (SQLException sQLException) {
            this.postProcessExceptionFromCommonExecute(sQLException);
            throw sQLException;
        }
        return this.constructUpdateCountArray(n2);
    }

    protected final int[] constructUpdateCountArray(int n2) throws BaseBatchUpdateException {
        int[] nArray = new int[n2];
        int n3 = 0;
        boolean bl = false;
        while (this.currentResultType != 1) {
            try {
                switch (this.currentResultType) {
                    case 3: {
                        if (n3 < n2) {
                            nArray[n3++] = this.implStatement.getNextRowsAffectedCount();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 2: {
                        throw this.exceptions.getException(6053);
                    }
                }
                this.currentResultType = this.implStatement.getNextResultType();
            }
            catch (SQLException sQLException) {
                throw new BaseBatchUpdateException(sQLException, new int[0]);
            }
        }
        if (bl) {
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = -2;
            }
        }
        return nArray;
    }

    public final boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseEscapeTranslator baseEscapeTranslator;
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.batchSQL == null) {
                this.batchSQL = new BaseSQL(this.connection.implConnection.quotingChar, null, this.exceptions);
            }
            if ((baseEscapeTranslator = this.getEscapeTranslator(string)) != null) {
                this.batchSQL.setEscapeTranslator(baseEscapeTranslator);
            }
            this.batchSQL.addToBatch(string, this.implStatement.getRequiredSQLProcessing(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBatch() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.clearBatchInternal();
        }
    }

    void clearBatchInternal() throws SQLException {
        if (this.batchSQL != null) {
            this.batchSQL.clearBatch();
        }
    }

    public final void cancel() throws SQLException {
        if (!this.connection.implConnection.supportsCancel()) {
            String[] stringArray = new String[]{"Statement.cancel"};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
        try {
            this.sendCancelRequest(0);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            if (sQLException.getMessage().compareTo("SOCKETTIMEOUT") == 0) {
                sQLException2 = this.exceptions.getException(6107, "08S01");
            }
            throw sQLException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendCancelRequest(int n2) throws SQLException {
        Object object = this.cancelSyncObject;
        synchronized (object) {
            if (this.isCancelPending) {
                return false;
            }
            this.isCancelPending = true;
        }
        if (this.state != 4 && this.connection.implConnection != null && this.executeState == 2) {
            this.implStatement.cancel(n2);
        }
        object = this.cancelSyncObject;
        synchronized (object) {
            this.isCancelPending = false;
        }
        return true;
    }

    private final void setupImplStatement() throws SQLException {
        this.implStatement = this.connection.implConnection.createImplStatement(this.resultSetScrollType, this.resultSetConcurrency);
        this.implStatement.setup(this.connection.implConnection, this.warnings);
        this.implStatement.setFetchSize(this.resultSetFetchSize);
        this.implStatement.setMaxFieldSize(this.maxFieldSize);
        this.implStatement.setMaxRows(this.maxRows);
    }

    private BaseEscapeTranslator getEscapeTranslator(String string) throws SQLException {
        if (this.escapeTranslator == null && string.indexOf(123) != -1) {
            this.escapeTranslator = this.connection.getEscapeTranslator();
            if (this.escapeTranslator != null) {
                this.escapeTranslator.setWarnings(this.warnings);
                this.escapeTranslator.setExceptions(this.exceptions);
            }
            this.implStatement.setEscapeTranslator(this.escapeTranslator);
        }
        if (this.escapeTranslator != null) {
            this.escapeTranslator.reset();
            this.escapeTranslator.setImplStatement(this.implStatement);
        }
        return this.escapeTranslator;
    }

    public final BaseImplResultSet getNextImplResultSet() throws SQLException {
        BaseImplResultSet baseImplResultSet = null;
        if (this.emulatedDatabaseMetaDataResultSet()) {
            baseImplResultSet = this.getEmulatatedDatabaseMetaDataImplResultSet();
        } else {
            baseImplResultSet = this.implStatement.implConnection.getImplResultSet();
            if (baseImplResultSet == null) {
                baseImplResultSet = this.implStatement.getNextResultSet();
            } else {
                this.implStatement.setupNextResultSet(baseImplResultSet);
            }
        }
        if (baseImplResultSet != null) {
            baseImplResultSet.setImplStatement(this.implStatement);
        }
        return baseImplResultSet;
    }

    protected final void resultSetClosed(BaseResultSet baseResultSet) {
        this.currentResultSets.removeElement(baseResultSet);
        if (this.databaseMetaDataResultSet != 0) {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private BaseImplResultSet getEmulatatedDatabaseMetaDataImplResultSet() throws SQLException {
        BaseImplResultSet baseImplResultSet = null;
        switch (this.databaseMetaDataResultSet) {
            case 3: {
                baseImplResultSet = new BaseTypeInfoImplResultSet((BaseTypeInfos)this.databaseMetaDataResultSetInfo);
                break;
            }
            case 4: {
                baseImplResultSet = new BaseTableTypesImplResultSet((BaseTableTypes)this.databaseMetaDataResultSetInfo);
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                baseImplResultSet = new BaseImplResultSetClientSideEmpty();
            }
        }
        baseImplResultSet.setImplStatement(this.implStatement);
        return baseImplResultSet;
    }

    private boolean emulatedDatabaseMetaDataResultSet() {
        return this.databaseMetaDataResultSetInfo != null || this.databaseMetaDataResultSet == 17 || this.databaseMetaDataResultSet == 19 || this.databaseMetaDataResultSet == 20 || this.databaseMetaDataResultSet == 21;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getMoreResults(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state != 3) {
                return false;
            }
            if (this.implStatement == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.closeCurrentResults(n2, true);
            this.currentColumns = null;
            boolean bl = this.getNextResultType();
            if (this.currentResultType != 1) {
                this.multipleResultsReturned = true;
            }
            return bl;
        }
    }

    public final ResultSet getGeneratedKeys() throws SQLException {
        if (this.implStatement == null || this.connection.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        BaseImplResultSet baseImplResultSet = null;
        if (!this.autoGeneratedKeysRequested) {
            String[] stringArray = new String[]{"Statement.getGeneratedKeys"};
            throw this.exceptions.getException(6093, stringArray);
        }
        BaseColumns baseColumns = this.implStatement.describeAutoGeneratedKeyColumns();
        if (baseColumns != null) {
            baseImplResultSet = this.implStatement.getAutoGeneratedKeyResultSet();
        } else {
            baseColumns = new BaseColumns();
            baseImplResultSet = new BaseImplResultSetClientSideEmpty();
        }
        BaseResultSet baseResultSet = null;
        if (baseImplResultSet != null) {
            baseResultSet = new BaseResultSet(this, baseColumns, baseImplResultSet);
        }
        if (baseResultSet == null) {
            throw this.exceptions.getException(6093);
        }
        return baseResultSet;
    }

    public int executeUpdate(String string, int n2) throws SQLException {
        if (this.implStatement == null || this.connection.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (n2 == 2) {
            return this.executeUpdate(string);
        }
        if (n2 != 1) {
            String[] stringArray = new String[]{"Statement.executeUpdate"};
            throw this.exceptions.getException(6069, stringArray);
        }
        if (this.connection.getMetaData().supportsGetGeneratedKeys()) {
            this.commonTransitionToState(1);
            this.autoGeneratedKeysRequested = true;
            this.commonValidateSQL(string);
            this.preProcessSQL(string);
            return this.executeUpdateInternal();
        }
        String[] stringArray = new String[]{"Statement.executeUpdate(String, int)"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public final int executeUpdate(String string, int[] nArray) throws SQLException {
        String[] stringArray = new String[]{"Statement.executeUpdate"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public final int executeUpdate(String string, String[] stringArray) throws SQLException {
        String[] stringArray2 = new String[]{"Statement.executeUpdate"};
        throw this.exceptions.getException(6003, stringArray2);
    }

    public boolean execute(String string, int n2) throws SQLException {
        if (this.implStatement == null || this.connection.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (n2 == 2) {
            return this.execute(string);
        }
        if (n2 != 1) {
            String[] stringArray = new String[]{"Statement.execute"};
            throw this.exceptions.getException(6069, stringArray);
        }
        if (this.connection.getMetaData().supportsGetGeneratedKeys()) {
            this.commonTransitionToState(1);
            this.autoGeneratedKeysRequested = true;
            this.commonValidateSQL(string);
            this.preProcessSQL(string);
            return this.executeInternal();
        }
        String[] stringArray = new String[]{"Statement.execute(String, int)"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public final boolean execute(String string, int[] nArray) throws SQLException {
        String[] stringArray = new String[]{"Statement.execute"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public final boolean execute(String string, String[] stringArray) throws SQLException {
        String[] stringArray2 = new String[]{"Statement.execute"};
        throw this.exceptions.getException(6003, stringArray2);
    }

    public final int getResultSetHoldability() throws SQLException {
        String[] stringArray = new String[]{"Statement.getResultSetHoldability"};
        throw this.exceptions.getException(6003, stringArray);
    }
}

