/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIFUNDataPacket;
import com.metamatrix.util.UtilException;
import java.net.InetAddress;
import java.sql.SQLException;

public class TTIFUN_OAUTHENTICATE
extends TTIFUNDataPacket {
    private static String footprint = "$Revision:   1.12.1.1  $";
    private String userName;
    private byte[] encryptedPassword;
    private String localhost;
    private String progName;
    private byte[] encryptionKey;
    private boolean wireCSmatchesOracleCS;
    private boolean useOSAuthentication;
    private int sysLoginRole;
    private boolean obtainedEncryptionKey;
    private boolean supportLinks;

    public TTIFUN_OAUTHENTICATE(String string, boolean bl, boolean bl2, int n) {
        this.TTCCode = 3;
        if (string == null || string.length() <= 0) {
            this.FUNCode = 115;
            this.useOSAuthentication = true;
        } else {
            this.FUNCode = 118;
            this.useOSAuthentication = false;
        }
        this.supportLinks = bl2;
        this.sysLoginRole = n;
        this.userName = string;
        this.obtainedEncryptionKey = false;
        try {
            this.localhost = InetAddress.getLocalHost().toString();
        }
        catch (Exception exception) {
            this.localhost = "unknownclient";
        }
        this.progName = "JDBC Connect Client";
        this.wireCSmatchesOracleCS = bl;
    }

    public void setEncryptedPassword(byte[] byArray) {
        this.encryptedPassword = byArray == null ? new byte[0] : byArray;
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException {
        byte[] byArray = null;
        if (this.userName != null) {
            byArray = oracleDataConsumer.getTransliterator().encode(this.userName);
        }
        oracleDataConsumer.writeByte((byte)1);
        oracleDataConsumer.writeB4(byArray.length);
        if (this.obtainedEncryptionKey) {
            oracleDataConsumer.writeB4((long)this.sysLoginRole | 1L | 0x100L);
            oracleDataConsumer.writeByte((byte)1);
            if (this.supportLinks) {
                oracleDataConsumer.writeB4(1);
            } else {
                oracleDataConsumer.writeB4(3);
            }
            oracleDataConsumer.writeByte((byte)1);
            oracleDataConsumer.writeByte((byte)1);
            if (this.wireCSmatchesOracleCS) {
                oracleDataConsumer.writeBytes(byArray, 0, byArray.length);
            } else {
                oracleDataConsumer.writeCLR(byArray, 0, byArray.length);
            }
            byte[] byArray2 = oracleDataConsumer.getTransliterator().encode("AUTH_PASSWORD");
            oracleDataConsumer.writeB4(byArray2.length);
            oracleDataConsumer.writeCLR(byArray2, 0, byArray2.length);
            oracleDataConsumer.writeB4(this.encryptedPassword.length);
            oracleDataConsumer.writeCLR(this.encryptedPassword, 0, this.encryptedPassword.length);
            oracleDataConsumer.writeB4(0);
            if (!this.supportLinks) {
                byte[] byArray3 = oracleDataConsumer.getTransliterator().encode("AUTH_INTERNALNAME_");
                byArray3[byArray3.length - 1] = 0;
                oracleDataConsumer.writeB4(byArray3.length);
                oracleDataConsumer.writeCLR(byArray3, 0, byArray3.length);
                byte[] byArray4 = oracleDataConsumer.getTransliterator().encode("jdbc_ttc_impl");
                oracleDataConsumer.writeB4(byArray4.length);
                oracleDataConsumer.writeCLR(byArray4, 0, byArray4.length);
                oracleDataConsumer.writeB4(0);
                byte[] byArray5 = oracleDataConsumer.getTransliterator().encode("AUTH_EXTERNALNAME_");
                byArray5[byArray5.length - 1] = 0;
                oracleDataConsumer.writeB4(byArray5.length);
                oracleDataConsumer.writeCLR(byArray5, 0, byArray5.length);
                byte[] byArray6 = oracleDataConsumer.getTransliterator().encode("jdbc_1");
                oracleDataConsumer.writeB4(byArray6.length);
                oracleDataConsumer.writeCLR(byArray6, 0, byArray6.length);
                oracleDataConsumer.writeB4(0);
            }
        } else {
            oracleDataConsumer.writeB4((long)this.sysLoginRole | 1L);
            oracleDataConsumer.writeByte((byte)1);
            oracleDataConsumer.writeB4(2);
            oracleDataConsumer.writeByte((byte)1);
            oracleDataConsumer.writeByte((byte)1);
            if (this.wireCSmatchesOracleCS) {
                oracleDataConsumer.writeBytes(byArray, 0, byArray.length);
            } else if (byArray.length > 0) {
                oracleDataConsumer.writeCLR(byArray, 0, byArray.length);
            }
            byte[] byArray7 = oracleDataConsumer.getTransliterator().encode("AUTH_PROGRAM_NM");
            oracleDataConsumer.writeB4(byArray7.length);
            oracleDataConsumer.writeCLR(byArray7, 0, byArray7.length);
            byte[] byArray8 = oracleDataConsumer.getTransliterator().encode(this.progName);
            oracleDataConsumer.writeB4(byArray8.length);
            oracleDataConsumer.writeCLR(byArray8, 0, byArray8.length);
            oracleDataConsumer.writeB4(0);
            byte[] byArray9 = oracleDataConsumer.getTransliterator().encode("AUTH_MACHINE");
            oracleDataConsumer.writeB4(byArray9.length);
            oracleDataConsumer.writeCLR(byArray9, 0, byArray9.length);
            byte[] byArray10 = oracleDataConsumer.getTransliterator().encode(this.localhost);
            oracleDataConsumer.writeB4(byArray10.length);
            oracleDataConsumer.writeCLR(byArray10, 0, byArray10.length);
            oracleDataConsumer.writeB4(0);
        }
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        String string;
        short s = oracleDataProvider.readB2();
        byte[][] byArrayArray = new byte[s][];
        byte[][] byArrayArray2 = new byte[s][];
        this.readKeyValuePairs(oracleDataProvider, byArrayArray, byArrayArray2, s);
        if (!this.obtainedEncryptionKey && (string = oracleDataProvider.getTransliterator().decode(byArrayArray[0], 0, byArrayArray[0].length)).equalsIgnoreCase("AUTH_SESSKEY")) {
            this.encryptionKey = byArrayArray2[0];
            this.obtainedEncryptionKey = true;
            this.FUNCode = 115;
        }
    }

    void readKeyValuePairs(OracleDataProvider oracleDataProvider, byte[][] byArray, byte[][] byArray2, int n) throws UtilException, SQLException {
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = oracleDataProvider.readB4();
            if (n3 > 0) {
                byArray[i] = oracleDataProvider.readCLR(n3);
            }
            if ((n2 = oracleDataProvider.readB4()) > 0) {
                byArray2[i] = oracleDataProvider.readCLR(n2);
            }
            oracleDataProvider.readB4();
        }
    }
}

