/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class UtilTransliteratorUsingSunIO
extends UtilTransliterator {
    private static String footprint = "$Revision:   3.9.2.0  $";
    private String encoding;
    private CharToByteConverter c2b;
    private ByteToCharConverter b2c;
    private int maxBytesPerChar;
    private int maxCharsPerByte;

    public UtilTransliteratorUsingSunIO(String string) throws UtilException {
        try {
            this.encoding = string;
            this.c2b = CharToByteConverter.getConverter((String)string);
            this.b2c = ByteToCharConverter.getConverter((String)string);
            this.maxBytesPerChar = this.c2b.getMaxBytesPerChar();
            this.maxCharsPerByte = this.b2c.getMaxCharsPerByte();
            this.setDefaultCacheSize();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, string);
        }
    }

    public boolean isFixedBytesPerChar() {
        return this.c2b.getMaxBytesPerChar() == 1;
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public int getMaxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    public byte[] encode(String string) throws UtilException {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        try {
            return this.c2b.convertAll(cArray);
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n = string.length();
        int n2 = n * this.maxBytesPerChar;
        this.setCacheSize(n);
        try {
            this.c2b.reset();
            this.c2b.setSubstitutionMode(true);
            string.getChars(0, n, this.charsCache, 0);
            int n3 = this.c2b.convert(this.charsCache, 0, n, this.bytesCache, 0, n2);
            nArray[0] = n3 += this.c2b.flush(this.bytesCache, this.c2b.nextByteIndex(), n2);
            return this.bytesCache;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public void encode(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n > 0) {
                int n2 = Math.min(n, this.streamChunkSize);
                int n3 = inputStream.read(this.bytesCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                int n4 = 0;
                while (n4 < n3) {
                    this.charsCache[n4] = (char)(this.bytesCache[n4] & 0xFF);
                    ++n4;
                }
                outputStreamWriter.write(this.charsCache, 0, n3);
                n -= n3;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n > 0) {
                int n2 = Math.min(n, this.streamChunkSize);
                int n3 = reader.read(this.charsCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                outputStreamWriter.write(this.charsCache, 0, n3);
                n -= n3;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public String decode(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 == 0) {
            return UtilTransliterator.EMPTY_STRING;
        }
        int n3 = n2 * this.maxCharsPerByte;
        this.setCacheSize(n3);
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n4 = this.b2c.convert(byArray, n, n + n2, this.charsCache, 0, n3);
            n4 += this.b2c.flush(this.charsCache, n4, n3);
            return new String(this.charsCache, 0, n4);
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public int decode(byte[] byArray, int n, int n2, char[] cArray) throws UtilException {
        if (n2 == 0) {
            return 0;
        }
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n3 = this.b2c.convert(byArray, n, n + n2, cArray, 0, cArray.length);
            n3 += this.b2c.flush(cArray, n3, cArray.length);
            return n3;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public String decode(byte[] byArray, int n, int n2, int n3) throws UtilException {
        int n4 = n2 * this.maxCharsPerByte;
        int n5 = Math.max(n4, n3);
        this.setCacheSize(n5);
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n6 = this.b2c.convert(byArray, n, n + n2, this.charsCache, 0, n4);
            n6 += this.b2c.flush(this.charsCache, n6, n4);
            int n7 = n6;
            while (n7 < n3) {
                this.charsCache[n7] = 32;
                ++n7;
            }
            return new String(this.charsCache, 0, n3);
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public Reader decodeAsReader(InputStream inputStream) throws UtilException {
        try {
            return new InputStreamReader(inputStream, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, this.encoding);
        }
    }
}

