/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyConfigInterface;
import com.metamatrix.jdbcspy.SpyLogger;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.util.Properties;

public class SpyLoggerForDriver
extends SpyLogger {
    private static String footprint = "$Revision:   1.4.1.0  $";
    private PrintWriter logWriter;

    public SpyLoggerForDriver() {
        this.setOptions(this.getDefaultProperties());
    }

    protected void readConfig(SpyConfigInterface spyConfigInterface) {
        Integer n;
        Boolean bl;
        this.logWriter = spyConfigInterface.getLogWriter();
        String string = spyConfigInterface.getClassnameToLoad();
        if (string != null) {
            try {
                Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((bl = spyConfigInterface.getLogTimestamp()) != null) {
            this.logTimestamp = bl;
        }
        if ((n = spyConfigInterface.getLogInputStreams()) != null) {
            switch (n) {
                case 1: {
                    this.logIS = true;
                    this.logSingleRead = true;
                    break;
                }
                case 2: {
                    this.logIS = false;
                    this.logSingleRead = false;
                    break;
                }
                case 3: {
                    this.logIS = true;
                    this.logSingleRead = false;
                }
            }
        }
        if ((n = spyConfigInterface.getLogLobs()) != null) {
            switch (n) {
                case 1: {
                    this.logLobs = true;
                    break;
                }
                case 2: {
                    this.logLobs = false;
                }
            }
        }
        this.logTName = spyConfigInterface.getLogThreadName();
        n = spyConfigInterface.getLineLimit();
        if (n != null) {
            this.linelimit = n;
        }
        if (this.linelimit < 0) {
            this.linelimit = 0;
        }
    }

    private Properties getDefaultProperties() {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream("spy.properties");
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    final void enter() {
    }

    final void leave() {
    }

    protected PrintWriter getLog() {
        if (this.logWriter != null) {
            return this.logWriter;
        }
        return DriverManager.getLogWriter();
    }
}

