/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.ddtek.jdbc.extensions.ExtEmbeddedConnection;
import com.ddtek.jdbc.extensions.SlExtensionInterface;
import com.metamatrix.jdbcspy.SpyConnection;
import com.metamatrix.jdbcspy.SpyConnectionEventListener;
import com.metamatrix.jdbcspy.SpyLoggerForDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class SpyPooledConnection
implements PooledConnection,
ExtEmbeddedConnection,
SlExtensionInterface,
com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection,
com.merant.SlExtensionInterface {
    private static String footprint = "$Revision:   1.3.1.0  $";
    protected PooledConnection realPooledConnection;
    protected SpyLoggerForDataSource spyLogger;
    protected Hashtable hash;
    private int id;
    private static int Id = 0;

    protected SpyPooledConnection() {
    }

    public SpyPooledConnection(PooledConnection pooledConnection, SpyLoggerForDataSource spyLoggerForDataSource) {
        this.realPooledConnection = pooledConnection;
        this.spyLogger = spyLoggerForDataSource;
        if (spyLoggerForDataSource.logCEL) {
            this.hash = new Hashtable();
        }
        this.id = ++Id;
    }

    public final Connection getConnection() throws SQLException {
        Connection connection;
        this.spyLogger.println("\n" + this + ".getConnection()");
        try {
            connection = this.realPooledConnection.getConnection();
        }
        catch (Throwable throwable) {
            throw this.spyLogger.sqlException(throwable);
        }
        SpyConnection spyConnection = new SpyConnection(connection, this.spyLogger);
        this.spyLogger.println("OK (" + spyConnection + ")");
        return spyConnection;
    }

    public final void close() throws SQLException {
        this.spyLogger.println("\n" + this + ".close()");
        try {
            this.realPooledConnection.close();
        }
        catch (Throwable throwable) {
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.println("OK");
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.spyLogger.println("\n" + this + ".addConnectionEventListener(ConnectionEventListener connectionEventListener)");
        if (this.spyLogger.logCEL) {
            SpyConnectionEventListener spyConnectionEventListener = (SpyConnectionEventListener)this.hash.get(connectionEventListener);
            if (spyConnectionEventListener == null) {
                spyConnectionEventListener = new SpyConnectionEventListener(connectionEventListener, this, this.spyLogger);
                this.hash.put(connectionEventListener, spyConnectionEventListener);
            }
            this.spyLogger.println("connectionEventListener = " + spyConnectionEventListener + " = " + connectionEventListener);
            this.realPooledConnection.addConnectionEventListener(spyConnectionEventListener);
        } else {
            this.realPooledConnection.addConnectionEventListener(connectionEventListener);
        }
        this.spyLogger.println("OK");
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.spyLogger.println("\n" + this + ".removeConnectionEventListener(ConnectionEventListener connectionEventListener)");
        if (this.spyLogger.logCEL) {
            SpyConnectionEventListener spyConnectionEventListener = (SpyConnectionEventListener)this.hash.get(connectionEventListener);
            if (spyConnectionEventListener == null) {
                this.spyLogger.println("connectionEventListener = (not registered) " + connectionEventListener);
                this.realPooledConnection.removeConnectionEventListener(connectionEventListener);
                this.spyLogger.println("OK");
                return;
            }
            this.spyLogger.println("connectionEventListener = " + spyConnectionEventListener);
            this.realPooledConnection.removeConnectionEventListener(spyConnectionEventListener);
            this.hash.remove(connectionEventListener);
        } else {
            this.realPooledConnection.removeConnectionEventListener(connectionEventListener);
        }
        this.spyLogger.println("OK");
    }

    public boolean unlock(String string) throws SQLException {
        if (this.realPooledConnection instanceof ExtEmbeddedConnection) {
            ExtEmbeddedConnection extEmbeddedConnection = (ExtEmbeddedConnection)this.realPooledConnection;
            return extEmbeddedConnection.unlock(string);
        }
        if (this.realPooledConnection instanceof com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection) {
            com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection extEmbeddedConnection = (com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection)this.realPooledConnection;
            return extEmbeddedConnection.unlock(string);
        }
        throw new SQLException("This method cannot be called on this driver");
    }

    public void setApplicationId(String string) throws SQLException {
        if (this.realPooledConnection instanceof SlExtensionInterface) {
            SlExtensionInterface slExtensionInterface = (SlExtensionInterface)((Object)this.realPooledConnection);
            slExtensionInterface.setApplicationId(string);
        } else if (this.realPooledConnection instanceof com.merant.SlExtensionInterface) {
            com.merant.SlExtensionInterface slExtensionInterface = (com.merant.SlExtensionInterface)((Object)this.realPooledConnection);
            slExtensionInterface.setApplicationId(string);
        } else {
            throw new SQLException("This method cannot be called on this driver");
        }
    }

    public void setOemId(String string) throws SQLException {
        if (!(this.realPooledConnection instanceof com.merant.SlExtensionInterface)) {
            throw new SQLException("This method cannot be called on this driver");
        }
        com.merant.SlExtensionInterface slExtensionInterface = (com.merant.SlExtensionInterface)((Object)this.realPooledConnection);
        slExtensionInterface.setOemId(string);
    }

    public String toString() {
        return "PooledConnection[" + this.id + "]";
    }
}

