/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.resource.jdbc.spi;

import com.metamatrix.resource.jdbc.spi.JCAExceptions;
import com.metamatrix.resource.jdbc.spi.JCALogger;
import com.metamatrix.util.UtilDebug;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionMetaData;

public class JCAManagedConnectionMetaData
implements ManagedConnectionMetaData {
    private static String footprint = "$Revision:   3.0.6.0  $";
    private Connection physConnectionHandle;
    private String databaseName;
    private String databaseVersion;
    private int maxConnections;
    private String userName;
    protected JCALogger logger;
    private JCAExceptions exceptions;

    public JCAManagedConnectionMetaData(Connection connection, JCALogger jCALogger, JCAExceptions jCAExceptions) {
        UtilDebug.assert("physConnecitonHandle must not be null", connection != null);
        UtilDebug.assert("exceptions must not be null", jCAExceptions != null);
        this.physConnectionHandle = connection;
        this.logger = jCALogger;
        this.exceptions = jCAExceptions;
        this.databaseName = null;
        this.databaseVersion = null;
        this.maxConnections = -1;
        this.userName = null;
    }

    public String getEISProductName() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionMetaData.getEISProductName()");
        }
        if (this.databaseName == null) {
            this.fetchMetaData();
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionMetaData.getEISProductName", this.databaseName);
        }
        return this.databaseName;
    }

    public String getEISProductVersion() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionMetaData.getEISProductVersion()");
        }
        if (this.databaseVersion == null) {
            this.fetchMetaData();
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionMetaData.getEISProductVersion", this.databaseVersion);
        }
        return this.databaseVersion;
    }

    public int getMaxConnections() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionMetaData.getMaxConnections()");
        }
        if (this.maxConnections == -1) {
            this.fetchMetaData();
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionMetaData.getMaxConnections", String.valueOf(this.maxConnections));
        }
        return this.maxConnections;
    }

    public String getUserName() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionMetaData.getUserName()");
        }
        if (this.userName == null) {
            this.fetchMetaData();
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionMetaData.getUserName", this.userName);
        }
        return this.userName;
    }

    private void fetchMetaData() throws ResourceException {
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = this.physConnectionHandle.getMetaData();
            this.databaseName = databaseMetaData.getDatabaseProductName();
            this.databaseVersion = databaseMetaData.getDatabaseProductVersion();
            this.maxConnections = databaseMetaData.getMaxConnections();
            this.userName = databaseMetaData.getUserName();
        }
        catch (SQLException sQLException) {
            throw this.exceptions.getException(sQLException, 4308, 1);
        }
    }
}

