/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilBufferedDataConsumer;
import com.metamatrix.util.UtilDataConsumer;
import com.metamatrix.util.UtilException;

public abstract class UtilPacketizingDataConsumer
implements UtilDataConsumer {
    private static String footprint = "$Revision:   3.4.5.0  $";
    protected UtilDataConsumer dataConsumerObject;
    protected int numBytesInCurrentPacket;
    protected int numPacketsCreatedSinceSend;
    protected int packetSize;
    private int numPacketsBuffered;
    private static final int MAX_BYTES_TO_BUFFER_BEFORE_SEND = 20000;
    private int numPacketsToBuffer;

    public UtilPacketizingDataConsumer(UtilDataConsumer utilDataConsumer, int n) {
        this.dataConsumerObject = utilDataConsumer;
        this.setPacketSize(n);
        this.numBytesInCurrentPacket = 0;
        this.numPacketsCreatedSinceSend = 0;
        this.numPacketsBuffered = 0;
    }

    public void setPacketSize(int n) {
        if (n > 0) {
            this.packetSize = n;
        }
        this.numPacketsToBuffer = 20000 / this.packetSize;
        ((UtilBufferedDataConsumer)this.dataConsumerObject).setBufferIncrementSize(this.packetSize * this.numPacketsToBuffer);
    }

    protected void signalStartOfPacket() throws UtilException {
    }

    protected void signalEndOfPacket(boolean bl) throws UtilException {
    }

    private void checkForStartOfPacket() throws UtilException {
        if (this.numBytesInCurrentPacket == 0) {
            this.signalStartOfPacket();
        } else if (this.numBytesInCurrentPacket == this.packetSize) {
            this.signalEndOfPacket(false);
            if (this.numPacketsBuffered < this.numPacketsToBuffer - 1) {
                ++this.numPacketsBuffered;
            } else {
                this.dataConsumerObject.send();
                this.numPacketsBuffered = 0;
            }
            ++this.numPacketsCreatedSinceSend;
            this.numBytesInCurrentPacket = 0;
            this.signalStartOfPacket();
        }
    }

    public void putByte(byte by) throws UtilException {
        this.checkForStartOfPacket();
        this.dataConsumerObject.putByte(by);
        ++this.numBytesInCurrentPacket;
    }

    public void putArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 <= 0) {
            return;
        }
        int n3 = n2;
        while (n3 != 0) {
            this.checkForStartOfPacket();
            int n4 = n3 <= this.packetSize - this.numBytesInCurrentPacket ? n3 : this.packetSize - this.numBytesInCurrentPacket;
            this.dataConsumerObject.putArrayOfBytes(byArray, n + (n2 - n3), n4);
            n3 -= n4;
            this.numBytesInCurrentPacket += n4;
        }
    }

    public int getPosition() throws UtilException {
        return this.dataConsumerObject.getPosition();
    }

    public void setPosition(int n) throws UtilException {
        this.dataConsumerObject.setPosition(n);
    }

    public void send() throws UtilException {
        if (this.numBytesInCurrentPacket > 0) {
            this.signalEndOfPacket(true);
        }
        this.dataConsumerObject.send();
        this.numPacketsCreatedSinceSend = 0;
        this.numBytesInCurrentPacket = 0;
        this.numPacketsBuffered = 0;
    }

    protected void writeInt8(int n) throws UtilException {
        this.dataConsumerObject.putByte((byte)n);
    }

    protected void writeInt16(int n) throws UtilException {
        this.dataConsumerObject.putByte((byte)(n >> 8 & 0xFF));
        this.dataConsumerObject.putByte((byte)(n >> 0 & 0xFF));
    }
}

