/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

public final class BaseResultSetFilterDescriptor {
    private static String footprint = "$Revision:   3.3.1.0  $";
    private int[] filterColumns;
    private Object[] filterValues;
    private boolean[] patterns;
    private boolean allRestrictionsRemoved;

    public BaseResultSetFilterDescriptor(int[] nArray, Object[] objectArray, boolean[] blArray, boolean bl) {
        this.filterColumns = nArray;
        this.filterValues = objectArray;
        this.patterns = blArray;
        if (bl) {
            this.stripDoubleQuotesFromValues();
        }
    }

    private void stripDoubleQuotesFromValues() {
        int n = this.filterValues.length;
        for (int i = 0; i < n; ++i) {
            Object object = this.filterValues[i];
            if (!(object instanceof String) || object == null || ((String)object).length() <= 0) continue;
            String string = (String)object;
            int n2 = string.length() - 1;
            if (string.charAt(0) != '\"' || string.charAt(n2) != '\"' || n2 <= 0) continue;
            string = string.substring(1, n2);
            this.filterValues[i] = string;
        }
    }

    public int getRestrictionCount() {
        int n = 0;
        if (this.filterColumns != null) {
            n = this.filterColumns.length;
        }
        return n;
    }

    public boolean allRestrictionsSatified() {
        if (this.allRestrictionsRemoved) {
            return true;
        }
        int n = this.getRestrictionCount();
        for (int i = 0; i < n; ++i) {
            if (this.filterValues[i] == null) continue;
            return false;
        }
        return true;
    }

    public Object getRestriction(int n) {
        int n2 = this.getRestrictionCount();
        for (int i = 0; i < n2; ++i) {
            if (this.filterColumns[i] != n) continue;
            return this.filterValues[i];
        }
        return null;
    }

    public boolean isPattern(int n) {
        return this.patterns[this.getIndex(n)];
    }

    public Object getRestrictionByIndex(int n) {
        return this.filterValues[n];
    }

    public void setRestrictionByIndex(int n, Object object) {
        this.filterValues[n] = object;
    }

    public boolean isPatternByIndex(int n) {
        return this.patterns[n];
    }

    public int getRestrictionColumnByIndex(int n) {
        return this.filterColumns[n];
    }

    public void removeRestriction(int n) {
        this.filterValues[this.getIndex((int)n)] = null;
    }

    public void removeAllRestrictions() {
        int n = this.getRestrictionCount();
        for (int i = 0; i < n; ++i) {
            this.filterValues[i] = null;
        }
        this.allRestrictionsRemoved = true;
    }

    public void removeAllRestrictions(boolean bl) {
        this.allRestrictionsRemoved = true;
        if (!bl) {
            this.removeAllRestrictions();
        }
    }

    private int getIndex(int n) {
        int n2 = this.getRestrictionCount();
        for (int i = 0; i < n2; ++i) {
            if (this.filterColumns[i] != n) continue;
            return i;
        }
        return 0;
    }

    public void setPattern(int n, boolean bl) {
        this.patterns[this.getIndex((int)n)] = bl;
    }
}

