/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.ui.viewsupport;

import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.ResourceNameUtil;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.notification.util.NotificationUtilities;
import com.metamatrix.modeler.core.refactor.OrganizeImportCommand;
import com.metamatrix.modeler.core.refactor.OrganizeImportHandler;
import com.metamatrix.modeler.core.search.runtime.ResourceImportRecord;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.core.validation.rules.CoreValidationRulesUtil;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import com.metamatrix.modeler.internal.ui.editors.OpenEditorMap;
import com.metamatrix.modeler.internal.ui.properties.ModelObjectAdapterFactoryContentProvider;
import com.metamatrix.modeler.internal.ui.util.DiagramProxy;
import com.metamatrix.modeler.internal.ui.viewsupport.MarkerUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelFileCache;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelObjectLabelProvider;
import com.metamatrix.modeler.internal.ui.viewsupport.OrganizeImportHandlerDialog;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.ui.UiConstants;
import com.metamatrix.modeler.ui.UiPlugin;
import com.metamatrix.modeler.ui.editors.ModelEditorManager;
import com.metamatrix.modeler.ui.event.ModelResourceEvent;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.ui.internal.InternalUiConstants;
import com.metamatrix.ui.internal.util.WidgetUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public abstract class ModelUtilities
implements UiConstants,
InternalUiConstants.Debug.Metrics {
    private static Container workspaceContainer;
    private static AdapterFactoryContentProvider emfContentProvider;
    private static ModelObjectAdapterFactoryContentProvider modelContentProvider;
    private static AdapterFactoryLabelProvider emfLabelProvider;
    private static AdapterFactoryItemDelegator emfItemDelegator;
    private static ContainerNotificationManager notificationMgr;
    private static ILabelProvider labelProvider;
    private static ModelFileCache modelFileCache;
    public static final String MODEL_FILE_EXTENSION = "xmi";
    public static final String VDB_FILE_EXTENSION = "vdb";
    public static final String XSD_FILE_EXTENSION = "xsd";
    public static final String DOT_MODEL_FILE_EXTENSION = ".xmi";
    public static final String DOT_VDB_FILE_EXTENSION = ".vdb";
    public static final String DOT_XSD_FILE_EXTENSION = ".xsd";
    private static final String I18N_PREFIX;
    private static final String FILE_DOES_NOT_EXIST_TITLE;
    private static final String FILE_DOES_NOT_EXIST_MSG_KEY = "fileDoesNotExist.message";
    private static final String CLOSED_PROJECT_TITLE;
    private static final String CLOSED_PROJECT_MSG_KEY = "projectClosed.message";
    private static final String MODEL_CHANGES_PENDING_TITLE;
    private static final String MODEL_CHANGES_PENDING_MSG_KEY = "modelChangesPending.message";
    private static final String MODEL_ERRORS_TITLE;
    private static final String MODEL_ERRORS_MSG_KEY = "modelHasErrors.message";
    private static final String MODEL_NOT_VALIDATED_TITLE;
    private static final String MODEL_NOT_VALIDATED_MSG_KEY = "modelNotValidated.message";
    private static final String MODEL_RESOURCE_NOT_FOUND_MSG_KEY = "modelResourceNotFound.message";
    private static final String MODEL_IMPORTED_NOT_FOUND_TITLE;
    private static final String MODEL_IMPORTED_NOT_FOUND_MSG_KEY = "modelHasMissingImports.message";
    private static final String MODEL_IMPORTED_PROBLEM_MSG_KEY = "importedError";
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$ui$viewsupport$ModelUtilities;

    private static String getString(String id) {
        return UiConstants.Util.getString(I18N_PREFIX + id);
    }

    private static String getString(String id, String arg) {
        return UiConstants.Util.getString(I18N_PREFIX + id, (Object)arg);
    }

    public static ITreeContentProvider getModelContentProvider() {
        if (modelContentProvider == null) {
            AdapterFactory factory = ModelerCore.getMetamodels().getEmfAdapterFactory();
            modelContentProvider = new ModelObjectAdapterFactoryContentProvider(factory);
        }
        return modelContentProvider;
    }

    public static AdapterFactoryContentProvider getEmfAdapterFactoryContentProvider() {
        if (emfContentProvider == null) {
            AdapterFactory factory = ModelerCore.getMetamodels().getEmfAdapterFactory();
            emfContentProvider = new AdapterFactoryContentProvider(factory);
        }
        return emfContentProvider;
    }

    public static AdapterFactoryItemDelegator getEMFItemDelegator() {
        if (emfItemDelegator == null) {
            AdapterFactory factory = ModelerCore.getMetamodels().getEmfAdapterFactory();
            emfItemDelegator = new AdapterFactoryItemDelegator(factory);
        }
        return emfItemDelegator;
    }

    public static AdapterFactoryLabelProvider getAdapterFactoryLabelProvider() {
        if (emfLabelProvider == null) {
            AdapterFactory factory = ModelerCore.getMetamodels().getEmfAdapterFactory();
            emfLabelProvider = new AdapterFactoryLabelProvider(factory);
        }
        return emfLabelProvider;
    }

    public static ILabelProvider getEMFLabelProvider() {
        if (labelProvider == null) {
            labelProvider = new ModelObjectLabelProvider();
        }
        return labelProvider;
    }

    public static ModelObjectLabelProvider getModelObjectLabelProvider() {
        if (labelProvider == null) {
            labelProvider = new ModelObjectLabelProvider();
        }
        return (ModelObjectLabelProvider)labelProvider;
    }

    public static IPropertySourceProvider getEmfPropertySourceProvider() {
        if (modelContentProvider == null) {
            AdapterFactory factory = ModelerCore.getMetamodels().getEmfAdapterFactory();
            modelContentProvider = new ModelObjectAdapterFactoryContentProvider(factory);
        }
        return modelContentProvider;
    }

    public static boolean isModelFile(IResource resource) {
        return modelFileCache.isModelFile(resource);
    }

    public static boolean isVdbFile(IResource resource) {
        String ext;
        boolean result = false;
        if (resource instanceof IFile && (ext = ((IFile)resource).getFileExtension()) != null && ext.equals(VDB_FILE_EXTENSION)) {
            result = true;
        }
        return result;
    }

    public static boolean isWsdlFile(IResource theResource) {
        String ext;
        boolean result = false;
        if (theResource instanceof IFile && (ext = ((IFile)theResource).getFileExtension()) != null && ext.equals("wsdl")) {
            result = true;
        }
        return result;
    }

    public static boolean isModelProjectResource(IResource resource) {
        IProject proj;
        return resource != null && (proj = resource.getProject()) != null && ModelerCore.hasModelNature((IProject)proj);
    }

    public static ModelResource getModelResource(Resource resource, boolean forceOpen) throws ModelWorkspaceException {
        if (resource == null) {
            return null;
        }
        return ModelerCore.getModelEditor().findModelResource(resource);
    }

    public static ModelResource getModelResource(IFile modelFile, boolean forceOpen) throws ModelWorkspaceException {
        if (modelFile == null) {
            return null;
        }
        return ModelerCore.getModelEditor().findModelResource(modelFile);
    }

    public static ModelResource getModelResourceForIFile(IFile modelFile, boolean forceOpen) {
        if (modelFile == null) {
            return null;
        }
        ModelResource mr = null;
        try {
            mr = ModelUtilities.getModelResource(modelFile, forceOpen);
        }
        catch (ModelWorkspaceException err1) {
            String message = UiConstants.Util.getString("ModelUtilities.errorFindingModelResource", (Object)modelFile);
            UiConstants.Util.log(4, (Throwable)err1, message);
        }
        return mr;
    }

    public static ModelResource getModelResourceForModelObject(EObject modelObject) {
        if (modelObject == null) {
            return null;
        }
        if (modelObject instanceof DiagramProxy) {
            ModelResource modelResource = ((DiagramProxy)modelObject).getModelResource();
            if (modelResource != null) {
                return modelResource;
            }
            return ModelerCore.getModelEditor().findModelResource(((DiagramProxy)modelObject).getTarget());
        }
        return ModelerCore.getModelEditor().findModelResource(modelObject);
    }

    public static Container getWorkspaceContainer() throws CoreException {
        if (workspaceContainer == null) {
            workspaceContainer = ModelerCore.getModelContainer();
        }
        return workspaceContainer;
    }

    public static boolean isModelInWorkspace(String theUuid) throws CoreException, ModelWorkspaceException {
        if (theUuid == null || theUuid.length() == 0) {
            return false;
        }
        boolean result = false;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        if (projects != null && projects.length > 0) {
            block0: for (int i = 0; i < projects.length; ++i) {
                IResource[] resources = projects[i].members();
                if (resources == null || resources.length <= 0) continue;
                for (int j = 0; j < resources.length; ++j) {
                    ModelResource modelResource;
                    String uuid;
                    if (!ModelUtilities.isModelFile(resources[j]) || (uuid = (modelResource = ModelUtilities.getModelResource((IFile)resources[j], false)).getUuid()) == null || !uuid.equals(theUuid)) continue;
                    result = true;
                    break block0;
                }
            }
        }
        return result;
    }

    public static void addNotifyChangedListener(INotifyChangedListener listener) {
        Container container = null;
        try {
            container = ModelUtilities.getWorkspaceContainer();
        }
        catch (CoreException e) {
            e.printStackTrace(System.err);
        }
        if (container != null) {
            if (notificationMgr == null) {
                notificationMgr = new ContainerNotificationManager();
                container.getChangeNotifier().addListener((INotifyChangedListener)notificationMgr);
            }
            notificationMgr.addNotifyChangedListener(listener);
        }
    }

    public static void removeNotifyChangedListener(INotifyChangedListener listener) {
        Container container = null;
        try {
            container = ModelUtilities.getWorkspaceContainer();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (container != null && notificationMgr != null) {
            notificationMgr.removeNotifyChangedListener(listener);
        }
    }

    public static boolean supportsModelDescription(IResource resource) {
        boolean result = false;
        if (ModelUtilities.isModelFile(resource)) {
            result = true;
            if (ModelUtil.isXsdFile((IResource)resource)) {
                result = false;
            }
        }
        return result;
    }

    public static void setModelDescription(ModelResource modelResource, String description) {
        if (!ModelUtilities.isReadOnly(modelResource)) {
            try {
                ModelAnnotation annotation = modelResource.getModelAnnotation();
                if (annotation != null) {
                    annotation.setDescription(description);
                } else {
                    UiConstants.Util.log(4, ModelUtilities.getString("ModelUtilities.nullModelAnnotation", modelResource.getPath().toString()));
                }
            }
            catch (ModelWorkspaceException ex) {
                String message = ModelUtilities.getString("ModelUtilities.setModelDescriptionError", modelResource.toString());
                UiConstants.Util.log(4, (Throwable)ex, message);
            }
        }
    }

    public static String getModelDescription(ModelResource model) {
        String result = "";
        try {
            result = model.getDescription();
        }
        catch (ModelWorkspaceException ex) {
            String message = ModelUtilities.getString("ModelUtilities.getModelDescriptionError", model.toString());
            UiConstants.Util.log(4, (Throwable)ex, message);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static boolean isVirtual(ModelResource modelResource) {
        boolean virtualState = false;
        if (modelResource != null) {
            try {
                virtualState = modelResource.getModelType().getValue() == 1;
            }
            catch (ModelWorkspaceException e) {
                String message = "[ModelUtilities.isVirtual()] ERROR: exception accessing ModelType";
                UiConstants.Util.log(4, (Throwable)e, message);
            }
        }
        return virtualState;
    }

    public static boolean isPhysical(ModelResource modelResource) {
        boolean physicalState = false;
        if (modelResource != null) {
            try {
                physicalState = modelResource.getModelType().getValue() == 0;
            }
            catch (ModelWorkspaceException e) {
                String message = "[ModelUtilities.isPhysical()] ERROR: exception accessing ModelType";
                UiConstants.Util.log(4, (Throwable)e, message);
            }
        }
        return physicalState;
    }

    public static boolean isLogical(ModelResource modelResource) {
        boolean result = false;
        if (modelResource != null) {
            try {
                result = modelResource.getModelType().getValue() == 9;
            }
            catch (ModelWorkspaceException e) {
                String message = "[ModelUtilities.isVirtual()] ERROR: exception accessing ModelType";
                UiConstants.Util.log(4, (Throwable)e, message);
            }
        }
        return result;
    }

    public static boolean isReadOnly(ModelResource modelResource) {
        boolean result = true;
        if (modelResource != null && OpenEditorMap.getInstance().isEditorOpen(modelResource)) {
            result = modelResource.isReadOnly();
        }
        return result;
    }

    public static boolean existsOnFilesystem(IResource theResource) {
        boolean result = false;
        if (theResource != null && theResource.getLocation() != null) {
            result = new File(theResource.getLocation().toOSString()).exists();
        }
        return result;
    }

    public static boolean areModelResourcesSame(EObject eObj1, EObject eObj2) {
        ModelResource mr1 = ModelUtilities.getModelResourceForModelObject(eObj1);
        ModelResource mr2 = ModelUtilities.getModelResourceForModelObject(eObj2);
        return mr1 != null && mr2 != null && mr1.equals(mr2);
    }

    public static boolean supportsDiagrams(ModelResource modelResource) {
        boolean result = false;
        if (modelResource != null) {
            MetamodelDescriptor md = null;
            try {
                md = modelResource.getPrimaryMetamodelDescriptor();
            }
            catch (ModelWorkspaceException e) {
                String message = "[ModelUtilities.supportsDiagrams()] ERROR: finding supports diagrams.  Resource = " + modelResource;
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            if (md != null) {
                result = md.supportsDiagrams();
            }
        }
        return result;
    }

    public static boolean supportsDiagrams(Object input) {
        MetamodelDescriptor md = null;
        boolean result = false;
        if (input != null) {
            try {
                ModelResource mr;
                if (input instanceof EObject && ((EObject)input).eResource() != null) {
                    md = ModelerCore.getModelEditor().getMetamodelDescriptor((EObject)input);
                } else if (input instanceof ModelResource) {
                    md = (MetamodelDescriptor)input;
                } else if (input instanceof IFile) {
                    ModelResource mr2 = ModelUtilities.getModelResource((IFile)input, false);
                    if (mr2 != null) {
                        md = mr2.getPrimaryMetamodelDescriptor();
                    }
                } else if (input instanceof Resource && (mr = ModelUtilities.getModelResource((Resource)input, false)) != null) {
                    md = mr.getPrimaryMetamodelDescriptor();
                }
                if (md != null) {
                    result = md.supportsDiagrams();
                }
            }
            catch (ModelWorkspaceException e) {
                String message = "[ModelUtilities.supportsDiagrams(Object)] ERROR: finding supports diagrams.  Object = " + input;
                UiConstants.Util.log(4, (Throwable)e, message);
            }
        }
        return result;
    }

    public static String validateModelName(String proposedName, String fileExtension) {
        boolean removedValidExtension = false;
        if (proposedName.endsWith(fileExtension)) {
            proposedName = proposedName.substring(0, proposedName.lastIndexOf(fileExtension));
            removedValidExtension = true;
        }
        if (proposedName.indexOf(46) != -1 && !removedValidExtension) {
            return UiConstants.Util.getString("ModelUtilities.illegalExtensionMessage", (Object)fileExtension);
        }
        ValidationResultImpl result = new ValidationResultImpl((Object)proposedName);
        CoreValidationRulesUtil.validateStringNameChars((ValidationResult)result, (String)proposedName, null);
        if (result.hasProblems()) {
            return result.getProblems()[0].getMessage();
        }
        if (fileExtension != null) {
            String reservedError = null;
            if (fileExtension.equalsIgnoreCase(DOT_MODEL_FILE_EXTENSION) || fileExtension.equalsIgnoreCase(MODEL_FILE_EXTENSION) ? (reservedError = ModelUtilities.modelNameReservedValidation(proposedName)) != null : (fileExtension.equalsIgnoreCase(DOT_VDB_FILE_EXTENSION) || fileExtension.equalsIgnoreCase(VDB_FILE_EXTENSION) ? (reservedError = ModelUtilities.vdbNameReservedValidation(proposedName)) != null : (fileExtension.equalsIgnoreCase(DOT_XSD_FILE_EXTENSION) || fileExtension.equalsIgnoreCase(XSD_FILE_EXTENSION)) && (reservedError = ModelUtilities.schemaNameReservedValidation(proposedName)) != null)) {
                return reservedError;
            }
        }
        return null;
    }

    public static String modelNameReservedValidation(String proposedName) {
        boolean invalid = ResourceNameUtil.isReservedModelName((String)proposedName);
        if (invalid) {
            return UiConstants.Util.getString("ModelUtilities.modelNameIsReservedError", (Object)proposedName);
        }
        return null;
    }

    public static String schemaNameReservedValidation(String proposedName) {
        boolean invalid = ResourceNameUtil.isReservedSchemaName((String)proposedName);
        if (invalid) {
            return UiConstants.Util.getString("ModelUtilities.schemaNameIsReservedError", (Object)proposedName);
        }
        return null;
    }

    public static String vdbNameReservedValidation(String proposedName) {
        boolean invalid = ResourceNameUtil.isReservedVdbName((String)proposedName);
        if (invalid) {
            return UiConstants.Util.getString("ModelUtilities.vdbNameIsReservedError", (Object)proposedName);
        }
        return null;
    }

    public static Collection getResourcesUsedBy(IResource targetIFile) {
        if (targetIFile == null) {
            return Collections.EMPTY_LIST;
        }
        List modelImports = null;
        ArrayList<IResource> result = Collections.EMPTY_LIST;
        ModelResource targetModelResource = null;
        try {
            targetModelResource = ModelUtilities.getModelResource((IFile)targetIFile, false);
            if (targetModelResource != null) {
                modelImports = targetModelResource.getModelImports();
            }
        }
        catch (ModelWorkspaceException err) {
            String message = UiConstants.Util.getString("ModelUtilities.errorFindingImports", (Object)targetModelResource);
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        if (modelImports != null && !modelImports.isEmpty()) {
            result = new ArrayList<IResource>(modelImports.size());
            Iterator iter = modelImports.iterator();
            while (iter.hasNext()) {
                IResource resource;
                Object importObject = iter.next();
                String modelPath = null;
                if (importObject instanceof ModelImport) {
                    modelPath = ((ModelImport)importObject).getPath();
                } else if (importObject instanceof ResourceImportRecord) {
                    modelPath = ((ResourceImportRecord)importObject).getImportedPath();
                }
                if (modelPath == null || WorkspaceResourceFinderUtil.isGlobalResource((String)modelPath) || (resource = WorkspaceResourceFinderUtil.findIResource((String)modelPath)) == null || resource.equals(targetIFile)) continue;
                result.add(resource);
            }
        }
        if (result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    public static Collection getResourcesUsedBy(ModelResource targetModelResource) {
        if (targetModelResource == null) {
            return Collections.EMPTY_LIST;
        }
        List modelImports = null;
        ArrayList<Object> result = Collections.EMPTY_LIST;
        try {
            modelImports = targetModelResource.getModelImports();
        }
        catch (ModelWorkspaceException err) {
            String message = UiConstants.Util.getString("ModelUtilities.errorFindingImports", (Object)targetModelResource);
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        if (modelImports != null && !modelImports.isEmpty()) {
            result = new ArrayList<Object>(modelImports.size());
            Iterator iter = modelImports.iterator();
            while (iter.hasNext()) {
                Object importObject = iter.next();
                String modelPath = null;
                if (importObject instanceof ModelImport) {
                    modelPath = ((ModelImport)importObject).getPath();
                } else if (importObject instanceof ResourceImportRecord) {
                    modelPath = ((ResourceImportRecord)importObject).getImportedPath();
                }
                if (modelPath == null || WorkspaceResourceFinderUtil.isGlobalResource((String)modelPath)) continue;
                IResource resource = WorkspaceResourceFinderUtil.findIResource((String)modelPath);
                Object mr = null;
                if (resource != null) {
                    try {
                        mr = ModelUtilities.getModelResource((IFile)resource, false);
                    }
                    catch (ModelWorkspaceException err1) {
                        String message = UiConstants.Util.getString("ModelUtilities.errorFindingModelResource", (Object)resource);
                        UiConstants.Util.log(4, (Throwable)err1, message);
                    }
                }
                if (mr == null || mr.equals(targetModelResource)) continue;
                result.add(mr);
            }
        }
        if (result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    public static boolean allDependenciesOpenInWorkspace(ModelResource targetModelResource) {
        if (targetModelResource == null) {
            return true;
        }
        boolean result = true;
        List modelImports = null;
        try {
            modelImports = targetModelResource.getModelImports();
        }
        catch (ModelWorkspaceException err) {
            String message = "[ModelUtilities.allDependenciesOpenInWorkspace()] ERROR: finding model inports.  Resource = " + targetModelResource;
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        if (modelImports != null && !modelImports.isEmpty()) {
            Iterator iter = modelImports.iterator();
            while (iter.hasNext()) {
                Object importObject = iter.next();
                String modelPath = null;
                if (importObject instanceof ModelImport) {
                    modelPath = ((ModelImport)importObject).getPath();
                } else if (importObject instanceof ResourceImportRecord) {
                    modelPath = ((ResourceImportRecord)importObject).getImportedPath();
                }
                if (modelPath == null || WorkspaceResourceFinderUtil.isGlobalResource((String)modelPath)) continue;
                IResource resource = WorkspaceResourceFinderUtil.findIResource((String)modelPath);
                ModelResource mr = null;
                if (resource != null) {
                    try {
                        mr = ModelUtilities.getModelResource((IFile)resource, false);
                    }
                    catch (ModelWorkspaceException err1) {
                        String message = "[ModelUtilities.allDependenciesOpenInWorkspace()] ERROR: finding model resource.  IFile = " + resource;
                        UiConstants.Util.log(4, (Throwable)err1, message);
                    }
                    if (mr == null) {
                        result = false;
                    }
                } else {
                    result = false;
                }
                if (result) continue;
                break;
            }
        }
        return result;
    }

    public static boolean isDependent(ModelResource targetModelResource, ModelResource dependentModelResource) {
        if (targetModelResource == null) {
            return false;
        }
        return ModelUtilities.getResourcesUsedBy(targetModelResource).contains(dependentModelResource);
    }

    public static boolean isDependent(IResource targetResource, IResource dependentResource) {
        if (targetResource == null) {
            return false;
        }
        return ModelUtilities.getResourcesUsedBy(targetResource).contains(dependentResource);
    }

    public static boolean verifyWorkspaceValidationState(Collection iFiles, Object source, String failString) {
        boolean result = true;
        Collection dirtyModels = ModelEditorManager.getDirtyResources();
        Iterator iter = iFiles.iterator();
        while (iter.hasNext() && result) {
            String message;
            IFile file = (IFile)iter.next();
            if (file == null) continue;
            if (!file.exists()) {
                message = ModelUtilities.getString(FILE_DOES_NOT_EXIST_MSG_KEY, file.getFullPath().makeRelative().toString()) + failString;
                MessageDialog.openError(null, (String)FILE_DOES_NOT_EXIST_TITLE, (String)message);
                result = false;
                continue;
            }
            if (!file.getProject().isOpen()) {
                message = ModelUtilities.getString(CLOSED_PROJECT_MSG_KEY, file.getFullPath().makeRelative().toString()) + failString;
                MessageDialog.openError(null, (String)CLOSED_PROJECT_TITLE, (String)message);
                result = false;
                continue;
            }
            if (dirtyModels.contains(file)) {
                message = ModelUtilities.getString(MODEL_CHANGES_PENDING_MSG_KEY, file.getFullPath().makeRelative().toString()) + failString;
                MessageDialog.openError(null, (String)MODEL_CHANGES_PENDING_TITLE, (String)message);
                result = false;
                continue;
            }
            if (ModelUtilities.requiresValidation(file)) {
                message = ModelUtilities.getString(MODEL_NOT_VALIDATED_MSG_KEY, file.getFullPath().makeRelative().toString()) + failString;
                MessageDialog.openError(null, (String)MODEL_NOT_VALIDATED_TITLE, (String)message);
                result = false;
                continue;
            }
            if (!ModelUtilities.hasErrors(file, source)) continue;
            message = ModelUtilities.getString(MODEL_ERRORS_MSG_KEY, file.getFullPath().makeRelative().toString()) + failString;
            MessageDialog.openError(null, (String)MODEL_ERRORS_TITLE, (String)message);
            result = false;
        }
        return result;
    }

    public static boolean verifyWorkspaceValidationState(IFile iFile, Object source, String failString) {
        return ModelUtilities.verifyWorkspaceValidationState(iFile, source, failString, false);
    }

    public static boolean verifyWorkspaceValidationState(IFile iFile, Object source, String failString, boolean checkDependencies) {
        return ModelUtilities.verifyWorkspaceValidationState(iFile, source, failString, checkDependencies, null, new ArrayList());
    }

    private static boolean verifyWorkspaceValidationState(IFile iFile, Object source, String failString, boolean checkDependencies, IFile instigator, List theProcessedFiles) {
        boolean result = true;
        if (iFile == null) {
            result = false;
        } else if (!iFile.exists()) {
            ModelUtilities.showVerifyErrorDialog(FILE_DOES_NOT_EXIST_TITLE, FILE_DOES_NOT_EXIST_MSG_KEY, iFile, failString, instigator);
            result = false;
        } else {
            Collection dirtyModels = ModelEditorManager.getDirtyResources();
            if (!iFile.getProject().isOpen()) {
                ModelUtilities.showVerifyErrorDialog(CLOSED_PROJECT_TITLE, CLOSED_PROJECT_MSG_KEY, iFile, failString, instigator);
                result = false;
            } else if (dirtyModels.contains(iFile)) {
                ModelUtilities.showVerifyErrorDialog(MODEL_CHANGES_PENDING_TITLE, MODEL_CHANGES_PENDING_MSG_KEY, iFile, failString, instigator);
                result = false;
            } else if (ModelUtilities.requiresValidation(iFile)) {
                ModelUtilities.showVerifyErrorDialog(MODEL_NOT_VALIDATED_TITLE, MODEL_NOT_VALIDATED_MSG_KEY, iFile, failString, instigator);
                result = false;
            } else if (ModelUtilities.hasErrors(iFile, source)) {
                ModelUtilities.showVerifyErrorDialog(MODEL_ERRORS_TITLE, MODEL_ERRORS_MSG_KEY, iFile, failString, instigator);
                result = false;
            } else if (checkDependencies && !theProcessedFiles.contains(iFile)) {
                theProcessedFiles.add(iFile);
                result = ModelUtilities.verifyDependencyWorkspaceValidationState(iFile, source, failString, instigator, theProcessedFiles);
            }
        }
        return result;
    }

    private static void showVerifyErrorDialog(String dialogTitleText, String messageKey, IFile iFile, String failString, IFile instigator) {
        String msgStr = ModelUtilities.getString(messageKey, iFile.getFullPath().makeRelative().toString());
        String fullMessage = instigator != null ? ModelUtilities.getString(MODEL_IMPORTED_PROBLEM_MSG_KEY, instigator.getFullPath().makeRelative().toString()) + msgStr + failString : msgStr + failString;
        MessageDialog.openError(null, (String)dialogTitleText, (String)fullMessage);
    }

    private static boolean verifyDependencyWorkspaceValidationState(IFile iFile, Object source, String failString, IFile instigator, List theProcessedFiles) {
        if (instigator == null) {
            instigator = iFile;
        } else if (instigator.equals(iFile)) {
            return true;
        }
        try {
            boolean allDepsPresent = ModelUtilities.allDependenciesOpenInWorkspace(ModelUtilities.getModelResource(iFile, true));
            if (!allDepsPresent) {
                String message = ModelUtilities.getString(MODEL_IMPORTED_NOT_FOUND_MSG_KEY, instigator.getFullPath().makeRelative().toString()) + failString;
                MessageDialog.openError(null, (String)MODEL_IMPORTED_NOT_FOUND_TITLE, (String)message);
                return false;
            }
        }
        catch (ModelWorkspaceException ex) {
            String message = UiConstants.Util.getString("ModelUtilities.errorFindingDependents", (Object)iFile);
            UiConstants.Util.log(4, (Throwable)ex, message);
        }
        Collection c = ModelUtilities.getResourcesUsedBy((IResource)iFile);
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            IFile depFile = (IFile)iter.next();
            if (ModelUtilities.verifyWorkspaceValidationState(depFile, source, failString, true, instigator, theProcessedFiles)) continue;
            return false;
        }
        return true;
    }

    public static Collection getAllWorkspaceResources() {
        int i;
        ArrayList<IFile> allResources = new ArrayList<IFile>();
        FileResourceCollectorVisitor visitor = new FileResourceCollectorVisitor();
        if (ModelerCore.getModelWorkspace() != null && ModelerCore.getWorkspace().getRoot() != null) {
            IProject[] projects = ModelerCore.getWorkspace().getRoot().getProjects();
            for (i = 0; i < projects.length; ++i) {
                try {
                    projects[i].accept((IResourceVisitor)visitor);
                    continue;
                }
                catch (CoreException e) {
                    // empty catch block
                }
            }
        }
        IFile[] fileResources = visitor.getFileResources();
        for (i = 0; i < fileResources.length; ++i) {
            IPath path;
            IFile fileResource = fileResources[i];
            if (fileResource == null || (path = fileResource.getFullPath()).lastSegment().charAt(0) == '.' || !ModelUtilities.isModelFile((IResource)fileResource)) continue;
            allResources.add(fileResource);
        }
        return allResources;
    }

    public static Collection getResourcesThatUse(ModelResource resource) {
        ArrayList<Object> result = Collections.EMPTY_LIST;
        IResource theResource = resource.getResource();
        Collection dependants = WorkspaceResourceFinderUtil.getResourcesThatUse((IResource)theResource);
        Iterator it = dependants.iterator();
        IResource nextRes = null;
        Object mo = null;
        try {
            while (it.hasNext()) {
                nextRes = (IResource)it.next();
                mo = ModelUtilities.getModelResource((IFile)nextRes, true);
                if (mo == null) continue;
                if (result.isEmpty()) {
                    result = new ArrayList<Object>();
                }
                result.add(mo);
            }
        }
        catch (ModelWorkspaceException err) {
            String message = ModelUtilities.getString(MODEL_RESOURCE_NOT_FOUND_MSG_KEY, mo.toString());
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        return result;
    }

    public static Collection getDependentResources(ModelResource resource) {
        ArrayList<Object> result = Collections.EMPTY_LIST;
        IResource theResource = resource.getResource();
        IResource[] dependents = WorkspaceResourceFinderUtil.getDependentResources((IResource)theResource);
        Object mo = null;
        try {
            for (int i = 0; i != dependents.length; ++i) {
                mo = ModelUtilities.getModelResource((IFile)dependents[i], true);
                if (mo == null) continue;
                if (result.isEmpty()) {
                    result = new ArrayList<Object>();
                }
                result.add(mo);
            }
        }
        catch (ModelWorkspaceException err) {
            String message = ModelUtilities.getString(MODEL_RESOURCE_NOT_FOUND_MSG_KEY, mo.toString());
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        return result;
    }

    public static boolean requiresValidation(IFile file) {
        ModelResource mr = null;
        try {
            mr = ModelUtilities.getModelResource(file, false);
        }
        catch (ModelWorkspaceException err) {
            String message = ModelUtilities.getString(MODEL_RESOURCE_NOT_FOUND_MSG_KEY, file.toString());
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        if (mr != null) {
            return ModelUtilities.requiresValidation(mr);
        }
        return false;
    }

    public static boolean requiresValidation(ModelResource targetModelResource) {
        if (targetModelResource == null) {
            return false;
        }
        if (ModelUtil.isXsdFile((IResource)targetModelResource.getResource())) {
            return false;
        }
        boolean isIndexModified = ModelUtilities.isIndexFileLastModifiedAfterResourceFile(targetModelResource);
        return targetModelResource.getIndexType() == 0 && isIndexModified;
    }

    private static boolean isIndexFileLastModifiedAfterResourceFile(ModelResource targetModelResource) {
        File rsrcIndexFile = new File(IndexUtil.INDEX_PATH, IndexUtil.getRuntimeIndexFileName((ModelResource)targetModelResource));
        if (!rsrcIndexFile.exists()) {
            return false;
        }
        IPath path = ((IFile)targetModelResource.getResource()).getLocation();
        long resourceLastModified = path.toFile().lastModified();
        long indexLastModified = rsrcIndexFile.lastModified();
        return indexLastModified < resourceLastModified;
    }

    public static boolean hasErrors(IFile file, Object source) {
        ModelResource mr = null;
        boolean foundError = false;
        try {
            mr = ModelUtilities.getModelResource(file, false);
        }
        catch (ModelWorkspaceException err) {
            String message = ModelUtilities.getString(MODEL_RESOURCE_NOT_FOUND_MSG_KEY, file.toString());
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        if (mr != null) {
            IMarker[] mrkrs = null;
            boolean errorOccurred = false;
            try {
                mrkrs = mr.getResource().findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            }
            catch (CoreException ex) {
                UiConstants.Util.log((Throwable)ex);
                errorOccurred = true;
            }
            if (!errorOccurred) {
                IMarker[] markers = mrkrs;
                boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, null, (Object)source);
                int ndx = markers.length;
                while (--ndx >= 0) {
                    int severity;
                    Object attr = MarkerUtilities.getMarkerAttribute((IMarker)markers[ndx], (String)"severity");
                    if (attr == null || (severity = ((Integer)attr).intValue()) != 2) continue;
                    foundError = true;
                    break;
                }
                if (startedTxn) {
                    ModelerCore.commitTxn();
                }
            }
        }
        return foundError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeModelContainers(ModelResource modelResource, String txnLabel, Object source) {
        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)txnLabel, (Object)source);
        boolean succeeded = false;
        try {
            ModelerCore.getModelEditor().getAllContainers(modelResource.getEmfResource());
            succeeded = true;
        }
        catch (ModelWorkspaceException err) {
            String message = ModelUtilities.getString("ModelUtilities.initializeModelContainersError", modelResource.toString());
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public static void rebuildImports(ModelResource modelResource, Object source, boolean includeDiagramReferences) throws ModelWorkspaceException {
        if (modelResource != null && !modelResource.isReadOnly()) {
            OrganizeImportCommand importCommand = new OrganizeImportCommand();
            OrganizeImportHandlerDialog importHandler = new OrganizeImportHandlerDialog();
            importCommand.setResource(modelResource.getEmfResource());
            importCommand.setHandler((OrganizeImportHandler)importHandler);
            importCommand.setIncludeDiagramReferences(includeDiagramReferences);
            IProgressMonitor monitor = null;
            IStatus status = importCommand.canExecute();
            if (status.isOK()) {
                IStatus runStatus = importCommand.execute(monitor);
                ModelResourceEvent event = new ModelResourceEvent(modelResource, 5, source);
                UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                if (!runStatus.isOK()) {
                    UiConstants.Util.log(runStatus);
                }
            } else {
                UiConstants.Util.log(status);
            }
        }
    }

    public static boolean hasMetamodelWithURI(ModelResource modelResource, String uri) throws ModelWorkspaceException {
        if (modelResource == null || uri == null) {
            return false;
        }
        List allMetamodelDescriptors = modelResource.getAllMetamodelDescriptors();
        for (int i = 0; i < allMetamodelDescriptors.size(); ++i) {
            MetamodelDescriptor mmdesc = (MetamodelDescriptor)allMetamodelDescriptors.get(i);
            if (!uri.equals(mmdesc.getURI())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasJdbcSource(ModelResource modelResource) throws ModelWorkspaceException {
        if (modelResource != null) {
            if (!modelResource.isLoaded()) {
                return ModelUtilities.hasMetamodelWithURI(modelResource, "http://www.metamatrix.com/metamodels/JDBC");
            }
            try {
                Resource resource = modelResource.getEmfResource();
                Iterator iter = resource.getContents().iterator();
                while (iter.hasNext()) {
                    EObject eObj = (EObject)iter.next();
                    if (!(eObj instanceof JdbcSource)) continue;
                    return true;
                }
            }
            catch (ModelWorkspaceException err) {
                UiConstants.Util.log((Throwable)err);
                WidgetUtil.showError((String)err.getLocalizedMessage());
            }
        }
        return false;
    }

    public static boolean isRelationalModel(ModelResource rsrc) throws ModelWorkspaceException {
        if (rsrc == null || rsrc.getPrimaryMetamodelDescriptor() == null) {
            return false;
        }
        return "http://www.metamatrix.com/metamodels/Relational".equals(rsrc.getPrimaryMetamodelDescriptor().getURI());
    }

    public static void saveModelResource(ModelResource modelResource, IProgressMonitor monitor, boolean force, Object source) {
        try {
            modelResource.save(monitor, force);
            if (5 == modelResource.getItemType()) {
                FunctionLibraryManager.reloadSources();
            }
        }
        catch (ModelWorkspaceException theException) {
            String message = UiConstants.Util.getString("ModelUtilities.errorSavingModelResource", (Object)modelResource, source);
            UiConstants.Util.log(4, (Throwable)theException, message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        modelFileCache = new ModelFileCache();
        I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$internal$ui$viewsupport$ModelUtilities == null ? (class$com$metamatrix$modeler$internal$ui$viewsupport$ModelUtilities = ModelUtilities.class$("com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities")) : class$com$metamatrix$modeler$internal$ui$viewsupport$ModelUtilities));
        FILE_DOES_NOT_EXIST_TITLE = ModelUtilities.getString("fileDoesNotExist.title");
        CLOSED_PROJECT_TITLE = ModelUtilities.getString("projectClosed.title");
        MODEL_CHANGES_PENDING_TITLE = ModelUtilities.getString("modelChangesPending.title");
        MODEL_ERRORS_TITLE = ModelUtilities.getString("modelHasErrors.title");
        MODEL_NOT_VALIDATED_TITLE = ModelUtilities.getString("modelNotValidated.title");
        MODEL_IMPORTED_NOT_FOUND_TITLE = ModelUtilities.getString("modelHasMissingImports.title");
    }

    private static class FileResourceCollectorVisitor
    implements IResourceVisitor {
        private List resources = new ArrayList();

        public boolean visit(IResource resource) throws CoreException {
            if (resource.exists() && resource instanceof IFile) {
                this.resources.add(resource);
            }
            return true;
        }

        public IFile[] getFileResources() {
            return this.resources.toArray(new IFile[this.resources.size()]);
        }
    }

    private static class ContainerNotificationManager
    implements INotifyChangedListener {
        private List listeners = new ArrayList();

        private ContainerNotificationManager() {
        }

        public void addNotifyChangedListener(INotifyChangedListener theListener) {
            if (!this.listeners.contains(theListener)) {
                this.listeners.add(theListener);
            }
        }

        public void notifyChanged(Notification theNotification) {
            this.fireNotification(theNotification);
        }

        private void fireNotification(Notification theNotification) {
            boolean timerOn = UiConstants.Util.isDebugEnabled("metricsTimingNotifications");
            String notificationType = null;
            Object[] info = null;
            if (timerOn) {
                if (NotificationUtilities.isAdded((Notification)theNotification)) {
                    notificationType = "ADDED";
                } else if (NotificationUtilities.isRemoved((Notification)theNotification)) {
                    notificationType = "REMOVED";
                } else if (NotificationUtilities.isMoved((Notification)theNotification)) {
                    notificationType = "MOVED";
                } else if (NotificationUtilities.isChanged((Notification)theNotification)) {
                    notificationType = "CHANGED";
                }
                EObject eObj = NotificationUtilities.getEObject((Notification)theNotification);
                if (eObj == null) {
                    info = new Object[2];
                } else {
                    info = new Object[3];
                    info[2] = eObj;
                }
            }
            ArrayList tempListenerList = new ArrayList(this.listeners);
            int size = tempListenerList.size();
            for (int i = 0; i < size; ++i) {
                String timerId = "Notification Handler:";
                String handlerNumber = null;
                INotifyChangedListener l = (INotifyChangedListener)tempListenerList.get(i);
                if (!this.listeners.contains(l)) continue;
                if (timerOn) {
                    timerId = timerId + l.getClass().getName();
                    handlerNumber = "Handler=" + i;
                    info[0] = notificationType;
                    info[1] = handlerNumber;
                    UiConstants.Util.start(timerId, "metricsTimingNotifications", info);
                }
                l.notifyChanged(theNotification);
                if (!timerOn) continue;
                UiConstants.Util.stop(timerId, "metricsTimingNotifications", info);
            }
        }

        public void removeNotifyChangedListener(INotifyChangedListener theListener) {
            this.listeners.remove(theListener);
        }
    }
}

