/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilResource;
import com.metamatrix.util.UtilResourceLocator;
import com.metamatrix.util.UtilTransliterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.PrivilegedActionException;
import java.util.HashMap;

public class UtilTransliteratorUsingICUTable
extends UtilTransliterator {
    private static String footprint = "$Revision:   3.1.1.0  $";
    private int[] unicodeToCharsetMapping;
    private int[] primaryCharsetToUnicodeMapping;
    private int[][] secondaryCharsetToUnicodeMapping;
    protected byte[] tempBytesCache;
    private int[] rl;
    private static final int CHUNK = 256;
    private static HashMap CachedConversionTables;
    private String tableName;
    private InputStream _in;

    public UtilTransliteratorUsingICUTable(String string) throws UtilException {
        ConversionTable conversionTable;
        this.tableName = string;
        if (CachedConversionTables == null) {
            CachedConversionTables = new HashMap();
        }
        if ((conversionTable = (ConversionTable)CachedConversionTables.get(string)) != null) {
            this.loadCachedConversionTable(conversionTable);
        } else {
            InputStream inputStream = null;
            UtilResource utilResource = new UtilResource(new UtilResourceLocator().getClass(), string);
            try {
                inputStream = utilResource.getAsStream();
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new UtilException(1005, string);
            }
            if (inputStream == null) {
                throw new UtilException(1005, string);
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            this.constructConversionTables(new BufferedReader(inputStreamReader));
            this.cacheConversionTables(string);
        }
        this.setCacheSize(256);
    }

    public static UtilTransliteratorUsingICUTable GetIfLoaded(String string) throws UtilException {
        if (CachedConversionTables == null) {
            return null;
        }
        if (CachedConversionTables.get(string) == null) {
            return null;
        }
        return new UtilTransliteratorUsingICUTable(string);
    }

    private void constructConversionTables(BufferedReader bufferedReader) throws UtilException {
        try {
            this.unicodeToCharsetMapping = new int[65536];
            int n = 0;
            while (n < 65536) {
                this.unicodeToCharsetMapping[n] = 63;
                ++n;
            }
            this.primaryCharsetToUnicodeMapping = new int[256];
            int n2 = 0;
            while (n2 < 256) {
                this.primaryCharsetToUnicodeMapping[n2] = 63;
                ++n2;
            }
            this.secondaryCharsetToUnicodeMapping = new int[256][];
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.charAt(0) != '<' || string.charAt(1) != 'U' || string.charAt(6) != '>') {
                    throw new UtilException(1034, this.tableName);
                }
                String string2 = string.substring(2, 6);
                int n3 = Integer.parseInt(string2, 16);
                int n4 = string.indexOf(92, 6);
                if (n4 == -1 || string.charAt(n4 + 1) != 'x') {
                    throw new UtilException(1034, this.tableName);
                }
                int n5 = Integer.parseInt(string.substring(n4 + 2, n4 + 4), 16);
                int n6 = string.indexOf(92, n4 + 4);
                int n7 = string.indexOf(124, n6 == -1 ? n4 + 4 : n6 + 4);
                int n8 = Integer.parseInt(string.substring(n7 + 1, n7 + 2));
                if (n6 == -1) {
                    this.unicodeToCharsetMapping[n3] = n5;
                    if (n8 == 0) {
                        this.primaryCharsetToUnicodeMapping[n5] = n3;
                    }
                } else {
                    if (string.charAt(n6 + 1) != 'x') {
                        throw new UtilException(1034, this.tableName);
                    }
                    int n9 = Integer.parseInt(string.substring(n6 + 2, n6 + 4), 16);
                    this.unicodeToCharsetMapping[n3] = n5 << 8 | n9;
                    this.primaryCharsetToUnicodeMapping[n5] = -1;
                    if (n8 == 0) {
                        if (this.secondaryCharsetToUnicodeMapping[n5] == null) {
                            this.secondaryCharsetToUnicodeMapping[n5] = new int[256];
                            int n10 = 0;
                            while (n10 < 256) {
                                this.secondaryCharsetToUnicodeMapping[n5][n10] = 63;
                                ++n10;
                            }
                        }
                        this.secondaryCharsetToUnicodeMapping[n5][n9] = n3;
                    }
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1008, this.tableName);
        }
    }

    private void cacheConversionTables(Object object) {
        ConversionTable conversionTable = new ConversionTable();
        conversionTable.unicodeToCharsetMapping = this.unicodeToCharsetMapping;
        conversionTable.primaryCharsetToUnicodeMapping = this.primaryCharsetToUnicodeMapping;
        conversionTable.secondaryCharsetToUnicodeMapping = this.secondaryCharsetToUnicodeMapping;
        CachedConversionTables.put(object, conversionTable);
    }

    private void loadCachedConversionTable(ConversionTable conversionTable) {
        this.unicodeToCharsetMapping = conversionTable.unicodeToCharsetMapping;
        this.primaryCharsetToUnicodeMapping = conversionTable.primaryCharsetToUnicodeMapping;
        this.secondaryCharsetToUnicodeMapping = conversionTable.secondaryCharsetToUnicodeMapping;
    }

    public boolean isFixedBytesPerChar() {
        return false;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    private int _encode(char[] cArray, int n, byte[] byArray) throws UtilException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            int n4 = this.unicodeToCharsetMapping[c];
            if (n4 > 255) {
                byArray[n2++] = (byte)(n4 >> 8 & 0xFF);
                byArray[n2++] = (byte)(n4 & 0xFF);
            } else {
                byArray[n2++] = (byte)n4;
            }
            ++n3;
        }
        return n2;
    }

    public byte[] encode(String string) throws UtilException {
        if (this.rl == null) {
            this.rl = new int[1];
        }
        byte[] byArray = this.encode(string, this.rl);
        int n = this.rl[0];
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n = string.length();
        int n2 = n * this.getMaxBytesPerChar();
        byte[] byArray = this.bytesCache.length >= n2 ? this.bytesCache : new byte[n2];
        char[] cArray = this.charsCache.length >= n ? this.charsCache : new char[n];
        string.getChars(0, n, cArray, 0);
        nArray[0] = this._encode(cArray, n, byArray);
        return byArray;
    }

    public void encode(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        if (this.bytesCache.length < 256) {
            this.bytesCache = new byte[256];
        }
        if (this.tempBytesCache == null || this.tempBytesCache.length < 256) {
            this.tempBytesCache = new byte[256 * this.getMaxBytesPerChar()];
        }
        try {
            while (n > 0) {
                int n2 = Math.min(n, 256);
                int n3 = inputStream.read(this.bytesCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                int n4 = 0;
                int n5 = 0;
                while (n5 < n3) {
                    int n6 = this.bytesCache[n5] & 0xFF;
                    int n7 = this.unicodeToCharsetMapping[n6];
                    if (n7 > 255) {
                        this.tempBytesCache[n4++] = (byte)(n7 >> 8 & 0xFF);
                        this.tempBytesCache[n4++] = (byte)(n7 & 0xFF);
                    } else {
                        this.tempBytesCache[n4++] = (byte)n7;
                    }
                    ++n5;
                }
                outputStream.write(this.tempBytesCache, 0, n4);
                n -= n3;
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n, OutputStream outputStream) throws UtilException {
        if (this.bytesCache.length < 256) {
            this.bytesCache = new byte[256];
        }
        if (this.charsCache.length < 256) {
            this.charsCache = new char[256];
        }
        try {
            while (n > 0) {
                int n2 = Math.min(n, 256);
                int n3 = reader.read(this.charsCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                int n4 = this._encode(this.charsCache, n3, this.bytesCache);
                outputStream.write(this.bytesCache, 0, n4);
                n -= n3;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    private int _decode(byte[] byArray, int n, int n2, char[] cArray) throws UtilException {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = byArray[n4 + n] & 0xFF;
            ++n4;
            if (this.secondaryCharsetToUnicodeMapping[n5] != null) {
                if (n4 >= n2) {
                    throw UtilException.createTransliterationFailedException("invalid encoded data");
                }
                int n6 = byArray[n4 + n] & 0xFF;
                cArray[n3++] = (char)this.secondaryCharsetToUnicodeMapping[n5][n6];
                ++n4;
                continue;
            }
            cArray[n3++] = (char)this.primaryCharsetToUnicodeMapping[n5];
        }
        return n3;
    }

    public String decode(byte[] byArray, int n, int n2) throws UtilException {
        int n3 = n2 * 1;
        char[] cArray = this.charsCache.length >= n3 ? this.charsCache : new char[n3];
        int n4 = this._decode(byArray, n, n2, cArray);
        return new String(cArray, 0, n4);
    }

    public int decode(byte[] byArray, int n, int n2, char[] cArray) throws UtilException {
        return this._decode(byArray, n, n2, cArray);
    }

    public String decode(byte[] byArray, int n, int n2, int n3) throws UtilException {
        char[] cArray = n2 > this.charsCache.length ? new char[n2] : this.charsCache;
        n2 = this._decode(byArray, n, n2, cArray);
        if (cArray.length < n3) {
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            cArray = cArray2;
        }
        int n4 = n2;
        while (n4 < n3) {
            cArray[n4] = 32;
            ++n4;
        }
        return new String(cArray, 0, n3);
    }

    public synchronized Reader decodeAsReader(InputStream inputStream) throws UtilException {
        this._in = inputStream;
        return new Reader(){
            private InputStream in;
            private int length;
            private byte[] cache;
            {
                this.in = UtilTransliteratorUsingICUTable.this._in;
            }

            public int read() throws IOException {
                int n = this.in.read();
                if (n == -1) {
                    return -1;
                }
                if (UtilTransliteratorUsingICUTable.this.secondaryCharsetToUnicodeMapping[n &= 0xFF] != null) {
                    int n2 = this.in.read() & 0xFF;
                    return UtilTransliteratorUsingICUTable.this.secondaryCharsetToUnicodeMapping[n][n2];
                }
                return UtilTransliteratorUsingICUTable.this.primaryCharsetToUnicodeMapping[n];
            }

            public int read(char[] cArray, int n, int n2) throws IOException {
                int n3;
                if (this.cache == null || this.cache.length < n2) {
                    this.cache = new byte[n2];
                }
                if ((n3 = this.in.read(this.cache, 0, n2)) <= 0) {
                    return n3;
                }
                int n4 = 0;
                try {
                    n4 = UtilTransliteratorUsingICUTable.this._decode(this.cache, n, n3, cArray);
                }
                catch (UtilException utilException) {
                    return -1;
                }
                return n4;
            }

            public void close() throws IOException {
                this.in.close();
            }
        };
    }

    private class ConversionTable {
        int[] unicodeToCharsetMapping;
        int[] primaryCharsetToUnicodeMapping;
        int[][] secondaryCharsetToUnicodeMapping;

        private ConversionTable() {
        }
    }
}

