/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplResultSetService;
import com.metamatrix.jdbc.base.BaseResultSetSortDescriptor;
import com.metamatrix.util.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;

public final class BaseImplResultSetClientSideSorter
extends BaseImplResultSetService {
    private static String footprint = "$Revision:   3.4.1.1  $";
    private File rowPositionFileHandle;
    private RandomAccessFile rowPositionFile;
    boolean haveSortedRows = false;
    BaseResultSetSortDescriptor sortDescriptor;
    private BaseData[] sortedRow;
    private BaseData[] nextRowToBeSorted;

    public void postSetupInitialize() throws SQLException {
        this.setupTempFile();
        super.postSetupInitialize();
    }

    public void setSortCriteria(BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        this.sortDescriptor = baseResultSetSortDescriptor;
    }

    private void setupTempFile() throws SQLException {
        try {
            this.rowPositionFileHandle = UtilTempFile.createTempFile("srt_");
            try {
                this.rowPositionFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new RandomAccessFile(BaseImplResultSetClientSideSorter.this.rowPositionFileHandle, "rw");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6038);
        }
    }

    public void close() throws SQLException {
        super.close();
        try {
            this.rowPositionFile.close();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    BaseImplResultSetClientSideSorter.this.rowPositionFileHandle.delete();
                    return null;
                }
            });
        }
        catch (IOException iOException) {}
    }

    public int getColumnAccess() {
        return 2;
    }

    public void setFetchSize(int n) {
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        if (!this.haveSortedRows) {
            this.initializeRows();
            this.fetchAndSortRows();
        }
        if (n > this.maxCursorPosition) {
            return false;
        }
        this.getSortedFromSubResultSet(n, false);
        return true;
    }

    private void fetchAndSortRows() throws SQLException {
        boolean bl;
        int n = 1;
        do {
            if (!(bl = this.subImplResultSet.fetchAtPosition(n))) continue;
            this.getCurrentFromSubResultSet(this.nextRowToBeSorted, false);
            this.insertSubResultSetRowIntoSortList(n);
            ++n;
        } while (bl);
        this.haveSortedRows = true;
        this.maxCursorPosition = n - 1;
    }

    private void insertSubResultSetRowIntoSortList(int n) throws SQLException {
        try {
            int n2;
            int n3;
            int n4 = 0;
            boolean bl = true;
            if (n != 1) {
                int n5;
                n3 = 1;
                n2 = n;
                int n6 = (n3 + n2) / 2;
                boolean bl2 = false;
                do {
                    n5 = n6;
                    this.getSortedFromSubResultSet(n6, true);
                    bl = this.compareCurrentRows();
                    if (bl) {
                        n3 = n6;
                        bl2 = true;
                        continue;
                    }
                    n2 = n6;
                    bl2 = false;
                } while (n5 != (n6 = (n3 + n2) / 2));
                n4 = n6 - 1 + (bl2 ? 1 : 0);
            }
            n3 = n;
            n2 = 0;
            while (n4 < n) {
                if (n4 != n - 1) {
                    this.rowPositionFile.seek(n4 * 4);
                    n2 = this.rowPositionFile.readInt();
                }
                this.rowPositionFile.seek(n4 * 4);
                this.rowPositionFile.writeInt(n3);
                n3 = n2;
                ++n4;
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6043);
        }
    }

    private void getSortedFromSubResultSet(int n, boolean bl) throws SQLException {
        try {
            this.rowPositionFile.seek((n - 1) * 4);
            n = this.rowPositionFile.readInt();
            this.subImplResultSet.fetchAtPosition(n);
            this.getCurrentFromSubResultSet(this.sortedRow, bl);
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6038);
        }
    }

    private void getCurrentFromSubResultSet(BaseData[] baseDataArray, boolean bl) throws SQLException {
        if (bl) {
            int n = this.sortDescriptor.getSortCount();
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.sortDescriptor.getSortColumnOrdinal(n2);
                BaseData baseData = this.subImplResultSet.getData(n3, this.columns.get((int)n3).baseDataType);
                baseDataArray[n3 - 1].populate(baseData);
                ++n2;
            }
        } else {
            int n = this.columns.count(1);
            int n4 = 1;
            while (n4 <= n) {
                BaseData baseData = this.subImplResultSet.getData(n4, this.columns.get((int)n4).baseDataType);
                baseDataArray[n4 - 1].populate(baseData);
                ++n4;
            }
        }
    }

    private boolean compareCurrentRows() throws SQLException {
        int n = 0;
        int n2 = 0;
        while (n < this.sortDescriptor.getSortCount() && n2 == 0) {
            int n3 = this.sortDescriptor.getSortColumnOrdinal(n);
            n2 = BaseData.compare(this.nextRowToBeSorted[n3 - 1], this.sortedRow[n3 - 1], BaseData.mapJDBCTypeToJavaObjectType(this.columns.get((int)n3).type), this.implStatement.implConnection.exceptions);
            ++n;
        }
        return n2 >= 0;
    }

    private void initializeRows() {
        int n = this.columns.count(1);
        this.sortedRow = new BaseData[n];
        this.nextRowToBeSorted = new BaseData[n];
        int n2 = 0;
        while (n2 < n) {
            BaseColumn baseColumn = this.columns.get(n2 + 1);
            this.sortedRow[n2] = new BaseData(null);
            this.nextRowToBeSorted[n2] = new BaseData(null);
            ++n2;
        }
    }

    public BaseData getData(int n, int n2) throws SQLException {
        return this.sortedRow[n - 1];
    }
}

