/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2LocalMessages;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDACrypto;
import com.metamatrix.jdbc.db2.drda.DRDARequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSecurityContext;
import com.metamatrix.util.UtilSecurityContextCreator;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.StringTokenizer;

public class DRDALoginRequest
extends DRDARequest {
    private static String footprint = "$Revision:   3.31.1.1  $";
    public boolean workAroundv8Bug = false;
    public boolean useTXNMGR = false;
    private short securityMechanism;
    private String newPassword;
    private byte[] serverSecToken;
    private byte[] secToken;
    UtilSecurityContext securityContext;
    private String kerberosSecurityPrincipal;
    private DRDACrypto drdaCrypto;

    public DRDALoginRequest(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter) throws SQLException {
        super(dB2ImplConnection, dRDACommunication, dRDAByteOrderedDataReader, dRDAByteOrderedDataWriter);
    }

    public void setSecurityMechanism(String string) {
        if (string == null || string.equalsIgnoreCase("ClearText") || string.equalsIgnoreCase("None")) {
            this.securityMechanism = (short)3;
        } else if (string.equalsIgnoreCase("EncryptedPassword")) {
            this.securityMechanism = (short)7;
        } else if (string.equalsIgnoreCase("EncryptedUIDPassword")) {
            this.securityMechanism = (short)9;
        } else if (string.equalsIgnoreCase("NewPassword")) {
            this.securityMechanism = (short)5;
        } else if (string.equalsIgnoreCase("Client")) {
            this.securityMechanism = (short)4;
            this.implConn.user = System.getProperty("user.name");
        } else {
            this.securityMechanism = this.implConn.isKerberosConnection ? (short)11 : (short)3;
        }
    }

    public void setNewPassword(String string) {
        this.newPassword = string;
    }

    public void submitRequest() throws SQLException {
        try {
            this.reader.empty();
            this.writeEXCSAT();
            switch (this.securityMechanism) {
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    this.drdaCrypto = new DRDACrypto(this.comm);
                    this.writeACCSEC(false);
                    this.writer.send();
                    this.reader.receive();
                    this.processReply(this.implConn.warnings);
                    try {
                        if (!this.implConn.isKerberosConnection) break;
                        if (this.implConn.servicePrincipalName == null || this.implConn.servicePrincipalName.equalsIgnoreCase("")) {
                            if (this.kerberosSecurityPrincipal != null) {
                                this.implConn.servicePrincipalName = this.kerberosSecurityPrincipal;
                            } else {
                                throw this.comm.exceptions.getException(7120);
                            }
                        }
                        this.securityContext = UtilSecurityContextCreator.createType4SecurityContext((String)this.implConn.servicePrincipalName);
                        break;
                    }
                    catch (UtilException utilException) {
                        throw this.implConn.exceptions.getException((Exception)((Object)utilException));
                    }
                }
                default: {
                    this.writeACCSEC(true);
                }
            }
            this.writeSECCHK();
            this.writeACCRDB();
            this.writer.send();
            this.reader.receive();
        }
        catch (UtilException utilException) {
            this.exception = utilException.getReason() == 1002 ? this.comm.exceptions.getException(7113) : this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    protected void writeEXCSAT() throws UtilException {
        int n = this.writer.writePacketHeader((short)1, (short)64, 1);
        int n2 = this.writer.writeCodePoint((short)4161);
        String string = "JDBC4DB2";
        int n3 = this.writer.writeCodePoint((short)4446);
        this.writer.writeString(string);
        this.writer.writeCodePointLength(n3);
        int n4 = this.writer.writeCodePoint((short)5124);
        this.writer.writeInt16(5123);
        this.writer.writeInt16(7);
        this.writer.writeInt16(5236);
        this.writer.writeInt16(5);
        this.writer.writeInt16(9223);
        if (this.workAroundv8Bug) {
            this.writer.writeInt16(6);
        } else {
            this.writer.writeInt16(7);
        }
        this.writer.writeInt16(9231);
        this.writer.writeInt16(7);
        this.writer.writeInt16(5184);
        this.writer.writeInt16(7);
        if (this.useTXNMGR) {
            this.writer.writeInt16(7169);
            this.writer.writeInt16(7);
        } else {
            this.writer.writeInt16(5312);
            this.writer.writeInt16(7);
            this.writer.writeInt16(5313);
            this.writer.writeInt16(5);
        }
        this.writer.writeCodePointLength(n4);
        String string2 = "DDT " + System.getProperty("os.name");
        int n5 = this.writer.writeCodePoint((short)4423);
        this.writer.writeString(string2);
        this.writer.writeCodePointLength(n5);
        String string3 = "JDBC4DB2 from " + System.getProperty("os.arch");
        int n6 = this.writer.writeCodePoint((short)4461);
        this.writer.writeString(string3);
        this.writer.writeCodePointLength(n6);
        String string4 = null;
        String string5 = this.implConn.connectProps.get("serverReleaseLevel");
        string4 = string5 == null ? "DDT00001" : string5;
        int n7 = this.writer.writeCodePoint((short)4442);
        this.writer.writeString(string4);
        this.writer.writeCodePointLength(n7);
        this.writer.writeCodePointLength(n2);
        this.writer.writePacketLength(n);
    }

    private void writeACCSEC(boolean bl) throws UtilException {
        int n = 0;
        n = bl ? this.writer.writePacketHeader((short)1, (short)64, 2) : this.writer.writePacketHeader((short)1, (short)0, 2);
        int n2 = this.writer.writeCodePoint((short)4205);
        this.writer.writeInt16(6);
        this.writer.writeInt16(4514);
        this.writer.writeInt16(this.securityMechanism);
        this.writer.writeInt16(22);
        this.writer.writeInt16(8464);
        this.writer.writeFixedLengthEncodedString(this.implConn.databaseName, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        switch (this.securityMechanism) {
            case 7: 
            case 9: 
            case 10: {
                int n3 = this.writer.writeCodePoint((short)4572);
                this.writer.writeBytes(this.drdaCrypto.getConnectionKey());
                this.writer.writeCodePointLength(n3);
                break;
            }
        }
        this.writer.writeCodePointLength(n2);
        this.writer.writePacketLength(n);
    }

    private void writeSECCHK() throws UtilException, SQLException {
        int n;
        int n2;
        int n3 = 0;
        n3 = this.implConn.isKerberosConnection ? this.writer.writePacketHeader((short)1, (short)80, 3) : this.writer.writePacketHeader((short)1, (short)64, 3);
        int n4 = this.writer.writeCodePoint((short)4206);
        this.writer.writeInt16(22);
        this.writer.writeInt16(8464);
        this.writer.writeFixedLengthEncodedString(this.implConn.databaseName, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        this.writer.writeInt16(6);
        this.writer.writeInt16(4514);
        this.writer.writeInt16(this.securityMechanism);
        if (this.securityMechanism == 5 || this.securityMechanism == 4 || this.securityMechanism == 7 || this.securityMechanism == 3) {
            n2 = this.writer.writeCodePoint((short)4512);
            if (!this.comm.isUDBCompatible()) {
                this.implConn.user = this.implConn.user.toUpperCase();
            }
            this.writer.writeSensitiveString(this.implConn.user);
            this.writer.writeCodePointLength(n2);
        }
        if (this.securityMechanism == 5 || this.securityMechanism == 3) {
            n2 = this.writer.writeCodePoint((short)4513);
            this.writer.writeSensitiveString(this.implConn.password);
            this.writer.writeCodePointLength(n2);
        }
        if (this.securityMechanism == 5) {
            n2 = this.writer.writeCodePoint((short)4574);
            this.writer.writeSensitiveString(this.newPassword);
            this.writer.writeCodePointLength(n2);
        }
        if (this.securityMechanism == 10 || this.securityMechanism == 9 || this.securityMechanism == 7) {
            this.drdaCrypto.deriveDESKey(this.drdaCrypto.getSharedSessionKey());
            if (this.securityMechanism == 7) {
                this.drdaCrypto.deriveDESInitVector(this.comm.defaultCCSIDTransliterator.encode(this.implConn.user));
            } else {
                this.drdaCrypto.deriveDESInitVector(this.serverSecToken);
            }
            if (this.securityMechanism != 7) {
                n2 = this.writer.writeCodePoint((short)4572);
                this.writer.writeBytes(this.drdaCrypto.DES_Encrypt(this.implConn.user, this.comm.defaultCCSIDTransliterator));
                this.writer.writeCodePointLength(n2);
            }
            n2 = this.writer.writeCodePoint((short)4572);
            this.writer.writeBytes(this.drdaCrypto.DES_Encrypt(this.implConn.password, this.comm.defaultCCSIDTransliterator));
            this.writer.writeCodePointLength(n2);
            if (this.securityMechanism == 10) {
                n = this.writer.writeCodePoint((short)4572);
                this.writer.writeBytes(this.drdaCrypto.DES_Encrypt(this.newPassword, this.comm.defaultCCSIDTransliterator));
                this.writer.writeCodePointLength(n);
            }
        }
        this.writer.writeCodePointLength(n4);
        this.writer.writePacketLength(n3);
        if (this.implConn.isKerberosConnection) {
            n2 = this.writer.writePacketHeader((short)3, (short)64, 3);
            n = this.writer.writeCodePoint((short)4572);
            this.secToken = this.securityContext.getSecurityToken(null);
            this.writer.writeBytes(this.secToken);
            this.writer.writeCodePointLength(n);
            this.writer.writePacketLength(n2);
        }
    }

    private void writeACCRDB() throws UtilException {
        int n = this.writer.writePacketHeader((short)1, (short)0, 4);
        int n2 = this.writer.writeCodePoint((short)8193);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8463);
        this.writer.writeInt16(9223);
        this.writer.writeInt16(23);
        this.writer.writeInt16(8501);
        this.writeCorrelationToken();
        this.writer.writeInt16(22);
        this.writer.writeInt16(8464);
        this.writer.writeFixedLengthEncodedString(this.implConn.databaseName, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        this.writer.writeInt16(12);
        this.writer.writeInt16(4398);
        this.writer.writeString("JDBC4DB2");
        this.writer.writeInt16(13);
        this.writer.writeInt16(47);
        this.writer.writeString("QTDSQLASC");
        this.writer.writeInt16(22);
        this.writer.writeInt16(53);
        this.writer.writeInt16(6);
        this.writer.writeInt16(4508);
        this.writer.writeInt16(this.comm.clientSBCS);
        this.writer.writeInt16(6);
        this.writer.writeInt16(4509);
        this.writer.writeInt16(this.comm.clientDBCS);
        this.writer.writeInt16(6);
        this.writer.writeInt16(4510);
        this.writer.writeInt16(this.comm.clientMBCS);
        this.writer.writeInt16(5);
        this.writer.writeInt16(8474);
        this.writer.writeInt8(241);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8481);
        this.writer.writeInt16(9276);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8480);
        this.writer.writeInt16(9254);
        this.writer.writeCodePointLength(n2);
        this.writer.writePacketLength(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 4633: 
                case 5187: 
                case 5292: 
                case 8705: {
                    return true;
                }
                case 4446: {
                    this.comm.ServerExternalName = this.reader.readString(n);
                    return true;
                }
                case 4398: {
                    this.comm.ServerProductID = this.reader.readString(n);
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    if (this.comm.ServerProductID.charAt(3) != '0') {
                        stringBuffer.append(this.comm.ServerProductID.charAt(3));
                    }
                    if (this.comm.ServerProductID.charAt(4) != '0') {
                        stringBuffer.append(this.comm.ServerProductID.charAt(4));
                    }
                    if (this.comm.ServerProductID.charAt(6) != '0') {
                        stringBuffer2.append(this.comm.ServerProductID.charAt(6));
                    }
                    if (this.comm.ServerProductID.length() >= 8) {
                        this.comm.databasePatchVersion = this.comm.ServerProductID.substring(7);
                    }
                    if (stringBuffer2.length() == 0) {
                        stringBuffer2.append('0');
                    }
                    if (stringBuffer.length() == 0) {
                        stringBuffer.append('0');
                    }
                    this.comm.serverMajorVersion = Integer.valueOf(stringBuffer.toString());
                    this.comm.serverMinorVersion = Integer.valueOf(stringBuffer2.toString());
                    return true;
                }
                case 4516: {
                    byte by = this.reader.getByte();
                    if (by == 0) return true;
                    this.reader.readAndDiscardBytes(n - 1);
                    String[] stringArray = new String[2];
                    stringArray[0] = this.implConn.databaseName.toUpperCase();
                    switch (by) {
                        case 1: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7016, null);
                            break;
                        }
                        case 2: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7017, null);
                            break;
                        }
                        case 3: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7018, null);
                            break;
                        }
                        case 4: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7019, null);
                            break;
                        }
                        case 5: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7020, null);
                            break;
                        }
                        case 6: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7021, null);
                            break;
                        }
                        case 7: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7022, null);
                            break;
                        }
                        case 8: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7023, null);
                            break;
                        }
                        case 9: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7024, null);
                            break;
                        }
                        case 10: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7025, null);
                            break;
                        }
                        case 11: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7026, null);
                            break;
                        }
                        case 14: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7027, null);
                            break;
                        }
                        case 15: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7028, null);
                            break;
                        }
                        case 16: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7029, null);
                            break;
                        }
                        case 18: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7030, null);
                            break;
                        }
                        case 19: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7031, null);
                            break;
                        }
                        case 20: {
                            stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7032, null);
                            break;
                        }
                    }
                    if (this.severityCode == 4) {
                        baseWarnings.add(7037, stringArray);
                        return true;
                    }
                    if (this.severityCode == 0) return true;
                    this.exception = this.comm.exceptions.getException(7037, stringArray, "08004", -1403);
                    return false;
                }
                case 5124: {
                    int n3 = this.reader.readPosition + n;
                    do {
                        short s = this.reader.readInt16();
                        short s2 = this.reader.readInt16();
                        switch (s) {
                            case 5123: {
                                this.comm.DDMAgentLevel = s2;
                                break;
                            }
                            case 5236: {
                                this.comm.CMNTCPIPLevel = s2;
                                break;
                            }
                            case 9223: {
                                this.comm.SQLAMLevel = s2;
                                break;
                            }
                            case 9231: {
                                this.comm.RDBLevel = s2;
                                break;
                            }
                            case 5184: {
                                this.comm.SECMGRLevel = s2;
                                break;
                            }
                            case 5312: {
                                this.comm.SYNCPTMGRLevel = s2;
                                break;
                            }
                            case 7169: {
                                this.comm.XAMGRLevel = s2;
                                if (!this.implConn.isXAImplConn || s2 != 0) break;
                                throw this.comm.exceptions.getException(7115);
                            }
                            case 5313: {
                                this.comm.RSYNCMGRLevel = s2;
                            }
                        }
                        if (this.reader.readPosition >= n3) return true;
                    } while (this.reader.readPosition != 0);
                    return true;
                }
                case 4461: {
                    this.comm.ServerName = this.reader.readString(n);
                    return true;
                }
                case 4423: {
                    this.comm.ServerClassName = this.reader.readString(n);
                    return true;
                }
                case 4442: {
                    this.comm.ServerReleaseLevel = this.reader.readString(n);
                    return true;
                }
                case 47: {
                    this.comm.ServerTypDefname = this.reader.readString(n);
                    return true;
                }
                case 53: {
                    int n4 = this.reader.readPosition + n;
                    do {
                        this.reader.readAndDiscardBytes(2);
                        short s = this.reader.readInt16();
                        short s3 = this.reader.readInt16();
                        switch (s) {
                            case 4508: {
                                this.comm.sbcs = s3;
                                break;
                            }
                            case 4509: {
                                this.comm.dbcs = s3;
                                break;
                            }
                            case 4510: {
                                this.comm.mbcs = s3;
                                break;
                            }
                        }
                    } while (this.reader.readPosition < n4 && this.reader.readPosition != 0);
                    this.comm.setServerSideTransliteration();
                    return true;
                }
                case 8451: {
                    this.implConn.cancelToken = new byte[n];
                    this.reader.readBytes(this.implConn.cancelToken, 0, n);
                    return true;
                }
                case 4572: {
                    this.serverSecToken = new byte[n];
                    this.reader.readBytes(this.serverSecToken, 0, n);
                    if (this.drdaCrypto == null) return true;
                    this.drdaCrypto.serverPubKeyBytes = this.serverSecToken;
                    return true;
                }
                case 4514: {
                    if (this.securityMechanism == this.reader.readInt16()) return true;
                    throw this.comm.exceptions.getException(7108, "08000");
                }
                case 4584: {
                    byte[] byArray = new byte[n];
                    this.reader.readBytes(byArray, 0, n);
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < 4; ++i) {
                        stringBuffer.append(byArray[i]);
                        if (i + 1 >= 4) continue;
                        stringBuffer.append(".");
                    }
                    this.comm.implConn.cancelHost = stringBuffer.toString();
                    this.comm.implConn.cancelPort = Integer.toString(((byArray[4] & 0xFF) << 8) + (byArray[5] & 0xFF));
                    return true;
                }
                case 6418: {
                    byte[] byArray = new byte[2];
                    byte[] byArray2 = new byte[n - 2];
                    this.reader.readBytes(byArray, 0, 2);
                    this.comm.implConn.cancelPort = Integer.toString(((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF));
                    int n5 = this.reader.readInt16() - 4;
                    this.reader.readAndDiscardBytes(2);
                    this.comm.implConn.cancelHost = this.reader.readString(n5);
                    return true;
                }
                case 4585: {
                    this.reader.readAndDiscardBytes(n);
                    this.comm.implConn.warnings.add(7112);
                    return true;
                }
                case 7170: {
                    this.kerberosSecurityPrincipal = this.reader.readString(n);
                    return true;
                }
                case 4512: 
                case 8485: 
                case 8501: 
                case 9294: {
                    this.reader.readAndDiscardBytes(n);
                    return true;
                }
                default: {
                    return super.processCodePoint(n, n2, baseWarnings);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    private void writeCorrelationToken() throws UtilException {
        String string = "";
        String string2 = String.valueOf(this.comm.getSocket().getLocalAddress());
        int n = string2.lastIndexOf("/");
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string = string + stringTokenizer.nextToken();
        }
        if (string.length() > 8) {
            string = string.substring(0, 8);
        } else if (string.length() < 8) {
            for (int i = 0; i <= 8 - string.length(); ++i) {
                string = string + 0;
            }
        }
        string = string + ".";
        String string3 = Integer.toString(this.comm.getSocket().getLocalPort());
        if (string3.length() < 4) {
            for (int i = 0; i < 4 - string3.length(); ++i) {
                string3 = string3 + 0;
            }
        } else if (string3.length() > 4) {
            string3 = string3.substring(0, 4);
        }
        string = string + string3;
        this.writer.writeEncodedString(string, this.comm.defaultCCSIDTransliterator);
        Calendar calendar = Calendar.getInstance();
        short s = (short)calendar.get(10);
        short s2 = (short)calendar.get(12);
        short s3 = (short)calendar.get(13);
        byte[] byArray = new byte[]{(byte)(s >>> 8 & 0xFF), (byte)(s >>> 0 & 0xFF), (byte)(s2 >>> 8 & 0xFF), (byte)(s2 >>> 0 & 0xFF), (byte)(s3 >>> 8 & 0xFF), (byte)(s3 >>> 0 & 0xFF)};
        this.writer.writeBytes(byArray);
    }
}

