/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.oracle.net8.OracleNet8Communication;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class OracleDataProvider {
    private static String footprint = "$Revision:   1.28.1.0  $";
    private OracleNet8Communication comm;
    public UtilTransliterator transliterator;
    public UtilTransliterator transliteratorForNationalCharset;
    protected int m_numBytesProcessed;
    protected int m_numBytesInPacketBuffer;
    protected int m_numBytesLeftInCurrentPacket;
    protected byte[] m_packetBuffer;
    protected int m_packetBufferSize;
    protected int m_NSPacketType;
    private boolean japaneseCharsetAsUTF8;
    private static byte[] nullValue = new byte[0];
    protected final int NSPT_HEADER_SIZE = 8;
    private InputStream m_socketStream;

    public OracleDataProvider(OracleNet8Communication oracleNet8Communication, boolean bl) {
        this.comm = oracleNet8Communication;
        try {
            this.m_socketStream = oracleNet8Communication.socket.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_packetBufferSize = 8192;
        this.m_packetBuffer = new byte[this.m_packetBufferSize];
        this.transliterator = oracleNet8Communication.transliterator;
        this.transliteratorForNationalCharset = oracleNet8Communication.transliteratorForNationalCharset;
        this.japaneseCharsetAsUTF8 = bl;
    }

    public UtilTransliterator getTransliterator() {
        return this.transliterator;
    }

    public UtilTransliterator getTransliteratorForNationalCharset() {
        return this.transliteratorForNationalCharset;
    }

    public void setTransliterator(UtilTransliterator utilTransliterator) {
        this.transliterator = utilTransliterator;
    }

    public void setTransliteratorForNationalCharacterSet(UtilTransliterator utilTransliterator) {
        this.transliteratorForNationalCharset = utilTransliterator;
    }

    public int getNSPacketType() {
        return this.m_NSPacketType;
    }

    public byte readByte() throws UtilException, SQLException {
        if (this.m_numBytesLeftInCurrentPacket == 0) {
            this.receivePiggybackPacket();
        }
        byte by = this.m_packetBuffer[this.m_numBytesProcessed];
        ++this.m_numBytesProcessed;
        --this.m_numBytesLeftInCurrentPacket;
        return by;
    }

    public void skipBytes(int n) throws UtilException, SQLException {
        if (n <= this.m_numBytesLeftInCurrentPacket) {
            this.m_numBytesProcessed += n;
            this.m_numBytesLeftInCurrentPacket -= n;
        } else {
            this.m_numBytesProcessed += this.m_numBytesLeftInCurrentPacket;
            int n2 = n - this.m_numBytesLeftInCurrentPacket;
            this.m_numBytesLeftInCurrentPacket = 0;
            this.receivePiggybackPacket();
            this.skipBytes(n2);
        }
    }

    public void readBytes(byte[] byArray, int n, int n2) throws UtilException, SQLException {
        if (n2 <= this.m_numBytesLeftInCurrentPacket) {
            if (n2 < 15) {
                while (n2 > 0) {
                    byArray[n++] = this.m_packetBuffer[this.m_numBytesProcessed++];
                    --n2;
                    --this.m_numBytesLeftInCurrentPacket;
                }
            } else {
                System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, n, n2);
                this.m_numBytesProcessed += n2;
                this.m_numBytesLeftInCurrentPacket -= n2;
            }
        } else {
            int n3;
            if (this.m_numBytesLeftInCurrentPacket < 15) {
                for (n3 = this.m_numBytesLeftInCurrentPacket; n3 > 0; --n3) {
                    byArray[n++] = this.m_packetBuffer[this.m_numBytesProcessed++];
                }
            } else {
                System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, n, this.m_numBytesLeftInCurrentPacket);
                this.m_numBytesProcessed += this.m_numBytesLeftInCurrentPacket;
                n += this.m_numBytesLeftInCurrentPacket;
            }
            n3 = n2 - this.m_numBytesLeftInCurrentPacket;
            this.m_numBytesLeftInCurrentPacket = 0;
            this.receivePiggybackPacket();
            this.readBytes(byArray, n, n3);
        }
    }

    public void receive() throws UtilException, SQLException {
        this.m_numBytesInPacketBuffer = 0;
        this.m_numBytesProcessed = 0;
        this.m_numBytesLeftInCurrentPacket = 0;
        this.readPacket();
    }

    public void receivePacket() throws UtilException, SQLException {
        this.readPacket();
    }

    private void receivePiggybackPacket() throws UtilException, SQLException {
        do {
            this.readPacket();
            if (this.m_NSPacketType == 12) {
                throw this.comm.exceptions.getException(1018);
            }
            this.m_numBytesProcessed += 2;
            this.m_numBytesLeftInCurrentPacket -= 2;
        } while (this.m_numBytesLeftInCurrentPacket == 0);
    }

    protected int getArrayOfBytesFromSocket(byte[] byArray, int n, int n2) throws UtilException, SQLException {
        int n3;
        try {
            n3 = this.m_socketStream.read(byArray, n, n2);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new SQLException("SOCKETTIMEOUT");
        }
        catch (IOException iOException) {
            throw new UtilException(1001);
        }
        if (n3 == 0) {
            throw this.comm.exceptions.getException(7004);
        }
        if (n3 == -1) {
            throw new UtilException(1001);
        }
        return n3;
    }

    public final short readB2() throws UtilException, SQLException {
        if (this.m_numBytesLeftInCurrentPacket >= 3) {
            switch (this.m_packetBuffer[this.m_numBytesProcessed++]) {
                case 0: {
                    --this.m_numBytesLeftInCurrentPacket;
                    return 0;
                }
                case 1: {
                    this.m_numBytesLeftInCurrentPacket -= 2;
                    return (short)(this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF);
                }
                case 2: {
                    this.m_numBytesLeftInCurrentPacket -= 3;
                    return (short)((this.m_packetBuffer[this.m_numBytesProcessed++] << 8) + (this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF));
                }
                case -127: {
                    this.m_numBytesLeftInCurrentPacket -= 2;
                    return (short)(-(this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF));
                }
                case -126: {
                    this.m_numBytesLeftInCurrentPacket -= 3;
                    return (short)(-((this.m_packetBuffer[this.m_numBytesProcessed++] << 8) + (this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF)));
                }
            }
            UtilDebug.assert((String)"Unexpected length indicator for readB2", (boolean)false);
            return 0;
        }
        switch (this.readByte()) {
            case 0: {
                return 0;
            }
            case 1: {
                return (short)(this.readByte() & 0xFF);
            }
            case 2: {
                return (short)((this.readByte() << 8) + (this.readByte() & 0xFF));
            }
            case -127: {
                return (short)(-(this.readByte() & 0xFF));
            }
            case -126: {
                return (short)(-((this.readByte() << 8) + (this.readByte() & 0xFF)));
            }
        }
        UtilDebug.assert((String)"Unexpected length indicator for readB2", (boolean)false);
        return 0;
    }

    public final int readB4() throws UtilException, SQLException {
        if (this.m_numBytesLeftInCurrentPacket >= 5) {
            switch (this.m_packetBuffer[this.m_numBytesProcessed++]) {
                case 0: {
                    --this.m_numBytesLeftInCurrentPacket;
                    return 0;
                }
                case 1: {
                    this.m_numBytesLeftInCurrentPacket -= 2;
                    return this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF;
                }
                case 2: {
                    this.m_numBytesLeftInCurrentPacket -= 3;
                    return ((this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) << 8) + (this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF);
                }
                case 3: {
                    this.m_numBytesLeftInCurrentPacket -= 4;
                    return (this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) << 16 | (this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) << 8 | this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF;
                }
                case 4: {
                    this.m_numBytesLeftInCurrentPacket -= 5;
                    return (this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) << 24 | (this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) << 16 | (this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) << 8 | this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF;
                }
            }
            UtilDebug.assert((String)"Unexpected length indicator for readB4", (boolean)false);
            return 0;
        }
        switch (this.readByte()) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.readByte() & 0xFF;
            }
            case 2: {
                return ((this.readByte() & 0xFF) << 8) + (this.readByte() & 0xFF);
            }
            case 3: {
                return (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            }
            case 4: {
                return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            }
        }
        UtilDebug.assert((String)"Unexpected length indicator for readB4", (boolean)false);
        return 0;
    }

    public final void skipB4() throws UtilException, SQLException {
        if (this.m_numBytesLeftInCurrentPacket >= 5) {
            switch (this.m_packetBuffer[this.m_numBytesProcessed++]) {
                case 0: {
                    --this.m_numBytesLeftInCurrentPacket;
                    return;
                }
                case 1: {
                    this.m_numBytesLeftInCurrentPacket -= 2;
                    ++this.m_numBytesProcessed;
                    return;
                }
                case 2: {
                    this.m_numBytesLeftInCurrentPacket -= 3;
                    this.m_numBytesProcessed += 2;
                    return;
                }
                case 3: {
                    this.m_numBytesLeftInCurrentPacket -= 4;
                    this.m_numBytesProcessed += 3;
                    return;
                }
                case 4: {
                    this.m_numBytesLeftInCurrentPacket -= 5;
                    this.m_numBytesProcessed += 4;
                }
            }
            UtilDebug.assert((String)"Unexpected length indicator for readB4", (boolean)false);
            return;
        }
        switch (this.readByte()) {
            case 0: {
                return;
            }
            case 1: {
                this.readByte();
                return;
            }
            case 2: {
                this.readByte();
                this.readByte();
                return;
            }
            case 3: {
                this.readByte();
                this.readByte();
                this.readByte();
                return;
            }
            case 4: {
                this.readByte();
                this.readByte();
                this.readByte();
                this.readByte();
                return;
            }
        }
        UtilDebug.assert((String)"Unexpected length indicator for readB4", (boolean)false);
    }

    public final long readSB4() throws UtilException, SQLException {
        switch (this.readByte()) {
            case 0: {
                return 0L;
            }
            case 1: {
                return this.readByte() & 0xFF;
            }
            case 2: {
                return ((this.readByte() & 0xFF) << 8) + (this.readByte() & 0xFF);
            }
            case 3: {
                return (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            }
            case 4: {
                long l = (long)(this.readByte() & 0xFF) << 24 | (long)(this.readByte() & 0xFF) << 16 | (long)(this.readByte() & 0xFF) << 8 | (long)(this.readByte() & 0xFF);
                return l;
            }
            case -127: {
                return -(this.readByte() & 0xFF);
            }
            case -126: {
                return -(((this.readByte() & 0xFF) << 8) + (this.readByte() & 0xFF));
            }
            case -125: {
                return -((this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
            }
            case -124: {
                long l = -((long)(this.readByte() & 0xFF) << 24 | (long)(this.readByte() & 0xFF) << 16 | (long)(this.readByte() & 0xFF) << 8 | (long)(this.readByte() & 0xFF));
                return l;
            }
        }
        UtilDebug.assert((String)"Unexpected length indicator for readB4", (boolean)false);
        return 0L;
    }

    public int readCLRInBuf(byte[] byArray, int n, int n2) throws UtilException, SQLException {
        short s;
        if (this.m_numBytesLeftInCurrentPacket >= 1) {
            s = (short)(this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF);
            --this.m_numBytesLeftInCurrentPacket;
        } else {
            s = (short)(this.readByte() & 0xFF);
        }
        int n3 = 0;
        if (s == 254) {
            boolean bl = true;
            if (this.m_numBytesLeftInCurrentPacket >= 1) {
                s = (short)(this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF);
                --this.m_numBytesLeftInCurrentPacket;
            } else {
                s = (short)(this.readByte() & 0xFF);
            }
            while (s > 0) {
                if (this.japaneseCharsetAsUTF8) {
                    if (s == 254 && !bl) {
                        s = (short)(this.readByte() & 0xFF);
                    }
                    if (s < 254) {
                        bl = false;
                    }
                }
                if (s <= this.m_numBytesLeftInCurrentPacket) {
                    System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, n3 + n, s);
                    this.m_numBytesProcessed += s;
                    this.m_numBytesLeftInCurrentPacket -= s;
                    n3 += s;
                } else {
                    System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, n3 + n, this.m_numBytesLeftInCurrentPacket);
                    this.m_numBytesProcessed += this.m_numBytesLeftInCurrentPacket;
                    int n4 = s - this.m_numBytesLeftInCurrentPacket;
                    this.m_numBytesLeftInCurrentPacket = 0;
                    this.receivePiggybackPacket();
                    System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, (n3 += this.m_numBytesLeftInCurrentPacket) + n, n4);
                    this.m_numBytesProcessed += n4;
                    this.m_numBytesLeftInCurrentPacket -= n4;
                    n3 += n4;
                }
                if (this.m_numBytesLeftInCurrentPacket >= 1) {
                    s = (short)(this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF);
                    --this.m_numBytesLeftInCurrentPacket;
                    continue;
                }
                s = (short)(this.readByte() & 0xFF);
            }
            return n3;
        }
        if (s == 0 || s == 253 || s == 255) {
            return 0;
        }
        n3 = 0;
        if (s <= this.m_numBytesLeftInCurrentPacket) {
            System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, n3 + n, s);
            this.m_numBytesProcessed += s;
            this.m_numBytesLeftInCurrentPacket -= s;
            n3 += s;
        } else {
            System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, n3 + n, this.m_numBytesLeftInCurrentPacket);
            this.m_numBytesProcessed += this.m_numBytesLeftInCurrentPacket;
            int n5 = s - this.m_numBytesLeftInCurrentPacket;
            this.m_numBytesLeftInCurrentPacket = 0;
            this.receivePiggybackPacket();
            System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, (n3 += this.m_numBytesLeftInCurrentPacket) + n, n5);
            this.m_numBytesProcessed += n5;
            this.m_numBytesLeftInCurrentPacket -= n5;
            n3 += n5;
        }
        return n3;
    }

    public byte[] readCLR(int n) throws UtilException, SQLException {
        short s;
        if (this.m_numBytesLeftInCurrentPacket >= 1) {
            s = (short)(this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF);
            --this.m_numBytesLeftInCurrentPacket;
        } else {
            s = (short)(this.readByte() & 0xFF);
        }
        int n2 = 0;
        byte[] byArray = null;
        if (s == 254) {
            byte[] byArray2;
            byArray = new byte[n];
            boolean bl = true;
            if (this.m_numBytesLeftInCurrentPacket >= 1) {
                s = (short)(this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF);
                --this.m_numBytesLeftInCurrentPacket;
            } else {
                s = (short)(this.readByte() & 0xFF);
            }
            while (s > 0) {
                if (this.japaneseCharsetAsUTF8) {
                    if (s == 254 && !bl) {
                        s = (short)(this.readByte() & 0xFF);
                    }
                    if (s < 254) {
                        bl = false;
                    }
                }
                if (n2 + s > n) {
                    byArray2 = new byte[n * 8];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    n *= 8;
                    byArray = byArray2;
                }
                if (s <= this.m_numBytesLeftInCurrentPacket) {
                    System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, n2, s);
                    this.m_numBytesProcessed += s;
                    this.m_numBytesLeftInCurrentPacket -= s;
                    n2 += s;
                } else {
                    System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, n2, this.m_numBytesLeftInCurrentPacket);
                    this.m_numBytesProcessed += this.m_numBytesLeftInCurrentPacket;
                    int n3 = s - this.m_numBytesLeftInCurrentPacket;
                    this.m_numBytesLeftInCurrentPacket = 0;
                    this.receivePiggybackPacket();
                    System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, n2 += this.m_numBytesLeftInCurrentPacket, n3);
                    this.m_numBytesProcessed += n3;
                    this.m_numBytesLeftInCurrentPacket -= n3;
                    n2 += n3;
                }
                if (this.m_numBytesLeftInCurrentPacket >= 1) {
                    s = (short)(this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF);
                    --this.m_numBytesLeftInCurrentPacket;
                    continue;
                }
                s = (short)(this.readByte() & 0xFF);
            }
            if (byArray.length != n2) {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
            }
        } else {
            if (s == 0 || s == 253 || s == 255) {
                return new byte[0];
            }
            byArray = new byte[s];
            if (s <= this.m_numBytesLeftInCurrentPacket) {
                System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, n2, s);
                this.m_numBytesProcessed += s;
                this.m_numBytesLeftInCurrentPacket -= s;
                n2 += s;
            } else {
                System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, n2, this.m_numBytesLeftInCurrentPacket);
                this.m_numBytesProcessed += this.m_numBytesLeftInCurrentPacket;
                int n4 = s - this.m_numBytesLeftInCurrentPacket;
                this.m_numBytesLeftInCurrentPacket = 0;
                this.receivePiggybackPacket();
                System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray, n2 += this.m_numBytesLeftInCurrentPacket, n4);
                this.m_numBytesProcessed += n4;
                this.m_numBytesLeftInCurrentPacket -= n4;
                n2 += n4;
            }
        }
        return byArray;
    }

    public int readCLR(byte[][] byArray) throws UtilException, SQLException {
        short s;
        if (this.m_numBytesLeftInCurrentPacket >= 1) {
            s = (short)(this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF);
            --this.m_numBytesLeftInCurrentPacket;
        } else {
            s = (short)(this.readByte() & 0xFF);
        }
        if (s == 254) {
            boolean bl = true;
            int n = 0;
            if (this.m_numBytesLeftInCurrentPacket >= 1) {
                s = (short)(this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF);
                --this.m_numBytesLeftInCurrentPacket;
            } else {
                s = (short)(this.readByte() & 0xFF);
            }
            while (s > 0) {
                int n2;
                if (this.japaneseCharsetAsUTF8) {
                    if (s == 254 && !bl) {
                        s = (short)(this.readByte() & 0xFF);
                    }
                    if (s < 254) {
                        bl = false;
                    }
                }
                if (n + s >= byArray[0].length) {
                    n2 = byArray[0].length < 255 ? n + s + 1 : byArray[0].length * 8;
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray[0], 0, byArray2, 0, byArray[0].length);
                    byArray[0] = byArray2;
                }
                if (s < this.m_numBytesLeftInCurrentPacket) {
                    System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray[0], n, s + 1);
                    this.m_numBytesProcessed += s + 1;
                    this.m_numBytesLeftInCurrentPacket -= s + 1;
                    n += s;
                } else {
                    System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray[0], n, this.m_numBytesLeftInCurrentPacket);
                    this.m_numBytesProcessed += this.m_numBytesLeftInCurrentPacket;
                    n2 = s - this.m_numBytesLeftInCurrentPacket;
                    this.m_numBytesLeftInCurrentPacket = 0;
                    this.receivePiggybackPacket();
                    System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray[0], n += this.m_numBytesLeftInCurrentPacket, n2 + 1);
                    this.m_numBytesProcessed += n2 + 1;
                    this.m_numBytesLeftInCurrentPacket -= n2 + 1;
                    n += n2;
                }
                s = (short)(byArray[0][n] & 0xFF);
            }
            return n;
        }
        if (s == 0 || s == 253 || s == 255) {
            return -1;
        }
        int n = 0;
        if (s > byArray[0].length) {
            byArray[0] = new byte[s];
        }
        if (s <= this.m_numBytesLeftInCurrentPacket) {
            System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray[0], n, s);
            this.m_numBytesProcessed += s;
            this.m_numBytesLeftInCurrentPacket -= s;
            n += s;
        } else {
            System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray[0], n, this.m_numBytesLeftInCurrentPacket);
            this.m_numBytesProcessed += this.m_numBytesLeftInCurrentPacket;
            int n3 = s - this.m_numBytesLeftInCurrentPacket;
            this.m_numBytesLeftInCurrentPacket = 0;
            this.receivePiggybackPacket();
            System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, byArray[0], n += this.m_numBytesLeftInCurrentPacket, n3);
            this.m_numBytesProcessed += n3;
            this.m_numBytesLeftInCurrentPacket -= n3;
            n += n3;
        }
        return s;
    }

    public void skipCLR() throws UtilException, SQLException {
        short s = (short)(this.readByte() & 0xFF);
        int n = 0;
        if (s == 0 || s == 253 || s == 255) {
            return;
        }
        if (s == 254) {
            boolean bl = true;
            s = (short)(this.readByte() & 0xFF);
            while (s > 0) {
                if (s == 254 && !bl) {
                    s = (short)(this.readByte() & 0xFF);
                }
                if (s < 254) {
                    bl = false;
                }
                this.skipBytes(s);
                n += s;
            }
        } else {
            this.skipBytes(s);
        }
    }

    public void skipVCS() throws UtilException, SQLException {
        int n = this.readB4();
        if (n != 0) {
            this.skipCLR();
        }
    }

    public byte[] readVCS() throws UtilException, SQLException {
        int n = this.readB4();
        if (n == 0) {
            return nullValue;
        }
        return this.readCLR(n);
    }

    public short readInt16BIG() {
        this.m_numBytesLeftInCurrentPacket -= 2;
        return (short)(((this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) << 8) + (this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF));
    }

    public short readInt16Little() {
        this.m_numBytesLeftInCurrentPacket -= 2;
        return (short)((this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) + ((this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) << 8));
    }

    public int readInt32Little() {
        this.m_numBytesLeftInCurrentPacket -= 4;
        return (this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) + ((this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) << 8) + ((this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) << 16) + ((this.m_packetBuffer[this.m_numBytesProcessed++] & 0xFF) << 24);
    }

    public String readString(int n) throws UtilException, SQLException {
        String string;
        byte[] byArray = new byte[n];
        this.readBytes(byArray, 0, n);
        try {
            string = new String(byArray, 0, n, "Cp1252");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray, 0, n);
        }
        return string;
    }

    private void readFirstPacketInBuffer() throws UtilException, SQLException {
        this.m_numBytesProcessed = 0;
        this.m_numBytesInPacketBuffer += this.getArrayOfBytesFromSocket(this.m_packetBuffer, this.m_numBytesInPacketBuffer, this.m_packetBufferSize - this.m_numBytesInPacketBuffer);
        if (this.m_numBytesInPacketBuffer == 1) {
            this.m_numBytesInPacketBuffer += this.getArrayOfBytesFromSocket(this.m_packetBuffer, 1, this.m_packetBufferSize - 1);
        }
        int n = ((this.m_packetBuffer[0] & 0xFF) << 8) + (this.m_packetBuffer[1] & 0xFF);
        while (this.m_numBytesInPacketBuffer < n) {
            this.m_numBytesInPacketBuffer += this.getArrayOfBytesFromSocket(this.m_packetBuffer, this.m_numBytesInPacketBuffer, this.m_packetBufferSize - this.m_numBytesInPacketBuffer);
        }
        this.m_numBytesLeftInCurrentPacket = n;
    }

    protected void readPacket() throws UtilException, SQLException {
        int n = this.m_numBytesInPacketBuffer - this.m_numBytesProcessed;
        if (n == 0) {
            this.m_numBytesInPacketBuffer = 0;
            this.readFirstPacketInBuffer();
        } else if (n == 1) {
            this.m_packetBuffer[0] = this.m_packetBuffer[this.m_numBytesProcessed];
            this.m_numBytesInPacketBuffer = 1;
            this.readFirstPacketInBuffer();
        } else {
            int n2 = ((this.m_packetBuffer[this.m_numBytesProcessed] & 0xFF) << 8) + (this.m_packetBuffer[this.m_numBytesProcessed + 1] & 0xFF);
            if (n2 + this.m_numBytesProcessed > this.m_numBytesInPacketBuffer) {
                System.arraycopy(this.m_packetBuffer, this.m_numBytesProcessed, this.m_packetBuffer, 0, n);
                this.m_numBytesInPacketBuffer = n;
                this.readFirstPacketInBuffer();
            } else {
                this.m_numBytesProcessed += this.m_numBytesLeftInCurrentPacket;
                this.m_numBytesLeftInCurrentPacket = n2;
            }
        }
        this.m_NSPacketType = this.m_packetBuffer[this.m_numBytesProcessed + 4];
        this.m_numBytesProcessed += 8;
        this.m_numBytesLeftInCurrentPacket -= 8;
    }
}

