/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.diagram.ui.custom.actions;

import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.diagram.ui.DiagramUiConstants;
import com.metamatrix.modeler.diagram.ui.DiagramUiPlugin;
import com.metamatrix.modeler.diagram.ui.actions.DiagramAction;
import com.metamatrix.modeler.diagram.ui.connection.UmlRelationshipHelper;
import com.metamatrix.modeler.diagram.ui.custom.CustomDiagramModelFactory;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditor;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditorUtil;
import com.metamatrix.modeler.diagram.ui.model.DiagramModelNode;
import com.metamatrix.modeler.diagram.ui.util.DiagramUiUtilities;
import com.metamatrix.modeler.internal.ui.editors.ModelEditor;
import com.metamatrix.ui.internal.eventsupport.SelectionUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class AddAssociatedObjectsAction
extends DiagramAction {
    private static final String THIS_CLASS = "AddAssociatedObjectsAction";
    private DiagramEditor editor;

    public AddAssociatedObjectsAction() {
        this.setImageDescriptor(DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview20/tb_add_to_diagram.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.setEnabled(this.shouldEnable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun() {
        boolean handleConstruction;
        Diagram diagram;
        block12: {
            block13: {
                if (this.editor == null) return;
                DiagramModelNode diagramNode = this.editor.getCurrentModel();
                diagram = (Diagram)diagramNode.getModelObject();
                CustomDiagramModelFactory modelFactory = (CustomDiagramModelFactory)this.editor.getModelFactory();
                List objectsToAdd = this.getAssociatedObjectsNotInDiagram();
                if (objectsToAdd.isEmpty()) return;
                if (diagramNode == null) return;
                if (modelFactory == null) return;
                handleConstruction = !DiagramEditorUtil.isDiagramUnderConstruction((Diagram)diagram);
                boolean requiredStart = false;
                boolean succeeded = false;
                try {
                    try {
                        if (handleConstruction) {
                            DiagramEditorUtil.setDiagramUnderConstruction((Diagram)diagram);
                        }
                        requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Add Related Objects", (Object)((Object)this));
                        modelFactory.add(objectsToAdd, diagramNode);
                        succeeded = true;
                    }
                    catch (Exception ex) {
                        DiagramUiConstants.Util.log(4, (Throwable)ex, ex.getClass().getName() + ":" + THIS_CLASS + ".doRun()");
                        Object var10_9 = null;
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        if (!handleConstruction) return;
                        DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
                        return;
                    }
                    Object var10_8 = null;
                    if (!requiredStart) break block12;
                    if (!succeeded) break block13;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    if (!handleConstruction) throw throwable;
                    DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
                    throw throwable;
                }
                ModelerCore.commitTxn();
                break block12;
            }
            ModelerCore.rollbackTxn();
        }
        if (!handleConstruction) return;
        DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
    }

    private boolean shouldEnable() {
        if (!(this.getPart() instanceof ModelEditor) || this.getSelection() == null || SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()).size() < 0) {
            return false;
        }
        return this.allSelectedInDiagram() && this.isWritable() && this.allObjectsAddable();
    }

    private boolean allSelectedInDiagram() {
        if (this.editor != null && this.editor.getDiagramViewer() != null && this.editor.getDiagramViewer().getSelectionHandler() != null) {
            List selectedEObjects = this.editor.getDiagramViewer().getSelectionHandler().getSelectedEObjects();
            if (selectedEObjects == null || selectedEObjects.isEmpty()) {
                return false;
            }
            Iterator iter = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()).iterator();
            EObject eObj = null;
            while (iter.hasNext()) {
                eObj = (EObject)iter.next();
                if (selectedEObjects.contains(eObj)) continue;
                return false;
            }
        }
        return true;
    }

    public void setDiagramEditor(DiagramEditor editor) {
        this.editor = editor;
    }

    private boolean isWritable() {
        DiagramModelNode currentDiagram;
        if (this.editor != null && (currentDiagram = this.editor.getCurrentModel()) != null) {
            return !this.isReadOnly();
        }
        return false;
    }

    private boolean allObjectsAddable() {
        boolean allOK = true;
        List objectsToAdd = this.getAssociatedObjectsNotInDiagram();
        if (objectsToAdd == null || objectsToAdd.isEmpty()) {
            allOK = false;
        }
        return allOK;
    }

    private List getAssociatedObjectsNotInDiagram() {
        ArrayList<EObject> newObjects = new ArrayList<EObject>();
        if (this.editor != null && this.editor.getCurrentModel() != null) {
            DiagramModelNode diagramNode = this.editor.getCurrentModel();
            List allAssociatedToAdd = UmlRelationshipHelper.getRelatedObjects((List)SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()));
            Iterator iter = allAssociatedToAdd.iterator();
            EObject nextEObj = null;
            while (iter.hasNext()) {
                nextEObj = (EObject)iter.next();
                if (this.editor == null || this.editor.getCurrentModel() == null || DiagramUiUtilities.diagramContainsEObject((EObject)nextEObj, (DiagramModelNode)diagramNode)) continue;
                newObjects.add(nextEObj);
            }
        }
        if (newObjects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return newObjects;
    }

    protected boolean requiresEditorForRun() {
        return false;
    }
}

