/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase.tds;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.sybase.SybaseConnection;
import com.metamatrix.jdbc.sybase.SybaseDepacketizingDataProvider;
import com.metamatrix.jdbc.sybase.SybasePacketizingDataConsumer;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCancelInfo;
import com.metamatrix.util.UtilBufferedDataConsumer;
import com.metamatrix.util.UtilBufferedDataProvider;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilIntelligentBufferingDataProvider;
import com.metamatrix.util.UtilSocketDataConsumer;
import com.metamatrix.util.UtilSocketDataProvider;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilTransliteratorForUCS2;
import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;

public class SybaseTDSCommunication {
    private static String footprint = "$Revision:   3.12.1.0  $";
    Socket socket;
    public SybaseConnection connection;
    private UtilSocketDataConsumer socketConsumer;
    UtilBufferedDataConsumer bufferedConsumer;
    SybasePacketizingDataConsumer packetizer;
    public UtilByteOrderedDataWriter writer;
    private UtilSocketDataProvider socketProvider;
    public BaseExceptions exceptions;
    public boolean supportsWideTables;
    public UtilTransliterator transliteratorForDefaultCharset;
    public UtilTransliterator transliteratorForCharData;
    public UtilTransliteratorForUCS2 ucs2Transliterator = null;
    public SybaseTDSCancelInfo cancelInfo = new SybaseTDSCancelInfo();
    public UtilByteOrderedDataReader currentlyRegisteredReader;
    int replyBufferSize;
    public int maxMemoryPerLongDataCache;
    public boolean debugWireProtocol;

    public SybaseTDSCommunication(Socket socket, int n, int n2, boolean bl, BaseExceptions baseExceptions, SybaseConnection sybaseConnection) throws SQLException {
        this.socket = socket;
        this.replyBufferSize = n;
        this.maxMemoryPerLongDataCache = n2;
        this.exceptions = baseExceptions;
        this.debugWireProtocol = bl;
        this.connection = sybaseConnection;
        this.socketConsumer = new UtilSocketDataConsumer(socket);
        this.bufferedConsumer = new UtilBufferedDataConsumer(this.socketConsumer);
        Socket socket2 = null;
        if (bl) {
            socket2 = socket;
        }
        this.packetizer = new SybasePacketizingDataConsumer(this.bufferedConsumer, socket2);
        this.writer = new UtilByteOrderedDataWriter(this.packetizer);
        this.socketProvider = new UtilSocketDataProvider(socket);
        this.currentlyRegisteredReader = null;
    }

    public UtilByteOrderedDataReader createReader() {
        UtilBufferedDataProvider utilBufferedDataProvider = new UtilBufferedDataProvider(this.socketProvider);
        SybaseDepacketizingDataProvider sybaseDepacketizingDataProvider = new SybaseDepacketizingDataProvider(utilBufferedDataProvider);
        UtilIntelligentBufferingDataProvider utilIntelligentBufferingDataProvider = new UtilIntelligentBufferingDataProvider(sybaseDepacketizingDataProvider, this.replyBufferSize);
        UtilByteOrderedDataReader utilByteOrderedDataReader = new UtilByteOrderedDataReader(utilIntelligentBufferingDataProvider);
        if (this.transliteratorForDefaultCharset != null) {
            utilByteOrderedDataReader.setTransliterator(this.transliteratorForDefaultCharset);
        } else {
            this.transliteratorForDefaultCharset = utilByteOrderedDataReader.getTransliterator();
            this.transliteratorForCharData = utilByteOrderedDataReader.getTransliterator();
        }
        return utilByteOrderedDataReader;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public UtilSocketDataProvider getSocketProvider() {
        return this.socketProvider;
    }

    public UtilByteOrderedDataWriter getWriter() {
        return this.writer;
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
    }

    public void enableDebugInfo() throws IOException {
        this.bufferedConsumer.enableDebugInfo();
    }

    public void disableDebugInfo() {
        this.bufferedConsumer.disableDebugInfo();
    }

    public void setMessageType(int n) {
        this.packetizer.setMessageType(n);
    }
}

