/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.commandline;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLConfig_42_HelperImpl;
import com.metamatrix.common.jdbc.JDBCUtil;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.commandline.ExecutionTarget;
import com.metamatrix.common.util.commandline.IPropertyValidation;
import com.metamatrix.common.xml.XMLReaderWriterImpl;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.log.PlatformLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class UICommandLineTool {
    private static final String LEFT = "(";
    private static final String RIGHT = ")";
    private static final String KEYSTORE_PW = "javax.net.ssl.keyStorePassword";
    private static final String TRUSTSTORE_PW = "javax.net.ssl.trustStorePassword";
    public static final String NEW_LINE = "\n";
    public static final String SAVE_PROPERTY_FILE = "savePropertyFile";
    public static final String SILENT_RUN = "metamatrix.silent.run";
    public static final String SILENT_RUN_VALUE = "silent";
    public static final String KEYSTORE_REVERT = "keystore.process.revert";
    public static final String KEYSTORE_NEW = "keystore.process.new";
    private String configFileName;
    private String targetClzz;
    private String systemInstallPath;
    private String configFileFullPath;
    private Element setupToolElement;
    private String headerMessage;
    private Map menuOptions = new HashMap();
    private MenuOption lastOption = null;
    private String[] keys;
    private String currentUserInput;
    private BufferedReader in;
    private Properties properties = new Properties();
    private Properties defaultproperties = new Properties();
    private Properties existingproperties = new Properties();
    private Properties tempProperties = new Properties();
    private Properties alwaysProperties = new Properties();
    private Properties requiredProperties = new Properties();
    private Properties postDefaultProperties = new Properties();
    private XMLConfig_42_HelperImpl helper = new XMLConfig_42_HelperImpl();
    protected static final Properties initialSystemProps = System.getProperties();
    private IPropertyValidation propValidator = null;
    private boolean saveFile = true;
    private boolean runSilent = false;
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void run(String systemInstallPath, String xmlFilePath) {
        this.systemInstallPath = systemInstallPath;
        try {
            this.runSilent = false;
            String silentRun = initialSystemProps.getProperty(SILENT_RUN, "");
            if (silentRun.equalsIgnoreCase(SILENT_RUN_VALUE)) {
                this.runSilent = true;
            }
            this.setupToolElement = this.loadXMLFile(xmlFilePath);
            this.loadConfiguration();
            this.initializeProperties();
            if (this.runSilent) {
                if (this.runTool(true)) {
                    this.exit();
                } else {
                    this.exitWithError();
                }
            } else {
                this.loadMenuOptions();
                this.mainMenu();
            }
        }
        catch (IOException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0037", (Object)xmlFilePath));
            e.printStackTrace();
            this.exitWithError();
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.exitWithError();
        }
    }

    protected void revertKeystore() throws Exception {
    }

    protected void createKeystore() throws Exception {
    }

    public boolean isRunSilent() {
        return this.runSilent;
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected Properties getExisingProperties() {
        return this.existingproperties;
    }

    protected void setExistingProperties(Properties props) {
        this.existingproperties = props;
    }

    protected Properties getDefaultProperties() {
        return this.defaultproperties;
    }

    protected void setDefaultProperties(Properties props) {
        this.defaultproperties = props;
    }

    protected Properties getAlwaysProperties() {
        return this.alwaysProperties;
    }

    protected void setAlwaysProperties(Properties props) {
        this.alwaysProperties = props;
    }

    protected void setPostDefaultProperties(Properties props) {
        this.postDefaultProperties = props;
    }

    protected Properties getPostDefaultProperties() {
        return this.postDefaultProperties;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public String getInstallationPath() {
        return this.systemInstallPath;
    }

    protected String getConfigurationPropertyFilePath() {
        String locPath = initialSystemProps.getProperty("PropertyFilePath");
        if (locPath == null) {
            locPath = this.systemInstallPath;
        }
        return locPath;
    }

    protected void loadConfiguration() throws Exception {
        List postElements;
        Element postElement;
        List reqElements;
        String validatorClzz;
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0010"));
        Element configElement = this.setupToolElement.getChild("Configuration");
        if (configElement == null) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0038", (Object)"Configuration"));
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.030.0038", (Object)"Configuration"));
        }
        Element runClassElement = configElement.getChild("TargetClass");
        if (runClassElement == null) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0039", (Object)"TargetClass"));
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.030.0039", (Object)"TargetClass"));
        }
        this.targetClzz = runClassElement.getText();
        if (this.targetClzz == null || this.targetClzz.length() == 0) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.030.0039", (Object)"TargetClass"));
        }
        Element validationClassElement = configElement.getChild("ValidationClass");
        if (validationClassElement != null && (validatorClzz = validationClassElement.getText()) != null && validatorClzz.length() > 0) {
            this.propValidator = this.createValidation(validatorClzz);
        }
        Element propFileElement = configElement.getChild("PropertyFileName");
        this.configFileName = propFileElement.getText();
        Element propElement = configElement.getChild("Defaults");
        List propertyElements = propElement.getChildren("Property");
        Properties dproperties = new Properties();
        if (propertyElements != null) {
            Iterator iterator = propertyElements.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                String name = element.getAttributeValue("Name");
                String value = element.getAttributeValue("Value");
                if (name != null && name.length() > 0) {
                    dproperties.setProperty(name, value);
                }
                ++i;
            }
        }
        String savePropertyFile = dproperties.getProperty(SAVE_PROPERTY_FILE, "true");
        this.saveFile = Boolean.valueOf(savePropertyFile);
        this.setDefaultProperties(dproperties);
        Element alwaysElement = configElement.getChild("Always");
        Properties aproperties = new Properties();
        aproperties.setProperty("metamatrix.installationDir", this.getInstallationPath());
        if (alwaysElement != null) {
            List alwaysElements = alwaysElement.getChildren("Property");
            Iterator iterator = alwaysElements.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                String name = element.getAttributeValue("Name");
                String value = element.getAttributeValue("Value");
                if (name != null && name.length() > 0) {
                    aproperties.setProperty(name, value);
                }
                ++i;
            }
        }
        this.setAlwaysProperties(aproperties);
        Element reqElement = configElement.getChild("Required");
        if (reqElement != null && (reqElements = reqElement.getChildren("Property")) != null) {
            Iterator iterator = reqElements.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                String name = element.getAttributeValue("Name");
                String value = element.getAttributeValue("Value");
                if (name != null && name.length() > 0 && value != null) {
                    this.requiredProperties.setProperty(name, value);
                }
                ++i;
            }
        }
        if ((postElement = configElement.getChild("PostDefaults")) != null && (postElements = postElement.getChildren("Property")) != null) {
            Properties props = new Properties();
            Iterator iterator = postElements.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                String name = element.getAttributeValue("Name");
                String value = element.getAttributeValue("Value");
                if (name != null && name.length() > 0 && value != null) {
                    props.setProperty(name, value);
                }
                ++i;
            }
            this.setPostDefaultProperties(props);
        }
        this.configFileFullPath = FileUtils.buildDirectoryPath((String[])new String[]{this.getConfigurationPropertyFilePath(), this.configFileName});
        Properties eproperties = new Properties();
        this.loadDefaultProperties(eproperties, this.configFileFullPath);
        if (this.runSilent) {
            this.loadSilentProperties(eproperties);
        }
        this.setExistingProperties(eproperties);
        System.out.println(CommonPlugin.Util.getString("ERR.003.030.0040", new Object[]{NEW_LINE, NEW_LINE, this.configFileFullPath, NEW_LINE}));
        this.in = new BufferedReader(new InputStreamReader(System.in));
    }

    protected void loadDefaultProperties(Properties props, String fileName) {
        try {
            Properties properties = PropertiesUtils.load((String)fileName);
            props.putAll((Map<?, ?>)properties);
        }
        catch (IOException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0041", (Object)fileName));
        }
    }

    protected void loadSilentProperties(Properties props) {
    }

    protected void initializeProperties() throws Exception {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getDefaultProperties());
        props.putAll((Map<?, ?>)this.getExisingProperties());
        props.putAll((Map<?, ?>)this.getAlwaysProperties());
        this.setProperties(props);
    }

    private void loadMenuOptions() {
        Element menuOptionsElement = this.setupToolElement.getChild("MenuOptions");
        this.headerMessage = this.getChoiceDescription(menuOptionsElement);
        List optionElements = menuOptionsElement.getChildren("Option");
        this.keys = new String[optionElements.size()];
        Iterator iterator = optionElements.iterator();
        int i = 1;
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String key = element.getAttributeValue("Key");
            String type = element.getAttributeValue("Type");
            String desc = element.getAttributeValue("Description");
            MenuOption o = new MenuOption(key);
            o.setDescription(desc);
            if (type != null) {
                String msg;
                o.setChoiceType(type);
                Element optionElement = this.setupToolElement.getChild(key);
                o.setOptionElement(optionElement);
                String actions = optionElement.getAttributeValue("Actions");
                if (actions != null && actions.length() > 0) {
                    List ca = StringUtil.getTokens(actions, ",");
                    o.addActions(ca);
                }
                if ((msg = optionElement.getAttributeValue("Msg")) != null && msg.length() > 0) {
                    o.setMessage(msg);
                }
            }
            this.menuOptions.put(key, o);
            o.setOptionNumber(String.valueOf(i));
            this.keys[i - 1] = key;
            ++i;
        }
        this.saveFile = this.menuOptions.containsKey("Save");
    }

    private void mainMenu() {
        this.help();
        this.printMainMenu();
        this.displayOptions();
    }

    private void displayOptions() {
        boolean display = true;
        while (display) {
            String command = this.getUserInput((String)null);
            if (command == null) {
                this.invalidCommand(command);
                continue;
            }
            if (!this.processCommand(command)) continue;
            this.printMainMenu();
        }
    }

    private boolean processCommand(String command) {
        MenuOption moption;
        int commandInt;
        boolean result = true;
        if (command.equalsIgnoreCase("Help")) {
            this.help();
            return true;
        }
        try {
            commandInt = Integer.parseInt(command) - 1;
        }
        catch (NumberFormatException e) {
            commandInt = 100;
        }
        if (commandInt >= 0 && commandInt < this.keys.length) {
            String key = this.keys[commandInt];
            moption = (MenuOption)this.menuOptions.get(key);
            if (moption == null) {
                this.invalidCommand(command);
                return false;
            }
            if (key.equalsIgnoreCase("Exit")) {
                this.checkToExit();
            } else if (key.equalsIgnoreCase("Help")) {
                this.help();
            } else if (key.equalsIgnoreCase("Save")) {
                this.writeConfigurationProperties();
            } else if (key.equalsIgnoreCase("Run")) {
                result = this.runTool(false);
            } else if (key.equalsIgnoreCase("ViewProperties")) {
                this.displayProperties();
            } else if (key.equalsIgnoreCase("TestConn")) {
                this.testConnections();
            } else {
                this.getUserEnteredProperties(key);
            }
        } else {
            this.invalidCommand(command);
            return false;
        }
        this.lastOption = moption;
        return result;
    }

    protected void checkToExit() {
        if (this.saveFile) {
            if (this.yesNoPrompt("Exit Application? (y/n)\n(be sure to select 'Save' if execution was not performed")) {
                this.exit();
            }
        } else {
            this.exit();
        }
    }

    protected void exit() {
        System.exit(0);
    }

    protected void exitWithError() {
        System.exit(-1);
    }

    private void getUserEnteredProperties(String key) {
        MenuOption mo = (MenuOption)this.menuOptions.get(key);
        this.displaySelectedOption(mo);
        if (mo.hasMultipleChoices()) {
            if (!this.processMultipleChoices(mo)) {
                return;
            }
        } else if (mo.hasSingleChoice()) {
            this.processSingleChoice(mo);
        }
        if (!this.processActions(mo)) {
            this.getUserEnteredProperties(key);
            return;
        }
    }

    private boolean processMultipleChoices(MenuOption mo) {
        this.displaySelectedOptionChoices(mo.getOptionElement());
        System.out.print(NEW_LINE);
        this.currentUserInput = this.getUserInput((String)null);
        Element element = this.getMenuOptionElement(mo, this.currentUserInput);
        if (element == null) {
            this.invalidCommand(this.currentUserInput);
            return false;
        }
        this.getUserInput(element);
        return true;
    }

    private void processSingleChoice(MenuOption mo) {
        this.getUserInput(mo.getOptionElement());
    }

    private boolean processActions(MenuOption mo) {
        if (mo.getActions() == null || mo.getActions().size() == 0) {
            return true;
        }
        Iterator it = mo.getActions().iterator();
        while (it.hasNext()) {
            String action = (String)it.next();
            if (!action.equalsIgnoreCase("testconnection") || this.testConnectionProperties()) continue;
            return false;
        }
        return true;
    }

    private void displaySelectedOption(MenuOption option) {
        System.out.print("\n\n" + option.getMessage() + NEW_LINE);
    }

    private void displaySelectedOptionChoices(Element parentElement) {
        List choiceElements = parentElement.getChildren("Choice");
        if (choiceElements != null) {
            Iterator iterator = choiceElements.iterator();
            while (iterator.hasNext()) {
                Element choiceElement = (Element)iterator.next();
                System.out.print(NEW_LINE);
                System.out.print(this.getChoiceKey(choiceElement) + ") " + this.getChoiceDescription(choiceElement));
            }
        }
    }

    private Element getMenuOptionElement(MenuOption option, String choiceKey) {
        if (option.getOptionElement() != null) {
            return this.getChoiceElement(choiceKey, option.getOptionElement());
        }
        return null;
    }

    private Element getChoiceElement(String choiceKey, Element parentElement) {
        List choiceElements = parentElement.getChildren("Choice");
        Iterator iterator = choiceElements.iterator();
        while (iterator.hasNext()) {
            Element choiceElement = (Element)iterator.next();
            if (!choiceKey.equalsIgnoreCase(this.getChoiceKey(choiceElement))) continue;
            return choiceElement;
        }
        return null;
    }

    private void getUserInput(Element element) {
        List propDefns = null;
        List compoundDefns = null;
        try {
            propDefns = this.getPropertyDefinitions(element);
        }
        catch (InvalidConfigurationElementException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0042"));
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        try {
            compoundDefns = this.getCompoundPropertyDefinitions(element);
        }
        catch (InvalidConfigurationElementException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0042"));
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        Iterator iterator = propDefns.iterator();
        while (iterator.hasNext()) {
            PropertyDefinition defn = (PropertyDefinition)iterator.next();
            String propName = defn.getName();
            String currentPropValue = this.properties.getProperty(propName, (String)defn.getDefaultValue());
            if (currentPropValue == null && (currentPropValue = initialSystemProps.getProperty(propName)) == null) {
                currentPropValue = this.tempProperties.getProperty(propName);
            }
            if (defn.isModifiable()) {
                block25: {
                    String value = null;
                    while (true) {
                        if (defn.isRequired()) {
                            value = this.getUserInput(defn, currentPropValue);
                            if (value == null || value.trim().length() == 0) {
                                System.out.println(CommonPlugin.Util.getString("UICommandTool.Invalid_value", (Object)defn.getDisplayName()));
                                continue;
                            }
                        } else {
                            value = this.getUserInput(defn, currentPropValue);
                        }
                        if (value == null || value.length() <= 0) break block25;
                        try {
                            this.validateProperty(propName, value);
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                            continue;
                        }
                        break;
                    }
                    this.properties.setProperty(defn.getName(), value);
                    continue;
                }
                this.properties.remove(defn.getName());
                continue;
            }
            if (defn.getDefaultValue() != null) {
                this.properties.setProperty(defn.getName(), (String)defn.getDefaultValue());
                continue;
            }
            if (currentPropValue == null) continue;
            this.properties.setProperty(defn.getName(), currentPropValue);
        }
        iterator = compoundDefns.iterator();
        while (iterator.hasNext()) {
            CompoundPropDefn compoundPropDefn = (CompoundPropDefn)iterator.next();
            propDefns = compoundPropDefn.getPropertyDefinitions();
            iterator = propDefns.iterator();
            while (iterator.hasNext()) {
                String currentPropValue;
                PropertyDefinition propDefn;
                block27: {
                    String uevalue;
                    block28: {
                        block26: {
                            propDefn = (PropertyDefinition)iterator.next();
                            String propName = propDefn.getName();
                            currentPropValue = this.properties.getProperty(propName, (String)propDefn.getDefaultValue());
                            if (currentPropValue == null) {
                                currentPropValue = this.tempProperties.getProperty(propName);
                            }
                            if (!propDefn.isModifiable()) break block27;
                            uevalue = null;
                            while (true) {
                                if (propDefn.isRequired()) {
                                    uevalue = this.getUserInput(propDefn, currentPropValue);
                                    if (uevalue == null || uevalue.trim().length() == 0) {
                                        System.out.println(CommonPlugin.Util.getString("UICommandTool.Invalid_value", (Object)propDefn.getDisplayName()));
                                        continue;
                                    }
                                } else {
                                    uevalue = this.getUserInput(propDefn, currentPropValue);
                                }
                                if (uevalue == null || uevalue.length() <= 0) break block26;
                                try {
                                    this.validateProperty(propName, uevalue);
                                }
                                catch (Exception e) {
                                    System.out.println(e.getMessage());
                                    continue;
                                }
                                break;
                            }
                            this.tempProperties.setProperty(propDefn.getName(), uevalue);
                            break block28;
                        }
                        this.tempProperties.remove(propDefn.getName());
                    }
                    compoundPropDefn.setProperty(propDefn.getName(), uevalue);
                    continue;
                }
                if (propDefn.getDefaultValue() != null) {
                    this.properties.setProperty(propDefn.getName(), (String)propDefn.getDefaultValue());
                    continue;
                }
                if (currentPropValue == null) continue;
                compoundPropDefn.setProperty(propDefn.getName(), currentPropValue);
            }
            if (compoundPropDefn.getPropertyValue().length() > 0) {
                this.properties.setProperty(compoundPropDefn.getCompoundPropertyName(), compoundPropDefn.getPropertyValue());
                continue;
            }
            this.properties.remove(compoundPropDefn.getCompoundPropertyName());
        }
    }

    private String getUserInput(PropertyDefinition defn, String currentPropValue) {
        String propDesc = defn.getShortDescription();
        String propName = defn.getName();
        if (currentPropValue == null) {
            currentPropValue = this.tempProperties.getProperty(propName);
        }
        System.out.println(propDesc + NEW_LINE + defn.getDisplayName() + " = ");
        String value = this.getUserInput(currentPropValue);
        return value;
    }

    protected String getUserInput(String defaultValue) {
        try {
            if (defaultValue != null && defaultValue.length() != 0) {
                System.out.print(CommonPlugin.Util.getString("ERR.003.030.0043", (Object)defaultValue));
            } else {
                System.out.print("\n? ");
            }
            String line = this.in.readLine();
            if (line == null || line.length() == 0) {
                line = defaultValue;
            }
            if (line == null) {
                line = "";
            } else {
                if (line.equals("*")) {
                    this.mainMenu();
                    return "";
                }
                if (line.equalsIgnoreCase("exit")) {
                    System.exit(0);
                } else if (line.equalsIgnoreCase("#")) {
                    line = "";
                }
            }
            return line;
        }
        catch (IOException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0044"));
            return "";
        }
    }

    protected Properties getTestConnectionProperties() {
        return this.properties;
    }

    protected Properties getConnectionProperties() {
        return this.properties;
    }

    protected Properties getPropertiesToRun() throws Exception {
        Properties runprops = new Properties();
        runprops.putAll((Map<?, ?>)initialSystemProps);
        Properties connProps = this.getConnectionProperties();
        runprops.putAll((Map<?, ?>)connProps);
        this.addPostDefaults(runprops);
        return runprops;
    }

    protected void addPostDefaults(Properties runProps) {
        Properties post = this.getPostDefaultProperties();
        if (post != null && post.size() > 0) {
            Iterator<Object> it = post.keySet().iterator();
            while (it.hasNext()) {
                String newValue;
                String key = (String)it.next();
                String value = runProps.getProperty(key);
                if (value != null && value.trim().length() > 0 || (value = post.getProperty(key)) == null || (newValue = this.replaceValue(value, runProps)) == null) continue;
                runProps.setProperty(key, newValue);
            }
        }
    }

    protected String replaceValue(String value, Properties props) {
        int end;
        StringBuffer sb = new StringBuffer(value);
        int start = value.indexOf(LEFT);
        if (start == -1) {
            return value;
        }
        while (start != -1 && (end = value.indexOf(RIGHT, start)) != -1) {
            String parm = value.substring(start + 1, end);
            String subValue = props.getProperty(parm);
            if (subValue != null) {
                sb.replace(start, end + 1, subValue);
                value = sb.toString();
                start = value.indexOf(LEFT, start + 1);
                continue;
            }
            start = value.indexOf(LEFT, start + 1);
        }
        return sb.toString();
    }

    protected boolean testConnections() {
        return false;
    }

    protected boolean testConnection() {
        return this.testConnection(this.getTestConnectionProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean testConnection(Properties props) {
        block10: {
            String url = "not defined";
            Connection conn = null;
            url = JDBCUtil.getDatabaseURL((Properties)props);
            System.out.print(CommonPlugin.Util.getString("ERR.003.030.0045", (Object)NEW_LINE, (Object)url, (Object)NEW_LINE));
            conn = JDBCUtil.createJDBCConnection((Properties)props);
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0011", (Object)url, (Object)NEW_LINE));
            Object var7_4 = null;
            if (conn == null) break block10;
            try {
                conn.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            conn = null;
            {
                break block10;
                catch (Exception e) {
                    System.out.print(CommonPlugin.Util.getString("ERR.003.030.0046", (Object)NEW_LINE, (Object)url, (Object)NEW_LINE));
                    PropertiesUtils.print((PrintStream)System.out, (Properties)props);
                    System.out.println(CommonPlugin.Util.getString("ERR.003.030.0047"));
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                    System.out.println(CommonPlugin.Util.getString("ERR.003.030.0048"));
                    boolean bl = false;
                    Object var7_5 = null;
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        conn = null;
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    conn = null;
                }
                throw throwable;
            }
        }
        return true;
    }

    private boolean testConnectionProperties() {
        if (this.yesNoPrompt("Test connection properties (y/n)?")) {
            return this.testConnection();
        }
        return true;
    }

    protected boolean yesNoPrompt(String message) {
        System.out.print(message);
        String value = this.getUserInput((String)null);
        return value.equalsIgnoreCase("y");
    }

    protected boolean runTool(boolean silent) {
        PrintStream sysOut = System.out;
        try {
            Properties p;
            if (!silent && !this.okToRun()) {
                return false;
            }
            boolean keystoreRevert = PropertiesUtils.getBooleanProperty((Properties)this.getProperties(), (String)KEYSTORE_REVERT, (boolean)false);
            if (keystoreRevert) {
                p = this.initializePropertiesForRunTool(silent);
                if (p == null) {
                    return false;
                }
                this.revertKeystore();
            }
            if ((p = this.initializePropertiesForRunTool(silent)) == null) {
                return false;
            }
            ExecutionTarget tool = this.createTargetInstance();
            tool.run(p);
            boolean keystoreNew = PropertiesUtils.getBooleanProperty((Properties)this.getProperties(), (String)KEYSTORE_NEW, (boolean)false);
            if (keystoreNew) {
                this.createKeystore();
            }
        }
        catch (Exception e) {
            System.setOut(sysOut);
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0049", (Object)e.getMessage()));
            e.printStackTrace();
            return false;
        }
        System.setOut(sysOut);
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0014"));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0015", (Object)new Date()));
        return true;
    }

    private Properties initializePropertiesForRunTool(boolean silent) throws Exception {
        Properties p = (Properties)this.getPropertiesToRun().clone();
        if (!this.arePropertiesValid(p)) {
            return null;
        }
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0012", (Object)new Date()));
        String keystorePW = System.getProperty(KEYSTORE_PW);
        String truststorestorePW = System.getProperty(TRUSTSTORE_PW);
        System.setProperties(p);
        if (keystorePW != null) {
            System.setProperty(KEYSTORE_PW, keystorePW);
        }
        if (truststorestorePW != null) {
            System.setProperty(TRUSTSTORE_PW, truststorestorePW);
        }
        CurrentConfiguration.reset();
        this.writeConfigurationProperties();
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0013"));
        return p;
    }

    protected boolean arePropertiesValid(Properties propstorun) throws Exception {
        Map.Entry<Object, Object> entry;
        Iterator<Map.Entry<Object, Object>> iter = this.requiredProperties.entrySet().iterator();
        String msg = null;
        String p2Value = null;
        while (iter.hasNext()) {
            entry = iter.next();
            msg = (String)entry.getValue();
            if (!propstorun.containsKey(entry.getKey())) {
                System.out.println(CommonPlugin.Util.getString("ERR.003.030.0182", (Object)msg));
                return false;
            }
            p2Value = propstorun.getProperty((String)entry.getKey());
            if (p2Value != null && p2Value.trim().length() != 0) continue;
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0182", (Object)msg));
            return false;
        }
        if (this.propValidator != null) {
            Iterator<Map.Entry<Object, Object>> itp = propstorun.entrySet().iterator();
            while (itp.hasNext()) {
                entry = itp.next();
                this.propValidator.isPropertyValid((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return true;
    }

    protected void validateProperty(String key, String value) throws Exception {
        if (this.propValidator != null) {
            this.propValidator.isPropertyValid(key, value);
        }
    }

    protected boolean okToRun() {
        return true;
    }

    private void invalidCommand(String command) {
        System.out.println(CommonPlugin.Util.getString("ERR.003.030.0050"));
    }

    private void help() {
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0016"));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0017", (Object)"exit"));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0018", (Object)"*"));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0019", (Object)"#"));
        System.out.println(CommonPlugin.Util.getString("ERR.003.030.0051"));
    }

    public List getPropertyDefinitions(Element element) throws InvalidConfigurationElementException {
        List propDefnElements = element.getChildren("PropertyDefinition");
        if (propDefnElements != null) {
            ArrayList<PropertyDefinition> propDefns = new ArrayList<PropertyDefinition>(propDefnElements.size());
            Iterator iterator = propDefnElements.iterator();
            while (iterator.hasNext()) {
                Element propDefnElement = (Element)iterator.next();
                PropertyDefinition propDefn = this.helper.createPropertyDefinition(propDefnElement);
                propDefns.add(propDefn);
            }
            return propDefns;
        }
        return null;
    }

    public List getCompoundPropertyDefinitions(Element element) throws InvalidConfigurationElementException {
        List compoundPropElements = element.getChildren("CompoundPropertyValue");
        if (compoundPropElements != null) {
            ArrayList<CompoundPropDefn> compoundElements = new ArrayList<CompoundPropDefn>(compoundPropElements.size());
            Iterator iterator = compoundPropElements.iterator();
            while (iterator.hasNext()) {
                CompoundPropDefn compDefn = new CompoundPropDefn();
                Element compoundPropElement = (Element)iterator.next();
                List propDefnElements = compoundPropElement.getChildren("PropertyDefinition");
                ArrayList<PropertyDefinition> propDefns = new ArrayList<PropertyDefinition>(propDefnElements.size());
                Iterator iter = propDefnElements.iterator();
                while (iter.hasNext()) {
                    Element propDefnElement = (Element)iter.next();
                    PropertyDefinition propDefn = this.helper.createPropertyDefinition(propDefnElement);
                    propDefns.add(propDefn);
                }
                compDefn.setPropertyDefinitions(propDefns);
                compDefn.setValuePattern(compoundPropElement.getAttributeValue("CompoundPropValuesPattern"));
                compDefn.setCompoundPropertyName(compoundPropElement.getAttributeValue("CompoundPropName"));
                compoundElements.add(compDefn);
            }
            return compoundElements;
        }
        return null;
    }

    public void displayProperties() {
        if (!this.isRunSilent()) {
            System.out.print(CommonPlugin.Util.getString("MSG.003.030.0020"));
            PropertiesUtils.print((PrintStream)System.out, (Properties)this.properties);
        }
    }

    public void writeConfigurationProperties() {
        this.writeProperties(this.configFileFullPath, this.properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeProperties(String fullPath, Properties props) {
        block23: {
            if (!this.saveFile) {
                return;
            }
            ArrayList<String> names = new ArrayList<String>();
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                names.add(name);
            }
            Collections.sort(names);
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0021", (Object)fullPath));
            FileOutputStream stream = null;
            PrintStream writer = null;
            File f = new File(fullPath);
            File p = f.getParentFile();
            if (!p.exists()) {
                this.createPath(p);
            }
            stream = new FileOutputStream(fullPath);
            writer = new PrintStream(stream);
            writer.println(CommonPlugin.Util.getString("MSG.003.030.0022"));
            writer.println("#" + new Date().toString());
            Iterator nIt = names.iterator();
            while (nIt.hasNext()) {
                String name = (String)nIt.next();
                String value = (String)props.get(name);
                name = this.saveConvert(name, true);
                value = this.saveConvert(value, false);
                writer.println(name + "=" + value);
            }
            writer.flush();
            Object var13_13 = null;
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (stream != null) {
                    stream.close();
                }
                break block23;
            }
            catch (Exception e2) {}
            break block23;
            {
                catch (IOException e) {
                    System.out.println(CommonPlugin.Util.getString("ERR.003.030.0052", (Object)fullPath));
                    e.printStackTrace();
                    Object var13_14 = null;
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block23;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0023"));
    }

    private void createPath(File f) {
        if (!f.exists()) {
            if (f.getParentFile() != null) {
                File p = f.getParentFile();
                this.createPath(p);
            }
            f.mkdir();
        }
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(UICommandLineTool.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(UICommandLineTool.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(UICommandLineTool.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(UICommandLineTool.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    protected final ExecutionTarget createTargetInstance() throws Exception {
        ExecutionTarget sr = null;
        sr = (ExecutionTarget)Class.forName(this.targetClzz).newInstance();
        return sr;
    }

    protected final IPropertyValidation createValidation(String clzz) throws Exception {
        IPropertyValidation sr = null;
        sr = (IPropertyValidation)Class.forName(clzz).newInstance();
        return sr;
    }

    private Element loadXMLFile(String filePath) throws Exception {
        FileInputStream stream = new FileInputStream(filePath);
        XMLReaderWriterImpl reader = new XMLReaderWriterImpl();
        Document doc = null;
        try {
            doc = reader.readDocument((InputStream)stream);
        }
        catch (IOException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0053", (Object)filePath));
            e.printStackTrace();
            throw e;
        }
        catch (JDOMException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0054", (Object)filePath));
            e.printStackTrace();
            throw e;
        }
        return doc.getRootElement();
    }

    private void printMainMenu() {
        System.out.println(NEW_LINE + this.headerMessage);
        System.out.println(NEW_LINE);
        int l = this.keys.length;
        for (int i = 0; i < l; ++i) {
            MenuOption mo = (MenuOption)this.menuOptions.get(this.keys[i]);
            System.out.println(mo.displayMenuOption());
        }
        if (this.lastOption != null) {
            System.out.print(CommonPlugin.Util.getString("MSG.003.030.0024", (Object)this.lastOption.displayMenuOption()));
        }
    }

    private String getChoiceKey(Element element) {
        return element.getAttributeValue("Key");
    }

    private String getChoiceDescription(Element element) {
        return element.getAttributeValue("Description");
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0055", args.length));
            System.exit(0);
        }
        PlatformLog log = PlatformLog.getInstance();
        ArrayList listeners = new ArrayList(log.getLogListeners());
        for (int i = 0; i < listeners.size(); ++i) {
            log.removeListener((LogListener)listeners.get(i));
        }
        UICommandLineTool ui = new UICommandLineTool();
        ui.run(args[0], args[1]);
    }

    public static class CompoundPropDefn {
        private String compoundPropertyName;
        private List propertyDefns;
        private String valuePattern;
        private Properties props = new Properties();

        public List getPropertyDefinitions() {
            return this.propertyDefns;
        }

        public void setProperty(String name, String value) {
            if (value != null) {
                this.props.setProperty(name, value);
            }
        }

        public String getPropertyValue() {
            String value = this.valuePattern;
            Iterator iterator = this.propertyDefns.iterator();
            while (iterator.hasNext()) {
                PropertyDefinition propDefn = (PropertyDefinition)iterator.next();
                String propName = propDefn.getName();
                String currentPropValue = this.props.getProperty(propName);
                if (currentPropValue == null) continue;
                value = StringUtil.replace(value, propName, currentPropValue);
            }
            return value;
        }

        public String getCompoundPropertyName() {
            return this.compoundPropertyName;
        }

        void setPropertyDefinitions(List propDefns) {
            this.propertyDefns = propDefns;
        }

        void setValuePattern(String valuePattern) {
            this.valuePattern = valuePattern;
        }

        void setCompoundPropertyName(String compoundPropertyName) {
            this.compoundPropertyName = compoundPropertyName;
        }
    }

    public static class MenuOption {
        private String key;
        private String description;
        private String message;
        private Element optionElement;
        private String choiceType = "";
        private Collection actions = new ArrayList(5);
        private String optionNumber = "";

        public MenuOption(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setOptionElement(Element element) {
            this.optionElement = element;
        }

        public Element getOptionElement() {
            return this.optionElement;
        }

        public void setOptionNumber(String number) {
            this.optionNumber = number;
        }

        public String getOptionNumber() {
            return this.optionNumber;
        }

        public void setMessage(String msg) {
            this.message = msg;
        }

        public String getMessage() {
            return this.message;
        }

        public void addActions(Collection values) {
            this.actions.addAll(values);
        }

        public void addAction(String value) {
            this.actions.add(value);
        }

        public Collection getActions() {
            return this.actions;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean hasMultipleChoices() {
            return this.choiceType.equalsIgnoreCase("Choice");
        }

        public boolean hasSingleChoice() {
            return this.choiceType.equalsIgnoreCase("Single");
        }

        public boolean containtsOptions() {
            return this.choiceType.equalsIgnoreCase("Options");
        }

        public void setChoiceType(String choiceType) {
            this.choiceType = choiceType;
        }

        public String displayMenuOption() {
            return this.optionNumber + ") " + this.description;
        }
    }

    public static final class Command {
        public static final String EXIT = "exit";
        public static final String MAIN_MENU = "*";
        public static final String DELETE = "#";
    }
}

