/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.JoinStrategyType;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CalculateCostUtil;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.DependentJoinData;
import com.metamatrix.query.optimizer.relational.rules.NewCalculateCostUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.relational.DependentValueSource;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.util.ValueIteratorSource;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.FunctionCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.sql.visitor.PredicateCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class RuleChooseDependent
implements OptimizerRule {
    private static Object ATOMIC_CRITERIA_COLLECTION_KEY = new /* Unavailable Anonymous Inner Class!! */;

    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode accessNode;
        LinkedList<PlanNode> matches = new LinkedList<PlanNode>();
        this.findCandidateAccess(plan, matches, metadata, capFinder, context);
        if (matches.size() == 0) {
            return plan;
        }
        Iterator matchIter = matches.iterator();
        while (matchIter.hasNext()) {
            PlanNode siblingNode;
            block25: {
                accessNode = (PlanNode)matchIter.next();
                siblingNode = NodeEditor.getSibling(accessNode);
                PlanNode joinNode = accessNode;
                while (joinNode.getType() != 7) {
                    joinNode = accessNode.getParent();
                }
                JoinStrategyType joinStrategy = (JoinStrategyType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_STRATEGY);
                if (!matches.contains(siblingNode)) continue;
                PlanNode chosenNode = this.chooseDepNodeByHintsAcessPattern(accessNode, siblingNode, metadata, capFinder);
                if (chosenNode != null) {
                    this.markDependent(chosenNode, metadata, rules);
                }
                try {
                    if (chosenNode == null) {
                        long siblingDepJoinCost = 0L;
                        long accessDepJoinCost = 0L;
                        if (joinStrategy.equals((Object)JoinStrategyType.NESTED_LOOP)) {
                            siblingDepJoinCost = NewCalculateCostUtil.computeCostForNestedLoopDepJoin(accessNode, siblingNode, metadata, capFinder, context);
                            accessDepJoinCost = NewCalculateCostUtil.computeCostForNestedLoopDepJoin(siblingNode, accessNode, metadata, capFinder, context);
                        } else if (joinStrategy.equals((Object)JoinStrategyType.MERGE)) {
                            siblingDepJoinCost = NewCalculateCostUtil.computeCostForMergeDepJoin(accessNode, siblingNode, metadata, capFinder, context);
                            accessDepJoinCost = NewCalculateCostUtil.computeCostForMergeDepJoin(siblingNode, accessNode, metadata, capFinder, context);
                        }
                        long depJoinCost = 0L;
                        PlanNode dependentNode = null;
                        PlanNode independentNode = null;
                        if (siblingDepJoinCost != Integer.MAX_VALUE && siblingDepJoinCost != Integer.MAX_VALUE) {
                            if (siblingDepJoinCost < accessDepJoinCost) {
                                dependentNode = siblingNode;
                                depJoinCost = siblingDepJoinCost;
                                independentNode = accessNode;
                            } else {
                                dependentNode = accessNode;
                                depJoinCost = accessDepJoinCost;
                                independentNode = siblingNode;
                            }
                            this.decideForAgainstDependentJoin(depJoinCost, independentNode, dependentNode, joinNode, metadata, context, rules);
                        }
                    }
                }
                catch (MetaMatrixRuntimeException e) {
                    PlanNode[] stillConsider = this.removeVirtual(accessNode, siblingNode);
                    if (stillConsider.length == 1) {
                        matches.add(stillConsider[0]);
                    }
                    if (stillConsider.length <= 1 || (chosenNode = this.chooseSibling(accessNode, siblingNode, metadata, capFinder)) == null) break block25;
                    this.markDependent(chosenNode, metadata, rules);
                }
            }
            matches.remove(accessNode);
            matches.remove(siblingNode);
            matchIter = matches.iterator();
            accessNode.removeProperty(ATOMIC_CRITERIA_COLLECTION_KEY);
            siblingNode.removeProperty(ATOMIC_CRITERIA_COLLECTION_KEY);
        }
        while (matches.size() > 0) {
            block26: {
                PlanNode joinNode = accessNode = (PlanNode)matches.get(0);
                while (joinNode.getType() != 7) {
                    joinNode = accessNode.getParent();
                }
                JoinStrategyType joinStrategy = (JoinStrategyType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_STRATEGY);
                JoinType joinType = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
                PlanNode siblingNode = NodeEditor.getSibling(accessNode);
                if (matches.contains(siblingNode)) continue;
                matches.remove(accessNode);
                if (accessNode.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS) && !accessNode.hasProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED)) {
                    this.markDependent(accessNode, metadata, rules);
                    continue;
                }
                if (this.hasHint(accessNode)) {
                    LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Making access node dependent due to hint: ", accessNode.nodeToString()});
                    this.markDependent(accessNode, metadata, rules);
                    continue;
                }
                try {
                    long depJoinCost = 0L;
                    if (joinStrategy.equals((Object)JoinStrategyType.NESTED_LOOP)) {
                        depJoinCost = NewCalculateCostUtil.computeCostForNestedLoopDepJoin(siblingNode, accessNode, metadata, capFinder, context);
                    } else if (joinStrategy.equals((Object)JoinStrategyType.MERGE)) {
                        depJoinCost = NewCalculateCostUtil.computeCostForMergeDepJoin(siblingNode, accessNode, metadata, capFinder, context);
                    }
                    this.decideForAgainstDependentJoin(depJoinCost, siblingNode, accessNode, joinNode, metadata, context, rules);
                }
                catch (MetaMatrixRuntimeException e) {
                    if (this.isVirtual(accessNode)) break block26;
                    LinkedList atomicCriteria = new LinkedList();
                    this.collectCriteriaUnderAccessNode(accessNode, atomicCriteria);
                    accessNode.setProperty(ATOMIC_CRITERIA_COLLECTION_KEY, atomicCriteria);
                    if (!CalculateCostUtil.isAccessNodeStrong(accessNode, metadata)) {
                        if (this.containsStrongAccessNode(siblingNode, metadata) || joinType.equals((Object)JoinType.JOIN_LEFT_OUTER)) {
                            this.markDependent(accessNode, metadata, rules);
                        }
                    }
                    LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as it's criteria is strong: ", accessNode.nodeToString()});
                }
            }
            accessNode.removeProperty(ATOMIC_CRITERIA_COLLECTION_KEY);
        }
        return plan;
    }

    private PlanNode[] removeVirtual(PlanNode accessNode1, PlanNode accessNode2) {
        if (this.isVirtual(accessNode1)) {
            if (this.isVirtual(accessNode2)) {
                return new PlanNode[]{null, null};
            }
            return new PlanNode[]{accessNode2};
        }
        if (this.isVirtual(accessNode2)) {
            return new PlanNode[]{accessNode1};
        }
        return new PlanNode[]{accessNode1, accessNode2};
    }

    void decideForAgainstDependentJoin(long depJoinCost, PlanNode independentNode, PlanNode dependentNode, PlanNode joinNode, QueryMetadataInterface metadata, CommandContext context, RuleStack rules) throws QueryMetadataException, MetaMatrixComponentException {
        JoinStrategyType joinStrategy = (JoinStrategyType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_STRATEGY);
        joinNode.setProperty((Object)NodeConstants.Info.EST_DEP_JOIN_COST, (Object)new Long(depJoinCost));
        if (joinStrategy.equals((Object)JoinStrategyType.MERGE)) {
            long mergeJoinCost = NewCalculateCostUtil.computeCostForMergeJoin(independentNode, dependentNode, metadata, context);
            joinNode.setProperty((Object)NodeConstants.Info.EST_JOIN_COST, (Object)new Long(mergeJoinCost));
            if (depJoinCost < mergeJoinCost) {
                this.markDependent(dependentNode, metadata, rules);
            }
        } else if (joinStrategy.equals((Object)JoinStrategyType.NESTED_LOOP)) {
            long nestedLoopJoinCost = NewCalculateCostUtil.computeCostForNestedLoopJoin(independentNode, dependentNode, metadata, context);
            joinNode.setProperty((Object)NodeConstants.Info.EST_JOIN_COST, (Object)new Long(nestedLoopJoinCost));
            if (depJoinCost < nestedLoopJoinCost) {
                this.markDependent(dependentNode, metadata, rules);
            }
        }
    }

    void findCandidateAccess(PlanNode root, Collection matches, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws QueryMetadataException, QueryPlannerException, MetaMatrixComponentException {
        if (this.isCandidate(root, metadata, capFinder, context)) {
            matches.add(root);
        }
        if (root.getChildCount() > 0 && root.getType() != 3) {
            List children = root.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PlanNode child = (PlanNode)iter.next();
                this.findCandidateAccess(child, matches, metadata, capFinder, context);
            }
        }
    }

    boolean isCandidate(PlanNode node, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws QueryMetadataException, MetaMatrixComponentException {
        Boolean hint = (Boolean)node.getProperty((Object)NodeConstants.Info.MAKE_NOT_DEP);
        if (hint != null && hint.equals(Boolean.TRUE)) {
            return false;
        }
        PlanNode parent = node.getParent();
        if (parent == null || parent.getType() != 7) {
            return false;
        }
        GroupSymbol group = (GroupSymbol)node.getGroups().iterator().next();
        Object modelID = metadata.getModelID(group.getMetadataID());
        if (!CapabilitiesUtil.supportsInCriteria(modelID, metadata, capFinder)) {
            return false;
        }
        if (!this.isValidJoin(parent, node)) {
            return false;
        }
        ProcessorPlan nonRelationalPlan = this.getNestedPlan(node);
        if (nonRelationalPlan == null && this.isNotQuery(node)) {
            return false;
        }
        return !this.isVirtual(node) || context == null || context.isVirtualDependentJoinAllowed();
    }

    ProcessorPlan getNestedPlan(PlanNode accessNode) {
        ProcessorPlan plan = null;
        PlanNode sourceNode = accessNode.getFirstChild();
        if (sourceNode.getType() == 19) {
            plan = (ProcessorPlan)sourceNode.getProperty((Object)NodeConstants.Info.PROCESSOR_PLAN);
        }
        return plan;
    }

    boolean isNotQuery(PlanNode node) {
        Command command;
        PlanNode sourceNode = node.getFirstChild();
        return sourceNode.getType() == 19 && (command = (Command)sourceNode.getProperty((Object)NodeConstants.Info.VIRTUAL_COMMAND)) != null && !(command instanceof QueryCommand);
    }

    boolean isValidJoin(PlanNode joinNode, PlanNode accessNode) {
        JoinType jtype = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
        if (jtype.equals((Object)JoinType.JOIN_CROSS) || jtype.equals((Object)JoinType.JOIN_FULL_OUTER)) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as parent join is CROSS or FULL OUTER: ", accessNode.nodeToString()});
            return false;
        }
        List jcrit = (List)joinNode.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
        if (jcrit == null || jcrit.size() == 0) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as parent join has no join criteria: ", accessNode.nodeToString()});
            return false;
        }
        boolean foundEquality = false;
        Iterator critIter = jcrit.iterator();
        while (critIter.hasNext()) {
            Collection leftGroups;
            Collection rightGroups;
            CompareCriteria compCrit;
            Criteria theCrit = (Criteria)critIter.next();
            if (!(theCrit instanceof CompareCriteria) || (compCrit = (CompareCriteria)theCrit).getOperator() != 1 || (rightGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)compCrit.getRightExpression())).size() <= 0 || (leftGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)compCrit.getLeftExpression())).size() <= 0) continue;
            foundEquality = true;
            break;
        }
        if (!foundEquality) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as parent join has no equality expressions: ", accessNode.nodeToString()});
            return false;
        }
        if (jtype.equals((Object)JoinType.JOIN_RIGHT_OUTER)) {
            if (joinNode.getLastChild() == accessNode) {
                LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as it is on outer side of a join: ", accessNode.nodeToString()});
                return false;
            }
        } else if (jtype.equals((Object)JoinType.JOIN_LEFT_OUTER) && joinNode.getFirstChild() == accessNode) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as it is on outer side of a join: ", accessNode.nodeToString()});
            return false;
        }
        return true;
    }

    PlanNode chooseDepNodeByHintsAcessPattern(PlanNode accessNode1, PlanNode accessNode2, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (accessNode1.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) {
            if (accessNode2.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) {
                if (!accessNode1.hasProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED)) {
                    if (!accessNode2.hasProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED)) {
                        LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Neither access node can be made dependent because both have unsatisfied access patterns: ", accessNode1.nodeToString(), "\n", accessNode2.toString()});
                        return null;
                    }
                    LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Making access node dependent to satisfy access pattern: ", accessNode1.nodeToString()});
                    return accessNode1;
                }
                if (!accessNode2.hasProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED)) {
                    LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Making access node dependent to satisfy access pattern: ", accessNode2.nodeToString()});
                    return accessNode2;
                }
            } else if (!accessNode1.hasProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED)) {
                LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Making access node dependent to satisfy access pattern: ", accessNode1.nodeToString()});
                return accessNode1;
            }
        } else if (accessNode2.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS) && !accessNode2.hasProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED)) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Making access node dependent to satisfy access pattern: ", accessNode2.nodeToString()});
            return accessNode2;
        }
        if (this.hasHint(accessNode1)) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Making access node dependent due to hint: ", accessNode1.nodeToString()});
            return accessNode1;
        }
        if (this.hasHint(accessNode2)) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Making access node dependent due to hint: ", accessNode2.nodeToString()});
            return accessNode2;
        }
        return null;
    }

    private boolean isVirtual(PlanNode node) {
        return node.getType() != 3;
    }

    PlanNode chooseSibling(PlanNode accessNode1, PlanNode accessNode2, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        LinkedList atomicCriteria1 = new LinkedList();
        this.collectCriteriaUnderAccessNode(accessNode1, atomicCriteria1);
        accessNode1.setProperty(ATOMIC_CRITERIA_COLLECTION_KEY, atomicCriteria1);
        LinkedList atomicCriteria2 = new LinkedList();
        this.collectCriteriaUnderAccessNode(accessNode2, atomicCriteria2);
        accessNode2.setProperty(ATOMIC_CRITERIA_COLLECTION_KEY, atomicCriteria2);
        boolean node1Strong = CalculateCostUtil.isAccessNodeStrong(accessNode1, metadata);
        boolean node2Strong = CalculateCostUtil.isAccessNodeStrong(accessNode2, metadata);
        PlanNode joinNode = accessNode1.getParent();
        if (node1Strong) {
            accessNode1.setProperty((Object)NodeConstants.Info.IS_STRONG, (Object)node1Strong);
            return accessNode2;
        }
        if (node2Strong) {
            accessNode2.setProperty((Object)NodeConstants.Info.IS_STRONG, (Object)node2Strong);
            return accessNode1;
        }
        if (joinNode.getProperty((Object)NodeConstants.Info.JOIN_STRATEGY).equals(JoinStrategyType.MERGE)) {
            return null;
        }
        Integer cost1 = (Integer)accessNode1.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        Integer cost2 = (Integer)accessNode2.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        if (cost1 != null && cost2 != null) {
            if (cost1 > cost2) {
                return accessNode1;
            }
            if (cost1 < cost2) {
                return accessNode2;
            }
        }
        if (!this.canMakeDependent(accessNode1, metadata)) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as access pattern forbids dependent join: ", accessNode1.nodeToString()});
            if (!this.canMakeDependent(accessNode2, metadata)) {
                LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as access pattern forbids dependent join: ", accessNode2.nodeToString()});
                return null;
            }
            return accessNode2;
        }
        if (!this.canMakeDependent(accessNode2, metadata)) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as access pattern forbids dependent join: ", accessNode2.nodeToString()});
            return accessNode1;
        }
        return this.chooseWeakNode(accessNode1, accessNode2, metadata);
    }

    PlanNode chooseWeakNode(PlanNode accessNode1, PlanNode accessNode2, QueryMetadataInterface metadata) {
        int count1 = this.getPredicateCount(accessNode1);
        int count2 = this.getPredicateCount(accessNode2);
        if (count2 < count1) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting weaker dependent access node sibling based on criteria: ", accessNode1.nodeToString()});
            return accessNode2;
        }
        LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting weaker dependent access node sibling based on criteria: ", accessNode2.nodeToString()});
        return accessNode1;
    }

    int getPredicateCount(PlanNode accessNode) {
        int count = 0;
        Collection crits = (Collection)accessNode.getProperty(ATOMIC_CRITERIA_COLLECTION_KEY);
        Iterator i = crits.iterator();
        while (i.hasNext()) {
            Criteria crit = (Criteria)i.next();
            count += PredicateCollectorVisitor.getPredicates((LanguageObject)crit).size();
        }
        return count;
    }

    void collectCriteriaUnderAccessNode(PlanNode node, Collection criteriaCollection) {
        switch (node.getType()) {
            case 13: {
                criteriaCollection.add(node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA));
                break;
            }
            case 7: {
                List crits = (List)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
                if (crits == null) break;
                Iterator iter = crits.iterator();
                while (iter.hasNext()) {
                    criteriaCollection.add(iter.next());
                }
                break;
            }
        }
        if (node.getChildren().size() > 0) {
            Iterator childIter = node.getChildren().iterator();
            while (childIter.hasNext()) {
                this.collectCriteriaUnderAccessNode((PlanNode)childIter.next(), criteriaCollection);
            }
        }
    }

    boolean hasHint(PlanNode accessNode) {
        Boolean hint = (Boolean)accessNode.getProperty((Object)NodeConstants.Info.MAKE_DEP);
        return hint != null && hint.equals(Boolean.TRUE);
    }

    boolean canMakeDependent(PlanNode accessNode, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        PlanNode joinNode = accessNode.getParent();
        ArrayList independentExpressions = new ArrayList();
        ArrayList dependentExpressions = new ArrayList();
        Collection accessPattern = this.getDependencyData(accessNode, joinNode, metadata, independentExpressions, dependentExpressions);
        boolean canMakeDependent = this.canMakeNodeDependent(accessNode, accessPattern, independentExpressions, dependentExpressions);
        return canMakeDependent;
    }

    void markDependent(PlanNode accessNode, QueryMetadataInterface metadata, RuleStack ruleStack) throws QueryMetadataException, MetaMatrixComponentException {
        PlanNode joinNode = accessNode.getParent();
        ArrayList independentExpressions = new ArrayList();
        ArrayList dependentExpressions = new ArrayList();
        Collection accessPattern = this.getDependencyData(accessNode, joinNode, metadata, independentExpressions, dependentExpressions);
        DependentJoinData joinData = new DependentJoinData(independentExpressions, dependentExpressions, accessPattern);
        if (accessNode.getType() == 3) {
            if (this.canMakeNodeDependent(accessNode, accessPattern, independentExpressions, dependentExpressions)) {
                accessNode.setProperty((Object)NodeConstants.Info.DEPENDENT_JOIN_DATA, (Object)joinData);
            }
        } else {
            PlanNode selectNode = NodeFactory.getNewNode((int)13);
            selectNode.setProperty((Object)NodeConstants.Info.IS_HAVING, (Object)Boolean.FALSE);
            selectNode.setProperty((Object)NodeConstants.Info.IS_PHANTOM, (Object)Boolean.FALSE);
            DependentValueSource valueIterSrc = new DependentValueSource();
            PlanNode sibling = NodeEditor.getSibling(accessNode);
            sibling.setProperty((Object)NodeConstants.Info.DEPENDENT_VALUE_SOURCE, (Object)valueIterSrc);
            Criteria crit = this.makeDependentCrit((ValueIteratorSource)valueIterSrc, independentExpressions, dependentExpressions);
            selectNode.setProperty((Object)NodeConstants.Info.SELECT_CRITERIA, (Object)crit);
            selectNode.setProperty((Object)NodeConstants.Info.DEPENDENT_SET_CRITS, (Object)Boolean.TRUE);
            selectNode.addGroups((Collection)accessNode.getGroups());
            NodeEditor.insertNode(joinNode, accessNode, selectNode);
            ruleStack.push(RuleConstants.CLEAN_CRITERIA);
            ruleStack.push(RuleConstants.PUSH_SELECT_CRITERIA);
            LinkedList children = (LinkedList)joinNode.getChildren();
            if (children.indexOf(selectNode) == 0) {
                joinNode.removeChild(selectNode);
                joinNode.addLastChild(selectNode);
                if (joinNode.getProperty((Object)NodeConstants.Info.JOIN_STRATEGY).equals(JoinStrategyType.MERGE)) {
                    List leftExpressions = (List)joinNode.getProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS);
                    List rightExpressions = (List)joinNode.getProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS);
                    joinNode.setProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS, (Object)rightExpressions);
                    joinNode.setProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS, (Object)leftExpressions);
                    Boolean sortInLeftAccess = (Boolean)joinNode.getProperty((Object)NodeConstants.Info.SORT_IN_LEFT_ACCESS);
                    Boolean sortInRightAccess = (Boolean)joinNode.getProperty((Object)NodeConstants.Info.SORT_IN_RIGHT_ACCESS);
                    joinNode.setProperty((Object)NodeConstants.Info.SORT_IN_LEFT_ACCESS, (Object)sortInRightAccess);
                    joinNode.setProperty((Object)NodeConstants.Info.SORT_IN_RIGHT_ACCESS, (Object)sortInLeftAccess);
                }
            }
        }
    }

    private Criteria makeDependentCrit(ValueIteratorSource iterSrc, List independentExpressions, List dependentExpressions) {
        Criteria depCrit = null;
        Iterator depIter = dependentExpressions.iterator();
        Iterator indepIter = independentExpressions.iterator();
        while (depIter.hasNext()) {
            Expression depExpr = (Expression)depIter.next();
            Expression indepExpr = (Expression)indepIter.next();
            DependentSetCriteria crit = new DependentSetCriteria(depExpr);
            crit.setValueExpression(indepExpr);
            crit.setValueIteratorSource(iterSrc);
            depCrit = CompoundCriteria.combineCriteria((Criteria)crit, depCrit);
        }
        return depCrit;
    }

    private boolean canMakeNodeDependent(PlanNode accessNode, Collection accessPattern, List independentExpressions, List dependentExpressions) {
        boolean canMakeDependent = false;
        if (independentExpressions.size() > 0) {
            boolean isAccessPatternCovered = accessNode.hasProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED);
            if (!isAccessPatternCovered) {
                isAccessPatternCovered = this.isAccessPatternCovered(accessPattern, dependentExpressions);
            }
            if (!isAccessPatternCovered) {
                LinkedList crits = (LinkedList)accessNode.getProperty(ATOMIC_CRITERIA_COLLECTION_KEY);
                if (crits == null) {
                    crits = new LinkedList();
                    this.collectCriteriaUnderAccessNode(accessNode, crits);
                }
                if (crits != null) {
                    HashSet elements = new HashSet();
                    Iterator i = crits.iterator();
                    while (i.hasNext()) {
                        Criteria crit = (Criteria)i.next();
                        if (crit == null) continue;
                        boolean REMOVE_DUPLICATES = true;
                        elements.addAll(ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true));
                    }
                    isAccessPatternCovered = this.isAccessPatternCovered(accessPattern, dependentExpressions, elements);
                }
            }
            if (isAccessPatternCovered) {
                canMakeDependent = true;
            }
        }
        return canMakeDependent;
    }

    private Collection getDependencyData(PlanNode accessNode, PlanNode joinNode, QueryMetadataInterface metadata, List independentExpressions, List dependentExpressions) throws QueryMetadataException, MetaMatrixComponentException {
        List crits = (List)joinNode.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
        Iterator critIter = crits.iterator();
        Collection accessPatterns = null;
        Collection chosenAccessPattern = null;
        if (accessNode.hasProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED)) {
            chosenAccessPattern = (Collection)accessNode.getProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED);
        } else if (accessNode.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) {
            accessPatterns = (Collection)accessNode.getProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
        }
        while (critIter.hasNext()) {
            Collection indepElements;
            CompareCriteria compCrit;
            Criteria predCrit = (Criteria)critIter.next();
            if (!(predCrit instanceof CompareCriteria) || (compCrit = (CompareCriteria)predCrit).getOperator() != 1) continue;
            Expression leftExpression = compCrit.getLeftExpression();
            Expression rightExpression = compCrit.getRightExpression();
            Expression independentExpression = null;
            Expression dependentExpression = null;
            Collection elements = ElementCollectorVisitor.getElements((LanguageObject)leftExpression, (boolean)false);
            if (this.forGroups(elements, accessNode.getGroups())) {
                independentExpression = rightExpression;
                dependentExpression = leftExpression;
            } else {
                independentExpression = leftExpression;
                dependentExpression = rightExpression;
            }
            if (RuleChooseDependent.containsFunctionsThatCannotBePushed(dependentExpression) || RuleChooseDependent.getModelIDFromExpression(dependentExpression, metadata) == null || (indepElements = ElementCollectorVisitor.getElements((LanguageObject)independentExpression, (boolean)false)).size() < 1) continue;
            Collection depElements = ElementCollectorVisitor.getElements((LanguageObject)dependentExpression, (boolean)false);
            if (chosenAccessPattern != null) {
                if (!this.accessPatternContainsAll(chosenAccessPattern, depElements)) {
                    continue;
                }
            } else if (accessPatterns != null) {
                Iterator patterns = accessPatterns.iterator();
                while (patterns.hasNext()) {
                    Collection anAccessPattern = (Collection)patterns.next();
                    if (!this.accessPatternContainsAll(anAccessPattern, depElements)) continue;
                    chosenAccessPattern = anAccessPattern;
                    break;
                }
            }
            dependentExpressions.add(dependentExpression);
            independentExpressions.add(independentExpression);
        }
        return chosenAccessPattern;
    }

    private static boolean containsFunctionsThatCannotBePushed(Expression expression) {
        Iterator functions = FunctionCollectorVisitor.getFunctions((LanguageObject)expression, (boolean)true).iterator();
        while (functions.hasNext()) {
            Function function = (Function)functions.next();
            if (function.getFunctionDescriptor().getPushdown() != 1) continue;
            return true;
        }
        return false;
    }

    private static Object getModelIDFromExpression(Expression expression, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = null;
        Iterator elementIter = ElementCollectorVisitor.getElements((LanguageObject)expression, (boolean)true).iterator();
        while (elementIter.hasNext()) {
            ElementSymbol elementSymbol = (ElementSymbol)elementIter.next();
            Object tempModelID = metadata.getModelID(elementSymbol.getMetadataID());
            if (modelID != null) {
                if (modelID.equals(tempModelID)) continue;
                return null;
            }
            modelID = tempModelID;
        }
        return modelID;
    }

    private boolean accessPatternContainsAll(Collection accessPattern, Collection depElements) {
        boolean containsAll = true;
        Iterator i = depElements.iterator();
        while (i.hasNext()) {
            ElementSymbol e = (ElementSymbol)i.next();
            if (accessPattern.contains(e.getMetadataID())) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    private boolean isAccessPatternCovered(Collection accessPattern, List dependentExpressions) {
        return this.isAccessPatternCovered(accessPattern, dependentExpressions, Collections.EMPTY_SET);
    }

    private boolean isAccessPatternCovered(Collection accessPattern, List dependentExpressions, Collection additionalElements) {
        ElementSymbol element;
        Iterator elementIter;
        Expression expr;
        if (accessPattern == null) {
            return true;
        }
        HashSet<Object> dependentIDs = new HashSet<Object>(dependentExpressions.size());
        Iterator i = dependentExpressions.iterator();
        while (i.hasNext()) {
            expr = (Expression)i.next();
            elementIter = ElementCollectorVisitor.getElements((LanguageObject)expr, (boolean)true).iterator();
            while (elementIter.hasNext()) {
                element = (ElementSymbol)elementIter.next();
                dependentIDs.add(element.getMetadataID());
            }
        }
        i = additionalElements.iterator();
        while (i.hasNext()) {
            expr = (Expression)i.next();
            elementIter = ElementCollectorVisitor.getElements((LanguageObject)expr, (boolean)true).iterator();
            while (elementIter.hasNext()) {
                element = (ElementSymbol)elementIter.next();
                dependentIDs.add(element.getMetadataID());
            }
        }
        return dependentIDs.containsAll(accessPattern);
    }

    boolean forGroups(Collection elements, Set groups) {
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            ElementSymbol element = (ElementSymbol)elementIter.next();
            GroupSymbol elementGroup = element.getGroupSymbol();
            if (groups.contains(elementGroup)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "ChooseDependent";
    }

    boolean containsStrongAccessNode(PlanNode node, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        Iterator childIterator;
        if (node.getType() == 3) {
            if (node.getProperty((Object)NodeConstants.Info.IS_STRONG) != null) {
                return true;
            }
            return CalculateCostUtil.isAccessNodeStrong(node, metadata);
        }
        List children = node.getChildren();
        if (children != null && (childIterator = children.iterator()).hasNext()) {
            return this.containsStrongAccessNode((PlanNode)childIterator.next(), metadata);
        }
        return false;
    }
}

