/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.PredicateCriteria;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class NewCalculateCostUtil {
    private static final int UNKNOWN_VALUE = -1;
    private static final int DEFAULT_PROCESSOR_BATCH_SIZE = 2000;
    private static final int DEFAULT_CONNECTOR_BATCH_SIZE = 2000;
    private static long compareTime;
    private static long readLeftTime;
    private static long readRightTime;
    private static long dupCompareTime;
    private static long procNewRequestLeftTime;
    private static long procMoreRequestLeftTime;
    private static long procNewRequestRightTime;
    private static long procMoreRequestRightTime;
    private static long depLoadDataTime;
    private static long depSetupTupleTime;
    private static long depCompareTime;
    private static long depReadLeftTime;
    private static long depReadRightTime;
    private static long depDupCompareTime;
    private static long depProcNewRequestLeftTime;
    private static long depProcMoreRequestLeftTime;
    private static long depProcNewRequestRightTime;
    private static long depProcMoreRequestRightTime;
    private static boolean COST_VARIABLES_LOADED;
    private static Properties costVariables;
    private static final String COMPARE_TIME = "compareTime";
    private static final String READ_LEFT_TIME = "readLeftTime";
    private static final String READ_RIGHT_TIME = "readRightTime";
    private static final String DUP_COMPARE_TIME = "dupCompareTime";
    private static final String PROC_NEW_REQUEST_LEFT_TIME = "procNewRequestLeftTime";
    private static final String PROC_MORE_REQUEST_LEFT_TIME = "procMoreRequestLeftTime";
    private static final String PROC_NEW_REQUEST_RIGHT_TIME = "procNewRequestRightTime";
    private static final String PROC_MORE_REQUEST_RIGHT_TIME = "procMoreRequestRightTime";
    private static final String DEP_LOAD_DATA_TIME = "depLoadDataTime";
    private static final String DEP_SETUP_TUPLE_TIME = "depSetupTupleTime";
    private static final String DEP_COMPARE_TIME = "depCompareTime";
    private static final String DEP_READ_LEFT_TIME = "depReadLeftTime";
    private static final String DEP_READ_RIGHT_TIME = "depReadRightTime";
    private static final String DEP_DUP_COMPARE_TIME = "depDupCompareTime";
    private static final String DEP_PROC_NEW_REQUEST_LEFT_TIME = "depProcNewRequestLeftTime";
    private static final String DEP_PROC_MORE_REQUEST_LEFT_TIME = "depProcMoreRequestLeftTime";
    private static final String DEP_PROC_NEW_REQUEST_RIGHT_TIME = "depProcNewRequestRightTime";
    private static final String DEP_PROC_MORE_REQUEST_RIGHT_TIME = "depProcMoreRequestRightTime";
    static /* synthetic */ Class class$com$metamatrix$query$optimizer$relational$rules$NewCalculateCostUtil;

    static int computeCostForTree(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        NewCalculateCostUtil.recursiveComputeCost(node, metadata);
        Integer cost = (Integer)node.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        if (cost != null) {
            return cost;
        }
        return -1;
    }

    private static void recursiveComputeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        if (node.getProperty((Object)NodeConstants.Info.EST_CARDINALITY) != null) {
            return;
        }
        Iterator children = node.getChildren().iterator();
        while (children.hasNext()) {
            PlanNode child = (PlanNode)children.next();
            NewCalculateCostUtil.recursiveComputeCost(child, metadata);
        }
        NewCalculateCostUtil.computeNodeCost(node, metadata);
    }

    private static void computeNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        PlanNode child = null;
        Integer childCost = null;
        switch (node.getType()) {
            case 6: {
                NewCalculateCostUtil.estimateSourceNodeCost(node, metadata);
                break;
            }
            case 4: {
                NewCalculateCostUtil.estimateSelectNodeCost(node, metadata);
                break;
            }
            case 2: {
                NewCalculateCostUtil.estimateJoinNodeCost(node, metadata);
                break;
            }
            case 0: {
                child = (PlanNode)node.getChildren().iterator().next();
                childCost = (Integer)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
                if (childCost == null) break;
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)childCost);
                break;
            }
            case 1: {
                NewCalculateCostUtil.estimateDupRemoveNodeCost(node, metadata);
                break;
            }
            case 7: {
                NewCalculateCostUtil.estimateGroupNodeCost(node, metadata);
                break;
            }
            case -1: {
                child = (PlanNode)node.getChildren().iterator().next();
                childCost = (Integer)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
                if (childCost == null) break;
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)childCost);
                break;
            }
            case 9: {
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(0));
                break;
            }
            case 3: {
                if (node.getChildCount() != 0) {
                    child = (PlanNode)node.getChildren().iterator().next();
                    childCost = (Integer)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
                } else {
                    childCost = new Integer(0);
                }
                if (childCost == null) break;
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)childCost);
                break;
            }
            case 8: {
                Iterator childIterator = node.getChildren().iterator();
                int childCost1 = (Integer)((PlanNode)childIterator.next()).getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
                int childCost2 = (Integer)((PlanNode)childIterator.next()).getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
                boolean isUnionAll = (Boolean)node.getProperty((Object)NodeConstants.Info.USE_ALL);
                int cost = isUnionAll ? childCost1 + childCost2 : (childCost1 + childCost2) / 2;
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(cost));
                break;
            }
            case 5: {
                child = (PlanNode)node.getChildren().iterator().next();
                childCost = (Integer)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
                if (childCost == null) break;
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)childCost);
                break;
            }
            case 11: {
                child = node.getFirstChild();
                childCost = (Integer)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
                Expression limit = (Expression)node.getProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT);
                if (limit instanceof Constant) {
                    Integer rowLimit = (Integer)((Constant)limit).getValue();
                    int limitCost = rowLimit;
                    if (childCost != null && childCost < limitCost) {
                        limitCost = childCost;
                    }
                    node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(limitCost));
                    break;
                }
                if (childCost == null) break;
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)childCost);
                break;
            }
            case 10: {
                child = node.getFirstChild();
                childCost = (Integer)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
                if (childCost == null) break;
                Expression offset = (Expression)node.getProperty((Object)NodeConstants.Info.OFFSET_TUPLE_COUNT);
                if (offset instanceof Constant) {
                    Integer rowOffset = (Integer)((Constant)offset).getValue();
                    int offsetCost = childCost - rowOffset;
                    Integer newCost = new Integer(offsetCost < 0 ? 0 : offsetCost);
                    node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)newCost);
                    break;
                }
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)childCost);
            }
        }
    }

    private static void estimateJoinNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Iterator children = node.getChildren().iterator();
        PlanNode child1 = (PlanNode)children.next();
        Integer childCost1 = (Integer)child1.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        PlanNode child2 = (PlanNode)children.next();
        Integer childCost2 = (Integer)child2.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        if (childCost1 != null && childCost2 != null) {
            JoinType joinType = (JoinType)node.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
            List joinCriteria = (List)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
            ArrayList<Integer> childCostList = new ArrayList<Integer>();
            childCostList.add(childCost1);
            childCostList.add(childCost2);
            int baseCost = NewCalculateCostUtil.computeChildCostBase(childCostList);
            if (baseCost == -1) {
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(baseCost));
                return;
            }
            Iterator joinCritIterator = joinCriteria.iterator();
            while (joinCritIterator.hasNext()) {
                Criteria criteria = (Criteria)joinCritIterator.next();
                baseCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(baseCost, criteria, metadata);
                childCostList.clear();
                childCostList.add(new Integer(baseCost));
            }
            Integer cost = null;
            if (JoinType.JOIN_CROSS.equals((Object)joinType)) {
                cost = new Integer(baseCost);
            } else if (JoinType.JOIN_FULL_OUTER.equals((Object)joinType)) {
                cost = new Integer(Math.max(childCost1 + childCost2, baseCost));
            } else if (JoinType.JOIN_LEFT_OUTER.equals((Object)joinType)) {
                cost = new Integer(Math.max(childCost1, baseCost));
            } else if (JoinType.JOIN_RIGHT_OUTER.equals((Object)joinType)) {
                cost = new Integer(Math.max(childCost2, baseCost));
            } else if (JoinType.JOIN_INNER.equals((Object)joinType)) {
                cost = new Integer(baseCost);
            }
            node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)cost);
        }
    }

    private static void estimateSelectNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        PlanNode child = (PlanNode)node.getChildren().iterator().next();
        Integer childCostInteger = (Integer)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        int childCost = -1;
        if (childCostInteger != null) {
            if (childCostInteger == -1) {
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)childCostInteger);
                return;
            }
            childCost = childCostInteger;
        }
        Criteria selectCriteria = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        int newCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, selectCriteria, metadata);
        node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(newCost));
    }

    private static void estimateSourceNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        int cost;
        if (node.getChildCount() > 0) {
            PlanNode child = node.getFirstChild();
            cost = (Integer)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        } else {
            GroupSymbol group = (GroupSymbol)node.getGroups().iterator().next();
            int cardinality = metadata.getCardinality(group.getMetadataID());
            if (cardinality <= 0) {
                cardinality = -1;
            }
            cost = cardinality;
        }
        node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(cost));
    }

    private static void estimateDupRemoveNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        PlanNode child = (PlanNode)node.getChildren().iterator().next();
        int childCost = (Integer)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        if (childCost == -1) {
            node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(childCost));
            return;
        }
        List elements = (ArrayList)node.getProperty((Object)NodeConstants.Info.TOP_COLS);
        if (elements == null) {
            elements = NewCalculateCostUtil.getElementSybmolsFromGroups(node.getGroups());
        } else {
            HashSet elems = new HashSet();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                Expression expression = (Expression)iter.next();
                ElementCollectorVisitor.getElements((LanguageObject)expression, elems);
            }
            elements = new ArrayList(elems);
        }
        List ndvList = NewCalculateCostUtil.getNDV(elements, childCost, metadata);
        int ndvCost = 1;
        if (ndvList.size() > 0) {
            Iterator ndvIterator = ndvList.iterator();
            while (ndvIterator.hasNext()) {
                ndvCost = Math.max(ndvCost, (Integer)ndvIterator.next());
            }
        } else {
            ndvCost = -1;
        }
        node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(Math.min(childCost, ndvCost)));
    }

    private static void estimateGroupNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        PlanNode child = (PlanNode)node.getChildren().iterator().next();
        int childCost = (Integer)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        if (childCost == -1) {
            node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(childCost));
            return;
        }
        List elements = (ArrayList)node.getProperty((Object)NodeConstants.Info.GROUP_COLS);
        if (elements == null) {
            elements = NewCalculateCostUtil.getElementSybmolsFromGroups(node.getGroups());
        } else {
            HashSet elems = new HashSet();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                Expression expression = (Expression)iter.next();
                ElementCollectorVisitor.getElements((LanguageObject)expression, elems);
            }
            elements = new ArrayList(elems);
        }
        List ndvList = NewCalculateCostUtil.getNDV(elements, childCost, metadata);
        int ndvCost = 1;
        if (ndvList.size() > 0) {
            Iterator ndvIterator = ndvList.iterator();
            while (ndvIterator.hasNext()) {
                ndvCost = Math.max(ndvCost, (Integer)ndvIterator.next());
            }
        } else {
            ndvCost = -1;
        }
        node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(Math.min(childCost, ndvCost)));
    }

    private static int recursiveEstimateCostOfCriteria(int childCost, Criteria crit, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        int cost;
        if (crit instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)crit;
            Iterator iter = compCrit.getCriteria().iterator();
            if (compCrit.getOperator() == 0) {
                cost = childCost;
                while (iter.hasNext()) {
                    cost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(cost, (Criteria)iter.next(), metadata);
                }
            } else {
                cost = 0;
                while (iter.hasNext()) {
                    cost += NewCalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, (Criteria)iter.next(), metadata);
                }
                cost = Math.min(childCost, cost);
            }
        } else {
            int nextCost;
            cost = crit instanceof NotCriteria ? (childCost != -1 ? ((nextCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, ((NotCriteria)crit).getCriteria(), metadata)) == -1 ? -1 : Math.max(childCost - nextCost, 1)) : -1) : NewCalculateCostUtil.estimatePredicateCost(childCost, (PredicateCriteria)crit, metadata);
        }
        return cost;
    }

    private static int estimatePredicateCost(int childCost, PredicateCriteria predicateCriteria, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        SetCriteria setCriteria;
        double childCostBase;
        if (childCost == -1) {
            return -1;
        }
        HashSet elements = new HashSet();
        ElementCollectorVisitor.getElements((LanguageObject)predicateCriteria, elements);
        List ndvList = NewCalculateCostUtil.getNDV(elements, childCost, metadata);
        boolean ndvKnown = NewCalculateCostUtil.isNDVKnown(ndvList);
        double ndv = -1.0;
        if (ndvKnown) {
            Iterator ndvIterator = ndvList.iterator();
            while (ndvIterator.hasNext()) {
                double tmpNDV = ((Integer)ndvIterator.next()).intValue();
                ndv = Math.max(ndv, tmpNDV);
            }
        } else {
            return -1;
        }
        double cost = childCostBase = (double)childCost;
        boolean isNegatedPredicateCriteria = false;
        if (predicateCriteria instanceof CompareCriteria) {
            CompareCriteria compCrit = (CompareCriteria)predicateCriteria;
            if (compCrit.getOperator() == 1) {
                cost = ndvKnown ? childCostBase / ndv : -1.0;
            } else if (compCrit.getOperator() == 2) {
                cost = ndvKnown ? childCostBase * (ndv - 1.0) / ndv : -1.0;
            } else {
                Iterator elementIterator = elements.iterator();
                ElementSymbol element = (ElementSymbol)elementIterator.next();
                GroupSymbol group = element.getGroupSymbol();
                int cardinality = metadata.getCardinality(group.getMetadataID());
                String dataType = metadata.getElementType(element.getMetadataID());
                if (cardinality <= 0) {
                    cost = -1.0;
                } else if (!NewCalculateCostUtil.isRangeMeasurable(dataType)) {
                    cost = childCostBase / 3.0;
                } else {
                    double maxValue = 0.0;
                    double minValue = 0.0;
                    double range = 0.0;
                    Constant value = (Constant)compCrit.getRightExpression();
                    double compareValue = 0.0;
                    String max = (String)metadata.getMaximumValue(element.getMetadataID());
                    String min = (String)metadata.getMinimumValue(element.getMetadataID());
                    if (max == null || min == null) {
                        cost = -1.0;
                    } else {
                        try {
                            if (dataType.equalsIgnoreCase("timestamp")) {
                                compareValue = ((Timestamp)value.getValue()).getTime();
                                SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                                maxValue = timestampFormat.parse(max).getTime();
                                minValue = timestampFormat.parse(min).getTime();
                            } else {
                                maxValue = Double.parseDouble(max);
                                minValue = Double.parseDouble(min);
                            }
                            range = maxValue - minValue;
                            if (dataType.equalsIgnoreCase("bigdecimal")) {
                                compareValue = ((BigDecimal)value.getValue()).doubleValue();
                            } else if (dataType.equalsIgnoreCase("biginteger")) {
                                compareValue = ((BigInteger)value.getValue()).doubleValue();
                            } else if (dataType.equalsIgnoreCase("byte")) {
                                compareValue = ((Byte)value.getValue()).doubleValue();
                            } else if (dataType.equalsIgnoreCase("short")) {
                                compareValue = ((Short)value.getValue()).doubleValue();
                            } else if (dataType.equalsIgnoreCase("integer")) {
                                compareValue = ((Integer)value.getValue()).doubleValue();
                            } else if (dataType.equalsIgnoreCase("long")) {
                                compareValue = ((Long)value.getValue()).doubleValue();
                            } else if (dataType.equalsIgnoreCase("float")) {
                                compareValue = ((Float)value.getValue()).doubleValue();
                            } else if (dataType.equalsIgnoreCase("double")) {
                                compareValue = (Double)value.getValue();
                            }
                            if (compCrit.getOperator() == 4 || compCrit.getOperator() == 6) {
                                cost = (maxValue - compareValue) / range * childCostBase;
                            }
                            if (compCrit.getOperator() == 3 || compCrit.getOperator() == 5) {
                                cost = (compareValue - minValue) / range * childCostBase;
                            }
                        }
                        catch (ParseException e) {
                            cost = childCostBase / 3.0;
                        }
                    }
                }
            }
        } else if (predicateCriteria instanceof MatchCriteria) {
            MatchCriteria matchCriteria = (MatchCriteria)predicateCriteria;
            Expression matchExpression = matchCriteria.getRightExpression();
            String compareValue = null;
            if (matchExpression instanceof Constant && ((Constant)matchExpression).getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
                compareValue = (String)((Constant)matchExpression).getValue();
            }
            cost = childCostBase / 3.0;
            if (compareValue != null) {
                if (compareValue.indexOf(37) >= 0) {
                    if (compareValue.length() == 1) {
                        cost = childCostBase;
                    }
                } else if (ndvKnown) {
                    cost = childCostBase / ndv;
                }
            }
            isNegatedPredicateCriteria = matchCriteria.isNegated();
        } else if (predicateCriteria instanceof SetCriteria) {
            setCriteria = (SetCriteria)predicateCriteria;
            cost = ndvKnown ? Math.min(childCostBase, childCostBase * (double)setCriteria.getNumberOfValues() / ndv) : childCostBase / 3.0;
        } else if (predicateCriteria instanceof SubquerySetCriteria) {
            setCriteria = (SubquerySetCriteria)predicateCriteria;
            cost = childCostBase / 3.0;
            isNegatedPredicateCriteria = setCriteria.isNegated();
        } else if (predicateCriteria instanceof IsNullCriteria) {
            IsNullCriteria isNullCriteria = (IsNullCriteria)predicateCriteria;
            if (NewCalculateCostUtil.isNullable(elements, metadata)) {
                int nnv = NewCalculateCostUtil.getNNV(elements, metadata);
                cost = childCostBase * (double)(nnv / NewCalculateCostUtil.getCardinality(elements, metadata));
            } else {
                cost = 0.0;
            }
            cost = childCostBase;
            isNegatedPredicateCriteria = isNullCriteria.isNegated();
        }
        if (isNegatedPredicateCriteria) {
            double predicateCost = cost;
            cost = predicateCost != -1.0 ? Math.max(childCostBase - predicateCost, 1.0) : -1.0;
        }
        return new Double(cost).intValue();
    }

    private static int getCardinality(HashSet elements, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        if (elements.size() != 1) {
            return -1;
        }
        ElementSymbol elem = (ElementSymbol)elements.iterator().next();
        Object groupID = elem.getGroupSymbol().getMetadataID();
        return metadata.getCardinality(groupID);
    }

    private static List getNDV(Collection elements, long estNodeCardinality, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        ArrayList<Integer> elemNDVList = new ArrayList<Integer>();
        if (elements.size() < 1) {
            return Collections.EMPTY_LIST;
        }
        Iterator elementIterator = elements.iterator();
        while (elementIterator.hasNext()) {
            ElementSymbol elem = (ElementSymbol)elementIterator.next();
            int ndv = NewCalculateCostUtil.estimateNDVForSymbol(elem, estNodeCardinality, metadata);
            if (ndv <= 0) {
                return Collections.EMPTY_LIST;
            }
            elemNDVList.add(new Integer(ndv));
        }
        return elemNDVList;
    }

    private static boolean isNullable(HashSet elements, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        if (elements.size() != 1) {
            return true;
        }
        ElementSymbol elem = (ElementSymbol)elements.iterator().next();
        Object elemID = elem.getMetadataID();
        return metadata.elementSupports(elemID, 4) || metadata.elementSupports(elemID, 10);
    }

    private static int getNNV(HashSet elements, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        if (elements.size() != 1) {
            return -1;
        }
        ElementSymbol elem = (ElementSymbol)elements.iterator().next();
        Object elemID = elem.getMetadataID();
        return metadata.getNullValues(elemID);
    }

    private static int computeChildCostBase(List childCost) {
        long cost = 1L;
        Iterator childCostIterator = childCost.iterator();
        while (childCostIterator.hasNext()) {
            long tmpCost = ((Integer)childCostIterator.next()).intValue();
            if (tmpCost == -1L) {
                return new Long(tmpCost).intValue();
            }
            cost *= tmpCost;
        }
        return new Long(cost).intValue();
    }

    private static boolean isNDVKnown(List ndvList) {
        if (!ndvList.isEmpty()) {
            Iterator ndvIterator = ndvList.iterator();
            while (ndvIterator.hasNext()) {
                int ndv = (Integer)ndvIterator.next();
                if (ndv != -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static long computeCostForMergeJoin(PlanNode leftChildNode, PlanNode rightChildNode, QueryMetadataInterface metadata, CommandContext context) throws MetaMatrixComponentException, QueryMetadataException {
        long leftChildCardinality = NewCalculateCostUtil.computeCostForTree(leftChildNode, metadata);
        long rightChildCardinality = NewCalculateCostUtil.computeCostForTree(rightChildNode, metadata);
        if (leftChildCardinality == -1L || rightChildCardinality == -1L || !COST_VARIABLES_LOADED) {
            throw new MetaMatrixRuntimeException();
        }
        long numberComparisons = leftChildCardinality + rightChildCardinality;
        long connectorBatchSize = 2000L;
        if (context != null) {
            connectorBatchSize = context.getConnectorBatchSize();
        }
        long totalReadLeftTime = leftChildCardinality * readLeftTime;
        long totalReadRightTime = rightChildCardinality * readRightTime;
        long totalCompareTime = numberComparisons * compareTime;
        long totalDupCompareTime = leftChildCardinality * dupCompareTime;
        long totalProcMoreRequestLeftTime = leftChildCardinality / connectorBatchSize * procMoreRequestLeftTime;
        long totalProcMoreRequestRightTime = rightChildCardinality / connectorBatchSize * procMoreRequestRightTime;
        long estMergeJoinComparisons = totalReadLeftTime + totalReadRightTime + totalCompareTime + totalDupCompareTime + procNewRequestLeftTime + totalProcMoreRequestLeftTime + procNewRequestRightTime + totalProcMoreRequestRightTime;
        return estMergeJoinComparisons;
    }

    public static long computeCostForMergeDepJoin(PlanNode independentNode, PlanNode dependentNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws MetaMatrixComponentException, QueryMetadataException {
        NewCalculateCostUtil.initializeCostVariables();
        long independentCardinality = NewCalculateCostUtil.computeCostForTree(independentNode, metadata);
        long dependentCardinality = NewCalculateCostUtil.computeCostForTree(dependentNode, metadata);
        if (independentCardinality == -1L || dependentCardinality == -1L || !COST_VARIABLES_LOADED) {
            throw new MetaMatrixRuntimeException();
        }
        long[] returnValues = NewCalculateCostUtil.estimateCostForDependentAccess(independentNode, dependentNode, metadata, capFinder);
        for (int i = 0; i < returnValues.length; ++i) {
            if (returnValues[i] != -1L) continue;
            throw new MetaMatrixRuntimeException();
        }
        long dependentAccessCardinality = returnValues[0];
        long dependentSetCriteriaSize = returnValues[1];
        long setCriteriaBatchSize = returnValues[2];
        long depAccessSymbolNDV = returnValues[3];
        long processorBatchSize = 2000L;
        long connectorBatchSize = 2000L;
        if (context != null) {
            processorBatchSize = context.getProcessorBatchSize();
            connectorBatchSize = context.getConnectorBatchSize();
        }
        dependentNode.setProperty((Object)NodeConstants.Info.EST_DEP_CARDINALITY, (Object)new Long(dependentAccessCardinality));
        long numberComparisons = independentCardinality + dependentAccessCardinality;
        long totalLoadDataTime = independentCardinality / processorBatchSize * depLoadDataTime;
        long totalSetupTupleTime = dependentSetCriteriaSize * depSetupTupleTime;
        long totalReadLeftTime = independentCardinality * depReadLeftTime;
        long totalReadRightTime = dependentAccessCardinality * depReadRightTime;
        long totalCompareTime = numberComparisons * depCompareTime;
        long totalDupCompareTime = independentCardinality * depDupCompareTime;
        long totalProcMoreRequestLeftTime = independentCardinality / connectorBatchSize * depProcMoreRequestLeftTime;
        long numberNewRequestsLeft = dependentSetCriteriaSize / setCriteriaBatchSize;
        long totalProcNewRequestRightTime = numberNewRequestsLeft * depProcNewRequestRightTime;
        double numMoreRequestsPerNewRequestRight = Math.floor(dependentCardinality * setCriteriaBatchSize / depAccessSymbolNDV / connectorBatchSize);
        long totalProcMoreRequestRightTime = new Double(numMoreRequestsPerNewRequestRight).longValue() * numberNewRequestsLeft * depProcMoreRequestRightTime;
        long estMergeJoinComparisons = totalLoadDataTime + totalSetupTupleTime + totalReadLeftTime + totalReadRightTime + totalCompareTime + totalDupCompareTime + depProcNewRequestLeftTime + totalProcMoreRequestLeftTime + totalProcNewRequestRightTime + totalProcMoreRequestRightTime;
        return estMergeJoinComparisons;
    }

    public static long computeCostForNestedLoopJoin(PlanNode leftChildNode, PlanNode rightChildNode, QueryMetadataInterface metadata, CommandContext context) throws MetaMatrixComponentException, QueryMetadataException {
        NewCalculateCostUtil.initializeCostVariables();
        long leftChildCardinality = NewCalculateCostUtil.computeCostForTree(leftChildNode, metadata);
        long rightChildCardinality = NewCalculateCostUtil.computeCostForTree(rightChildNode, metadata);
        if (leftChildCardinality == -1L || rightChildCardinality == -1L || !COST_VARIABLES_LOADED) {
            throw new MetaMatrixRuntimeException();
        }
        long numberComparisons = leftChildCardinality * rightChildCardinality;
        long connectorBatchSize = 2000L;
        if (context != null) {
            connectorBatchSize = context.getConnectorBatchSize();
        }
        long totalReadLeftTime = leftChildCardinality * readLeftTime;
        long totalReadRightTime = rightChildCardinality * readRightTime;
        long totalCompareTime = numberComparisons * compareTime;
        long totalProcMoreRequestLeftTime = leftChildCardinality / connectorBatchSize * procMoreRequestLeftTime;
        long totalProcMoreRequestRightTime = rightChildCardinality / connectorBatchSize * procMoreRequestRightTime;
        long estMergeJoinComparisons = totalReadLeftTime + totalReadRightTime + totalCompareTime + procNewRequestLeftTime + totalProcMoreRequestLeftTime + procNewRequestRightTime + totalProcMoreRequestRightTime;
        return estMergeJoinComparisons;
    }

    public static long computeCostForNestedLoopDepJoin(PlanNode independentNode, PlanNode dependentNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws MetaMatrixComponentException, QueryMetadataException {
        NewCalculateCostUtil.initializeCostVariables();
        long independentCardinality = NewCalculateCostUtil.computeCostForTree(independentNode, metadata);
        long dependentCardinality = NewCalculateCostUtil.computeCostForTree(dependentNode, metadata);
        if (independentCardinality == -1L || dependentCardinality == -1L || !COST_VARIABLES_LOADED) {
            throw new MetaMatrixRuntimeException();
        }
        long[] returnValues = NewCalculateCostUtil.estimateCostForDependentAccess(independentNode, dependentNode, metadata, capFinder);
        for (int i = 0; i < returnValues.length; ++i) {
            if (returnValues[i] != -1L) continue;
            throw new MetaMatrixRuntimeException();
        }
        long dependentAccessCardinality = returnValues[0];
        long dependentSetCriteriaSize = returnValues[1];
        long setCriteriaBatchSize = returnValues[2];
        long depAccessSymbolNDV = returnValues[3];
        long connectorBatchSize = 2000L;
        if (context != null) {
            connectorBatchSize = context.getConnectorBatchSize();
        }
        dependentNode.setProperty((Object)NodeConstants.Info.EST_DEP_CARDINALITY, (Object)new Long(dependentCardinality));
        long numberComparisons = independentCardinality * dependentCardinality;
        long totalReadLeftTime = independentCardinality * depReadLeftTime;
        long totalReadRightTime = dependentAccessCardinality * depReadRightTime;
        long totalCompareTime = numberComparisons * depCompareTime;
        long totalProcMoreRequestLeftTime = independentCardinality / connectorBatchSize * depProcMoreRequestLeftTime;
        long numberNewRequestsLeft = dependentSetCriteriaSize / setCriteriaBatchSize;
        long totalProcNewRequestRightTime = numberNewRequestsLeft * depProcNewRequestRightTime;
        double numMoreRequestsPerNewRequestRight = Math.floor(dependentCardinality * setCriteriaBatchSize / depAccessSymbolNDV / connectorBatchSize);
        long totalProcMoreRequestRightTime = new Double(numMoreRequestsPerNewRequestRight).longValue() * numberNewRequestsLeft * depProcMoreRequestRightTime;
        long estMergeJoinComparisons = totalReadLeftTime + totalReadRightTime + totalCompareTime + depProcNewRequestLeftTime + totalProcMoreRequestLeftTime + totalProcNewRequestRightTime + totalProcMoreRequestRightTime;
        return estMergeJoinComparisons;
    }

    public static boolean isMergeJoinOptional(PlanNode planNode, QueryMetadataInterface metadata) {
        PlanNode parent = planNode;
        while (parent.getType() != 2) {
            parent = planNode.getParent();
        }
        return parent.getProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS) != null && parent.getProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS) != null;
    }

    public static boolean isRangeMeasurable(String dataType) {
        return dataType.equalsIgnoreCase("bigdecimal") || dataType.equalsIgnoreCase("biginteger") || dataType.equalsIgnoreCase("byte") || dataType.equalsIgnoreCase("short") || dataType.equalsIgnoreCase("integer") || dataType.equalsIgnoreCase("long") || dataType.equalsIgnoreCase("float") || dataType.equalsIgnoreCase("double") || dataType.equalsIgnoreCase("timestamp");
    }

    public static List getElementSybmolsFromGroups(Set groups) {
        Iterator groupsIterator = groups.iterator();
        HashSet elementSymbols = new HashSet();
        while (groupsIterator.hasNext()) {
            GroupSymbol group = (GroupSymbol)groupsIterator.next();
            ElementCollectorVisitor.getElements((LanguageObject)group, elementSymbols);
        }
        return new ArrayList(elementSymbols);
    }

    private static long[] estimateCostForDependentAccess(PlanNode independentNode, PlanNode dependentNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws MetaMatrixComponentException, QueryMetadataException {
        List joinCriteriaSymbols = NewCalculateCostUtil.getJoinCriteriaSymbols(independentNode, metadata);
        long dependentNodeCardinality = ((Integer)dependentNode.getProperty((Object)NodeConstants.Info.EST_CARDINALITY)).longValue();
        long independentNodeCardinality = ((Integer)independentNode.getProperty((Object)NodeConstants.Info.EST_CARDINALITY)).longValue();
        int indSymbolNDV = -1;
        int depSymbolNDV = -1;
        int setCriteriaBatchSize = -1;
        Set independentGroups = independentNode.getGroups();
        Iterator joinCriteriaSymbolsIterator = joinCriteriaSymbols.iterator();
        while (joinCriteriaSymbolsIterator.hasNext()) {
            ArrayList symbols = (ArrayList)joinCriteriaSymbolsIterator.next();
            Iterator symbolsIterator = symbols.iterator();
            int currentIndSymbolNDV = -1;
            int currentDepSymbolNDV = -1;
            ElementSymbol currentIndSymbol = null;
            ElementSymbol currentDepSymbol = null;
            while (symbolsIterator.hasNext()) {
                ElementSymbol symbol = (ElementSymbol)symbolsIterator.next();
                if (NewCalculateCostUtil.isSymbolInGroups(symbol, independentGroups)) {
                    currentIndSymbol = symbol;
                    continue;
                }
                currentDepSymbol = symbol;
            }
            boolean virtualIndepSymbol = currentIndSymbol != null ? metadata.isVirtualGroup(currentIndSymbol.getGroupSymbol().getMetadataID()) : false;
            currentIndSymbolNDV = virtualIndepSymbol ? NewCalculateCostUtil.getMappedPhysicalNDV(currentIndSymbol, independentNode, metadata) : NewCalculateCostUtil.estimateNDVForSymbol(currentIndSymbol, independentNodeCardinality, metadata);
            boolean virtualDepSymbol = currentDepSymbol != null ? metadata.isVirtualGroup(currentDepSymbol.getGroupSymbol().getMetadataID()) : false;
            currentDepSymbolNDV = virtualDepSymbol ? NewCalculateCostUtil.getMappedPhysicalNDV(currentDepSymbol, dependentNode, metadata) : NewCalculateCostUtil.estimateNDVForSymbol(currentDepSymbol, dependentNodeCardinality, metadata);
            if (currentIndSymbolNDV == -1 || currentDepSymbolNDV == -1) {
                long[] values = new long[]{dependentNodeCardinality, -1L, -1L};
                return values;
            }
            if (indSymbolNDV != -1 && currentIndSymbolNDV >= indSymbolNDV) continue;
            indSymbolNDV = currentIndSymbolNDV;
            depSymbolNDV = currentDepSymbolNDV;
            Object modelID = null;
            modelID = virtualDepSymbol ? NewCalculateCostUtil.getMappedPhysicalModel(currentDepSymbol, dependentNode, metadata) : metadata.getModelID(currentDepSymbol.getMetadataID());
            setCriteriaBatchSize = CapabilitiesUtil.getMaxInCriteriaSize(modelID, metadata, capFinder);
        }
        independentNode.setProperty((Object)NodeConstants.Info.EST_SET_SIZE, (Object)new Integer(new Long(indSymbolNDV).intValue()));
        dependentNodeCardinality = dependentNodeCardinality * (long)indSymbolNDV / (long)depSymbolNDV;
        long[] values = new long[]{dependentNodeCardinality, indSymbolNDV, setCriteriaBatchSize, depSymbolNDV};
        return values;
    }

    private static int getMappedPhysicalNDV(ElementSymbol currentDepSymbol, PlanNode dependentNode, QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        PlanNode sourceNode;
        PlanNode currentNode = dependentNode;
        ElementSymbol currentExpr = currentDepSymbol;
        while ((sourceNode = NodeEditor.findNodePreOrder((PlanNode)currentNode, (int)6)) != null) {
            Map symbolMap = (Map)sourceNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
            currentExpr = (Expression)symbolMap.get(currentExpr);
            if (!(currentExpr instanceof ElementSymbol)) {
                Collection elements = ElementCollectorVisitor.getElements((LanguageObject)currentExpr, (boolean)false, (boolean)false);
                switch (elements.size()) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        currentExpr = (ElementSymbol)elements.iterator().next();
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
            }
            try {
                ElementSymbol currentElem = currentExpr;
                if (!metadata.isVirtualGroup(currentElem.getGroupSymbol().getMetadataID())) {
                    return metadata.getDistinctValues(currentElem.getMetadataID());
                }
                currentNode = sourceNode.getFirstChild();
            }
            catch (QueryMetadataException e) {
                throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
            }
        }
        return -1;
    }

    private static Object getMappedPhysicalModel(ElementSymbol currentDepSymbol, PlanNode dependentNode, QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        PlanNode sourceNode;
        PlanNode currentNode = dependentNode;
        ElementSymbol currentExpr = currentDepSymbol;
        while ((sourceNode = NodeEditor.findNodePreOrder((PlanNode)currentNode, (int)6)) != null) {
            Map symbolMap = (Map)sourceNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
            currentExpr = (Expression)symbolMap.get(currentExpr);
            if (!(currentExpr instanceof ElementSymbol)) {
                Collection elements = ElementCollectorVisitor.getElements((LanguageObject)currentExpr, (boolean)false, (boolean)false);
                if (elements.size() == 0) {
                    return null;
                }
                currentExpr = (ElementSymbol)elements.iterator().next();
            }
            try {
                ElementSymbol currentElem = currentExpr;
                if (!metadata.isVirtualGroup(currentElem.getGroupSymbol().getMetadataID())) {
                    return metadata.getModelID(currentElem.getMetadataID());
                }
                currentNode = sourceNode.getFirstChild();
            }
            catch (QueryMetadataException e) {
                throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
            }
        }
        return null;
    }

    private static List getJoinCriteriaSymbols(PlanNode nodeA, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        PlanNode parent = nodeA.getParent();
        while (parent.getType() != 2) {
            parent = nodeA.getParent();
        }
        List joinCriteria = (List)parent.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
        Iterator joinCriteriaIterator = joinCriteria.iterator();
        ArrayList joinCriteriaElements = new ArrayList();
        while (joinCriteriaIterator.hasNext()) {
            ArrayList critElements = new ArrayList();
            ElementCollectorVisitor.getElements((LanguageObject)((Criteria)joinCriteriaIterator.next()), critElements);
            joinCriteriaElements.add(critElements);
        }
        return joinCriteriaElements;
    }

    private static boolean isSymbolInGroups(ElementSymbol symbol, Set groups) {
        Iterator groupIterator = groups.iterator();
        while (groupIterator.hasNext()) {
            if (symbol.getGroupSymbol() != (GroupSymbol)groupIterator.next()) continue;
            return true;
        }
        return false;
    }

    private static int estimateNDVForSymbol(ElementSymbol symbol, long estNodeCardinality, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        if (symbol == null) {
            return -1;
        }
        double ndv = 0.0;
        double tableCardinality = 0.0;
        Object elemID = symbol.getMetadataID();
        Object groupID = symbol.getGroupSymbol().getMetadataID();
        if (elemID != null && groupID != null) {
            ndv = metadata.getDistinctValues(elemID);
            tableCardinality = metadata.getCardinality(groupID);
        }
        if (ndv <= 0.0) {
            return new Double(-1.0).intValue();
        }
        double estNDV = (double)estNodeCardinality * ndv / tableCardinality;
        if (estNDV < ndv) {
            return Math.max(1, new Double(estNDV).intValue());
        }
        return Math.max(1, new Double(ndv).intValue());
    }

    private static void initializeCostVariables() {
        if (!COST_VARIABLES_LOADED) {
            try {
                costVariables = new Properties();
                costVariables.load((class$com$metamatrix$query$optimizer$relational$rules$NewCalculateCostUtil == null ? (class$com$metamatrix$query$optimizer$relational$rules$NewCalculateCostUtil = NewCalculateCostUtil.class$("com.metamatrix.query.optimizer.relational.rules.NewCalculateCostUtil")) : class$com$metamatrix$query$optimizer$relational$rules$NewCalculateCostUtil).getResourceAsStream("costVariables.props"));
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                COST_VARIABLES_LOADED = false;
            }
            Set<Object> keys = costVariables.keySet();
            Iterator<Object> keyIterator = keys.iterator();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                if (key.equals(COMPARE_TIME)) {
                    compareTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(READ_LEFT_TIME)) {
                    readLeftTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(READ_RIGHT_TIME)) {
                    readRightTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(DUP_COMPARE_TIME)) {
                    dupCompareTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(PROC_NEW_REQUEST_LEFT_TIME)) {
                    procNewRequestLeftTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(PROC_MORE_REQUEST_LEFT_TIME)) {
                    procMoreRequestLeftTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(PROC_NEW_REQUEST_RIGHT_TIME)) {
                    procNewRequestRightTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(PROC_MORE_REQUEST_RIGHT_TIME)) {
                    procMoreRequestRightTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(DEP_LOAD_DATA_TIME)) {
                    depLoadDataTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(DEP_SETUP_TUPLE_TIME)) {
                    depSetupTupleTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(DEP_COMPARE_TIME)) {
                    depCompareTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(DEP_READ_LEFT_TIME)) {
                    depReadLeftTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(DEP_READ_RIGHT_TIME)) {
                    depReadRightTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(DEP_DUP_COMPARE_TIME)) {
                    depDupCompareTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(DEP_PROC_NEW_REQUEST_LEFT_TIME)) {
                    depProcNewRequestLeftTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(DEP_PROC_MORE_REQUEST_LEFT_TIME)) {
                    depProcMoreRequestLeftTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (key.equals(DEP_PROC_NEW_REQUEST_RIGHT_TIME)) {
                    depProcNewRequestRightTime = Long.parseLong(costVariables.getProperty(key));
                    continue;
                }
                if (!key.equals(DEP_PROC_MORE_REQUEST_RIGHT_TIME)) continue;
                depProcMoreRequestRightTime = Long.parseLong(costVariables.getProperty(key));
            }
            COST_VARIABLES_LOADED = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        COST_VARIABLES_LOADED = false;
        NewCalculateCostUtil.initializeCostVariables();
    }
}

