@ECHO off
SETLOCAL enableextensions
SET JAVA_BIN=
SET MM_JAVA=
SET MM_ROOT=
SET ROOT=
ECHO.
ECHO This utility is intended for use with the MetaMatrix installed 
ECHO JRE/JDK.  This utility can be used with MetaMatrix Server, 
ECHO MetaMatrix Designer, MetaMatrix Modeler, MetaMatrix Console, 
ECHO and MetaMatrix CDK installation.  This utility can also be 
ECHO used to upgrade a JRE/JDK by specifying the home or root 
ECHO directory of the target JRE/JDK.  
ECHO.
ECHO Please note, this utility assumes that you are using the default 
ECHO recommended directory structure provided for each installed 
ECHO MetaMatrix component.
ECHO.
ECHO Enter the complete path to the root MetaMatrix installation 
SET /P ROOT="directory [press ENTER to exit]: "

IF "%ROOT%"=="" GOTO exit

IF EXIST "%ROOT%\bin\mmenv.cmd" GOTO serverRoot
IF EXIST "%ROOT%\bin\mmenv.bat" GOTO serverRoot
IF EXIST "%ROOT%\bin\mmtoolsenv.cmd" GOTO toolsRoot
IF EXIST "%ROOT%\bin\mmtoolsenv.bat" GOTO toolsRoot
IF EXIST "%ROOT%\eclipse\startup.jar" SET JAVA_BIN=%ROOT%\eclipse\jre\bin\java.exe
IF EXIST "%ROOT%\jre\bin\java.exe" SET JAVA_BIN=%ROOT%\jre\bin\java.exe
IF EXIST "%ROOT%\bin\java.exe" SET JAVA_BIN=%ROOT%\bin\java.exe

GOTO runUpdate

:serverRoot
FOR /F "delims=" %%i IN ('cd') DO SET cwd=%%i
FOR /F "delims=\" %%i IN ('cd') DO SET cdl=%%i
FOR /F "delims=\" %%i IN ('ECHO %ROOT%') DO SET ndl=%%i
%ndl%
cd "%ROOT%\bin"
IF EXIST "mmenv.cmd" call mmenv.cmd > NUL
IF EXIST "mmenv.bat" call mmenv.bat > NUL
%cdl%
cd "%cwd%"
SET cwd=
SET cdl=
SET ndl=
IF NOT "%MM_JAVA%"=="" SET JAVA_BIN=%MM_JAVA%\bin\java.exe
GOTO runUpdate

:toolsRoot
FOR /F "delims=" %%i IN ('cd') DO SET cwd=%%i
FOR /F "delims=\" %%i IN ('cd') DO SET cdl=%%i
FOR /F "delims=\" %%i IN ('ECHO %ROOT%') DO SET ndl=%%i
%ndl%
cd "%ROOT%\bin"
IF EXIST "mmtoolsenv.bat" call mmtoolsenv.bat > NUL
IF EXIST "mmtoolsenv.cmd" call mmtoolsenv.cmd > NUL
%cdl%
cd "%cwd%"
SET cwd=
SET cdl=
SET ndl=
IF NOT "%MM_JAVA%"=="" SET JAVA_BIN=%MM_JAVA%\bin\java.exe
GOTO runUpdate

:runUpdate
IF "%JAVA_BIN%"=="" GOTO noJREFound
IF NOT EXIST "%JAVA_BIN%" GOTO noJREFound

ECHO.
ECHO Using %JAVA_BIN%...
"%JAVA_BIN%" -version
ECHO.

IF NOT "%1"=="" (
   ECHO Running update tool using options %*
   "%JAVA_BIN%" -jar tzupdater.jar %*
   IF %errorlevel% == 1 GOTO testFailed
   ECHO.
   ECHO Update command completed successfully.
) ELSE (
   ECHO Applying update...
   "%JAVA_BIN%" -jar tzupdater.jar -u
   ECHO.
   ECHO Performing validation tests...
   "%JAVA_BIN%" -jar tzupdater.jar -t
   IF %errorlevel% == 1 GOTO testFailed
   ECHO.
   ECHO Updates applied successfully.
)
GOTO exit

:testFailed
ECHO.
ECHO !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
ECHO.
ECHO Time zone validation test failed for this version of the updater.
ECHO Please review any warnings or error messages above.
GOTO exit

:noJREFound
ECHO.
ECHO !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
ECHO.
ECHO The update utility was unable to locate a JRE.  Please verify 
ECHO the path specified is the full path to a MetaMatrix installed 
ECHO component or a valid JRE root directory.
ECHO.
ECHO If you continue to have problems, please execute the tool directly 
ECHO using the following form:
ECHO.
ECHO java -jar tzupdater.jar -u
ECHO.
ECHO The above command will update the time zone information for the JRE
ECHO that the java.exe was executed from.
ECHO.

:exit

ECHO.
endlocal
@ECHO on