/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.columns;

import com.metamatrix.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkDateTimeColumn;
import com.metamatrix.jdbc.sequelink.utilities.BooleanArray;
import com.metamatrix.jdbc.sequelink.utilities.IntArray;
import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;

public class SequeLinkDateColumn
extends SequeLinkDateTimeColumn {
    private IntArray array;
    private BooleanArray isNull;

    public SequeLinkDateColumn(StatementContext statementContext, SequeLinkColumnDescribe sequeLinkColumnDescribe, int n2) throws SQLException {
        super(statementContext, sequeLinkColumnDescribe, n2, 11);
        this.out = new char[19];
        this.array = new IntArray();
        this.isNull = new BooleanArray();
    }

    protected void setBindInfo() {
        this.sqlnkType = 9;
        this.sqlnkSize = 4;
    }

    protected void readDataFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        int n2 = sspInputStream.readSSPInt16() - 1900;
        n2 <<= 4;
        n2 |= sspInputStream.readSSPInt8() - 1;
        n2 <<= 5;
        this.array.add(n2 |= sspInputStream.readSSPInt8());
        this.isNull.add(false);
    }

    protected void readNull() {
        this.array.add(0);
        this.isNull.add(true);
    }

    public void clearData() {
        this.array.reset();
        this.isNull.reset();
    }

    public BaseData getData(int n2, int n3, DiagnosticList diagnosticList) throws SQLException {
        if (this.isNull.get(n3)) {
            this.myBaseData.setNull(this.baseDataType);
            return this.myBaseData;
        }
        int n4 = this.array.get(n3);
        int n5 = n4 & 0x1F;
        int n6 = (n4 >>= 5) & 0xF;
        int n7 = n4 >>= 4;
        switch (n2) {
            case 11: {
                Date date = new Date(n7, n6, n5);
                this.myBaseData.setDate(date);
                break;
            }
            case 10: {
                String string = this.getDateString(n7, n6, n5);
                this.myBaseData.setString(string);
                break;
            }
            case 13: {
                Timestamp timestamp = new Timestamp(n7, n6, n5, 0, 0, 0, 0);
                this.myBaseData.setTimestamp(timestamp);
                break;
            }
            default: {
                Date date = new Date(n7, n6, n5);
                this.myBaseData.setDate(date);
            }
        }
        return this.myBaseData;
    }

    private String getDateString(int n2, int n3, int n4) throws SQLException {
        this.pos = 0;
        this.writeInt(n2 + 1900, 4);
        this.out[this.pos++] = 45;
        this.writeInt(n3 + 1, 2);
        this.out[this.pos++] = 45;
        this.writeInt(n4, 2);
        return new String(this.out, 0, this.pos);
    }
}

