/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.diagram.ui.custom;

import com.metamatrix.metamodels.diagram.AbstractDiagramEntity;
import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.metamodels.diagram.DiagramLink;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.notification.util.NotificationUtilities;
import com.metamatrix.modeler.core.transaction.SourcedNotification;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.diagram.ui.DiagramUiConstants;
import com.metamatrix.modeler.diagram.ui.connection.NodeConnectionModel;
import com.metamatrix.modeler.diagram.ui.custom.CustomDiagramNode;
import com.metamatrix.modeler.diagram.ui.custom.CustomDiagramNotificationHelper;
import com.metamatrix.modeler.diagram.ui.drawing.DrawingModelFactory;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditorUtil;
import com.metamatrix.modeler.diagram.ui.model.DiagramModelNode;
import com.metamatrix.modeler.diagram.ui.model.LabelModelNode;
import com.metamatrix.modeler.diagram.ui.notation.uml.model.UmlClassifierNode;
import com.metamatrix.modeler.diagram.ui.pakkage.PackageDiagramModelFactory;
import com.metamatrix.modeler.diagram.ui.util.DiagramUiUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelObjectUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class CustomDiagramModelFactory
extends PackageDiagramModelFactory
implements DiagramUiConstants {
    private static final String KEY_CUSTOM_DIAGRAM_NAME = "DiagramNames.customDiagram";
    private static final String THIS_CLASS = "CustomDiagramModelFactory";
    private String errorMessage;

    public DiagramModelNode createModel(Object baseObject, String sNotationId, IProgressMonitor monitor) {
        if (!(baseObject instanceof Diagram)) {
            return null;
        }
        HashMap<EObject, DiagramModelNode> nodeMap = new HashMap<EObject, DiagramModelNode>();
        this.setSNotationId(sNotationId);
        Diagram diagram = (Diagram)baseObject;
        CustomDiagramNode diagramModelNode = null;
        List contents = null;
        diagramModelNode = new CustomDiagramNode((EObject)diagram, DiagramUiConstants.Util.getString(KEY_CUSTOM_DIAGRAM_NAME));
        List drawingNodes = DrawingModelFactory.getDrawingNodes((Diagram)diagram, (DiagramModelNode)diagramModelNode);
        contents = this.getDiagramContents(diagram);
        if (!contents.isEmpty()) {
            Iterator iter = contents.iterator();
            if (this.getGenerator() != null) {
                while (iter.hasNext()) {
                    this.errorMessage = null;
                    EObject eObj = (EObject)iter.next();
                    DiagramModelNode childModelNode = this.getGenerator().createModel((Object)eObj, diagram);
                    if (childModelNode != null) {
                        nodeMap.put(eObj, childModelNode);
                        childModelNode.setParent((DiagramModelNode)diagramModelNode);
                        diagramModelNode.addChild(childModelNode);
                        diagramModelNode.update("children");
                        diagramModelNode.update("layout");
                        continue;
                    }
                    String name = DiagramUiUtilities.getEObjectLabel((EObject)eObj);
                    this.errorMessage = DiagramUiConstants.Util.getString("DiagramErrors.modelNodeFailure") + " for object = " + name;
                    DiagramUiConstants.Util.log(2, this.errorMessage);
                }
            } else {
                DiagramUiConstants.Util.log(2, DiagramUiConstants.Util.getString("DiagramErrors.modelGeneratorFailure"));
            }
            if (!diagramModelNode.getChildren().isEmpty()) {
                HashMap<EObject, NodeConnectionModel> connMap = new HashMap<EObject, NodeConnectionModel>();
                ArrayList<NodeConnectionModel> realAssociations = new ArrayList<NodeConnectionModel>();
                List currentChildren = diagramModelNode.getChildren();
                iter = currentChildren.iterator();
                while (iter.hasNext()) {
                    DiagramModelNode childModelNode = (DiagramModelNode)iter.next();
                    List childAssList = childModelNode.getAssociations(nodeMap);
                    NodeConnectionModel nextConnection = null;
                    NodeConnectionModel nextRealConnection = null;
                    Iterator innerIter = null;
                    Iterator subIter = childAssList.iterator();
                    while (subIter.hasNext()) {
                        boolean connExists = false;
                        nextConnection = (NodeConnectionModel)subIter.next();
                        if (nextConnection.getModelObject() != null) {
                            Object existingConn = connMap.get(nextConnection.getModelObject());
                            if (existingConn != null) {
                                connExists = true;
                            }
                        } else {
                            innerIter = realAssociations.iterator();
                            while (innerIter.hasNext() && !connExists) {
                                nextRealConnection = (NodeConnectionModel)innerIter.next();
                                if (nextRealConnection == null || nextConnection == null || !nextRealConnection.equals(nextConnection)) continue;
                                connExists = true;
                            }
                        }
                        if (connExists) continue;
                        if (nextConnection.getModelObject() != null) {
                            connMap.put(nextConnection.getModelObject(), nextConnection);
                        }
                        realAssociations.add(nextConnection);
                    }
                }
                iter = realAssociations.iterator();
                while (iter.hasNext()) {
                    NodeConnectionModel nextAssociation = (NodeConnectionModel)iter.next();
                    ((DiagramModelNode)nextAssociation.getSourceNode()).addSourceConnection(nextAssociation);
                    ((DiagramModelNode)nextAssociation.getTargetNode()).addTargetConnection(nextAssociation);
                    List labelNodes = nextAssociation.getLabelNodes();
                    if (labelNodes == null || labelNodes.isEmpty()) continue;
                    Iterator labelIter = labelNodes.iterator();
                    LabelModelNode nextNode = null;
                    while (labelIter.hasNext()) {
                        nextNode = (LabelModelNode)labelIter.next();
                        diagramModelNode.addChild((DiagramModelNode)nextNode);
                    }
                }
            }
        }
        if (!drawingNodes.isEmpty()) {
            diagramModelNode.addChildren(drawingNodes);
        }
        return diagramModelNode;
    }

    protected boolean currentDiagramRemoved(Diagram theDiagram) {
        boolean isRemoved = false;
        if (theDiagram == null) {
            isRemoved = true;
        } else if (theDiagram.eResource() == null) {
            isRemoved = true;
            if (theDiagram.eContainer() == null && this.diagramIsTransient(theDiagram)) {
                isRemoved = false;
            }
        }
        return isRemoved;
    }

    private List getDiagramContents(Diagram customDiagram) {
        List<EObject> contents = new ArrayList();
        if (customDiagram != null) {
            EList diagramChildren = customDiagram.eContents();
            if (diagramChildren != null && !diagramChildren.isEmpty()) {
                AbstractDiagramEntity nextDE = null;
                Iterator iter = diagramChildren.iterator();
                while (iter.hasNext()) {
                    nextDE = (AbstractDiagramEntity)iter.next();
                    if (nextDE instanceof DiagramLink || nextDE.getModelObject() == null) continue;
                    contents.add(nextDE.getModelObject());
                }
            } else {
                contents = Collections.EMPTY_LIST;
            }
        }
        return contents;
    }

    private boolean isValidDiagram(DiagramModelNode diagramModelNode) {
        String type;
        ModelResource mr;
        boolean result = false;
        Diagram diagram = (Diagram)diagramModelNode.getModelObject();
        if (diagram != null && diagram.getTarget() != null && (mr = ModelUtilities.getModelResourceForModelObject((EObject)diagram)) != null && (type = diagram.getType()) != null && type.equals("customDiagramType")) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean notifyModel(Notification notification, DiagramModelNode diagramModelNode, String sDiagramTypeId) {
        boolean handleConstruction;
        Diagram diagram;
        boolean currentDiagramOK;
        block13: {
            block11: {
                currentDiagramOK = true;
                diagram = (Diagram)diagramModelNode.getModelObject();
                if (this.currentDiagramRemoved(diagram)) {
                    currentDiagramOK = false;
                }
                if (!currentDiagramOK) return currentDiagramOK;
                if (!this.isValidDiagram(diagramModelNode)) return currentDiagramOK;
                if (!this.shouldHandleNotification(notification, diagramModelNode)) return currentDiagramOK;
                boolean requiredStart = false;
                boolean succeeded = false;
                handleConstruction = !DiagramEditorUtil.isDiagramUnderConstruction((Diagram)diagram);
                try {
                    try {
                        if (handleConstruction) {
                            DiagramEditorUtil.setDiagramUnderConstruction((Diagram)diagram);
                        }
                        requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Update Custom Diagram", (Object)((Object)this));
                        CustomDiagramNotificationHelper helper = new CustomDiagramNotificationHelper(notification, (Diagram)diagramModelNode.getModelObject(), (Object)this);
                        this.handleMoves(helper.getMovedEObjects(), diagramModelNode);
                        this.handleAdds(helper.getAddNotifications(), diagramModelNode);
                        this.handleRemoves(helper.getRemoveNotifications(), diagramModelNode);
                        this.handleChanges(helper.getChangedNotifications(), diagramModelNode);
                        this.add(new ArrayList(helper.getUndoAddedEObjects()), diagramModelNode);
                        succeeded = true;
                    }
                    catch (Exception ex) {
                        DiagramUiConstants.Util.log(4, (Throwable)ex, ex.getClass().getName() + ":" + THIS_CLASS + ".notifyModel()");
                        Object var11_12 = null;
                        if (!requiredStart) return currentDiagramOK;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                        if (!handleConstruction) return currentDiagramOK;
                        DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
                        return currentDiagramOK;
                    }
                    Object var11_11 = null;
                    if (!requiredStart) return currentDiagramOK;
                    if (!succeeded) break block11;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (!requiredStart) throw throwable;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                    if (!handleConstruction) throw throwable;
                    DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
                    throw throwable;
                }
                ModelerCore.commitTxn();
                break block13;
            }
            ModelerCore.rollbackTxn();
        }
        if (!handleConstruction) return currentDiagramOK;
        DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
        return currentDiagramOK;
    }

    private boolean shouldHandleNotification(Notification notification, DiagramModelNode diagramModelNode) {
        boolean shouldHandle = false;
        Diagram currentDiagram = (Diagram)diagramModelNode.getModelObject();
        ModelResource diagramMR = ModelUtilities.getModelResourceForModelObject((EObject)currentDiagram);
        if (diagramMR != null) {
            if (notification instanceof SourcedNotification) {
                Object source = ((SourcedNotification)notification).getSource();
                if (source == null || source != null && !source.equals((Object)this)) {
                    Collection notifications = ((SourcedNotification)notification).getNotifications();
                    Iterator iter = notifications.iterator();
                    Notification nextNotification = null;
                    while (iter.hasNext() && !shouldHandle) {
                        nextNotification = (Notification)iter.next();
                        Object targetObject = ModelerCore.getModelEditor().getChangedObject(nextNotification);
                        if (targetObject == null || !(targetObject instanceof EObject)) continue;
                        shouldHandle = true;
                    }
                }
            } else {
                Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
                if (targetObject != null && targetObject instanceof EObject) {
                    shouldHandle = true;
                }
            }
        }
        return shouldHandle;
    }

    public Diagram getDiagram(EObject someTarget) {
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)someTarget);
        try {
            List returnedDiagrams = modelResource.getModelDiagrams().getDiagrams(someTarget);
            if (returnedDiagrams.size() == 1) {
                return (Diagram)returnedDiagrams.get(0);
            }
            Iterator iter = returnedDiagrams.iterator();
            while (iter.hasNext()) {
                Diagram nextDiagram = (Diagram)iter.next();
                if (nextDiagram.getType() == null || !nextDiagram.getType().equals("customDiagramType")) continue;
                return nextDiagram;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void add(EObject someTarget, DiagramModelNode customDiagramModelNode, boolean updateAssociations) {
        DiagramModelNode newNode = this.getGenerator().createModel((Object)someTarget, (Diagram)customDiagramModelNode.getModelObject());
        if (newNode != null) {
            customDiagramModelNode.addChild(newNode);
            if (updateAssociations) {
                this.updateAssociations(customDiagramModelNode, customDiagramModelNode);
            }
        }
    }

    public void add(List targets, DiagramModelNode customDiagramModelNode) {
        Iterator iter = targets.iterator();
        EObject nextTarget = null;
        ArrayList<DiagramModelNode> newChildren = new ArrayList<DiagramModelNode>(targets.size());
        while (iter.hasNext()) {
            nextTarget = (EObject)iter.next();
            DiagramModelNode newNode = this.getGenerator().createModel((Object)nextTarget, (Diagram)customDiagramModelNode.getModelObject());
            if (newNode == null) continue;
            newNode.setParent(customDiagramModelNode);
            newChildren.add(newNode);
        }
        if (!newChildren.isEmpty()) {
            customDiagramModelNode.addChildren(newChildren);
            this.updateAssociations(customDiagramModelNode, customDiagramModelNode);
        }
    }

    protected void updateAssociations(DiagramModelNode diagramModelNode, DiagramModelNode diagramNode) {
        super.updateAssociations(diagramModelNode, diagramNode);
        HashMap nodeMap = this.getNodeMap(diagramNode);
        if (diagramModelNode instanceof CustomDiagramNode) {
            NodeConnectionModel nextAssociation = null;
            ArrayList realAssociations = new ArrayList();
            List currentChildren = diagramModelNode.getChildren();
            Iterator<Object> iter = currentChildren.iterator();
            while (iter.hasNext()) {
                List allAssociations;
                DiagramModelNode childModelNode = (DiagramModelNode)iter.next();
                if (childModelNode == null || (allAssociations = childModelNode.getAssociations(nodeMap)) == null || allAssociations.isEmpty()) continue;
                Iterator subIter = allAssociations.iterator();
                Object nextAss = null;
                while (subIter.hasNext()) {
                    nextAss = subIter.next();
                    if (realAssociations.contains(nextAss)) continue;
                    realAssociations.add(nextAss);
                }
            }
            List staleAssociations = this.getStaleAssociations(realAssociations, diagramModelNode);
            ArrayList changedNodes = new ArrayList(this.cleanUpStaleAssociations(staleAssociations, diagramModelNode));
            HashMap<Object, String> updatedNodes = new HashMap<Object, String>();
            iter = changedNodes.iterator();
            while (iter.hasNext()) {
                updatedNodes.put(iter.next(), "x");
            }
            iter = realAssociations.iterator();
            while (iter.hasNext()) {
                List labelNodes;
                nextAssociation = (NodeConnectionModel)iter.next();
                if (this.associationExists(diagramModelNode, nextAssociation)) continue;
                ((DiagramModelNode)nextAssociation.getSourceNode()).addSourceConnection(nextAssociation);
                ((DiagramModelNode)nextAssociation.getTargetNode()).addTargetConnection(nextAssociation);
                if (updatedNodes.get(nextAssociation.getSourceNode()) == null) {
                    updatedNodes.put(nextAssociation.getSourceNode(), "x");
                }
                if (updatedNodes.get(nextAssociation.getTargetNode()) == null) {
                    updatedNodes.put(nextAssociation.getTargetNode(), "x");
                }
                if ((labelNodes = nextAssociation.getLabelNodes()) == null || labelNodes.isEmpty()) continue;
                Iterator labelIter = labelNodes.iterator();
                LabelModelNode nextNode = null;
                while (labelIter.hasNext()) {
                    nextNode = (LabelModelNode)labelIter.next();
                    diagramModelNode.addChild((DiagramModelNode)nextNode);
                }
            }
            iter = this.getCurrentAssociations(diagramModelNode).iterator();
            while (iter.hasNext()) {
                nextAssociation = (NodeConnectionModel)iter.next();
                nextAssociation.updateLabels();
                ((DiagramModelNode)nextAssociation.getSourceNode()).updateAssociations();
                ((DiagramModelNode)nextAssociation.getTargetNode()).updateAssociations();
            }
            if (!updatedNodes.isEmpty()) {
                iter = updatedNodes.keySet().iterator();
                DiagramModelNode nextNode = null;
                while (iter.hasNext()) {
                    nextNode = (DiagramModelNode)iter.next();
                    nextNode.updateAssociations();
                }
            }
        }
    }

    public void remove(List targets, DiagramModelNode customDiagramModelNode) {
        Iterator iter = targets.iterator();
        EObject nextTarget = null;
        ArrayList<DiagramModelNode> oldChildren = new ArrayList<DiagramModelNode>(targets.size());
        while (iter.hasNext()) {
            nextTarget = (EObject)iter.next();
            DiagramModelNode oldNode = this.getModelNode(customDiagramModelNode, nextTarget);
            if (oldNode == null) continue;
            this.removeAllAssociationsFromNode(oldNode, customDiagramModelNode);
            oldChildren.add(oldNode);
        }
        if (!oldChildren.isEmpty()) {
            customDiagramModelNode.removeChildren(oldChildren, true);
        }
    }

    public void clear(DiagramModelNode customDiagramModelNode) {
        ArrayList currentChildren = new ArrayList(customDiagramModelNode.getChildren());
        if (!currentChildren.isEmpty()) {
            Iterator iter = currentChildren.iterator();
            DiagramModelNode nextNode = null;
            while (iter.hasNext()) {
                nextNode = (DiagramModelNode)iter.next();
                if (nextNode == null) continue;
                this.removeAllAssociationsFromNode(nextNode, customDiagramModelNode);
            }
            if (!currentChildren.isEmpty()) {
                customDiagramModelNode.removeChildren(currentChildren, true);
            }
        }
    }

    private void performAdd(Notification notification, DiagramModelNode customDiagramModelNode) {
        boolean performedChange = false;
        if (NotificationUtilities.isEObjectNotifier((Notification)notification)) {
            Object target = ModelerCore.getModelEditor().getChangedObject(notification);
            if (DiagramUiConstants.Util.isDebugEnabled("debugNotifications") && DiagramUiConstants.Util.isDebugEnabled("diagramModelNode")) {
                DiagramUiConstants.Util.print("diagramModelNode", "targetObject = " + target);
            }
            if (!(target instanceof EObject) || target instanceof Diagram || target instanceof AbstractDiagramEntity) {
                return;
            }
            EObject targetObject = (EObject)target;
            if (NotificationUtilities.addedChildrenParentIsNotifier((Notification)notification)) {
                EObject parentEObject;
                DiagramModelNode parentNode;
                EObject[] newChildren;
                boolean isNested = false;
                DiagramModelNode targetNode = this.getNodeInDiagram(customDiagramModelNode, targetObject);
                if (targetNode == null) {
                    isNested = true;
                    targetNode = this.getModelNode(customDiagramModelNode, targetObject);
                }
                if (targetNode != null && (newChildren = NotificationUtilities.getAddedChildren((Notification)notification)).length > 0) {
                    EObject childParent = newChildren[0].eContainer();
                    DiagramModelNode parentNode2 = this.getModelNode(customDiagramModelNode, childParent);
                    if (parentNode2 != null) {
                        if (parentNode2 instanceof UmlClassifierNode) {
                            ((UmlClassifierNode)parentNode2).reconcile();
                        } else {
                            for (int iChild = 0; iChild < newChildren.length; ++iChild) {
                                DiagramModelNode newNode = this.getGenerator().createChildModel(parentNode2, (Object)newChildren[iChild]);
                                if (newNode == null) continue;
                                performedChange = true;
                            }
                        }
                    }
                    if (performedChange) {
                        this.updateAssociations(parentNode2, customDiagramModelNode);
                    }
                }
                if (isNested && (parentNode = this.getModelNode(customDiagramModelNode, parentEObject = targetObject.eContainer())) != null) {
                    parentNode.updateForChild(false);
                }
            }
        }
    }

    private void performRemove(Notification notification, DiagramModelNode customDiagramModelNode) {
        if (NotificationUtilities.isEObjectNotifier((Notification)notification)) {
            Object target = ModelerCore.getModelEditor().getChangedObject(notification);
            if (DiagramUiConstants.Util.isDebugEnabled("debugNotifications") && DiagramUiConstants.Util.isDebugEnabled("diagramModelNode")) {
                DiagramUiConstants.Util.debug("debugNotifications", "CustomDiagramModelFactory.performRemove()  targetObject = " + target);
            }
            if (!(target instanceof EObject) || target instanceof Diagram || target instanceof AbstractDiagramEntity) {
                return;
            }
            EObject targetObject = (EObject)target;
            DiagramModelNode parentNode = this.getModelNode(customDiagramModelNode, targetObject);
            DiagramModelNode removedNode = null;
            EObject[] removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
            for (int iChild = 0; iChild < removedChildren.length; ++iChild) {
                removedNode = this.getModelNode(customDiagramModelNode, removedChildren[iChild]);
                if (removedNode == null) continue;
                if (parentNode != null) {
                    if (!(parentNode instanceof UmlClassifierNode)) {
                        parentNode.removeChild(removedNode, false);
                    }
                    this.updateAssociations(parentNode, customDiagramModelNode);
                    continue;
                }
                this.removeAllAssociationsFromNode(removedNode, customDiagramModelNode);
                customDiagramModelNode.removeChild(removedNode, false);
            }
            if (parentNode != null && parentNode instanceof UmlClassifierNode) {
                ((UmlClassifierNode)parentNode).reconcile();
            }
        } else {
            Object target = ModelerCore.getModelEditor().getChangedObject(notification);
            if (target instanceof Resource) {
                DiagramModelNode removedNode = null;
                EObject[] removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
                for (int iChild = 0; iChild < removedChildren.length; ++iChild) {
                    removedNode = this.getModelNode(customDiagramModelNode, removedChildren[iChild]);
                    if (removedNode == null) continue;
                    this.removeAllAssociationsFromNode(removedNode, customDiagramModelNode);
                    customDiagramModelNode.removeChild(removedNode, false);
                }
            }
        }
    }

    protected void performChange(Notification notification, DiagramModelNode customDiagramModelNode) {
        super.performChange(notification, customDiagramModelNode);
        EObject targetObject = NotificationUtilities.getEObject((Notification)notification);
        if (targetObject != null) {
            List diagramChildren = this.getDiagramContents((Diagram)customDiagramModelNode.getModelObject());
            Iterator iter = diagramChildren.iterator();
            EObject modelEObject = null;
            Object nextObj = null;
            while (iter.hasNext()) {
                DiagramModelNode targetNode;
                nextObj = iter.next();
                if (!(nextObj instanceof EObject) || (modelEObject = (EObject)nextObj) == null || !ModelObjectUtilities.isDescendant((EObject)targetObject, (EObject)modelEObject) || (targetNode = this.getModelNode(customDiagramModelNode, modelEObject)) == null) continue;
                this.getGenerator().performUpdate(targetNode, null);
                targetNode.update("size");
                targetNode.update("name");
            }
        }
    }

    private void handleMoves(Collection movedEObjects, DiagramModelNode customDiagramModelNode) {
        if (movedEObjects != null && !movedEObjects.isEmpty()) {
            DiagramModelNode targetNode = null;
            EObject nextEObj = null;
            Iterator iter = movedEObjects.iterator();
            while (iter.hasNext()) {
                nextEObj = (EObject)iter.next();
                targetNode = this.getModelNode(customDiagramModelNode, nextEObj);
                if (targetNode == null) continue;
                this.getGenerator().performUpdate(targetNode, null);
            }
        }
    }

    private void handleRemoves(Collection removeNotifications, DiagramModelNode customDiagramModelNode) {
        if (removeNotifications != null && !removeNotifications.isEmpty()) {
            Notification nextNotification = null;
            Iterator iter = removeNotifications.iterator();
            while (iter.hasNext()) {
                nextNotification = (Notification)iter.next();
                this.performRemove(nextNotification, customDiagramModelNode);
            }
        }
    }

    private void handleAdds(Collection addNotifications, DiagramModelNode customDiagramModelNode) {
        if (addNotifications != null && !addNotifications.isEmpty()) {
            Notification nextNotification = null;
            Iterator iter = addNotifications.iterator();
            while (iter.hasNext()) {
                nextNotification = (Notification)iter.next();
                this.performAdd(nextNotification, customDiagramModelNode);
            }
        }
    }

    private void handleChanges(Collection changeNotifications, DiagramModelNode customDiagramModelNode) {
        if (changeNotifications != null && !changeNotifications.isEmpty()) {
            Notification nextNotification = null;
            Iterator iter = changeNotifications.iterator();
            while (iter.hasNext()) {
                nextNotification = (Notification)iter.next();
                this.performChange(nextNotification, customDiagramModelNode);
            }
        }
    }
}

