/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.db2;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2Connection;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDASyncRequest;
import com.metamatrix.jdbcx.base.BaseImplXAResource;
import com.metamatrix.jdbcx.db2.DB2Xid;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class DB2ImplXAResource
extends BaseImplXAResource {
    private static String footprint = "$Revision:   3.12.2.0  $";
    BaseConnection connection;
    DB2ImplConnection implConn;
    DRDASyncRequest request;
    int timeout;
    private BaseWarnings warnings;
    private UtilVectorUnsynced suspendedXids;
    public DRDAByteOrderedDataWriter writer;
    public DRDAByteOrderedDataReader reader;

    public DB2ImplXAResource(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.implConn = ((DB2Connection)baseConnection).implCon;
        this.suspendedXids = new UtilVectorUnsynced();
        this.reader = this.implConn.comm.createReader();
        this.reader.setToBigEndian();
        this.writer = this.implConn.dataWriter;
        this.warnings = this.implConn.warnings;
        this.request = new DRDASyncRequest(this.implConn, this.implConn.comm, this.reader, this.writer);
    }

    protected void open() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(Xid xid, int n) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                if (n == 0x8000000) {
                    for (int i = 0; i < this.suspendedXids.size(); ++i) {
                        if ((Xid)this.suspendedXids.elementAt(i) != xid) continue;
                        this.suspendedXids.remove(i);
                    }
                }
                this.implConn.inLocalTransaction = false;
                this.request.start(new DB2Xid(xid), n);
                this.request.submitRequest();
                this.request.processReply(this.warnings);
                this.checkXAStatus();
            }
            catch (SQLException sQLException) {
                throw new XAException(this.implConn.exceptions.getException(7100).getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.rollBack(new DB2Xid(xid));
                this.request.submitRequest();
                this.request.processReply(this.warnings);
                this.checkXAStatus();
                this.implConn.inLocalTransaction = true;
            }
            catch (SQLException sQLException) {
                throw new XAException(this.implConn.exceptions.getException(7101).getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(Xid xid, boolean bl) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.commit(new DB2Xid(xid), bl);
                this.request.submitRequest();
                this.request.processReply(this.warnings);
                this.checkXAStatus();
                this.implConn.inLocalTransaction = true;
            }
            catch (SQLException sQLException) {
                throw new XAException(this.implConn.exceptions.getException(7102).getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Xid[] recover(int n) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.recover();
                this.request.submitRequest();
                this.request.processReply(this.warnings);
            }
            catch (SQLException sQLException) {
                throw new XAException(this.implConn.exceptions.getException(7099).getMessage());
            }
            return this.request.recoveredXids;
        }
    }

    protected int prepare(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.prepareToCommit(new DB2Xid(xid));
                this.request.submitRequest();
                this.request.processReply(this.warnings);
                return this.request.xaStatus;
            }
            catch (SQLException sQLException) {
                throw new XAException(sQLException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void end(Xid xid, int n) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                if (!this.isXidSuspended(xid)) {
                    if (n == 0x2000000) {
                        this.suspendedXids.add((Object)xid);
                    }
                    this.implConn.inLocalTransaction = true;
                    this.request.end(new DB2Xid(xid), n);
                    this.request.submitRequest();
                    this.request.processReply(this.warnings);
                    this.checkXAStatus();
                } else if (n == 0x4000000 || n == 0x20000000) {
                    for (int i = 0; i < this.suspendedXids.size(); ++i) {
                        if ((Xid)this.suspendedXids.elementAt(i) != xid) continue;
                        this.suspendedXids.remove(i);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new XAException(this.implConn.exceptions.getException(7103).getMessage());
            }
        }
    }

    protected void forget(Xid xid) throws XAException {
        XAException xAException = new XAException(-6);
    }

    protected int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    protected boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        this.timeout = n;
        return false;
    }

    protected String getRmIdentification() throws XAException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.implConn.host);
        stringBuffer.append("_");
        stringBuffer.append(this.implConn.port);
        stringBuffer.append("_");
        stringBuffer.append(this.implConn.databaseName);
        return stringBuffer.toString();
    }

    private final boolean isXidSuspended(Xid xid) {
        boolean bl = false;
        for (int i = 0; i < this.suspendedXids.size(); ++i) {
            if ((Xid)this.suspendedXids.elementAt(i) != xid) continue;
            bl = true;
        }
        return bl;
    }

    private final void checkXAStatus() throws XAException {
        switch (this.request.xaStatus) {
            case 0: {
                break;
            }
            case 99: {
                this.warnings.add(7111);
                break;
            }
            default: {
                throw new XAException(this.request.xaStatus);
            }
        }
    }
}

