/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.slbase;

import com.metamatrix.jdbc.slbase.BaseClassUtility;
import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbc.slbase.BaseConnectionProperties;
import com.metamatrix.jdbc.slbase.BaseDriver;
import com.metamatrix.jdbc.slbase.BaseDriverPropertyInfos;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseURLParser;
import com.metamatrix.jdbcx.slbase.BaseClassUtilityX;
import com.metamatrix.jdbcx.slbase.BaseLog;
import com.metamatrix.jdbcx.slbase.BasePooledConnection;
import com.metamatrix.slutil.UtilDebug;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class BaseDataSource
implements DataSource,
ConnectionPoolDataSource,
Referenceable,
Serializable {
    protected transient BaseExceptions exceptions;
    public transient UtilDebug debug;
    private transient PrintWriter printWriter;
    protected transient Object spyLogger;
    private transient boolean internalConnectionCallDoNotLog = false;
    protected String databaseName;
    String dataSourceName = "";
    String description;
    String password;
    String portNumber;
    String roleName;
    String serverName;
    String user;
    String extendedOptions;
    int loginTimeout = 0;
    boolean batchPerformanceWorkaround = false;
    String spyAttributes;
    boolean embedded = false;
    int maxPooledStatements = 0;
    int initialPoolSize = 0;
    int minPoolSize = 0;
    int maxPoolSize = 0;
    int maxIdleTime = 0;
    int propertyCycle = 0;
    int insensitiveResultSetBufferSize = 2048;
    String alternateServers;
    int connectionRetryCount = 0;
    int connectionRetryDelay = 3;
    boolean loadBalancing = false;
    int resultsetMetaDataOptions = 0;

    public final String getDatabaseName() {
        return this.databaseName;
    }

    public final void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String string) {
        this.password = string;
    }

    public int getPortNumber() {
        if (this.portNumber == null) {
            return 0;
        }
        return Integer.parseInt(this.portNumber);
    }

    public final void setPortNumber(int n) {
        this.portNumber = new Integer(n).toString();
    }

    public final String getRoleName() {
        return this.roleName;
    }

    public final void setRoleName(String string) {
        this.roleName = string;
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final void setServerName(String string) {
        this.serverName = string;
    }

    public final String getExtendedOptions() {
        return this.extendedOptions;
    }

    public final void setExtendedOptions(String string) {
        this.extendedOptions = string;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setUser(String string) {
        this.user = string;
    }

    public final boolean getBatchPerformanceWorkaround() {
        return this.batchPerformanceWorkaround;
    }

    public final void setBatchPerformanceWorkaround(boolean bl) {
        if (BaseClassUtility.exposeCtsIncompatibleOptions()) {
            this.batchPerformanceWorkaround = bl;
        }
    }

    public final int getLoginTimeout() {
        return this.loginTimeout;
    }

    public final void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    public final String getSpyAttributes() {
        return this.spyAttributes;
    }

    public final void setSpyAttributes(String string) {
        this.spyAttributes = string;
        if (this.spyAttributes != null) {
            if (this.spyAttributes.charAt(0) == '(') {
                this.spyAttributes = this.spyAttributes.substring(1);
            }
            if (this.spyAttributes.charAt(this.spyAttributes.length() - 1) == ')') {
                this.spyAttributes = this.spyAttributes.substring(0, this.spyAttributes.length() - 1);
            }
        }
    }

    public final boolean getEmbedded() {
        return this.embedded;
    }

    public final void setEmbedded(boolean bl) {
        this.embedded = bl;
    }

    public void setMaxStatements(int n) {
        this.maxPooledStatements = n;
    }

    public void setMaxPooledStatements(int n) {
        this.maxPooledStatements = n;
    }

    public int getMaxStatements() {
        return this.maxPooledStatements;
    }

    public int getMaxPooledStatements() {
        return this.maxPooledStatements;
    }

    public void setInitialPoolSize(int n) {
        this.initialPoolSize = n;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setMinPoolSize(int n) {
        this.minPoolSize = n;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxIdleTime(int n) {
        this.maxIdleTime = n;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setPropertyCycle(int n) {
        this.propertyCycle = n;
    }

    public int getPropertyCycle() {
        return this.propertyCycle;
    }

    public void setInsensitiveResultSetBufferSize(int n) {
        this.insensitiveResultSetBufferSize = n;
    }

    public int getInsensitiveResultSetBufferSize() {
        return this.insensitiveResultSetBufferSize;
    }

    public final String getAlternateServers() {
        return this.alternateServers;
    }

    public final void setAlternateServers(String string) {
        this.alternateServers = string;
    }

    public final void setConnectionRetryCount(int n) {
        this.connectionRetryCount = n;
    }

    public final int getConnectionRetryCount() {
        return this.connectionRetryCount;
    }

    public final void setConnectionRetryDelay(int n) {
        this.connectionRetryDelay = n;
    }

    public final int getConnectionRetryDelay() {
        return this.connectionRetryDelay;
    }

    public final void setLoadBalancing(boolean bl) {
        this.loadBalancing = bl;
    }

    public final boolean getLoadBalancing() {
        return this.loadBalancing;
    }

    public final void setResultsetMetaDataOptions(int n) {
        this.resultsetMetaDataOptions = n;
    }

    public final int getResultsetMetaDataOptions() {
        return this.resultsetMetaDataOptions;
    }

    private void setupLogger() {
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
    }

    protected BaseConnection getBaseConnection() throws SQLException {
        this.setupExceptionHandling();
        BaseConnection baseConnection = BaseClassUtilityX.getConnection(this);
        BaseDriverPropertyInfos baseDriverPropertyInfos = baseConnection.getPropertyInfo();
        BaseConnectionProperties baseConnectionProperties = this.getConnectionProperties(baseDriverPropertyInfos);
        this.debug = BaseDriver.setupDebugging(baseConnectionProperties);
        baseConnectionProperties.validate(baseDriverPropertyInfos, this.exceptions);
        baseConnection.open(baseConnectionProperties, this.exceptions, this.debug);
        return baseConnection;
    }

    protected BaseConnection getBaseConnection(String string, String string2) throws SQLException {
        this.setupExceptionHandling();
        BaseConnection baseConnection = BaseClassUtilityX.getConnection(this);
        BaseDriverPropertyInfos baseDriverPropertyInfos = baseConnection.getPropertyInfo();
        BaseConnectionProperties baseConnectionProperties = this.getConnectionProperties(baseDriverPropertyInfos);
        baseConnectionProperties.put("user", string);
        baseConnectionProperties.put("password", string2);
        this.debug = BaseDriver.setupDebugging(baseConnectionProperties);
        baseConnectionProperties.validate(baseDriverPropertyInfos, this.exceptions);
        baseConnection.open(baseConnectionProperties, this.exceptions, this.debug);
        return baseConnection;
    }

    public final Connection getConnection() throws SQLException {
        BaseConnection baseConnection;
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getConnection()");
        }
        try {
            baseConnection = this.getBaseConnection();
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return baseConnection;
        }
        Connection connection = BaseLog.GetSpyConnection(baseConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + connection + ")");
        return connection;
    }

    public final Connection getConnection(String string, String string2) throws SQLException {
        BaseConnection baseConnection;
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getConnection(String user, String password)");
            BaseLog.Println(this.spyLogger, "user = " + string);
            BaseLog.Println(this.spyLogger, "password = ********");
        }
        try {
            baseConnection = this.getBaseConnection(string, string2);
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return baseConnection;
        }
        Connection connection = BaseLog.GetSpyConnection(baseConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + connection + ")");
        return connection;
    }

    public final PooledConnection getPooledConnection() throws SQLException {
        BasePooledConnection basePooledConnection;
        Object object;
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getPooledConnection()");
        }
        try {
            BasePooledConnection basePooledConnection2;
            object = this.getBaseConnection();
            basePooledConnection = basePooledConnection2 = new BasePooledConnection((BaseConnection)object, this.exceptions);
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return basePooledConnection;
        }
        object = BaseLog.GetSpyPooledConnection(basePooledConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + object + ")");
        return object;
    }

    public final PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        BasePooledConnection basePooledConnection;
        Object object;
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getPooledConnection(String user, String password)");
            BaseLog.Println(this.spyLogger, "user = " + string);
            BaseLog.Println(this.spyLogger, "password = ********");
        }
        try {
            BasePooledConnection basePooledConnection2;
            object = this.getBaseConnection(string, string2);
            basePooledConnection = basePooledConnection2 = new BasePooledConnection((BaseConnection)object, this.exceptions);
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return basePooledConnection;
        }
        object = BaseLog.GetSpyPooledConnection(basePooledConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + object + ")");
        return object;
    }

    public final PrintWriter getLogWriter() throws SQLException {
        this.setupExceptionHandling();
        return this.printWriter;
    }

    public final void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.setupExceptionHandling();
        this.printWriter = printWriter;
        this.spyLogger = printWriter == null ? null : BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
    }

    public final Reference getReference() throws NamingException {
        String string = BaseClassUtilityX.getRootName(this);
        String string2 = "com.metamatrix.jdbcx." + string.toLowerCase() + "." + string + "DataSource";
        Reference reference = new Reference(string2, string2 + "Factory", null);
        if (this.databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.dataSourceName != null) {
            reference.add(new StringRefAddr("dataSourceName", this.dataSourceName));
        }
        if (this.description != null) {
            reference.add(new StringRefAddr("description", this.description));
        }
        if (this.password != null) {
            reference.add(new StringRefAddr("password", this.password));
        }
        if (this.portNumber != null) {
            reference.add(new StringRefAddr("portNumber", this.portNumber));
        }
        if (this.roleName != null) {
            reference.add(new StringRefAddr("roleName", this.roleName));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr("serverName", this.serverName));
        }
        if (this.user != null) {
            reference.add(new StringRefAddr("user", this.user));
        }
        if (this.loginTimeout != 0) {
            reference.add(new StringRefAddr("loginTimeout", new Integer(this.loginTimeout).toString()));
        }
        if (this.embedded) {
            reference.add(new StringRefAddr("embedded", "true"));
        }
        if (this.spyAttributes != null) {
            reference.add(new StringRefAddr("spyAttributes", this.spyAttributes));
        }
        if (this.alternateServers != null) {
            reference.add(new StringRefAddr("alternateServers", this.alternateServers));
        }
        reference.add(new StringRefAddr("resultsetMetaDataOptions", new Integer(this.resultsetMetaDataOptions).toString()));
        reference.add(new StringRefAddr("connectionRetryCount", new Integer(this.connectionRetryCount).toString()));
        reference.add(new StringRefAddr("connectionRetryDelay", new Integer(this.connectionRetryDelay).toString()));
        if (this.loadBalancing) {
            reference.add(new StringRefAddr("loadBalancing", "true"));
        } else {
            reference.add(new StringRefAddr("loadBalancing", "false"));
        }
        reference.add(new StringRefAddr("maxPooledStatements", Integer.toString(this.maxPooledStatements)));
        reference.add(new StringRefAddr("initialPoolSize", Integer.toString(this.initialPoolSize)));
        reference.add(new StringRefAddr("minPoolSize", Integer.toString(this.minPoolSize)));
        reference.add(new StringRefAddr("maxPoolSize", Integer.toString(this.maxPoolSize)));
        reference.add(new StringRefAddr("maxIdleTime", Integer.toString(this.maxIdleTime)));
        reference.add(new StringRefAddr("propertyCycle", Integer.toString(this.propertyCycle)));
        reference.add(new StringRefAddr("insensitiveResultSetBufferSize", Integer.toString(this.insensitiveResultSetBufferSize)));
        if (this.extendedOptions != null) {
            reference.add(new StringRefAddr("extendedOptions", this.extendedOptions));
        }
        BaseConnection baseConnection = BaseClassUtilityX.getConnection(this);
        String string3 = this.batchPerformanceWorkaround ? "true" : "false";
        reference.add(new StringRefAddr("batchPerformanceWorkaround", string3));
        this.implAddProperties(reference);
        return reference;
    }

    protected void implAddProperties(Reference reference) {
    }

    protected String implGetPropertyNameValuePairs() throws SQLException {
        return null;
    }

    protected void setupExceptionHandling() throws SQLException {
        if (this.exceptions == null) {
            this.exceptions = new BaseExceptions(BaseClassUtilityX.getRootName(this));
        }
    }

    protected BaseConnectionProperties getConnectionProperties(BaseDriverPropertyInfos baseDriverPropertyInfos) throws SQLException {
        String string;
        BaseConnectionProperties baseConnectionProperties = new BaseConnectionProperties();
        baseConnectionProperties.putDefaults(baseDriverPropertyInfos);
        String string2 = BaseClassUtilityX.getRootName(this);
        String string3 = "jdbc:datadirect:" + string2 + ":";
        if (this.serverName == null) {
            if (this.portNumber != null) {
                throw this.exceptions.getException(6101);
            }
        } else {
            string3 = string3 + "//" + this.serverName;
            if (this.portNumber != null) {
                string3 = string3 + ":" + this.portNumber;
            }
        }
        if (this.user != null) {
            string3 = string3 + ";user=" + this.user;
        }
        if (this.password != null) {
            string3 = string3 + ";password=" + this.password;
        }
        if (this.databaseName != null) {
            string3 = string3 + ";databaseName=" + this.databaseName;
        }
        if (this.loginTimeout != 0) {
            string3 = string3 + ";loginTimeout=" + new Integer(this.loginTimeout).toString();
        }
        if (this.maxPooledStatements > 0) {
            string3 = string3 + ";maxPooledStatements=" + new Integer(this.maxPooledStatements).toString();
        }
        if (this.embedded) {
            string3 = string3 + ";embedded=true";
        }
        if (this.alternateServers != null) {
            string3 = string3 + ";alternateServers=" + this.alternateServers;
        }
        string3 = string3 + ";batchPerformanceWorkaround=" + this.getBooleanString(this.batchPerformanceWorkaround);
        string3 = string3 + ";insensitiveResultSetBufferSize=" + Integer.toString(this.insensitiveResultSetBufferSize);
        string3 = string3 + ";connectionRetryCount=" + Integer.toString(this.connectionRetryCount);
        string3 = string3 + ";connectionRetryDelay=" + Integer.toString(this.connectionRetryDelay);
        string3 = string3 + ";loadBalancing=" + this.getBooleanString(this.loadBalancing);
        string3 = string3 + ";resultsetMetaDataOptions=" + this.resultsetMetaDataOptions;
        if (this.extendedOptions != null) {
            string3 = string3 + ";" + this.extendedOptions;
        }
        if ((string = this.implGetPropertyNameValuePairs()) != null) {
            string3 = string3 + ";" + string;
        }
        BaseURLParser baseURLParser = BaseClassUtility.getURLParser(string2);
        baseURLParser.parse(string2, string3, baseConnectionProperties);
        return baseConnectionProperties;
    }

    private String getBooleanString(boolean bl) {
        return bl ? "true" : "false";
    }
}

