/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilByteArray;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class UtilTransliteratorForUCS2
extends UtilTransliterator {
    private static String footprint = "$Revision:   3.5.2.0  $";
    private boolean isBigEndian;
    private byte[] temp;
    private int[] rl;
    private InputStream _in;

    public UtilTransliteratorForUCS2() {
        this.setDefaultCacheSize();
        this.isBigEndian = true;
    }

    public boolean isFixedBytesPerChar() {
        return true;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    public void setToBigEndian() {
        this.isBigEndian = true;
    }

    public void setToLittleEndian() {
        this.isBigEndian = false;
    }

    public byte[] encode(String string) throws UtilException {
        if (this.rl == null) {
            this.rl = new int[1];
        }
        return UtilByteArray.duplicate(this.encode(string, this.rl), string.length() * 2);
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n = string.length();
        this.setCacheSize(n);
        string.getChars(0, n, this.charsCache, 0);
        if (this.isBigEndian) {
            int n2 = 0;
            while (n2 < n) {
                char c = this.charsCache[n2];
                this.bytesCache[n2 * 2] = (byte)(c >>> 8);
                this.bytesCache[n2 * 2 + 1] = (byte)c;
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                char c = this.charsCache[n3];
                this.bytesCache[n3 * 2] = (byte)c;
                this.bytesCache[n3 * 2 + 1] = (byte)(c >>> 8);
                ++n3;
            }
        }
        nArray[0] = n * 2;
        return this.bytesCache;
    }

    public void encode(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            if (this.temp == null) {
                this.temp = new byte[this.streamChunkSize];
            }
            while (n > 0) {
                int n2;
                int n3 = Math.min(n, this.streamChunkSize);
                int n4 = inputStream.read(this.temp, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                if (this.isBigEndian) {
                    n2 = 0;
                    while (n2 < n4) {
                        this.bytesCache[n2 * 2] = 0;
                        this.bytesCache[n2 * 2 + 1] = this.temp[n2];
                        ++n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < n4) {
                        this.bytesCache[n2 * 2] = this.temp[n2];
                        this.bytesCache[n2 * 2 + 1] = 0;
                        ++n2;
                    }
                }
                outputStream.write(this.bytesCache, 0, n4 * 2);
                n -= n4;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            while (n > 0) {
                char c;
                int n2;
                int n3 = Math.min(n, this.streamChunkSize);
                int n4 = reader.read(this.charsCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                if (this.isBigEndian) {
                    n2 = 0;
                    while (n2 < n4) {
                        c = this.charsCache[n2];
                        this.bytesCache[n2 * 2] = (byte)(c >>> 8);
                        this.bytesCache[n2 * 2 + 1] = (byte)c;
                        ++n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < n4) {
                        c = this.charsCache[n2];
                        this.bytesCache[n2 * 2] = (byte)c;
                        this.bytesCache[n2 * 2 + 1] = (byte)(c >>> 8);
                        ++n2;
                    }
                }
                outputStream.write(this.bytesCache, 0, n4 * 2);
                n -= n4;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void _decode(byte[] var1_1, int var2_2, char[] var3_3, int var4_4, int var5_5) {
        block2: {
            var6_6 = 0;
            var7_7 = 0;
            if (!this.isBigEndian) ** GOTO lbl13
            while (var7_7 < var5_5) {
                var3_3[var7_7 + var4_4] = (char)((var1_1[var6_6 + var2_2] & 255) << 8 | var1_1[var6_6 + 1 + var2_2] & 255);
                var6_6 += 2;
                ++var7_7;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var3_3[var7_7 + var4_4] = (char)((var1_1[var6_6 + 1 + var2_2] & 255) << 8 | var1_1[var6_6 + var2_2] & 255);
                var6_6 += 2;
                ++var7_7;
lbl13:
                // 2 sources

                ** while (var7_7 < var5_5)
            }
        }
    }

    public String decode(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 == 0) {
            return UtilTransliterator.EMPTY_STRING;
        }
        int n3 = n2 / 2;
        this.setCacheSize(n3);
        this._decode(byArray, n, this.charsCache, 0, n3);
        return new String(this.charsCache, 0, n3);
    }

    public int decode(byte[] byArray, int n, int n2, char[] cArray) throws UtilException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2 / 2;
        if (n3 > cArray.length) {
            n3 = cArray.length;
        }
        this._decode(byArray, n, cArray, 0, n3);
        return n3;
    }

    public String decode(byte[] byArray, int n, int n2, int n3) throws UtilException {
        int n4 = n2 / 2;
        int n5 = Math.max(n4, n3);
        this.setCacheSize(n5);
        this._decode(byArray, n, this.charsCache, 0, n4);
        int n6 = n4;
        while (n6 < n3) {
            this.charsCache[n6] = 32;
            ++n6;
        }
        return new String(this.charsCache, 0, n3);
    }

    public synchronized Reader decodeAsReader(InputStream inputStream) throws UtilException {
        this._in = inputStream;
        return new Reader(){
            private InputStream in;
            private int length;
            private byte[] cache;
            {
                this.in = UtilTransliteratorForUCS2.this._in;
            }

            public int read() throws IOException {
                int n = this.in.read();
                int n2 = this.in.read();
                if (n == -1 || n2 == -1) {
                    return -1;
                }
                if (UtilTransliteratorForUCS2.this.isBigEndian) {
                    return (char)((n & 0xFF) << 8 | n2 & 0xFF);
                }
                return (char)((n2 & 0xFF) << 8 | n & 0xFF);
            }

            public int read(char[] cArray, int n, int n2) throws IOException {
                int n3;
                int n4 = n2 * 2;
                if (this.cache == null || this.cache.length < n4) {
                    this.cache = new byte[n4];
                }
                if ((n3 = this.in.read(this.cache, 0, n4)) <= 0) {
                    return n3;
                }
                int n5 = n3 / 2;
                UtilTransliteratorForUCS2.this._decode(this.cache, 0, cArray, n, n5);
                return n5;
            }

            public void close() throws IOException {
                this.in.close();
            }
        };
    }
}

