/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection;
import com.metamatrix.jdbc.base.BaseCallableStatement;
import com.metamatrix.jdbc.base.BaseCallbleStatement;
import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseConnectionStartup;
import com.metamatrix.jdbc.base.BaseDatabaseMetaData;
import com.metamatrix.jdbc.base.BaseDriverPropertyInfos;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.base.BaseLicenseUtility;
import com.metamatrix.jdbc.base.BasePreparedStatement;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseSQLScanner;
import com.metamatrix.jdbc.base.BaseSQLToken;
import com.metamatrix.jdbc.base.BaseSavepoints;
import com.metamatrix.jdbc.base.BaseStatement;
import com.metamatrix.jdbc.base.BaseStatementPool;
import com.metamatrix.jdbc.base.BaseURLParser;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.extensions.ExtConnection;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;

public abstract class BaseConnection
implements Connection,
ExtConnection,
com.ddtek.jdbc.extensions.ExtEmbeddedConnection,
ExtEmbeddedConnection {
    private static String footprint = "$Revision:   3.51.1.4  $";
    protected String driverName;
    protected BaseConnectionProperties connectProps;
    UtilDebug debug;
    BaseImplConnection implConnection;
    private boolean pingServerDuringIsClosed = false;
    private BaseDatabaseMetaData databaseMetaData;
    private boolean actualAutoCommitMode;
    private boolean exposedAutoCommitMode = true;
    boolean manualTxnWorkStarted = false;
    private boolean readOnlyMode;
    private String currentCatalog;
    private String originalCatalog;
    private int currentTransactionIsolation = -1;
    private int originalTransactionIsolation = -1;
    protected BaseWarnings warnings;
    protected BaseExceptions exceptions;
    protected boolean lockedEmbedding;
    BaseStatementPool statementPool;
    private int supportsSavepoints = -1;
    private BaseSavepoints savepoints;
    protected boolean isXAConnection;
    BaseEscapeTranslator escapeTranslator;
    private boolean autoGeneratedKeysRequested = false;
    boolean isJavaDoubleToString;
    protected int prepareExecuteMode = 0;
    private String clientAppName = "";
    private String clientHostName = "";
    private String clientUser = "";
    private String clientAcctInfo = "";
    Calendar cal = Calendar.getInstance();
    char[] buff = new char[10];
    boolean loginTimedOut = false;
    Object loginTimedOutSync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseDriverPropertyInfos getPropertyInfo() {
        BaseDriverPropertyInfos baseDriverPropertyInfos = new BaseDriverPropertyInfos();
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.getImplPropertyInfo(baseDriverPropertyInfos);
        }
        baseDriverPropertyInfos.put("alternateServers", "List of server connection information used to attempt an alternate connections.", "", null, false);
        if (BaseClassUtility.exposeCtsIncompatibleOptions()) {
            baseDriverPropertyInfos.put("batchPerformanceWorkaround", "Batch Performance Workaround", "false", null, false);
        }
        baseDriverPropertyInfos.put("maxPooledStatements", "Maximum number of PreparedStatement objects to pool.", "0", null, false);
        baseDriverPropertyInfos.put("insensitiveResultSetBufferSize", "Maxiumn memory in KB to use for client-side insensitive scrolling.", "2048", null, false);
        baseDriverPropertyInfos.put("connectionRetryCount", "Max number of times to attempt to retry a connection.", "5", null, false);
        baseDriverPropertyInfos.put("connectionRetryDelay", "Time to delay before retrying connection.", "1", null, false);
        baseDriverPropertyInfos.put("loadBalancing", "Specifies whether to perform load balancing.", "false", null, false);
        baseDriverPropertyInfos.put("resultsetMetaDataOptions", "Integer bit mask for configuring the information returned in ResultSetMetaData resultsets.", "0", null, false);
        baseDriverPropertyInfos.put("javaDoubleToString", "Specifies whether the Java Double to String conversion algorithm should be used.", "false", null, false);
        baseDriverPropertyInfos.put("initializationString", "SQL executed after a connection is established.", "", null, false);
        return baseDriverPropertyInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(BaseConnectionProperties baseConnectionProperties, BaseExceptions baseExceptions, UtilDebug utilDebug) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            int n;
            this.driverName = BaseClassUtility.getRootName(this);
            this.connectProps = baseConnectionProperties;
            this.exceptions = baseExceptions;
            this.debug = utilDebug;
            this.warnings = new BaseWarnings(baseExceptions.getMessages());
            this.readOnlyMode = false;
            this.actualAutoCommitMode = true;
            if (baseConnectionProperties.get("validateIsClosed") != null) {
                this.pingServerDuringIsClosed = baseConnectionProperties.get("validateIsClosed").equalsIgnoreCase("true");
            }
            int n2 = 0;
            if (baseConnectionProperties.get("loginTimeout") != null) {
                n2 = Integer.valueOf(baseConnectionProperties.get("loginTimeout"));
            }
            this.implConnection = this.setupImplConnection(n2);
            this.lockedEmbedding = BaseLicenseUtility.isLocked(this);
            String string = baseConnectionProperties.get("maxPooledStatements");
            if (string != null && (n = Integer.parseInt(string)) > 0) {
                this.statementPool = new BaseStatementPool(n);
            }
            this.isJavaDoubleToString = new Boolean(baseConnectionProperties.get("javaDoubleToString"));
            this.executeInitializationString();
        }
    }

    public void executeInitializationString() throws SQLException {
        try {
            boolean bl = false;
            String string = this.connectProps.get("initializationString");
            if (string != null && string.length() > 0) {
                Statement statement = this.createStatement();
                BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
                String string2 = "";
                if (string.charAt(0) == '(') {
                    int n = string.length() - 1;
                    baseSQLScanner.setup(string.substring(1, n), '\'', '\"');
                } else {
                    baseSQLScanner.setup(string, '\'', '\"');
                }
                BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
                while (baseSQLToken.type != 6) {
                    if (baseSQLToken.type == 15) {
                        statement.addBatch(string2);
                        bl = true;
                        string2 = "";
                    } else {
                        string2 = string2 + baseSQLToken.value;
                    }
                    baseSQLToken = baseSQLScanner.getNextToken();
                }
                if ((string2 = string2.trim()).length() > 0) {
                    statement.addBatch(string2);
                    bl = true;
                    string2 = "";
                }
                if (bl) {
                    statement.executeBatch();
                }
            }
        }
        catch (SQLException sQLException) {
            throw this.exceptions.getException(sQLException, 0, 6110);
        }
    }

    public final synchronized void reset() throws SQLException {
        if (this.implConnection != null) {
            this.commonCloseReset();
            this.commonReset(true);
        }
    }

    public final synchronized void resetXA(boolean bl) throws SQLException {
        if (this.implConnection != null) {
            this.commonCloseResetXA(bl);
            this.commonReset(true);
        }
    }

    private BaseImplConnection setupImplConnection(int n) throws SQLException {
        this.implConnection = this.createImplConnection(this.connectProps);
        this.implConnection.setup(this.connectProps, this.warnings, this.exceptions, this.debug);
        if (!(this.connectProps.get("user") != null && this.connectProps.get("user").length() != 0 || this.implConnection.supportsIntegratedSecurity())) {
            throw this.exceptions.getException(6094);
        }
        this.implConnection.setReadOnly(this.readOnlyMode);
        if (n > 0) {
            this.loginTimedOutSync = new Object();
            final BaseConnection baseConnection = this;
            final int n2 = n;
            final BaseExceptions baseExceptions = this.exceptions;
            try {
                BaseConnectionStartup baseConnectionStartup = (BaseConnectionStartup)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws SQLException {
                        return new BaseConnectionStartup(baseConnection, n2, baseExceptions);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (SQLException)privilegedActionException.getException();
            }
        } else {
            this.connect();
        }
        return this.implConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimedOut() {
        Object object = this.loginTimedOutSync;
        synchronized (object) {
            this.loginTimedOut = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loginTimedOut() {
        if (this.loginTimedOutSync == null) {
            return false;
        }
        Object object = this.loginTimedOutSync;
        synchronized (object) {
            return this.loginTimedOut;
        }
    }

    void connect() throws SQLException {
        Object object;
        if (this.isXAConnection) {
            this.implConnection.prepareForXA();
        }
        String string = this.connectProps.get("alternateServers");
        int n = 1 + Integer.parseInt(this.connectProps.get("connectionRetryCount"));
        int n2 = Integer.parseInt(this.connectProps.get("connectionRetryDelay"));
        boolean bl = false;
        if (string != null && string.length() > 0 && (object = this.connectProps.get("loadBalancing")) != null && ((String)object).equalsIgnoreCase("true")) {
            bl = true;
        }
        object = null;
        Throwable throwable = null;
        SQLException sQLException = null;
        String string2 = null;
        int n3 = 0;
        while (n3 < n) {
            object = this.getConnectPropList((ArrayList)object, this.connectProps, string, bl);
            int n4 = ((ArrayList)object).size();
            boolean bl2 = false;
            int n5 = 0;
            while (n5 < n4) {
                BaseConnectionProperties baseConnectionProperties = (BaseConnectionProperties)((ArrayList)object).get(n5);
                if (baseConnectionProperties != null) {
                    try {
                        if (this.loginTimedOut()) {
                            return;
                        }
                        this.implConnection.setup(baseConnectionProperties, this.warnings, this.exceptions, null);
                        this.implConnection.open();
                        while (throwable != null) {
                            String[] stringArray = new String[]{throwable.getMessage()};
                            this.warnings.add(6001, stringArray, ((SQLException)throwable).getSQLState(), ((SQLException)throwable).getErrorCode());
                            throwable = ((SQLException)throwable).getNextException();
                        }
                        return;
                    }
                    catch (SQLException sQLException2) {
                        String[] stringArray = new String[]{this.connectProps.get("serverName")};
                        string2 = new UtilException(1021, stringArray).getMessage();
                        if (sQLException2.getSQLState().startsWith("08")) {
                            if (sQLException2.getMessage().indexOf(string2) != -1) {
                                bl2 = true;
                                ((ArrayList)object).set(n5, null);
                            }
                            if (throwable == null) {
                                throwable = sQLException2;
                            }
                            if (sQLException != null) {
                                sQLException.setNextException(sQLException2);
                            }
                            sQLException = sQLException2;
                        }
                        throw sQLException2;
                    }
                }
                ++n5;
            }
            if (bl2 && n4 == 1) {
                throw throwable;
            }
            if (n2 > 0) {
                try {
                    Thread.sleep(n2 * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++n3;
        }
        throw throwable;
    }

    private ArrayList getConnectPropList(ArrayList arrayList, BaseConnectionProperties baseConnectionProperties, String string, boolean bl) throws SQLException {
        int n;
        ArrayList<Object> arrayList2;
        Object object;
        ArrayList<BaseConnectionProperties> arrayList3 = arrayList;
        if (arrayList == null) {
            arrayList3 = new ArrayList<BaseConnectionProperties>();
            arrayList3.add(baseConnectionProperties);
            if (string != null && string.length() > 0) {
                BaseConnectionProperties baseConnectionProperties2 = new BaseConnectionProperties();
                object = new StringTokenizer(string, "(),");
                arrayList2 = new ArrayList();
                while (((StringTokenizer)object).hasMoreElements()) {
                    arrayList2.add(((StringTokenizer)object).nextElement());
                }
                String string2 = BaseClassUtility.getRootName(this);
                BaseURLParser baseURLParser = BaseClassUtility.getURLParser(string2);
                n = arrayList2.size();
                int n2 = 0;
                while (n2 < n) {
                    BaseConnectionProperties baseConnectionProperties3 = baseConnectionProperties.copy();
                    StringBuffer stringBuffer = new StringBuffer("jdbc:mmx:");
                    stringBuffer.append(string2);
                    stringBuffer.append("://");
                    stringBuffer.append((String)arrayList2.get(n2));
                    if (!baseURLParser.parse(string2, stringBuffer.toString(), baseConnectionProperties2)) {
                        throw this.exceptions.getException(6098);
                    }
                    this.implConnection.mergeAlternateConnectProps(baseConnectionProperties2, baseConnectionProperties3);
                    arrayList3.add(baseConnectionProperties3);
                    ++n2;
                }
            }
        }
        int n3 = arrayList3.size();
        if (bl && n3 > 1) {
            object = new Random();
            arrayList2 = new ArrayList<Object>(n3);
            int n4 = 0;
            while (n4 < n3) {
                arrayList2.add(null);
                ++n4;
            }
            int n5 = 0;
            while (n5 < n3) {
                n = ((Random)object).nextInt(n3);
                while (true) {
                    if (arrayList2.get(n) == null) break;
                    n = (n + 1) % n3;
                }
                arrayList2.set(n, arrayList3.get(n5));
                ++n5;
            }
            arrayList3 = arrayList2;
        }
        return arrayList3;
    }

    public final synchronized void clearWarnings() throws SQLException {
        this.warnings.clear();
    }

    public final synchronized void close() throws SQLException {
        if (this.implConnection != null) {
            this.commonCloseReset();
            this.commonClose();
        }
    }

    public final synchronized void closeXA(boolean bl) throws SQLException {
        if (this.implConnection != null && !this.lockedEmbedding) {
            this.commonCloseResetXA(bl);
            this.commonClose();
        }
    }

    final void commonClose() throws SQLException {
        if (this.statementPool != null) {
            this.statementPool.empty();
            this.statementPool = null;
        }
        this.implConnection.close();
        this.implConnection = null;
    }

    final void commonReset(boolean bl) throws SQLException {
        this.clientAppName = "";
        this.clientHostName = "";
        this.clientUser = "";
        this.clientAcctInfo = "";
        if (this.originalCatalog != null && this.currentCatalog != null && !this.originalCatalog.equals(this.currentCatalog)) {
            this.setCatalog(this.originalCatalog);
        }
        if (this.originalTransactionIsolation != -1 && this.originalTransactionIsolation != this.currentTransactionIsolation) {
            this.setTransactionIsolation(this.originalTransactionIsolation);
        }
        if (bl) {
            this.setAutoCommit(true);
        }
        this.setReadOnly(false);
        this.implConnection.reset();
    }

    final void commonCloseReset() throws SQLException {
        block2: {
            this.clearWarnings();
            if (this.actualAutoCommitMode) break block2;
            try {
                this.rollback();
            }
            catch (SQLException sQLException) {}
        }
    }

    final void commonCloseResetXA(boolean bl) throws SQLException {
        block2: {
            this.clearWarnings();
            if (bl || this.actualAutoCommitMode) break block2;
            try {
                this.rollback();
            }
            catch (SQLException sQLException) {}
        }
    }

    final void validateSavepoint(String string, Savepoint savepoint, boolean bl) throws SQLException {
        if (this.supportsSavepoints == -1) {
            int n = this.supportsSavepoints = this.getMetaData().supportsSavepoints() ? 1 : 0;
        }
        if (this.supportsSavepoints == 0) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(6003, stringArray);
        }
        if (this.savepoints == null) {
            this.savepoints = new BaseSavepoints(this.exceptions, this);
        }
        if (savepoint != null && !this.savepoints.isValid(savepoint, bl)) {
            throw this.exceptions.getException(6082);
        }
    }

    public final synchronized void commit() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (!this.exposedAutoCommitMode && !this.actualAutoCommitMode) {
            if (this.savepoints != null) {
                this.savepoints.remove();
            }
            this.implConnection.commitTransaction();
            this.manualTxnWorkStarted = false;
        }
    }

    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public final synchronized Statement createStatement(int n, int n2) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.lockedEmbedding) {
            throw this.exceptions.getException(6050);
        }
        this.validateTypeAndConcurrency("createStatement", n, n2);
        BaseStatement baseStatement = new BaseStatement(this, n, n2);
        this.postDownGradeWarnings(baseStatement, n, n2);
        return baseStatement;
    }

    final void validateTypeAndConcurrency(String string, int n, int n2) throws SQLException {
        boolean bl = false;
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                bl = true;
            }
        }
        switch (n2) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(6002, stringArray);
        }
    }

    private void postDownGradeWarnings(Statement statement, int n, int n2) throws SQLException {
        if (n != statement.getResultSetType()) {
            this.warnings.add(6046, "01000");
        }
        if (n2 != statement.getResultSetConcurrency()) {
            this.warnings.add(6047, "01000");
        }
    }

    public final synchronized boolean getAutoCommit() throws SQLException {
        return this.exposedAutoCommitMode;
    }

    public final synchronized boolean getActualAutoCommit() {
        return this.actualAutoCommitMode;
    }

    public final synchronized boolean getManualTxnWorkStarted() {
        return this.manualTxnWorkStarted;
    }

    public final synchronized String getCatalog() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.currentCatalog == null) {
            this.currentCatalog = this.implConnection.getCatalog();
            if (this.originalCatalog == null) {
                this.originalCatalog = this.currentCatalog;
            }
        }
        return this.currentCatalog;
    }

    public boolean getIsJavaDoubleToString() {
        return this.isJavaDoubleToString;
    }

    public final synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.databaseMetaData == null) {
            BaseImplDatabaseMetaData baseImplDatabaseMetaData = this.createImplDatabaseMetaData(this.connectProps);
            baseImplDatabaseMetaData.setup(this);
            this.databaseMetaData = new BaseDatabaseMetaData(this, baseImplDatabaseMetaData);
        }
        return this.databaseMetaData;
    }

    public final synchronized int getTransactionIsolation() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.currentTransactionIsolation == -1) {
            this.currentTransactionIsolation = this.implConnection.getTransactionIsolation();
            if (this.originalTransactionIsolation == -1) {
                this.originalTransactionIsolation = this.currentTransactionIsolation;
            }
        }
        return this.currentTransactionIsolation;
    }

    public final Map getTypeMap() throws SQLException {
        return new HashMap();
    }

    public final synchronized SQLWarning getWarnings() {
        return this.warnings.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClosed() {
        boolean bl;
        boolean bl2 = bl = this.implConnection == null;
        if (this.pingServerDuringIsClosed && !bl) {
            BaseConnection baseConnection = this;
            synchronized (baseConnection) {
                switch (this.implConnection.testConnection()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 2: {
                        Statement statement = null;
                        try {
                            statement = this.createStatement();
                            statement.execute("Test Server Connectivity");
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                                bl = true;
                                String[] stringArray = new String[]{sQLException.getMessage()};
                                this.warnings.add(6001, stringArray, sQLException.getSQLState());
                            }
                            if (statement == null) break;
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException2) {}
                        }
                        break;
                    }
                }
            }
        }
        return bl;
    }

    public final synchronized boolean isReadOnly() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        return this.readOnlyMode;
    }

    public final String nativeSQL(String string) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        BaseEscapeTranslator baseEscapeTranslator = this.getEscapeTranslator();
        baseEscapeTranslator.setWarnings(this.warnings);
        BaseSQL baseSQL = new BaseSQL(string, 3, this.implConnection.quotingChar, baseEscapeTranslator, this.exceptions);
        return baseSQL.getFormatted();
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        if (string != null && string.charAt(0) == '-' && string.charAt(2) == '!' && string.equals("--!ddtc!\n{call ddtc(?)}")) {
            return new BaseCallbleStatement(this);
        }
        return this.prepareCall(string, 1003, 1007);
    }

    public final synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.lockedEmbedding) {
            throw this.exceptions.getException(6050);
        }
        this.validateTypeAndConcurrency("prepareCall", n, n2);
        CallableStatement callableStatement = null;
        if (this.statementPool != null) {
            callableStatement = this.statementPool.getCallableStatement(string, n, n2);
        }
        if (callableStatement == null) {
            BaseCallableStatement baseCallableStatement = new BaseCallableStatement(this, string, n, n2);
            callableStatement = this.statementPool != null ? this.statementPool.makeCallableStatementPoolable(baseCallableStatement) : baseCallableStatement;
        }
        this.postDownGradeWarnings(callableStatement, n, n2);
        return callableStatement;
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public final synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.finalizeTxnMode(false);
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.lockedEmbedding) {
            throw this.exceptions.getException(6050);
        }
        this.validateTypeAndConcurrency("prepareStatement", n, n2);
        PreparedStatement preparedStatement = null;
        if (this.statementPool != null) {
            preparedStatement = this.statementPool.getPreparedStatement(string, n, n2);
        }
        if (preparedStatement == null) {
            BasePreparedStatement basePreparedStatement = new BasePreparedStatement(this, string, n, n2, this.autoGeneratedKeysRequested);
            preparedStatement = this.statementPool != null ? this.statementPool.makePreparedStatementPoolable(basePreparedStatement) : basePreparedStatement;
        }
        this.postDownGradeWarnings(preparedStatement, n, n2);
        return preparedStatement;
    }

    public final synchronized void rollback() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (!this.exposedAutoCommitMode && !this.actualAutoCommitMode) {
            if (this.savepoints != null) {
                this.savepoints.remove();
            }
            this.implConnection.rollbackTransaction();
            this.manualTxnWorkStarted = false;
        }
    }

    public final synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.manualTxnWorkStarted && bl) {
            this.setAutoCommitInternal(true);
            this.manualTxnWorkStarted = false;
        }
        this.exposedAutoCommitMode = bl;
    }

    public final synchronized void setActualAutoCommit(boolean bl) throws SQLException {
        this.setAutoCommitInternal(bl);
    }

    private void setAutoCommitInternal(boolean bl) throws SQLException {
        if (bl) {
            if (!this.actualAutoCommitMode) {
                this.implConnection.stopManualTransactionMode();
                this.actualAutoCommitMode = true;
                if (this.savepoints != null) {
                    this.savepoints.remove();
                }
            }
        } else if (this.actualAutoCommitMode) {
            this.implConnection.startManualTransactionMode();
            this.actualAutoCommitMode = false;
        }
    }

    synchronized boolean finalizeTxnMode(boolean bl) throws SQLException {
        if (this.exposedAutoCommitMode != this.actualAutoCommitMode) {
            try {
                this.setAutoCommitInternal(this.exposedAutoCommitMode);
            }
            catch (SQLException sQLException) {
                throw this.exceptions.getException(sQLException, 6096);
            }
        }
        boolean bl2 = this.manualTxnWorkStarted;
        if (!this.exposedAutoCommitMode && bl) {
            this.manualTxnWorkStarted = true;
        }
        return bl2;
    }

    public final synchronized void setCatalog(String string) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.currentCatalog != null && this.currentCatalog.equals(string)) {
            return;
        }
        if (this.originalCatalog == null) {
            this.originalCatalog = this.getCatalog();
        }
        this.implConnection.setCatalog(string);
        this.currentCatalog = new String(string);
    }

    public final synchronized void setReadOnly(boolean bl) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.readOnlyMode = bl;
        this.implConnection.setReadOnly(bl);
    }

    public final synchronized void setTransactionIsolation(int n) throws SQLException {
        if (n == 2112) {
            this.lockedEmbedding = false;
            return;
        }
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.finalizeTxnMode(false);
        if (this.originalTransactionIsolation == -1) {
            this.originalTransactionIsolation = this.implConnection.getTransactionIsolation();
        }
        this.implConnection.setTransactionIsolation(n);
        this.currentTransactionIsolation = n;
    }

    public final void setTypeMap(Map map) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unlock(String string) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            if (this.lockedEmbedding) {
                this.lockedEmbedding = !BaseLicenseUtility.unlock(string);
            }
            return !this.lockedEmbedding;
        }
    }

    protected abstract void getImplPropertyInfo(BaseDriverPropertyInfos var1);

    protected abstract BaseImplConnection createImplConnection(BaseConnectionProperties var1) throws SQLException;

    public abstract BaseImplDatabaseMetaData createImplDatabaseMetaData(BaseConnectionProperties var1) throws SQLException;

    public BaseEscapeTranslator createEscapeTranslator() throws SQLException {
        return null;
    }

    public final BaseEscapeTranslator getEscapeTranslator() throws SQLException {
        if (this.escapeTranslator == null) {
            this.escapeTranslator = this.createEscapeTranslator();
        }
        return this.escapeTranslator;
    }

    public boolean getBatchIsJDBCCompliant() {
        return true;
    }

    public static Properties makeSpyProperties(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            properties.put(string3, string4);
        }
        return properties;
    }

    public final BaseConnectionProperties getConnectProperties() {
        return this.connectProps;
    }

    public void setHoldability(int n) throws SQLException {
        int n2 = this.getHoldability();
        if (n2 != n) {
            throw this.exceptions.getException(6109);
        }
    }

    public int getHoldability() throws SQLException {
        int n = this.implConnection.getHoldability();
        if (n == -1) {
            n = this.getMetaData().getResultSetHoldability();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Savepoint setSavepoint() throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.validateSavepoint("Connection.setSavepoint", null, false);
            this.finalizeTxnMode(false);
            Savepoint savepoint = null;
            if (!this.actualAutoCommitMode) {
                savepoint = this.savepoints.createSavepoint(null);
                try {
                    this.implConnection.setSavepoint(this.savepoints.getName(savepoint));
                }
                catch (SQLException sQLException) {
                    this.savepoints.remove(savepoint, false);
                    throw sQLException;
                }
            } else {
                throw this.exceptions.getException(6027, "25S01");
            }
            return savepoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Savepoint setSavepoint(String string) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.validateSavepoint("Connection.setSavepoint", null, false);
            this.finalizeTxnMode(false);
            Savepoint savepoint = null;
            if (!this.actualAutoCommitMode) {
                savepoint = this.savepoints.get(string);
                if (savepoint != null) {
                    this.implConnection.implicitReleaseSavepoint(string);
                    savepoint = null;
                }
                savepoint = this.savepoints.createSavepoint(string);
                try {
                    this.implConnection.setSavepoint(string);
                }
                catch (SQLException sQLException) {
                    this.savepoints.remove(savepoint, false);
                    throw sQLException;
                }
            } else {
                throw this.exceptions.getException(6027, "25S01");
            }
            return savepoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback(Savepoint savepoint) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.validateSavepoint("Connection.rollback(Savepoint)", savepoint, true);
            if (!this.exposedAutoCommitMode) {
                if (!this.actualAutoCommitMode) {
                    String string = this.savepoints.getName(savepoint);
                    this.savepoints.remove(savepoint, true);
                    this.implConnection.rollbackTransaction(string);
                }
            } else {
                throw this.exceptions.getException(6027, "25S01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseSavepoint(Savepoint savepoint) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.validateSavepoint("releaseSavepoint.rollback", savepoint, true);
            if (!this.exposedAutoCommitMode) {
                if (!this.actualAutoCommitMode) {
                    String string = this.savepoints.getName(savepoint);
                    this.savepoints.remove(savepoint, true);
                    this.implConnection.releaseSavepoint(string);
                }
            } else {
                throw this.exceptions.getException(6027, "25S01");
            }
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        String[] stringArray = new String[]{"Connection.createStatement"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        String[] stringArray = new String[]{"Connection.prepareStatement"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        String[] stringArray = new String[]{"Connection.prepareCall"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        block6: {
            block5: {
                try {
                    if (n != 2) break block5;
                    PreparedStatement preparedStatement = this.prepareStatement(string);
                    Object var5_7 = null;
                    this.autoGeneratedKeysRequested = false;
                    return preparedStatement;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    this.autoGeneratedKeysRequested = false;
                    throw throwable;
                }
            }
            if (n != 1) {
                String[] stringArray = new String[]{"Connection.prepareStatement"};
                throw this.exceptions.getException(6069, stringArray);
            }
            if (!this.getMetaData().supportsGetGeneratedKeys()) break block6;
            this.autoGeneratedKeysRequested = true;
            PreparedStatement preparedStatement = this.prepareStatement(string);
            Object var5_8 = null;
            this.autoGeneratedKeysRequested = false;
            return preparedStatement;
        }
        String[] stringArray = new String[]{"Connection.prepareStatement"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        String[] stringArray = new String[]{"Connection.prepareStatement"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        String[] stringArray2 = new String[]{"Connection.prepareStatement"};
        throw this.exceptions.getException(6003, stringArray2);
    }

    public void prepareForXA() {
        this.isXAConnection = true;
    }

    public synchronized void setClientApplicationName(String string) throws SQLException {
        if (string == null) {
            String[] stringArray = new String[]{"ExtConnection.setClientApplicationName"};
            throw this.exceptions.getException(6069, stringArray);
        }
        String string2 = this.implConnection.setClientApplicationName(string);
        if (!string2.equals(string)) {
            this.warnings.add(6100);
        }
        this.clientAppName = string2;
    }

    public synchronized String getClientApplicationName() throws SQLException {
        return this.clientAppName;
    }

    public synchronized void setClientHostName(String string) throws SQLException {
        if (string == null) {
            String[] stringArray = new String[]{"ExtConnection.setClientHostName"};
            throw this.exceptions.getException(6069, stringArray);
        }
        String string2 = this.implConnection.setClientHostName(string);
        if (!string2.equals(string)) {
            this.warnings.add(6100);
        }
        this.clientHostName = string2;
    }

    public synchronized String getClientHostName() throws SQLException {
        return this.clientHostName;
    }

    public synchronized void setClientUser(String string) throws SQLException {
        if (string == null) {
            String[] stringArray = new String[]{"ExtConnection.setClientUser"};
            throw this.exceptions.getException(6069, stringArray);
        }
        String string2 = this.implConnection.setClientUser(string);
        if (!string2.equals(string)) {
            this.warnings.add(6100);
        }
        this.clientUser = string2;
    }

    public synchronized String getClientUser() throws SQLException {
        return this.clientUser;
    }

    public synchronized void setClientAccountingInfo(String string) throws SQLException {
        if (string == null) {
            String[] stringArray = new String[]{"ExtConnection.setClientAccountingInfo"};
            throw this.exceptions.getException(6069, stringArray);
        }
        String string2 = this.implConnection.setClientAccountingInfo(string);
        if (!string2.equals(string)) {
            this.warnings.add(6100);
        }
        this.clientAcctInfo = string2;
    }

    public synchronized String getClientAccountingInfo() throws SQLException {
        return this.clientAcctInfo;
    }
}

