/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerConnection;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSExecuteRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSLoginRequest;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Properties;

public final class SQLServerImplConnection
extends BaseImplConnection {
    private static String footprint = "$Revision:   3.42.1.5  $";
    SQLServerConnection connection;
    TDSConnection conn;
    boolean useServerSideCursor;
    boolean useImplicitTransactions;
    int maxRows;
    int maxFieldSize;
    public static int defaultMaxFieldSize = Integer.MAX_VALUE;
    int maxPrecision = -1;
    public SQLServerByteOrderedDataWriter writer;
    public SQLServerByteOrderedDataReader reader;
    public boolean useServerSideUpdatableCursors;
    public boolean useODBCCompatibleComputeColumnNames;
    public int lockingModeConcurrency;
    public static final int PESSIMISTIC_CONCURRENCY = 0;
    public static final int OPTIMISTIC_CONCURRENCY = 1;
    boolean sendStringParametersAsUnicode;
    boolean alwaysReportTriggerResults;
    public int receiveStringParameterType;
    public static final int NVARCHAR = 0;
    public static final int VARCHAR = 1;
    public static final int DESCRIBE = 2;

    public SQLServerImplConnection(SQLServerConnection sQLServerConnection) {
        this.connection = sQLServerConnection;
        this.quotingChar = (char)39;
        this.maxFieldSize = defaultMaxFieldSize;
    }

    public void open() throws SQLException {
        block22: {
            String string;
            int n;
            Object object;
            String string2 = this.connectProps.get("receiveStringParameterType");
            this.receiveStringParameterType = string2 == null ? 0 : (string2.equalsIgnoreCase("nvarchar") ? 0 : (string2.equalsIgnoreCase("varchar") ? 1 : (string2.equalsIgnoreCase("describe") ? 2 : 0)));
            String string3 = this.connectProps.get("alwaysReportTriggerResults");
            this.alwaysReportTriggerResults = string3 != null && string3.equalsIgnoreCase("true");
            String string4 = this.connectProps.get("codePageOverride");
            String string5 = this.connectProps.get("sendStringParametersAsUnicode");
            if (string5 == null) {
                this.sendStringParametersAsUnicode = true;
            } else if (!string5.equalsIgnoreCase("false")) {
                if (string4 == null || string4.length() == 0) {
                    this.sendStringParametersAsUnicode = true;
                } else {
                    object = new String[]{"sendStringParametersAsUnicode"};
                    this.warnings.add(7016, (String[])object);
                    this.sendStringParametersAsUnicode = false;
                }
            } else {
                this.sendStringParametersAsUnicode = false;
            }
            object = this.connectProps.get("replyBufferSize");
            int n2 = 0;
            if (object != null) {
                try {
                    n2 = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = this.connectProps.get("packetSize");
            int n3 = 8192;
            if (object != null) {
                try {
                    n = Integer.parseInt((String)object);
                    n3 = n == -1 ? 65024 : (n == 0 ? 8192 : (n > 127 ? 65024 : n * 512));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = this.connectProps.get("longDataCacheSize");
            n = 0x200000;
            if (object != null) {
                try {
                    n = Integer.parseInt((String)object);
                    if (n == 0) {
                        n = 0x200000;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string6 = this.connectProps.get("selectMethod");
            this.useServerSideCursor = string6.equalsIgnoreCase("cursor");
            String string7 = this.connectProps.get("transactionMode");
            this.useImplicitTransactions = true;
            if (string7 != null) {
                this.useImplicitTransactions = string7.equalsIgnoreCase("implicit");
            }
            object = this.connectProps.get("computeColumnNames");
            this.useODBCCompatibleComputeColumnNames = false;
            if (object != null && ((String)object).equalsIgnoreCase("true")) {
                this.useODBCCompatibleComputeColumnNames = true;
            }
            if ((string = this.connectProps.get("useServerSideUpdatableCursors")) != null) {
                this.useServerSideUpdatableCursors = string.equalsIgnoreCase("true");
            }
            Properties properties = this.connectProps.getSocketDebugProperties();
            this.conn = new TDSConnection(this.connectProps.get("serverName"), this.connectProps.get("portNumber"), this.connectProps.get("user"), this.connectProps.get("authenticationMethod"), n2, n3, n, string4, properties, this.warnings, this.exceptions, this.connection);
            this.writer = this.conn.getWriter();
            this.reader = this.conn.createReader();
            TDSLoginRequest tDSLoginRequest = new TDSLoginRequest(this.conn, this.reader, this.writer, this.warnings, this.connectProps.get("user"), this.connectProps.get("password"), this.connectProps.get("databaseName"), this.connectProps.get("programName"), this.connectProps.get("hostProcess"), this.connectProps.get("netAddress"), this.connectProps.get("WSID"));
            tDSLoginRequest.submitRequest(null);
            this.cacheMaxPrecision();
            this.lockingModeConcurrency = 0;
            object = this.connectProps.get("lockingMode");
            if (object == null) break block22;
            try {
                if (((String)object).equalsIgnoreCase("optimistic")) {
                    this.lockingModeConcurrency = 1;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void close() throws SQLException {
        this.conn.close();
    }

    protected BaseImplStatement createImplStatement(int n, int n2) throws SQLException {
        return new SQLServerImplStatement(this.conn, n, n2, this.exceptions);
    }

    public int getEmptyRowInsertSyntax() {
        return 1;
    }

    protected void startManualTransactionMode() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        if (this.useImplicitTransactions) {
            tDSExecuteRequest.setSQL("SET IMPLICIT_TRANSACTIONS ON");
        } else {
            tDSExecuteRequest.setSQL("BEGIN TRAN");
        }
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    protected void commitTransaction() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        if (this.useImplicitTransactions) {
            tDSExecuteRequest.setSQL("IF @@TRANCOUNT > 0 COMMIT TRAN");
        } else {
            tDSExecuteRequest.setSQL("IF @@TRANCOUNT > 0 COMMIT TRAN BEGIN TRAN");
        }
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    protected void rollbackTransaction() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        tDSExecuteRequest.setSQL("IF @@TRANCOUNT > 0 ROLLBACK TRAN");
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    protected void rollbackTransaction(String string) throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        tDSExecuteRequest.setSQL("IF @@TRANCOUNT > 0 ROLLBACK TRAN " + string);
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    protected void setSavepoint(String string) throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        tDSExecuteRequest.setSQL("IF @@TRANCOUNT = 0 BEGIN TRAN ; SAVE TRAN " + string);
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    protected void stopManualTransactionMode() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        tDSExecuteRequest.setSQL("IF @@TRANCOUNT > 0 COMMIT TRAN SET IMPLICIT_TRANSACTIONS OFF");
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    protected int getTransactionIsolation() throws SQLException {
        return 2;
    }

    protected void setTransactionIsolation(int n) throws SQLException {
        String string = new String("SET TRANSACTION ISOLATION LEVEL ");
        switch (n) {
            case 2: {
                string = string + "READ COMMITTED";
                break;
            }
            case 1: {
                string = string + "READ UNCOMMITTED";
                break;
            }
            case 4: {
                string = string + "REPEATABLE READ";
                break;
            }
            case 8: {
                String string2 = this.connectProps.get("snapshotSerializable");
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    if (this.conn.getDatabaseMajorVersion() < 9) {
                        throw this.exceptions.getException(7023);
                    }
                    string = string + "SNAPSHOT";
                    break;
                }
                string = string + "SERIALIZABLE";
                break;
            }
            case 16: {
                if (this.conn.getDatabaseMajorVersion() < 9) {
                    throw this.exceptions.getException(7023);
                }
                string = string + "SNAPSHOT";
            }
        }
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        tDSExecuteRequest.setSQL(string);
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    protected String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    protected void setCatalog(String string) throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        tDSExecuteRequest.setSQL("USE " + string);
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    private void cacheMaxPrecision() {
        block2: {
            if (this.maxPrecision >= 0) break block2;
            try {
                TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
                tDSExecuteRequest.setSQL("select @@MAX_PRECISION");
                tDSExecuteRequest.submitRequest(null);
                tDSExecuteRequest.processReply(1, null);
                tDSExecuteRequest.getRow(null);
                tDSExecuteRequest.getColumnDataForRow(1, 4);
                this.maxPrecision = tDSExecuteRequest.getColumn((int)1).data.getIntegerNoConvert();
                tDSExecuteRequest.discardReplyBytes();
            }
            catch (SQLException sQLException) {
                this.maxPrecision = 28;
            }
        }
    }

    public static String mapNativeErrorToSQLState(int n) {
        switch (n) {
            case 919: 
            case 926: 
            case 3606: 
            case 3607: 
            case 3622: 
            case 5701: 
            case 5703: {
                return "01000";
            }
            case 16934: 
            case 16947: {
                return "01001";
            }
            case 8153: {
                return "01003";
            }
            case 120: 
            case 121: {
                return "07008";
            }
            case 911: 
            case 916: 
            case 2740: 
            case 4017: 
            case 4019: 
            case 17809: 
            case 18450: 
            case 18458: {
                return "08004";
            }
            case 512: {
                return "21000";
            }
            case 109: 
            case 110: 
            case 213: {
                return "21S01";
            }
            case 4409: 
            case 4501: 
            case 4502: {
                return "21S02";
            }
            case 8115: 
            case 8152: {
                return "22001";
            }
            case 168: 
            case 220: 
            case 232: 
            case 236: 
            case 237: 
            case 238: 
            case 240: 
            case 244: 
            case 246: 
            case 248: 
            case 535: 
            case 1007: {
                return "22003";
            }
            case 210: 
            case 211: 
            case 241: 
            case 242: 
            case 295: 
            case 296: 
            case 517: {
                return "22007";
            }
            case 8134: {
                return "22012";
            }
            case 206: 
            case 235: 
            case 245: 
            case 247: 
            case 249: 
            case 256: 
            case 305: 
            case 409: 
            case 518: 
            case 529: {
                return "22018";
            }
            case 1010: {
                return "22019";
            }
            case 310: {
                return "22025";
            }
            case 221: 
            case 233: 
            case 234: 
            case 272: 
            case 273: 
            case 544: 
            case 547: 
            case 1505: 
            case 1508: 
            case 2601: 
            case 2615: 
            case 2627: 
            case 3604: 
            case 3605: 
            case 8101: {
                return "23000";
            }
            case 16930: 
            case 16931: {
                return "24000";
            }
            case 266: 
            case 628: 
            case 3902: 
            case 3903: 
            case 3906: 
            case 3908: 
            case 6401: {
                return "25000";
            }
            case 4002: 
            case 18456: 
            case 18459: {
                return "28000";
            }
            case 16916: {
                return "34000";
            }
            case 1205: 
            case 1211: 
            case 7112: {
                return "40001";
            }
            case 229: 
            case 230: {
                return "42000";
            }
            case 2714: {
                return "42S01";
            }
            case 208: 
            case 239: 
            case 267: 
            case 1906: 
            case 2501: 
            case 2706: 
            case 3701: 
            case 4401: 
            case 4701: 
            case 4902: 
            case 4924: {
                return "42S02";
            }
            case 1913: {
                return "42S11";
            }
            case 3718: {
                return "42S12";
            }
            case 2705: 
            case 2727: 
            case 4506: {
                return "42S21";
            }
            case 207: {
                return "42S22";
            }
            case 550: {
                return "44000";
            }
            case 16902: {
                return "HY109";
            }
            case 4060: {
                return "08001";
            }
        }
        return "HY000";
    }

    public boolean supportsCancel() {
        return true;
    }

    public boolean supportsQueryTimeout() {
        return false;
    }

    public boolean supportsIntegratedSecurity() {
        return true;
    }

    protected boolean enableXlobOnLongVarX() {
        return true;
    }

    public int getTDSVersion() {
        return this.conn.getTDSVersion();
    }

    public void reset() throws SQLException {
        this.conn.resetTransliteratorPool();
    }

    public Socket getQueryTimeoutSocket() {
        return this.conn.socket;
    }
}

