/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.db2;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.db2.DB2Connection;
import com.metamatrix.jdbc.db2.drda.DRDAConstants;
import com.metamatrix.jdbcx.base.BaseImplXAResource;
import com.metamatrix.jdbcx.base.BaseXADataSource;
import com.metamatrix.jdbcx.db2.DB2ImplXAResource;
import com.metamatrix.util.UtilType4SecurityContext;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class DB2DataSource
extends BaseXADataSource {
    private static String footprint = "$Revision:   3.23.1.1  $";
    String collectionId;
    String locationName;
    String packageName;
    String conversationType;
    int maxCachedBlobLen;
    int bufferSize;
    boolean withHoldCursors = true;
    String addToCreateTable;
    boolean forceFixRow;
    String codePageOverride;
    boolean stripNewlines = true;
    boolean catalogIncludesSynonyms = true;
    boolean allowImplicitResultSetCloseForXA = true;
    String alternateID;
    String securityMechanism = "ClearText";
    String authenticationMethod = "ClearText";
    String charSetFor65535;
    String catalogSchema;
    boolean useCurrentSchema;
    boolean sendStreamAsBlob;
    boolean enableCancelTimeout;
    boolean createDefaultPackage;
    boolean dropDefaultPackage;
    boolean grantExecute;
    String grantee;
    String decimalDelimiter;
    int decimalPrecision;
    String stringDelimiter;
    String isolationLevel;
    String resourceRelease;
    int dynamicSections = Integer.parseInt(DRDAConstants.DEFAULT_DYNAMIC_SECTIONS_STRING);
    boolean replacePackage;
    String packageOwner;
    String defaultQualifier;
    String versionName;

    public DB2DataSource() {
        super.setPortNumber(50000);
        this.collectionId = DRDAConstants.DEFAULT_COLLECTION_ID_PROP;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public String getPackageCollection() {
        return this.collectionId;
    }

    public boolean getForceFixRow() {
        return this.forceFixRow;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean getWithHoldCursors() {
        return this.withHoldCursors;
    }

    public boolean getCreateDefaultPackage() {
        return this.createDefaultPackage;
    }

    public boolean getDropDefaultPackage() {
        return this.dropDefaultPackage;
    }

    public String getAddToCreateTable() {
        return this.addToCreateTable;
    }

    public boolean getStripNewlines() {
        return this.stripNewlines;
    }

    public String getAlternateID() {
        return this.alternateID;
    }

    public boolean getCatalogIncludesSynonyms() {
        return this.catalogIncludesSynonyms;
    }

    public String getCodePageOverride() {
        return this.codePageOverride;
    }

    public String getSecurityMechanism() {
        return this.securityMechanism;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public String getCharSetFor65535() {
        return this.charSetFor65535;
    }

    public String getCatalogSchema() {
        return this.catalogSchema;
    }

    public boolean getUseCurrentSchema() {
        return this.useCurrentSchema;
    }

    public boolean getSendStreamAsBlob() {
        return this.sendStreamAsBlob;
    }

    public boolean getGrantExecute() {
        return this.grantExecute;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    public int getDynamicSections() {
        return this.dynamicSections;
    }

    public boolean getReplacePackage() {
        return this.replacePackage;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getPackageOwner() {
        return this.packageOwner;
    }

    public String getDefaultQualifier() {
        return this.defaultQualifier;
    }

    public boolean getAllowImplicitResultSetCloseForXA() {
        return this.allowImplicitResultSetCloseForXA;
    }

    public boolean getEnableCancelTimeout() {
        return this.enableCancelTimeout;
    }

    public void setEnableCancelTimeout(boolean bl) {
        this.enableCancelTimeout = bl;
    }

    public void setAllowImplicitResultSetCloseForXA(boolean bl) {
        this.allowImplicitResultSetCloseForXA = bl;
    }

    public void setCatalogIncludesSynonyms(boolean bl) {
        this.catalogIncludesSynonyms = bl;
    }

    public void setStripNewlines(boolean bl) {
        this.stripNewlines = bl;
    }

    public void setAlternateID(String string) {
        this.alternateID = string;
    }

    public void setCollectionId(String string) {
        this.collectionId = string;
    }

    public void setPackageCollection(String string) {
        this.collectionId = string;
    }

    public void setForceFixRow(boolean bl) {
        this.forceFixRow = bl;
    }

    public void setLocationName(String string) {
        this.locationName = string;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public void setWithHoldCursors(boolean bl) {
        this.withHoldCursors = bl;
    }

    public void setCreateDefaultPackage(boolean bl) {
        this.createDefaultPackage = bl;
    }

    public void setCodePageOverride(String string) {
        this.codePageOverride = string;
    }

    public void setDropDefaultPackage(boolean bl) {
        this.dropDefaultPackage = bl;
    }

    public void setGrantExecute(boolean bl) {
        this.grantExecute = bl;
    }

    public void setGrantee(String string) {
        this.grantee = string;
    }

    public void setIsolationLevel(String string) {
        this.isolationLevel = string;
    }

    public void setAddToCreateTable(String string) {
        this.addToCreateTable = string;
    }

    public void setDynamicSections(int n) {
        this.dynamicSections = n;
    }

    public void setReplacePackage(boolean bl) {
        this.replacePackage = bl;
    }

    public void setVersionName(String string) {
        this.versionName = string;
    }

    public void setPackageOwner(String string) {
        this.packageOwner = string;
    }

    public void setDefaultQualifier(String string) {
        this.defaultQualifier = string;
    }

    public void setSecurityMechanism(String string) {
        this.securityMechanism = string;
    }

    public void setAuthenticationMethod(String string) {
        this.authenticationMethod = string;
    }

    public void setCharSetFor65535(String string) {
        this.charSetFor65535 = string;
    }

    public void setCatalogSchema(String string) {
        this.catalogSchema = string;
    }

    public void setUseCurrentSchema(boolean bl) {
        this.useCurrentSchema = bl;
    }

    public void setSendStreamAsBlob(boolean bl) {
        this.sendStreamAsBlob = bl;
    }

    protected void implAddProperties(Reference reference) {
        if (this.locationName != null) {
            reference.add(new StringRefAddr("locationName", this.locationName));
        }
        if (this.addToCreateTable != null) {
            reference.add(new StringRefAddr("addToCreateTable", this.addToCreateTable));
        }
        if (this.packageOwner != null) {
            reference.add(new StringRefAddr("packageOwner", this.packageOwner));
        }
        if (this.defaultQualifier != null) {
            reference.add(new StringRefAddr("defaultQualifier", this.defaultQualifier));
        }
        if (this.alternateID != null) {
            reference.add(new StringRefAddr("alternateID", this.alternateID));
        }
        if (this.codePageOverride != null) {
            reference.add(new StringRefAddr("codePageOverride", this.codePageOverride));
        }
        if (this.collectionId != null) {
            reference.add(new StringRefAddr("packageCollection", this.collectionId));
        }
        if (this.grantee != null) {
            reference.add(new StringRefAddr("grantee", this.grantee));
        }
        if (this.securityMechanism != null) {
            reference.add(new StringRefAddr("securityMechanism", this.securityMechanism));
        }
        if (this.authenticationMethod != null) {
            reference.add(new StringRefAddr("authenticationMethod", this.authenticationMethod));
        }
        if (this.charSetFor65535 != null) {
            reference.add(new StringRefAddr("charSetFor65535", this.charSetFor65535));
        }
        if (this.catalogSchema != null) {
            reference.add(new StringRefAddr("catalogSchema", this.catalogSchema));
        }
        reference.add(new StringRefAddr("useCurrentSchema", String.valueOf(this.useCurrentSchema)));
        if (BaseClassUtility.exposeCtsIncompatibleOptions()) {
            reference.add(new StringRefAddr("withHoldCursors", String.valueOf(this.withHoldCursors)));
        }
        reference.add(new StringRefAddr("createDefaultPackage", String.valueOf(this.createDefaultPackage)));
        reference.add(new StringRefAddr("grantExecute", String.valueOf(this.grantExecute)));
        reference.add(new StringRefAddr("dynamicSections", String.valueOf(this.dynamicSections)));
        reference.add(new StringRefAddr("replacePackage", String.valueOf(this.replacePackage)));
        reference.add(new StringRefAddr("catalogIncludesSynonyms", String.valueOf(this.catalogIncludesSynonyms)));
        reference.add(new StringRefAddr("allowImplicitResultSetCloseForXA", String.valueOf(this.allowImplicitResultSetCloseForXA)));
        reference.add(new StringRefAddr("stripNewlines", String.valueOf(this.stripNewlines)));
        reference.add(new StringRefAddr("enableCancelTimeout", String.valueOf(this.enableCancelTimeout)));
        if (BaseClassUtility.exposeCtsIncompatibleOptions()) {
            reference.add(new StringRefAddr("sendStreamAsBlob", String.valueOf(this.sendStreamAsBlob)));
        }
    }

    protected String implGetPropertyNameValuePairs() throws SQLException {
        String string = "createDefaultPackage=" + String.valueOf(this.createDefaultPackage);
        if (BaseClassUtility.exposeCtsIncompatibleOptions()) {
            string = string + ";withHoldCursors=" + String.valueOf(this.withHoldCursors);
        }
        if (this.locationName != null) {
            string = string + ";locationName=" + this.locationName;
        }
        if (this.collectionId != null) {
            string = string + ";packageCollection=" + this.collectionId;
        }
        if (this.grantee != null) {
            string = string + ";grantee=" + this.grantee;
        }
        if (this.addToCreateTable != null) {
            string = string + ";addToCreateTable=" + this.addToCreateTable;
        }
        if (this.packageOwner != null) {
            string = string + ";packageOwner=" + this.packageOwner;
        }
        if (this.defaultQualifier != null) {
            string = string + ";defaultQualifier=" + this.defaultQualifier;
        }
        if (this.alternateID != null) {
            string = string + ";alternateID=" + this.alternateID;
        }
        if (this.codePageOverride != null) {
            string = string + ";codePageOverride=" + this.codePageOverride;
        }
        if (this.securityMechanism != null) {
            string = string + ";securityMechanism=" + this.securityMechanism;
        }
        if (this.authenticationMethod != null) {
            string = string + ";authenticationMethod=" + this.authenticationMethod;
        }
        if (this.charSetFor65535 != null) {
            string = string + ";charSetFor65535=" + this.charSetFor65535;
        }
        if (this.catalogSchema != null) {
            string = string + ";catalogSchema=" + this.catalogSchema;
        }
        string = string + ";useCurrentSchema=" + String.valueOf(this.useCurrentSchema);
        string = string + ";grantExecute=" + String.valueOf(this.grantExecute);
        string = string + ";dynamicSections=" + String.valueOf(this.dynamicSections);
        string = string + ";replacePackage=" + String.valueOf(this.replacePackage);
        string = string + ";catalogIncludesSynonyms=" + String.valueOf(this.catalogIncludesSynonyms);
        string = string + ";allowImplicitResultSetCloseForXA=" + String.valueOf(this.allowImplicitResultSetCloseForXA);
        string = string + ";stripNewlines=" + String.valueOf(this.stripNewlines);
        string = string + ";enableCancelTimeout=" + String.valueOf(this.enableCancelTimeout);
        if (BaseClassUtility.exposeCtsIncompatibleOptions()) {
            string = string + ";sendStreamAsBlob=" + String.valueOf(this.sendStreamAsBlob);
        }
        return string;
    }

    protected BaseImplXAResource createImplXAResource(BaseConnection baseConnection) throws SQLException {
        if (((DB2Connection)baseConnection).implCon.comm.supportsXA) {
            return new DB2ImplXAResource(baseConnection);
        }
        throw ((DB2Connection)baseConnection).implCon.exceptions.getException(7094);
    }

    public String getAuthenticatedUser(String string) {
        String string2;
        if (!this.securityMechanism.equalsIgnoreCase(this.authenticationMethod)) {
            if (this.securityMechanism.equalsIgnoreCase("ClearText")) {
                string2 = this.authenticationMethod;
            } else {
                if (!this.authenticationMethod.equalsIgnoreCase("ClearText")) {
                    return "";
                }
                string2 = this.securityMechanism;
            }
        } else {
            string2 = this.authenticationMethod;
        }
        if (string2.equalsIgnoreCase("Client")) {
            return System.getProperty("user.name");
        }
        if (string2.equalsIgnoreCase("kerberos")) {
            return UtilType4SecurityContext.getPrincipalName();
        }
        return "";
    }
}

