/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.sql;

import com.metamatrix.common.util.DateUtil;
import com.metamatrix.core.util.Stopwatch;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class SQLProcessor {
    private Stopwatch stopWatch = null;
    private PrintStream statLog = null;
    private PrintStream logger = null;
    private boolean continueOnError;
    private boolean commitEachCall;
    private Connection connection;
    private boolean printResults = false;
    private int continueOnErrormaxAllowed = Integer.MAX_VALUE;
    private int errorCnt = 0;
    public static final String SELECT = "SELECT";
    public static final String DELETE = "DELETE";
    public static final String INSERT = "INSERT";
    public static final String UPDATE = "UPDATE";
    public static final String NULL = "(NULL)";
    public static final String ROWS_AFFECTED = "Rows Affected:";

    public SQLProcessor() {
        this.logger = System.out;
        this.stopWatch = new Stopwatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeListOfStatements(Connection theConnection, List listOfSQLStatements, Properties props, PrintStream logger) throws Exception {
        FileOutputStream sfos;
        int cnt;
        block13: {
            String sIsoLevel;
            if (logger != null) {
                this.logger = logger;
            }
            cnt = 0;
            this.connection = theConnection;
            if (props == null) {
                props = new Properties();
            }
            sfos = null;
            String statFileName = props.getProperty("statfile");
            if (statFileName != null) {
                sfos = new FileOutputStream(new File(statFileName));
                this.statLog = new PrintStream(sfos);
            }
            String coe = props.getProperty("continueOnError", "false");
            this.continueOnError = Boolean.valueOf(coe);
            String commitCall = props.getProperty("commitEachCall", "true");
            this.commitEachCall = new Boolean(commitCall);
            String coeMax = props.getProperty("discontineuOnErrorCnt");
            if (coeMax != null && coeMax.length() > 0) {
                this.continueOnErrormaxAllowed = Integer.parseInt(coeMax);
            }
            if ((sIsoLevel = props.getProperty("isolationLevel", "")) != null && sIsoLevel.length() > 0) {
                this.setTransactionLevel(theConnection, sIsoLevel);
            } else {
                int isolevel = theConnection.getTransactionIsolation();
                this.writeStatLog("Use Default IsolationLevel: " + isolevel);
            }
            boolean orig_autocommit = false;
            if (this.commitEachCall) {
                orig_autocommit = theConnection.getAutoCommit();
                theConnection.setAutoCommit(true);
            }
            if (this.statLog != null) {
                this.stopWatch.printStatistics(this.statLog);
            }
            try {
                cnt = this.executeListOfStatments(listOfSQLStatements);
                Object var14_13 = null;
                if (!this.commitEachCall) break block13;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (this.commitEachCall) {
                    theConnection.setAutoCommit(orig_autocommit);
                }
                if (sfos != null) {
                    sfos.flush();
                    sfos.close();
                }
                throw throwable;
            }
            theConnection.setAutoCommit(orig_autocommit);
        }
        if (sfos != null) {
            sfos.flush();
            sfos.close();
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeListOfStatments(List listOfSQLStatements) throws Exception {
        String sql = "";
        int cnt = 0;
        this.writeStatLog("\tShould excute " + listOfSQLStatements.size() + " statements");
        this.writeStatLog("\tCommit after each call: " + this.commitEachCall);
        this.writeStatLog("\tContinue on error " + this.continueOnError);
        Iterator it = listOfSQLStatements.iterator();
        this.writeStatLog("Execution Started\t" + DateUtil.getCurrentDateAsString());
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj == null || obj.toString().length() == 0) continue;
            if (obj instanceof StringBuffer) {
                StringBuffer buffer = (StringBuffer)obj;
                sql = buffer.toString();
            } else {
                sql = (String)obj;
            }
            try {
                this.stopWatch.start();
                this.execute(sql);
            }
            catch (SQLException sqle) {
                if (this.logger != null) {
                    this.logger.print("\n*** ERROR *** executing sql statement: " + sql);
                    this.logger.print("\n*** MSG ***\n" + sqle.getMessage());
                }
                ++this.errorCnt;
                if (this.continueOnError) {
                    if (this.errorCnt < this.continueOnErrormaxAllowed) continue;
                    this.logger.print("\n*** REACHED MAX ALLOWED ERRORS OF " + this.errorCnt + ", WILL STOP");
                    throw sqle;
                }
                throw sqle;
            }
            catch (Exception ex) {
                if (this.logger != null) {
                    this.logger.print("\n*** ERROR *** executing sql statement: " + sql);
                    this.logger.print("\n*** MSG ***\n" + ex.getMessage());
                }
                ++this.errorCnt;
                if (this.continueOnError) {
                    if (this.errorCnt < this.continueOnErrormaxAllowed) continue;
                    this.logger.print("\n*** REACHED MAX ALLOWED ERRORS OF " + this.errorCnt + ", WILL STOP");
                    throw ex;
                }
                throw ex;
            }
            finally {
                this.stopWatch.stop();
                ++cnt;
            }
        }
        this.writeStatLog("Execution Completed\t" + DateUtil.getCurrentDateAsString());
        this.writeStatLog("Excuted " + cnt + " statements");
        return cnt;
    }

    protected void execute(String sql) throws Exception {
        String checkSql = null;
        checkSql = sql.toUpperCase();
        checkSql = checkSql.trim();
        this.logger.print("\nExecute SQL " + sql);
        Statement statement = this.connection.createStatement();
        try {
            if (checkSql.startsWith(SELECT)) {
                ResultSet rs = statement.executeQuery(sql);
                if (this.printResults) {
                    this.logger.print(this.printOutResultSet(rs));
                }
            } else {
                statement.execute(sql);
            }
        }
        catch (SQLException sqle) {
            try {
                this.connection.rollback();
            }
            catch (SQLException se) {
                // empty catch block
            }
            throw sqle;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    private StringBuffer printOutResultSet(ResultSet rs) throws Exception {
        int i;
        StringBuffer buffer = new StringBuffer();
        ResultSetMetaData rsMeta = rs.getMetaData();
        int columnCount = rsMeta.getColumnCount();
        int columnSize = 0;
        for (i = 1; i <= columnCount; ++i) {
            String columnName = rsMeta.getColumnName(i);
            buffer.append(columnName + '\t');
            int a = rsMeta.getColumnDisplaySize(i);
            if (a <= columnSize) continue;
            columnSize = a;
        }
        buffer.append('\n');
        for (i = 1; i <= columnCount; ++i) {
            rsMeta.getColumnName(i);
            for (int size = 0; size < columnSize; ++size) {
                buffer.append("-");
            }
            buffer.append('\t');
        }
        buffer.append('\n');
        while (rs.next()) {
            for (i = 1; i <= columnCount; ++i) {
                Object a = rs.getObject(i);
                if (a != null) {
                    buffer.append(a.toString() + '\t');
                    continue;
                }
                buffer.append("(NULL)\t");
            }
            buffer.append('\n');
        }
        return buffer;
    }

    private void setTransactionLevel(Connection con, String level) throws SQLException {
        if (level.equals("TRANSACTION_READ_UNCOMMITTED")) {
            con.setTransactionIsolation(2);
        } else if (level.equals("TRANSACTION_READ_COMMITTED")) {
            con.setTransactionIsolation(2);
        } else if (level.equals("TRANSACTION_REPEATABLE_READ")) {
            con.setTransactionIsolation(4);
        } else if (level.equals("TRANSACTION_SERIALIZABLE")) {
            con.setTransactionIsolation(8);
        } else if (level.equals("TRANSACTION_NONE")) {
            con.setTransactionIsolation(0);
        }
        this.writeStatLog("IsolationLevel Changed To: " + level);
    }

    private void writeStatLog(String msg) {
        if (this.statLog != null) {
            this.statLog.print(msg);
        }
    }
}

