/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.odbc;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.odbc.MetaMatrixODBCIPException;
import com.metamatrix.odbc.ODBCPlugin;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import oajava.sql.sqlip;
import oajava.sql.xo_int;

public class MetaMatrixODBCIP
implements sqlip {
    public static final String USER_CONNECTION_STRING_DELIMITER = ";";
    public static final char ADDNL_PROPERTIES_DELIMITER = '|';
    public static final String METAMATRIX_JDBC_DRIVER_CLASS_NAME = "com.metamatrix.jdbc.MMDriver";
    public static final String METAMATRIX_PROTOCOL_PROPERTY_KEY = "PROTOCOL";
    public static final String HOST_NAME_PROPERTY_KEY = "ADDRESS";
    public static final String METAMATRIX_ADDRESS_PROPERTY_KEY = "MMADDRESS";
    public static final String METAMATRIX_PORT_PROPERTY_KEY = "MMPRT";
    public static final String METAMATRIX_VDB_NAME_PROPERTY_KEY = "VDB";
    public static final String METAMATRIX_VDB_VERSION_PROPERTY_KEY = "VDBVERSION";
    public static final String METAMATRIX_ADDNL_PROPERTIES_PROPERTY_KEY = "PROPERTIES";
    public static final String METAMATRIX_ODBC_TIMEZONE_PROPERTY_KEY = "ODBCTIMEZONE";
    public static final String METAMATRIX_USE_ODBC_FETCH = "USEODBCFETCH";
    public static final String METAMATRIX_APPLICATION_NAME_KEY = "APPLICATIONNAME";
    public static final String DEFAULT_APPLICATION_NAME = "ODBC API";
    public static final String ALLOW_DBL_QUOTED_VARIABLE = "allowDoubleQuotedVariable";
    public static final int MAX_ERROR_MESSAGE_RETURN_LENGTH = 300;
    private String dburl = null;
    private Connection connection = null;
    private Throwable lastError = null;
    private String userName = null;
    private TimeZone timeZone = TimeZone.getDefault();
    private boolean useODBCFetchSize = true;
    private String applicationName = "ODBC API";
    private boolean allowDoubleQuotedVariable = true;
    private Object[] logParams = null;

    public MetaMatrixODBCIP(int callback, int traceLoggingHandle, int memoryTree) {
        if (LogManager.isMessageToBeRecorded((String)"ODBC_CONNECTION", (int)6)) {
            String msg = ODBCPlugin.Util.getString("MetaMatrixODBCIP.connection");
            LogManager.logTrace((String)"ODBC_CONNECTION", (String)msg);
        }
    }

    public int sqlipConnect(String logicalDatabaseName, String dbConnectionURL, String userName, String password, int readWriteCode, String userConnectionString, String securityToken) {
        try {
            String addnlPropertiesString;
            String metaMatrixVDBVersion;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                Class.forName(METAMATRIX_JDBC_DRIVER_CLASS_NAME);
            }
            catch (Exception e) {
                String m = ODBCPlugin.Util.getString("MetaMatrixODBCIP.error_driver_class");
                return this.handleException("MetaMatrixODBCIP.error_driver_class", null, (Exception)new MetaMatrixODBCIPException((Throwable)e, m));
            }
            Properties connectionProps = this.parseConnectionString(userConnectionString);
            String metaMatrixProtocol = connectionProps.getProperty(METAMATRIX_PROTOCOL_PROPERTY_KEY);
            if (metaMatrixProtocol == null || metaMatrixProtocol.length() == 0) {
                return this.handleException("MetaMatrixODBCIP.error_protocol", null, null);
            }
            String host = connectionProps.getProperty(HOST_NAME_PROPERTY_KEY);
            if (host == null || host.length() == 0) {
                return this.handleException("MetaMatrixODBCIP.error_host", null, null);
            }
            boolean usePort = true;
            String metaMatrixAddress = connectionProps.getProperty(METAMATRIX_ADDRESS_PROPERTY_KEY);
            if (metaMatrixAddress == null || metaMatrixAddress.length() == 0) {
                metaMatrixAddress = host;
            } else {
                usePort = false;
                metaMatrixAddress = metaMatrixAddress.replace('|', ',');
            }
            String metaMatrixPort = connectionProps.getProperty(METAMATRIX_PORT_PROPERTY_KEY);
            if (usePort && (metaMatrixPort == null || metaMatrixPort.length() == 0)) {
                return this.handleException("MetaMatrixODBCIP.error_port", null, null);
            }
            String metaMatrixVDB = connectionProps.getProperty(METAMATRIX_VDB_NAME_PROPERTY_KEY);
            if (metaMatrixVDB == null || metaMatrixVDB.length() == 0) {
                return this.handleException("MetaMatrixODBCIP.error_vdb", null, null);
            }
            StringBuffer url = new StringBuffer("jdbc:metamatrix:").append(metaMatrixVDB).append("@").append(metaMatrixProtocol).append("://").append(metaMatrixAddress);
            if (usePort) {
                url.append(":").append(metaMatrixPort);
            }
            if ((metaMatrixVDBVersion = connectionProps.getProperty(METAMATRIX_VDB_VERSION_PROPERTY_KEY)) != null && metaMatrixVDBVersion.length() != 0) {
                url.append(USER_CONNECTION_STRING_DELIMITER).append("version").append("=").append(metaMatrixVDBVersion);
            }
            if ((addnlPropertiesString = connectionProps.getProperty(METAMATRIX_ADDNL_PROPERTIES_PROPERTY_KEY)) != null && addnlPropertiesString.length() > 0) {
                if (!(addnlPropertiesString = this.convertAdditionalProperties(addnlPropertiesString)).startsWith(USER_CONNECTION_STRING_DELIMITER)) {
                    url.append(USER_CONNECTION_STRING_DELIMITER);
                }
                url.append(addnlPropertiesString);
                this.extractAddnlProperties(addnlPropertiesString);
            }
            if ((addnlPropertiesString == null || addnlPropertiesString.indexOf(ALLOW_DBL_QUOTED_VARIABLE) == -1) && this.allowDoubleQuotedVariable) {
                url.append(USER_CONNECTION_STRING_DELIMITER);
                url.append(ALLOW_DBL_QUOTED_VARIABLE);
                url.append("=").append("true");
            }
            url.append(USER_CONNECTION_STRING_DELIMITER).append("ApplicationName").append("=").append(this.applicationName);
            String actualURL = url.toString();
            this.dburl = url.toString();
            this.userName = userName;
            this.logParams = new Object[]{this.dburl, userName};
            String msg = ODBCPlugin.Util.getString("MetaMatrixODBCIP.connect", this.logParams);
            LogManager.logInfo((String)"ODBC_CONNECTION", (String)msg);
            this.connection = DriverManager.getConnection(actualURL, userName, password);
        }
        catch (SQLException se) {
            return this.handleException("MetaMatrixODBCIP.error_connect", this.logParams, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    void extractAddnlProperties(String addnlPropertiesString) {
        StringTokenizer propTokens = new StringTokenizer(addnlPropertiesString, USER_CONNECTION_STRING_DELIMITER);
        while (propTokens.hasMoreTokens()) {
            String value;
            String token = propTokens.nextToken();
            int index = token.indexOf("=");
            if (index < 0) continue;
            String key = token.substring(0, index);
            if (key.equalsIgnoreCase(METAMATRIX_APPLICATION_NAME_KEY)) {
                if (token.length() < index + 1 || token.substring(index + 1).trim().length() <= 0) continue;
                this.applicationName = token.substring(index + 1).trim();
                LogManager.logInfo((String)"ODBC_CONNECTION", (String)("Use ODBC Application Name: " + this.applicationName));
                continue;
            }
            if (key.equalsIgnoreCase(METAMATRIX_ODBC_TIMEZONE_PROPERTY_KEY)) {
                value = token.substring(index + 1);
                TimeZone odbcTimeZone = TimeZone.getTimeZone(value);
                LogManager.logInfo((String)"ODBC_CONNECTION", (String)("Using ODBC time zone: " + value));
                this.timeZone = odbcTimeZone;
                continue;
            }
            if (key.equalsIgnoreCase(METAMATRIX_USE_ODBC_FETCH)) {
                value = token.substring(index + 1);
                this.useODBCFetchSize = Boolean.valueOf(value);
                LogManager.logInfo((String)"ODBC_CONNECTION", (String)("Use ODBC fetch size: " + this.useODBCFetchSize));
                continue;
            }
            if (!key.equalsIgnoreCase(ALLOW_DBL_QUOTED_VARIABLE)) continue;
            value = token.substring(index + 1);
            this.allowDoubleQuotedVariable = Boolean.valueOf(value);
            LogManager.logInfo((String)"ODBC_CONNECTION", (String)("Allow Double Quoted Variables:" + value));
        }
    }

    public int sqlipDisconnect() {
        try {
            String msg = ODBCPlugin.Util.getString("MetaMatrixODBCIP.disconnect", this.logParams);
            LogManager.logInfo((String)"ODBC_CONNECTION", (String)msg);
            this.connection.close();
        }
        catch (SQLException se) {
            return this.handleException("MetaMatrixODBCIP.error_disconnect", this.logParams, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    public int sqlipError(StringBuffer sSqlState, xo_int piNativeError, StringBuffer sErrorText) {
        try {
            int returnCode = MetaMatrixODBCIP.getError(sSqlState, piNativeError, sErrorText, this.lastError, "ODBC_CONNECTION");
            this.lastError = null;
            return returnCode;
        }
        catch (Throwable e) {
            LogManager.logError((String)"ODBC_CONNECTION", (Throwable)e, (String)e.getMessage());
            return -1;
        }
    }

    public int sqlipGetInfo(int optionCode, StringBuffer optionValue) {
        return 0;
    }

    public int sqlipSetInfo(String args) {
        return 0;
    }

    public int sqlipCommit() {
        try {
            String logMsg = ODBCPlugin.Util.getString("MetaMatrixODBCIP.commit", this.logParams);
            LogManager.logTrace((String)"ODBC_CONNECTION", (String)logMsg);
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException se) {
            return this.handleException("MetaMatrixODBCIP.error_commit", this.logParams, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    public int sqlipRollback() {
        try {
            LogManager.logTrace((String)"ODBC_CONNECTION", (String)ODBCPlugin.Util.getString("MetaMatrixODBCIP.rollback", this.logParams));
            if (!this.connection.getAutoCommit()) {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException se) {
            return this.handleException("MetaMatrixODBCIP.error_rollback", this.logParams, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    public int sqlipStartTransaction(int explicitFlag, String args) {
        block4: {
            try {
                LogManager.logTrace((String)"ODBC_CONNECTION", (String)ODBCPlugin.Util.getString("MetaMatrixODBCIP.transaction", this.logParams));
                if (explicitFlag <= 0) break block4;
                if (this.connection.getAutoCommit()) {
                    this.connection.setAutoCommit(false);
                    break block4;
                }
                return this.handleException("MetaMatrixODBCIP.error_nested_transaction", this.logParams, null);
            }
            catch (SQLException se) {
                return this.handleException("MetaMatrixODBCIP.error_transaction", this.logParams, se);
            }
            catch (Throwable e) {
                return this.handleException(e);
            }
        }
        return 0;
    }

    public int sqlipPrepareToCommit(String args, xo_int readOnly) {
        return 0;
    }

    Connection getConnectionObj() {
        return this.connection;
    }

    TimeZone getTimeZone() {
        return this.timeZone;
    }

    boolean useODBCFetchSize() {
        return this.useODBCFetchSize;
    }

    String getDatabaseURL() {
        return this.dburl;
    }

    String getUserName() {
        return this.userName;
    }

    String getApplicationName() {
        return this.applicationName;
    }

    Properties parseConnectionString(String connectionString) {
        Properties props = new Properties();
        StringTokenizer tokenizer = new StringTokenizer(connectionString, USER_CONNECTION_STRING_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String propString = tokenizer.nextToken();
            this.parsePropertyString(props, propString);
        }
        return props;
    }

    String convertAdditionalProperties(String addnlPropertiesString) {
        return addnlPropertiesString.replace('|', USER_CONNECTION_STRING_DELIMITER.toCharArray()[0]);
    }

    private Properties parsePropertyString(Properties props, String propertyString) {
        if (propertyString.indexOf("=") > 0) {
            String key = propertyString.substring(0, propertyString.indexOf("=")).trim();
            String value = propertyString.substring(propertyString.indexOf("=") + 1, propertyString.length());
            props.setProperty(key, value);
        }
        return props;
    }

    private int handleException(String key, Object[] params, Exception e) {
        String msg = null;
        msg = params != null ? ODBCPlugin.Util.getString(key, params) : ODBCPlugin.Util.getString(key);
        if (e == null) {
            e = new MetaMatrixODBCIPException(msg);
        }
        LogManager.logError((String)"ODBC_CONNECTION", (Throwable)e, (String)msg);
        this.lastError = e;
        return -1;
    }

    private int handleException(Throwable e) {
        LogManager.logError((String)"ODBC_CONNECTION", (Throwable)e, (String)e.getMessage());
        this.lastError = e;
        return -1;
    }

    static int getError(StringBuffer state, xo_int nativeError, StringBuffer errorMessage, Throwable t, String loggingContext) {
        if (nativeError != null) {
            nativeError.setVal(0);
        }
        if (t != null) {
            LogManager.logTrace((String)loggingContext, (String)(ODBCPlugin.Util.getString("MetaMatrixODBCIP.show_error") + t.getMessage()));
            if (state != null) {
                String sqlState;
                String stateVal = "NONE1";
                if (t instanceof SQLException && (sqlState = ((SQLException)t).getSQLState()) != null) {
                    if (sqlState.length() > 5) {
                        sqlState = sqlState.substring(0, 5);
                    }
                    stateVal = sqlState;
                }
                state.append(stateVal);
            }
            if (errorMessage != null) {
                String message = t.getMessage();
                if (message != null) {
                    if (message.length() > 300) {
                        message = message.substring(0, 300);
                    }
                } else {
                    message = ODBCPlugin.Util.getString("MetaMatrixODBCIP.no_message");
                }
                errorMessage.append(message);
            }
        } else {
            LogManager.logTrace((String)loggingContext, (String)ODBCPlugin.Util.getString("MetaMatrixODBCIP.null_error"));
            return 1;
        }
        return 0;
    }

    static {
        if (LogManager.isMessageToBeRecorded((String)"ODBC_CONNECTION", (int)6)) {
            String msg = ODBCPlugin.Util.getString("MetaMatrixODBCIP.classpath", (Object)System.getProperty("java.class.path"));
            LogManager.logTrace((String)"ODBC_CONNECTION", (String)msg);
            msg = ODBCPlugin.Util.getString("MetaMatrixODBCIP.home", (Object)System.getProperty("java.home"));
            LogManager.logTrace((String)"ODBC_CONNECTION", (String)msg);
        }
    }
}

