/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.language;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.data.language.IAggregate;
import com.metamatrix.data.language.IBatchedUpdates;
import com.metamatrix.data.language.ICaseExpression;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICompoundCriteria;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IDelete;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExistsCriteria;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IFromItem;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.IGroupBy;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.IIsNullCriteria;
import com.metamatrix.data.language.IJoin;
import com.metamatrix.data.language.ILikeCriteria;
import com.metamatrix.data.language.ILimit;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.INotCriteria;
import com.metamatrix.data.language.IOrderBy;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISearchedCaseExpression;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.language.ISubqueryCompareCriteria;
import com.metamatrix.data.language.ISubqueryInCriteria;
import com.metamatrix.data.language.IUnion;
import com.metamatrix.data.language.IUpdate;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.datamgr.language.AggregateImpl;
import com.metamatrix.dqp.internal.datamgr.language.BatchedUpdatesImpl;
import com.metamatrix.dqp.internal.datamgr.language.BulkInsertImpl;
import com.metamatrix.dqp.internal.datamgr.language.CaseExpressionImpl;
import com.metamatrix.dqp.internal.datamgr.language.CompareCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.CompoundCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.DeleteImpl;
import com.metamatrix.dqp.internal.datamgr.language.ElementImpl;
import com.metamatrix.dqp.internal.datamgr.language.ExistsCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.FromImpl;
import com.metamatrix.dqp.internal.datamgr.language.FunctionImpl;
import com.metamatrix.dqp.internal.datamgr.language.GroupByImpl;
import com.metamatrix.dqp.internal.datamgr.language.GroupImpl;
import com.metamatrix.dqp.internal.datamgr.language.InCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.InlineViewImpl;
import com.metamatrix.dqp.internal.datamgr.language.InsertImpl;
import com.metamatrix.dqp.internal.datamgr.language.IsNullCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.JoinImpl;
import com.metamatrix.dqp.internal.datamgr.language.LikeCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.LimitImpl;
import com.metamatrix.dqp.internal.datamgr.language.LiteralImpl;
import com.metamatrix.dqp.internal.datamgr.language.NotCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.OrderByImpl;
import com.metamatrix.dqp.internal.datamgr.language.OrderByItemImpl;
import com.metamatrix.dqp.internal.datamgr.language.ParameterImpl;
import com.metamatrix.dqp.internal.datamgr.language.ProcedureImpl;
import com.metamatrix.dqp.internal.datamgr.language.QueryImpl;
import com.metamatrix.dqp.internal.datamgr.language.ScalarSubqueryImpl;
import com.metamatrix.dqp.internal.datamgr.language.SearchedCaseExpressionImpl;
import com.metamatrix.dqp.internal.datamgr.language.SelectImpl;
import com.metamatrix.dqp.internal.datamgr.language.SelectSymbolImpl;
import com.metamatrix.dqp.internal.datamgr.language.SubqueryCompareCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.SubqueryInCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.UnionImpl;
import com.metamatrix.dqp.internal.datamgr.language.UpdateImpl;
import com.metamatrix.dqp.internal.datamgr.metadata.MetadataFactory;
import com.metamatrix.dqp.internal.datamgr.metadata.ProcedureIDImpl;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.sql.lang.BatchedUpdateCommand;
import com.metamatrix.query.sql.lang.BulkInsert;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.ScalarSubquery;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LanguageBridgeFactory {
    private MetadataFactory metadataFactory = null;

    public LanguageBridgeFactory(QueryMetadataInterface metadata) {
        if (metadata != null) {
            this.metadataFactory = new MetadataFactory(metadata);
        }
    }

    public ICommand translate(Command command) throws MetaMatrixComponentException {
        if (command == null) {
            return null;
        }
        if (command instanceof Query) {
            return this.translate((Query)command);
        }
        if (command instanceof SetQuery) {
            return this.translate((SetQuery)command);
        }
        if (command instanceof Insert) {
            return this.translate((Insert)command);
        }
        if (command instanceof Update) {
            return this.translate((Update)command);
        }
        if (command instanceof Delete) {
            return this.translate((Delete)command);
        }
        if (command instanceof StoredProcedure) {
            return this.translate((StoredProcedure)command);
        }
        if (command instanceof BatchedUpdateCommand) {
            return this.translate((BatchedUpdateCommand)command);
        }
        return null;
    }

    IQuery translate(QueryCommand command) throws MetaMatrixComponentException {
        if (command instanceof Query) {
            return this.translate((Query)command);
        }
        if (command instanceof SetQuery) {
            return this.translate((SetQuery)command);
        }
        return null;
    }

    IUnion translate(SetQuery union) throws MetaMatrixComponentException {
        UnionImpl unionOut = null;
        Iterator queryIter = union.getQueries().iterator();
        Iterator allIter = union.getUseAllFlags().iterator();
        while (queryIter.hasNext()) {
            QueryCommand queryCommand = (QueryCommand)queryIter.next();
            boolean useAll = (Boolean)allIter.next();
            if (unionOut == null) {
                if (queryCommand instanceof SetQuery) {
                    throw new MetaMatrixComponentException(DQPPlugin.Util.getString("LanguageBridgeFactory.cant_translate_union"));
                }
                Query query = (Query)queryCommand;
                unionOut = new UnionImpl(this.translate(query.getSelect()), this.translate(query.getFrom()), this.translate(query.getCriteria()), this.translate(query.getGroupBy()), this.translate(query.getHaving()), this.translate(query.getOrderBy()));
                continue;
            }
            unionOut.addUnionQuery(this.translate(queryCommand), useAll);
        }
        if (union.getOrderBy() != null) {
            unionOut.setUnionOrderBy(this.translate(union.getOrderBy()));
        }
        return unionOut;
    }

    IQuery translate(Query query) throws MetaMatrixComponentException {
        QueryImpl q = new QueryImpl(this.translate(query.getSelect()), this.translate(query.getFrom()), this.translate(query.getCriteria()), this.translate(query.getGroupBy()), this.translate(query.getHaving()), this.translate(query.getOrderBy()));
        q.setLimit(this.translate(query.getLimit()));
        return q;
    }

    ISelect translate(Select select) throws MetaMatrixComponentException {
        List symbols = select.getSymbols();
        ArrayList<SelectSymbolImpl> translatedSymbols = new ArrayList<SelectSymbolImpl>(symbols.size());
        Iterator i = symbols.iterator();
        while (i.hasNext()) {
            SingleElementSymbol symbol = (SingleElementSymbol)i.next();
            boolean isAlias = false;
            String alias = symbol.getName();
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
                isAlias = true;
            }
            IElement iExp = null;
            if (symbol instanceof ElementSymbol) {
                iExp = this.translate((ElementSymbol)symbol);
            } else if (symbol instanceof AggregateSymbol) {
                iExp = this.translate((AggregateSymbol)symbol);
            } else if (symbol instanceof ExpressionSymbol) {
                iExp = this.translate(((ExpressionSymbol)symbol).getExpression());
            }
            SelectSymbolImpl selectSymbol = new SelectSymbolImpl(symbol.getName(), (IExpression)iExp);
            if (isAlias) {
                selectSymbol.setOutputName(alias);
                selectSymbol.setAlias(true);
            }
            translatedSymbols.add(selectSymbol);
        }
        return new SelectImpl(translatedSymbols, select.isDistinct());
    }

    IFrom translate(From from) throws MetaMatrixComponentException {
        List clauses = from.getClauses();
        ArrayList<IFromItem> items = new ArrayList<IFromItem>();
        Iterator i = clauses.iterator();
        while (i.hasNext()) {
            items.add(this.translate((FromClause)i.next()));
        }
        return new FromImpl(items);
    }

    IFromItem translate(FromClause clause) throws MetaMatrixComponentException {
        if (clause == null) {
            return null;
        }
        if (clause instanceof JoinPredicate) {
            return this.translate((JoinPredicate)clause);
        }
        if (clause instanceof SubqueryFromClause) {
            return this.translate((SubqueryFromClause)clause);
        }
        if (clause instanceof UnaryFromClause) {
            return this.translate((UnaryFromClause)clause);
        }
        return null;
    }

    IJoin translate(JoinPredicate join) throws MetaMatrixComponentException {
        List crits = join.getJoinCriteria();
        ArrayList<ICriteria> criteria = new ArrayList<ICriteria>();
        Iterator i = crits.iterator();
        while (i.hasNext()) {
            criteria.add(this.translate((Criteria)i.next()));
        }
        int joinType = 0;
        if (join.getJoinType().equals((Object)JoinType.JOIN_INNER)) {
            joinType = 0;
        } else if (join.getJoinType().equals((Object)JoinType.JOIN_LEFT_OUTER)) {
            joinType = 2;
        } else if (join.getJoinType().equals((Object)JoinType.JOIN_RIGHT_OUTER)) {
            joinType = 3;
        } else if (join.getJoinType().equals((Object)JoinType.JOIN_FULL_OUTER)) {
            joinType = 4;
        } else if (join.getJoinType().equals((Object)JoinType.JOIN_CROSS)) {
            joinType = 1;
        }
        return new JoinImpl(this.translate(join.getLeftClause()), this.translate(join.getRightClause()), joinType, criteria);
    }

    IFromItem translate(SubqueryFromClause clause) throws MetaMatrixComponentException {
        return new InlineViewImpl(this.translate((QueryCommand)clause.getCommand()), clause.getName());
    }

    IGroup translate(UnaryFromClause clause) throws MetaMatrixComponentException {
        return this.translate(clause.getGroup());
    }

    ICriteria translate(Criteria criteria) throws MetaMatrixComponentException {
        if (criteria == null) {
            return null;
        }
        if (criteria instanceof CompareCriteria) {
            return this.translate((CompareCriteria)criteria);
        }
        if (criteria instanceof CompoundCriteria) {
            return this.translate((CompoundCriteria)criteria);
        }
        if (criteria instanceof ExistsCriteria) {
            return this.translate((ExistsCriteria)criteria);
        }
        if (criteria instanceof IsNullCriteria) {
            return this.translate((IsNullCriteria)criteria);
        }
        if (criteria instanceof MatchCriteria) {
            return this.translate((MatchCriteria)criteria);
        }
        if (criteria instanceof NotCriteria) {
            return this.translate((NotCriteria)criteria);
        }
        if (criteria instanceof SetCriteria) {
            return this.translate((SetCriteria)criteria);
        }
        if (criteria instanceof SubqueryCompareCriteria) {
            return this.translate((SubqueryCompareCriteria)criteria);
        }
        if (criteria instanceof SubquerySetCriteria) {
            return this.translate((SubquerySetCriteria)criteria);
        }
        return null;
    }

    ICompareCriteria translate(CompareCriteria criteria) throws MetaMatrixComponentException {
        int operator = 0;
        switch (criteria.getOperator()) {
            case 1: {
                operator = 0;
                break;
            }
            case 2: {
                operator = 1;
                break;
            }
            case 3: {
                operator = 2;
                break;
            }
            case 5: {
                operator = 3;
                break;
            }
            case 4: {
                operator = 4;
                break;
            }
            case 6: {
                operator = 5;
            }
        }
        return new CompareCriteriaImpl(this.translate(criteria.getLeftExpression()), this.translate(criteria.getRightExpression()), operator);
    }

    ICompoundCriteria translate(CompoundCriteria criteria) throws MetaMatrixComponentException {
        List nestedCriteria = criteria.getCriteria();
        ArrayList<ICriteria> translatedCriteria = new ArrayList<ICriteria>();
        Iterator i = nestedCriteria.iterator();
        while (i.hasNext()) {
            translatedCriteria.add(this.translate((Criteria)i.next()));
        }
        int operator = 0;
        operator = criteria.getOperator() == 0 ? 0 : 1;
        return new CompoundCriteriaImpl(translatedCriteria, operator);
    }

    IExistsCriteria translate(ExistsCriteria criteria) throws MetaMatrixComponentException {
        return new ExistsCriteriaImpl(this.translate((Query)criteria.getCommand()));
    }

    IIsNullCriteria translate(IsNullCriteria criteria) throws MetaMatrixComponentException {
        return new IsNullCriteriaImpl(this.translate(criteria.getExpression()), criteria.isNegated());
    }

    ILikeCriteria translate(MatchCriteria criteria) throws MetaMatrixComponentException {
        Character escapeChar = null;
        if (criteria.getEscapeChar() != '\u0000') {
            escapeChar = new Character(criteria.getEscapeChar());
        }
        return new LikeCriteriaImpl(this.translate(criteria.getLeftExpression()), this.translate(criteria.getRightExpression()), escapeChar, criteria.isNegated());
    }

    IInCriteria translate(SetCriteria criteria) throws MetaMatrixComponentException {
        List expressions = criteria.getValues();
        ArrayList<IExpression> translatedExpressions = new ArrayList<IExpression>();
        Iterator i = expressions.iterator();
        while (i.hasNext()) {
            translatedExpressions.add(this.translate((Expression)i.next()));
        }
        return new InCriteriaImpl(this.translate(criteria.getExpression()), translatedExpressions, criteria.isNegated());
    }

    ISubqueryCompareCriteria translate(SubqueryCompareCriteria criteria) throws MetaMatrixComponentException {
        int quantifier = 0;
        switch (criteria.getPredicateQuantifier()) {
            case 4: {
                quantifier = 1;
                break;
            }
            case 3: {
                quantifier = 0;
                break;
            }
            case 2: {
                quantifier = 0;
            }
        }
        int operator = 0;
        switch (criteria.getOperator()) {
            case 1: {
                operator = 1;
                break;
            }
            case 2: {
                operator = 2;
                break;
            }
            case 3: {
                operator = 3;
                break;
            }
            case 5: {
                operator = 4;
                break;
            }
            case 4: {
                operator = 5;
                break;
            }
            case 6: {
                operator = 6;
            }
        }
        return new SubqueryCompareCriteriaImpl(this.translate(criteria.getLeftExpression()), operator, quantifier, this.translate((Query)criteria.getCommand()));
    }

    ISubqueryInCriteria translate(SubquerySetCriteria criteria) throws MetaMatrixComponentException {
        return new SubqueryInCriteriaImpl(this.translate(criteria.getExpression()), criteria.isNegated(), this.translate((Query)criteria.getCommand()));
    }

    INotCriteria translate(NotCriteria criteria) throws MetaMatrixComponentException {
        return new NotCriteriaImpl(this.translate(criteria.getCriteria()));
    }

    IGroupBy translate(GroupBy groupBy) throws MetaMatrixComponentException {
        if (groupBy == null) {
            return null;
        }
        List items = groupBy.getSymbols();
        ArrayList<IExpression> translatedItems = new ArrayList<IExpression>();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            translatedItems.add(this.translate((Expression)i.next()));
        }
        return new GroupByImpl(translatedItems);
    }

    IOrderBy translate(OrderBy orderBy) throws MetaMatrixComponentException {
        if (orderBy == null) {
            return null;
        }
        List items = orderBy.getVariables();
        List types = orderBy.getTypes();
        ArrayList<OrderByItemImpl> translatedItems = new ArrayList<OrderByItemImpl>();
        for (int i = 0; i < items.size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)items.get(i);
            boolean direction = (Boolean)types.get(i) != OrderBy.DESC;
            OrderByItemImpl orderByItem = null;
            if (symbol instanceof ElementSymbol) {
                IElement innerElement = this.translate((ElementSymbol)symbol);
                orderByItem = new OrderByItemImpl(symbol.getName(), direction, innerElement);
            } else {
                orderByItem = new OrderByItemImpl(symbol.getName(), direction, null);
            }
            translatedItems.add(orderByItem);
        }
        return new OrderByImpl(translatedItems);
    }

    IExpression translate(Expression expr) throws MetaMatrixComponentException {
        if (expr == null) {
            return null;
        }
        if (expr instanceof CaseExpression) {
            return this.translate((CaseExpression)expr);
        }
        if (expr instanceof Constant) {
            return this.translate((Constant)expr);
        }
        if (expr instanceof Function) {
            return this.translate((Function)expr);
        }
        if (expr instanceof Reference) {
            return this.translate((Reference)expr);
        }
        if (expr instanceof ScalarSubquery) {
            return this.translate((ScalarSubquery)expr);
        }
        if (expr instanceof SearchedCaseExpression) {
            return this.translate((SearchedCaseExpression)expr);
        }
        if (expr instanceof SingleElementSymbol) {
            return this.translate((SingleElementSymbol)expr);
        }
        return null;
    }

    ICaseExpression translate(CaseExpression expr) throws MetaMatrixComponentException {
        ArrayList<IExpression> whens = new ArrayList<IExpression>();
        ArrayList<IExpression> thens = new ArrayList<IExpression>();
        for (int i = 0; i < expr.getWhenCount(); ++i) {
            whens.add(this.translate(expr.getWhenExpression(i)));
            thens.add(this.translate(expr.getThenExpression(i)));
        }
        return new CaseExpressionImpl(this.translate(expr.getExpression()), whens, thens, this.translate(expr.getElseExpression()), expr.getType());
    }

    ILiteral translate(Constant constant) {
        return new LiteralImpl(constant.getValue(), constant.getType());
    }

    IFunction translate(Function function) throws MetaMatrixComponentException {
        Expression[] args = function.getArgs();
        IExpression[] params = null;
        if (args != null) {
            params = new IExpression[args.length];
            for (int i = 0; i < args.length; ++i) {
                params[i] = this.translate(args[i]);
            }
        }
        return new FunctionImpl(function.getName(), params, function.getType());
    }

    IExpression translate(Reference ref) throws MetaMatrixComponentException {
        return this.translate(ref.getExpression());
    }

    ISearchedCaseExpression translate(SearchedCaseExpression expr) throws MetaMatrixComponentException {
        ArrayList<ICriteria> whens = new ArrayList<ICriteria>();
        ArrayList<IExpression> thens = new ArrayList<IExpression>();
        for (int i = 0; i < expr.getWhenCount(); ++i) {
            whens.add(this.translate(expr.getWhenCriteria(i)));
            thens.add(this.translate(expr.getThenExpression(i)));
        }
        return new SearchedCaseExpressionImpl(whens, thens, this.translate(expr.getElseExpression()), expr.getType());
    }

    IExpression translate(ScalarSubquery ss) throws MetaMatrixComponentException {
        return new ScalarSubqueryImpl(this.translate((Query)ss.getCommand()));
    }

    IExpression translate(SingleElementSymbol symbol) throws MetaMatrixComponentException {
        if (symbol == null) {
            return null;
        }
        if (symbol instanceof AliasSymbol) {
            return this.translate((AliasSymbol)symbol);
        }
        if (symbol instanceof ElementSymbol) {
            return this.translate((ElementSymbol)symbol);
        }
        if (symbol instanceof AggregateSymbol) {
            return this.translate((AggregateSymbol)symbol);
        }
        if (symbol instanceof ExpressionSymbol) {
            return this.translate((ExpressionSymbol)symbol);
        }
        return null;
    }

    IExpression translate(AliasSymbol symbol) throws MetaMatrixComponentException {
        return this.translate(symbol.getSymbol());
    }

    IElement translate(ElementSymbol symbol) throws MetaMatrixComponentException {
        ElementImpl element = null;
        element = new ElementImpl(this.translate(symbol.getGroupSymbol()), symbol.getName(), null, symbol.getType());
        if (element.getGroup().getMetadataID() == null) {
            return element;
        }
        Object mid = symbol.getMetadataID();
        if (!(mid instanceof TempMetadataID)) {
            try {
                element.setMetadataID(this.metadataFactory.createMetadataID(mid, 0));
            }
            catch (QueryMetadataException e) {
                LogManager.logWarning((String)"CONNECTOR", (Throwable)e, (String)DQPPlugin.Util.getString("LanguageBridgeFactory.Unable_to_set_the_metadata_ID_for_element_{0}._10", (Object)symbol.getName()));
                throw new MetaMatrixComponentException((Throwable)e);
            }
        }
        return element;
    }

    IAggregate translate(AggregateSymbol symbol) throws MetaMatrixComponentException {
        return new AggregateImpl(symbol.getAggregateFunction(), symbol.isDistinct(), this.translate(symbol.getExpression()), symbol.getType());
    }

    IExpression translate(ExpressionSymbol symbol) throws MetaMatrixComponentException {
        return this.translate(symbol.getExpression());
    }

    IInsert translate(Insert insert) throws MetaMatrixComponentException {
        List elements = insert.getVariables();
        ArrayList<IElement> translatedElements = new ArrayList<IElement>();
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            translatedElements.add(this.translate((ElementSymbol)i.next()));
        }
        if (insert instanceof BulkInsert) {
            BulkInsert bulkInsert = (BulkInsert)insert;
            BulkInsertImpl translatedBulkInsert = new BulkInsertImpl(this.translate(insert.getGroup()), translatedElements);
            List rows = bulkInsert.getRows();
            translatedBulkInsert.setRows(rows);
            return translatedBulkInsert;
        }
        List values = insert.getValues();
        ArrayList<IExpression> translatedValues = new ArrayList<IExpression>();
        Iterator i2 = values.iterator();
        while (i2.hasNext()) {
            translatedValues.add(this.translate((Expression)i2.next()));
        }
        return new InsertImpl(this.translate(insert.getGroup()), translatedElements, translatedValues);
    }

    IUpdate translate(Update update) throws MetaMatrixComponentException {
        List changes = update.getChangeList();
        ArrayList<ICompareCriteria> translatedChanges = new ArrayList<ICompareCriteria>();
        Iterator i = changes.iterator();
        while (i.hasNext()) {
            translatedChanges.add(this.translate((CompareCriteria)i.next()));
        }
        return new UpdateImpl(this.translate(update.getGroup()), translatedChanges, this.translate(update.getCriteria()));
    }

    IDelete translate(Delete delete) throws MetaMatrixComponentException {
        return new DeleteImpl(this.translate(delete.getGroup()), this.translate(delete.getCriteria()));
    }

    IProcedure translate(StoredProcedure sp) throws MetaMatrixComponentException {
        ProcedureIDImpl metadataID = null;
        if (sp.getProcedureID() != null) {
            try {
                metadataID = (ProcedureIDImpl)this.metadataFactory.createProcedureID(sp.getProcedureID());
            }
            catch (Exception e) {
                LogManager.logWarning((String)"CONNECTOR", (Throwable)e, (String)DQPPlugin.Util.getString("LanguageBridgeFactory.Unable_to_set_the_metadata_ID_for_element_{0}._10", (Object)sp.getProcedureName()));
                throw new MetaMatrixComponentException((Throwable)e);
            }
        }
        List parameters = sp.getParameters();
        ArrayList<IParameter> translatedParameters = new ArrayList<IParameter>();
        Iterator i = parameters.iterator();
        while (i.hasNext()) {
            translatedParameters.add(this.translate((SPParameter)i.next(), metadataID));
        }
        return new ProcedureImpl(sp.getProcedureName(), translatedParameters, (MetadataID)metadataID);
    }

    IParameter translate(SPParameter param, ProcedureIDImpl procID) throws MetaMatrixComponentException {
        int direction = 0;
        switch (param.getParameterType()) {
            case 1: {
                direction = 0;
                break;
            }
            case 3: {
                direction = 2;
                break;
            }
            case 2: {
                direction = 1;
                break;
            }
            case 5: {
                direction = 4;
                break;
            }
            case 4: {
                direction = 3;
            }
        }
        try {
            MetadataID metadataID = null;
            if (direction == 4) {
                metadataID = this.metadataFactory.createResultSetID(procID, param.getMetadataID(), param.getResultSetIDs());
                return new ParameterImpl(param.getIndex(), direction, param.getValue(), param.getClassType(), metadataID);
            }
            metadataID = this.metadataFactory.createParameterID(procID, param.getMetadataID());
            return new ParameterImpl(param.getIndex(), direction, param.getValue(), param.getClassType(), metadataID);
        }
        catch (QueryMetadataException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    IGroup translate(GroupSymbol symbol) throws MetaMatrixComponentException {
        GroupImpl group = new GroupImpl(symbol.getName(), symbol.getDefinition(), null);
        if (symbol.getMetadataID() instanceof TempMetadataID) {
            return group;
        }
        try {
            group.setMetadataID(this.metadataFactory.createMetadataID(symbol.getMetadataID(), 1));
        }
        catch (Exception e) {
            LogManager.logWarning((String)"CONNECTOR", (Throwable)e, (String)DQPPlugin.Util.getString("LanguageBridgeFactory.Unable_to_set_the_metadata_ID_for_group_{0}._11", (Object)symbol.getName()));
            throw new MetaMatrixComponentException((Throwable)e);
        }
        return group;
    }

    IBatchedUpdates translate(BatchedUpdateCommand command) throws MetaMatrixComponentException {
        List updates = command.getUpdateCommands();
        ArrayList<ICommand> translatedUpdates = new ArrayList<ICommand>(updates.size());
        Iterator i = updates.iterator();
        while (i.hasNext()) {
            translatedUpdates.add(this.translate((Command)i.next()));
        }
        return new BatchedUpdatesImpl(translatedUpdates);
    }

    ILimit translate(Limit limit) throws MetaMatrixComponentException {
        if (limit == null) {
            return null;
        }
        int rowOffset = 0;
        if (limit.getOffset() != null) {
            ILiteral c1 = (ILiteral)this.translate(limit.getOffset());
            rowOffset = (Integer)c1.getValue();
        }
        ILiteral c2 = (ILiteral)this.translate(limit.getRowLimit());
        int rowLimit = (Integer)c2.getValue();
        return new LimitImpl(rowOffset, rowLimit);
    }
}

