--
-- BUILD SCRIPT
--         RDBMS: ORACLE
-- RDBMS VERSION: ORACLE
--          NOTE: These tables support the IndexingService changes
--				  
--


CREATE TABLE DD_SHREDQUEUE
(
  QUEUE_ID      NUMBER(19) NOT NULL,
  UUID1         NUMBER(20) NOT NULL,
  UUID2         NUMBER(20) NOT NULL,
  OBJECT_ID     VARCHAR(44) NOT NULL,
  NAME          VARCHAR(128) NOT NULL,
  VERSION       VARCHAR(20),
  MDL_PATH      VARCHAR(2000),
  CMD_ACTION    NUMBER(1) NOT NULL,
  TXN_ID        NUMBER(19) ,
  SUB_BY_NME    VARCHAR(100),
  SUB_BY_DATE   VARCHAR(50)
);
SET DEFINE OFF
SET DEFINE ON

CREATE UNIQUE INDEX DDSQ_QUE_IX ON DD_SHREDQUEUE (QUEUE_ID)
;
CREATE UNIQUE INDEX DDSQ_TXN_IX ON DD_SHREDQUEUE (TXN_ID)
;

CREATE INDEX DDSQ_UUID_IX ON DD_SHREDQUEUE (OBJECT_ID)
;

                                
-- uses oracle 9 version of outerjoin
--
CREATE OR REPLACE VIEW DD_REQUEUETOSHRED_VIEW (UUID1, UUID2, MDLNAME, DDVRSION, MBRVRSION, TXN_ID, COMMAND_TYPE) AS
Select b.ENTRY_ID_P1, b.ENTRY_ID_P2, ENTRY_NAME, a.VRSION, b.ITEM_VERSION, a.TXN_ID, 2
 from  MBR_ENTRIES b, DD_MDL a 
WHERE ( b.ENTRY_ID_P1=a.UUID1 (+) and b.ENTRY_ID_P2=a.UUID2 (+))
and b.ITEM_ID_P1 IS NOT NULL AND b.ENTRY_NAME <> '.project' and a.TXN_ID IS NULL and
      b.ENTRY_ID_P1 NOT IN (Select c.UUID1 from  DD_SHREDQUEUE c 
                           where b.ENTRY_ID_P1=c.UUID1 and b.ENTRY_ID_P2=c.UUID2 and b.ITEM_VERSION=c.VERSION)
UNION 
Select b.ENTRY_ID_P1, b.ENTRY_ID_P2, ENTRY_NAME, a.VRSION, b.ITEM_VERSION, a.TXN_ID, 2
 from  MBR_ENTRIES b, DD_MDL a
 WHERE  b.ENTRY_ID_P1=a.UUID1 and b.ENTRY_ID_P2=a.UUID2 and CAST(a.VRSION AS DECIMAL(8,2)) <> CAST(b.ITEM_VERSION as DECIMAL(8,2))
and  b.ENTRY_ID_P1 NOT IN (Select c.UUID1 from  DD_SHREDQUEUE c 
                                where b.ENTRY_ID_P1=c.UUID1 and b.ENTRY_ID_P2=c.UUID2 and b.ITEM_VERSION=c.VERSION)
;


SPOOL OFF
