/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.statement.command;

import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.exception.ResourceException;
import com.metamatrix.metamodels.db.model.pool.ConnectionPool;
import com.metamatrix.metamodels.db.model.statement.command.SQLStatement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BatchSQLStatement
implements SQLStatement {
    List paramData;
    int[] sqlTypes;
    MetabaseRepositoryShredderComponentRequest message;
    String statement;

    public BatchSQLStatement(MetabaseRepositoryShredderComponentRequest message, String statement, int[] paramSQLTypes) {
        if (message == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("BatchSQLStatement.Unable_to_create_an_instance_of_BatchSQLStatement.__The_MetabaseRepositoryShredderComponentRequest_parameter_instance_was_null._1"));
        }
        this.message = message;
        this.statement = statement;
        this.sqlTypes = paramSQLTypes;
        this.paramData = new ArrayList();
        if (message != null) {
            message.statementAdded();
        } else {
            DBModelPlugin.Util.log(2, DBModelPlugin.Util.getString("AbstractSQLStatement.Unable_to_increment_the_number_of_SQL_statements_added_for_the_message_in_AbstractSQLStatement._The_message_was_null._1"));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ConnectionPool pool) throws ResourceException {
        block27: {
            username = this.message.getUserName();
            connection = pool.getConnection(username);
            prepStatement = null;
            try {
                try {
                    prepStatement = connection.prepareStatement(this.statement);
                    connection.setAutoCommit(false);
                    iter = this.paramData.iterator();
                    block15: while (true) {
                        if (!iter.hasNext()) break;
                        data = (List)iter.next();
                        iterator = data.iterator();
                        i = 0;
                        while (true) {
                            if (!iterator.hasNext()) {
                                prepStatement.addBatch();
                                continue block15;
                            }
                            dataValue = iterator.next();
                            ++i;
                            if (dataValue == null) {
                                prepStatement.setNull(i, this.sqlTypes[i - 1]);
                                continue;
                            }
                            if (this.sqlTypes[i - 1] == 2004) {
                                content = this.getByteArrayForValue(dataValue);
                                if (content != null) {
                                    prepStatement.setBinaryStream(i, (InputStream)new ByteArrayInputStream(content), content.length);
                                    continue;
                                }
                                prepStatement.setNull(i, this.sqlTypes[i - 1]);
                                continue;
                            }
                            prepStatement.setObject(i, dataValue);
                        }
                        break;
                    }
                    status = prepStatement.executeBatch();
                    errors = 0;
                    j = 0;
                    while (true) {
                        if (j >= status.length) {
                            if (errors != 0) {
                                params1 = new String[]{Integer.toString(errors), Integer.toString(this.paramData.size())};
                                errorMessage = DBModelPlugin.Util.getString("BatchSQLStatement.{0}_statements_resulted_in_errors_out_of_{1}_total_statements_attempted_when_executing_a_batch_SQL_Statement._1", params1);
                                this.message.addWarningStatus(errorMessage, null);
                            }
                            connection.commit();
                        }
                        statusInt = status[j];
                        if (statusInt == -3) {
                            ++errors;
                        }
                        ++j;
                    }
                }
                catch (SQLException e) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException status) {
                        // empty catch block
                    }
                    try {
                        params2 = new Object[]{e.getSQLState(), new Integer(e.getErrorCode()), this.sqlTypes};
                        msg2 = DBModelPlugin.Util.getString("BatchSQLStatement.stateCodeDataTypes", params2);
                        DBModelPlugin.Util.log(4, msg2);
                    }
                    catch (Exception params2) {
                        // empty catch block
                    }
                    params = new Object[]{this.statement};
                    msg = DBModelPlugin.Util.getString("BatchSQLStatement.Error_while_executing_a_the_batch_SQL_Statement__{0}_1", params);
                    DBModelPlugin.Util.log(4, (Throwable)e, msg);
                    this.message.addWarningStatus(msg, e);
                }
                catch (Throwable t) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException params) {
                        // empty catch block
                    }
                    params = new Object[]{this.statement};
                    msg = DBModelPlugin.Util.getString("BatchSQLStatement.Error_while_executing_a_the_batch_SQL_Statement__{0}_1", params);
                    DBModelPlugin.Util.log(4, t, msg);
                    this.message.addWarningStatus(msg, t);
                }
            }
            catch (Throwable var12_23) {
                var11_24 = null;
                if (prepStatement != null) {
                    try {
                        prepStatement.close();
                    }
                    catch (SQLException var13_26) {
                        // empty catch block
                    }
                }
                this.message.statementProcessed();
                pool.returnConnection(connection);
                throw var12_23;
            }
            {
                var11_25 = null;
                if (prepStatement == null) break block27;
            }
            ** try [egrp 5[TRYBLOCK] [7 : 564->574)] { 
lbl93:
            // 1 sources

            prepStatement.close();
            break block27;
lbl95:
            // 1 sources

            catch (SQLException var13_27) {
                // empty catch block
            }
        }
        this.message.statementProcessed();
        pool.returnConnection(connection);
    }

    public void addStatement(List data) {
        this.paramData.add(data);
    }

    public int getCurrentSize() {
        return this.paramData.size();
    }

    private byte[] getByteArrayForValue(Object value) {
        byte[] bytes = null;
        if (value != null) {
            String stringValue = value.toString();
            bytes = stringValue.getBytes();
        }
        return bytes;
    }
}

