/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.statement.command;

import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.exception.ResourceException;
import com.metamatrix.metamodels.db.model.pool.ConnectionPool;
import com.metamatrix.metamodels.db.model.statement.command.SQLStatement;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class AbstractSQLStatement
implements SQLStatement {
    private MetabaseRepositoryShredderComponentRequest message;
    protected String statement;

    public AbstractSQLStatement(MetabaseRepositoryShredderComponentRequest message, String statement) {
        if (message == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("AbstractSQLStatement.Unable_to_create_instance_of_AbstractSQLStatement._MetabaseRepositoryShredderComponentRequest_parameter_instance_was_null._1"));
        }
        this.message = message;
        this.statement = statement;
        if (message != null) {
            message.statementAdded();
        } else {
            DBModelPlugin.Util.log(2, DBModelPlugin.Util.getString("AbstractSQLStatement.Unable_to_increment_the_number_of_SQL_statements_added_for_the_message_in_AbstractSQLStatement._The_message_was_null._1"));
        }
    }

    protected abstract void executeStatement(Connection var1) throws SQLException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ConnectionPool pool) throws ResourceException {
        Connection connection = pool.getConnection(this.message.getUserName());
        try {
            try {
                this.executeStatement(connection);
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Object[] params = new String[]{this.statement};
                this.message.addWarningStatus(DBModelPlugin.Util.getString("AbstractSQLStatement.Unable_to_execute_the_statement__{0}_1", params), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.message.statementProcessed();
            pool.returnConnection(connection);
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.message.statementProcessed();
            pool.returnConnection(connection);
            return;
        }
    }

    protected String getStatement() {
        return this.statement;
    }

    protected MetabaseRepositoryShredderComponentRequest getMessage() {
        return this.message;
    }
}

