/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.statement;

import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerException;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.exception.ResourceException;
import com.metamatrix.metamodels.db.model.pool.ConnectionPool;
import com.metamatrix.metamodels.db.model.statement.command.SQLStatement;

public class StatementProcessor
extends QueueWorker {
    ConnectionPool pool;

    public void initialize() throws QueueWorkerException {
    }

    public void cleanup() throws QueueWorkerException {
    }

    public StatementProcessor(ConnectionPool pool) {
        this.pool = pool;
    }

    public void process(Object object) throws QueueWorkerException {
        if (!(object instanceof SQLStatement)) {
            Object[] params = new String[]{object.getClass().toString()};
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("StatementProcessor.The_instance_of_work_passed_to_the_StatementProcessor_was_not_an_instance_of_a_SQLStatement.__Type_passed_in__{0}._Cannot_process_work._1", params));
        }
        if (this.pool == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("StatementProcessor.The_statement_processor_has_a_null_reference_for_the_Connection_pool_that_is_used_to_do_work.__Work_cannot_be_processed._2"));
        }
        SQLStatement statement = (SQLStatement)object;
        try {
            statement.execute(this.pool);
        }
        catch (ResourceException e) {
            String errorMessage = DBModelPlugin.Util.getString("StatementProcessor.execution_error", (Object)statement.toString());
            DBModelPlugin.Util.log(4, (Throwable)((Object)e), errorMessage);
            throw new QueueWorkerException((Exception)((Object)e), errorMessage);
        }
    }
}

