/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.statement;

import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.statement.StatementTarget;
import com.metamatrix.metamodels.db.model.statement.command.ParameterizedSingleSQLStatement;
import com.metamatrix.metamodels.db.model.statement.command.SQLStatement;
import com.metamatrix.metamodels.db.model.statement.command.SingleSQLStatement;
import java.util.List;

public class NonBatchingStatementTarget
implements StatementTarget {
    WorkerPool statementQueue;

    public NonBatchingStatementTarget(WorkerPool statementQueue) {
        this.statementQueue = statementQueue;
    }

    public void put(String statement, List data, int[] sqlTypes, MetabaseRepositoryShredderComponentRequest message) {
        ParameterizedSingleSQLStatement sqlStatement = new ParameterizedSingleSQLStatement(message, statement, data, sqlTypes);
        this.addWork(sqlStatement, message);
    }

    public void put(String statement, MetabaseRepositoryShredderComponentRequest message) {
        SingleSQLStatement sqlStatement = new SingleSQLStatement(message, statement);
        this.addWork(sqlStatement, message);
    }

    public void flush() {
    }

    public void setUsername(String username) {
    }

    private void addWork(SQLStatement statement, MetabaseRepositoryShredderComponentRequest message) {
        try {
            this.statementQueue.addWork((Object)statement);
        }
        catch (QueueSuspendedException e) {
            String errorMessage = DBModelPlugin.Util.getString("BatchingStatementTarget.Unable_to_add_work_for_this_message_to_the_statement_processor_queue.__Queue_was_suspended._2");
            message.addErrorStatus(errorMessage, e);
            DBModelPlugin.Util.log(4, (Throwable)e, errorMessage);
        }
    }
}

