/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.statement;

import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.statement.AbstractStatementTarget;
import com.metamatrix.metamodels.db.model.statement.command.BatchSQLStatement;
import com.metamatrix.metamodels.db.platform.api.IndexingServiceModelActionRequest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BatchingStatementTarget
extends AbstractStatementTarget {
    public static final int DEFAULT_BATCHING_SIZE = 200;
    private WorkerPool statementWorkerPool;
    private Map batchInsertSQLStatements;
    private int batchingSize = 200;

    public BatchingStatementTarget(WorkerPool statementWorkerPool, int batchSize) {
        this.statementWorkerPool = statementWorkerPool;
        this.batchInsertSQLStatements = new HashMap();
        if (this.batchingSize > 0) {
            this.batchingSize = batchSize;
        } else {
            Object[] params = new String[]{Integer.toBinaryString(200)};
            DBModelPlugin.Util.log(1, DBModelPlugin.Util.getString("BatchingStatementTarget.The_batching_size_passed_to_the_instance_of_the_BatchingStatementTarget_was_<0._Default_value_of_{0}_being_used._1", params));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map map = this.batchInsertSQLStatements;
        synchronized (map) {
            Iterator iter = this.batchInsertSQLStatements.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = this.batchInsertSQLStatements.get(key);
                try {
                    this.statementWorkerPool.addWork(value);
                }
                catch (QueueSuspendedException e) {
                    DBModelPlugin.Util.log(4, (Throwable)e, DBModelPlugin.Util.getString("BatchingStatementTarget.Unable_to_add_work_to_the_statement_work_queue_for_a___flush()___command.__Flush_command_failed._1"));
                }
            }
            this.batchInsertSQLStatements.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String statement, List data, int[] sqlTypes, MetabaseRepositoryShredderComponentRequest message) {
        if (message != null) {
            Object key = this.getStatementMapKey(message, statement);
            Map map = this.batchInsertSQLStatements;
            synchronized (map) {
                Object object = this.batchInsertSQLStatements.get(key);
                BatchSQLStatement batchStatement = null;
                if (object == null) {
                    batchStatement = new BatchSQLStatement(message, statement, sqlTypes);
                    this.batchInsertSQLStatements.put(key, batchStatement);
                } else {
                    batchStatement = (BatchSQLStatement)object;
                }
                batchStatement.addStatement(data);
                if (batchStatement.getCurrentSize() > this.batchingSize) {
                    this.batchInsertSQLStatements.remove(key);
                    try {
                        this.statementWorkerPool.addWork((Object)batchStatement);
                    }
                    catch (QueueSuspendedException e) {
                        String errorMessage = DBModelPlugin.Util.getString("BatchingStatementTarget.Unable_to_add_work_for_this_message_to_the_statement_processor_queue.__Queue_was_suspended._2");
                        message.addErrorStatus(errorMessage, e);
                        DBModelPlugin.Util.log(4, (Throwable)e, errorMessage);
                    }
                }
            }
        }
        Object[] params = new String[]{statement};
        DBModelPlugin.Util.log(4, DBModelPlugin.Util.getString("BatchingStatementTarget.Unable_to_add_the_statement_{0}_to_the_BatchingStatementTarget,_the_metabase_command_in_the_message_parameter_passed_in_was_null._3", params));
    }

    private Object getStatementMapKey(IndexingServiceModelActionRequest request, String statement) {
        String key = null;
        if (request != null) {
            key = String.valueOf(request.getUserName()) + statement;
        } else {
            DBModelPlugin.Util.log(4, DBModelPlugin.Util.getString("BatchingStatementTarget.The_MetabaseRequest_parameter_passed_to_the_getStatementMapKey_was_null.__Invalid_parameter._5"));
        }
        return key;
    }
}

