/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.service.message;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.metabase.platform.DirectoryServiceFactory;
import com.metamatrix.metabase.platform.DirectoryServiceProxy;
import com.metamatrix.metabase.repository.RepositoryParameters;
import com.metamatrix.metabase.repository.api.BufferedInputStreamWrapper;
import com.metamatrix.metabase.repository.internal.message.MessageFactory;
import com.metamatrix.metabase.repository.internal.message.RequestMessage;
import com.metamatrix.metabase.repository.internal.message.ResponseMessage;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.platform.security.api.SessionToken;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BasicLazyLoadModelInputStreamWrapper
implements BufferedInputStreamWrapper {
    BufferedInputStream stream = null;
    private SessionToken token = null;
    private String userName;
    private ObjectID uuid;
    private String path;
    private String version;

    public BasicLazyLoadModelInputStreamWrapper(SessionToken token, ObjectID uuid, String path, String version) {
        this.token = token;
        this.userName = token.getUsername();
        this.uuid = uuid;
        this.path = path;
        this.version = version;
    }

    public BufferedInputStream getInputStream() throws IOException {
        if (this.stream == null) {
            try {
                this.loadModelStream();
            }
            catch (Exception err) {
                err.printStackTrace();
                throw new IOException(err.getMessage());
            }
        }
        return this.stream;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }

    public void setTempDirectoryPath(String string) {
    }

    public String getFileName() {
        return null;
    }

    private void loadModelStream() throws Exception {
        String msg = "CREATE  REQUEST-command getVersion IPath " + (this.path == null ? "NOPATH" : this.path) + " For model " + this.uuid.toString();
        DBModelPlugin.Util.log(1, msg);
        RepositoryParameters parameters = new RepositoryParameters();
        Path entryPath = new Path(this.path);
        parameters.setId(this.uuid);
        parameters.setUserName(this.userName);
        parameters.setPath((IPath)entryPath);
        parameters.setVersion(this.version);
        RequestMessage mr = MessageFactory.createRequest((String)"getVersion", (RepositoryParameters)parameters);
        ResponseMessage response = (ResponseMessage)this.submit(this.userName, mr);
        ByteArrayInputStream parserStream = null;
        parserStream = response.getContent() == null ? new ByteArrayInputStream(new byte[]{32}) : new ByteArrayInputStream(response.getContent());
        this.stream = new BufferedInputStream(parserStream);
    }

    protected Object submit(String userName, RequestMessage message) throws Exception {
        return this.getProxy().submitRequest(this.token.getSessionID(), userName, message);
    }

    private DirectoryServiceProxy getProxy() throws Exception {
        DirectoryServiceProxy dsProxy = DirectoryServiceFactory.getDirectoryServiceProxy();
        return dsProxy;
    }
}

