/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.service.message;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.metabase.repository.api.BufferedInputStreamWrapper;
import com.metamatrix.metamodels.db.model.component.ShredderRequestKey;
import com.metamatrix.metamodels.db.model.service.message.BasicBufferedInputStreamWrapper;
import com.metamatrix.metamodels.db.platform.api.IndexingServiceModelActionRequest;
import java.io.BufferedInputStream;

public class BasicIndexingServiceModelActionRequest
implements IndexingServiceModelActionRequest {
    private BufferedInputStreamWrapper stream;
    private ObjectID id = null;
    private int commandType;
    private String modelName;
    private String userName;
    private String version;
    private final String modelRepositoryPath;

    public BasicIndexingServiceModelActionRequest(ObjectID id, BufferedInputStream stream, int commandType, String modelName, String userName, String modelRepositoryPath) {
        this.id = id;
        this.userName = userName;
        this.modelName = modelName;
        this.commandType = commandType;
        this.modelRepositoryPath = modelRepositoryPath;
        this.stream = new BasicBufferedInputStreamWrapper(stream);
        this.version = "1";
    }

    public BasicIndexingServiceModelActionRequest(BufferedInputStreamWrapper stream, ShredderRequestKey key) {
        this.id = key.getObjectID();
        this.userName = key.getUserName();
        this.modelName = key.getModelName();
        this.commandType = key.getAction();
        this.modelRepositoryPath = key.getPath();
        this.stream = stream;
        this.version = key.getVersion();
    }

    public Object getModelID() {
        return this.id;
    }

    public String getModelName() {
        return this.modelName;
    }

    public BufferedInputStreamWrapper getModelStream() {
        return this.stream;
    }

    public String getModelURI() {
        return null;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getModelVersion() {
        return this.version;
    }

    public String getCommandTypeString() {
        return IndexingServiceModelActionRequest.MESSAGE_TYPE_NAMES[this.commandType];
    }

    public int getCommandType() {
        return this.commandType;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getModelRepositoryPath() {
        return this.modelRepositoryPath;
    }
}

