/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.processing.helper;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.metamodels.db.core.URIHelper;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.processing.helper.ObjectToDBMappingHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class PropertyObjectToDBMappingHelper
implements ObjectToDBMappingHelper {
    private Map metaclassURIToFeatureMappingInfos;
    private Map metaclassURIToInsertStatements;
    private Map metaclassURIToTableName;
    private Map metaclassURIToVirtualTableName;
    private Map featureURIToDefaultValue;
    private Map metaclassURIToFeatureURIs;
    private Map featureURIToEnumMetaclassURI;
    private Map featureURIToContainsRefDefaultEType;
    private Map enumMetaclassURIToLiteralMapping;

    public PropertyObjectToDBMappingHelper(Properties props) {
        ArgCheck.isNotNull((Object)props);
        this.metaclassURIToFeatureMappingInfos = new HashMap();
        this.metaclassURIToInsertStatements = new HashMap();
        this.metaclassURIToTableName = new HashMap();
        this.metaclassURIToVirtualTableName = new HashMap();
        this.featureURIToContainsRefDefaultEType = new HashMap();
        this.enumMetaclassURIToLiteralMapping = new HashMap();
        this.featureURIToDefaultValue = new HashMap();
        this.metaclassURIToFeatureURIs = new HashMap();
        this.featureURIToEnumMetaclassURI = new HashMap();
        this.parseProperties(props);
    }

    public int getFeatureValueInsertPosition(String featureURI) {
        int position = -1;
        MappingInfo info = this.getMappingInfoForFeatureURI(featureURI);
        if (info != null) {
            position = info.getPositionIndex();
        }
        return position;
    }

    public int getMaxDataValueSizeForFeature(String featureURI) {
        int size = -1;
        MappingInfo info = this.getMappingInfoForFeatureURI(featureURI);
        if (info != null) {
            size = info.getMaxColSize();
        }
        return size;
    }

    public int getJDBCSQLTypeForFeature(String featureURI) {
        int type = -1;
        MappingInfo info = this.getMappingInfoForFeatureURI(featureURI);
        if (info != null) {
            type = info.getSqlType();
        }
        return type;
    }

    public String getFeatureDefaultEType(String featureURI) {
        return (String)this.featureURIToContainsRefDefaultEType.get(featureURI);
    }

    public String getTableNameForMetaclassURI(String metaclassURI) {
        return (String)this.metaclassURIToTableName.get(metaclassURI);
    }

    public String getVirtualTableNameForMetaclassURI(String metaclassURI) {
        return (String)this.metaclassURIToVirtualTableName.get(metaclassURI);
    }

    public String getInsertStatementForMetaclassURI(String metaclassURI) {
        return (String)this.metaclassURIToInsertStatements.get(metaclassURI);
    }

    public Integer getIntValueForEnum(String enumTypeMetaclassURI, String literalValue) {
        Integer value = null;
        Map enumMap = (Map)this.enumMetaclassURIToLiteralMapping.get(enumTypeMetaclassURI);
        if (enumMap != null) {
            Integer intValue;
            value = intValue = (Integer)enumMap.get(literalValue);
        }
        return value;
    }

    public Object getDefaultValueForFeatureURI(String featureURI) {
        return (String)this.featureURIToDefaultValue.get(featureURI);
    }

    public List getFeatureURIsForMetaclassURI(String metaclassURI) {
        return (List)this.metaclassURIToFeatureURIs.get(metaclassURI);
    }

    public String getEnumTypeForFeatureURI(String featureURI) {
        return (String)this.featureURIToEnumMetaclassURI.get(featureURI);
    }

    private void parseProperties(Properties props) {
        Set keys = ((Hashtable)props).keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = props.getProperty(key);
            String uri = this.getURIFromKey(key);
            String suffix = this.getSuffix(key);
            if ("mapping".equals(suffix)) {
                Map mappingInfos = this.processFeatureMappingInfoString(uri, value);
                this.metaclassURIToFeatureMappingInfos.put(uri, mappingInfos);
                continue;
            }
            if ("insert".equals(suffix)) {
                this.metaclassURIToInsertStatements.put(uri, value);
                continue;
            }
            if ("tableName".equals(suffix)) {
                this.metaclassURIToTableName.put(uri, value);
                continue;
            }
            if ("virtualtableName".equals(suffix)) {
                this.metaclassURIToVirtualTableName.put(uri, value);
                continue;
            }
            if ("enumMap".equals(suffix)) {
                Map enumMap = this.createLiteralToValueMappingFromString(value);
                this.enumMetaclassURIToLiteralMapping.put(uri, enumMap);
                continue;
            }
            if ("default".equals(suffix)) {
                this.featureURIToDefaultValue.put(uri, value);
                continue;
            }
            if ("enumType".equals(suffix)) {
                this.featureURIToEnumMetaclassURI.put(uri, value);
                continue;
            }
            if (!"reference".equals(suffix)) continue;
            this.featureURIToContainsRefDefaultEType.put(uri, value);
        }
    }

    private String getSuffix(String key) {
        int index;
        if (key != null && (index = key.lastIndexOf(".")) != -1) {
            return key.substring(index + 1);
        }
        return null;
    }

    private String getURIFromKey(String key) {
        String uri = null;
        if (key != null) {
            uri = key.substring(0, key.lastIndexOf("."));
        }
        return uri;
    }

    private Map createLiteralToValueMappingFromString(String string) {
        HashMap<String, Integer> mappings = new HashMap<String, Integer>();
        StringTokenizer tokenizer = new StringTokenizer(string, ", ");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            StringTokenizer infoTokens = new StringTokenizer(token, "|");
            Object[] params = new String[]{string};
            Assertion.assertTrue((infoTokens.countTokens() == 2 ? 1 : 0) != 0, (String)DBModelPlugin.Util.getString("PropertyObjectToDBMappingHelper.Unable_to_parse_the_Enumeration_mapping_info_for_the_enum_value_{0}_1", params));
            String literalString = infoTokens.nextToken().trim();
            String valueString = infoTokens.nextToken().trim();
            Integer valueInt = new Integer(Integer.parseInt(valueString));
            mappings.put(literalString, valueInt);
        }
        return mappings;
    }

    private Map processFeatureMappingInfoString(String metaclassURI, String string) {
        HashMap<String, MappingInfo> infos = new HashMap<String, MappingInfo>();
        StringTokenizer tokenizer = new StringTokenizer(string, ", ");
        int i = 0;
        ArrayList<String> featureURIs = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            StringTokenizer infoTokens = new StringTokenizer(token, "|");
            Assertion.assertTrue((infoTokens.countTokens() == 3 ? 1 : 0) != 0, (String)DBModelPlugin.Util.getString("PropertyInsertMappingHelper.format_of_mapping_info_incorrect", new Object[]{string}));
            String feature = infoTokens.nextToken().trim();
            String maxColSizeString = infoTokens.nextToken().trim();
            String sqlTypeString = infoTokens.nextToken().trim();
            int sqlType = Integer.parseInt(sqlTypeString);
            int maxColSize = Integer.parseInt(maxColSizeString);
            MappingInfo info = new MappingInfo(feature, maxColSize, sqlType, i);
            infos.put(feature, info);
            featureURIs.add(URIHelper.getFeatureURI((String)metaclassURI, (String)feature));
            ++i;
        }
        this.metaclassURIToFeatureURIs.put(metaclassURI, featureURIs);
        return infos;
    }

    private MappingInfo getMappingInfoForFeatureURI(String featureURI) {
        MappingInfo info = null;
        String metaclassURI = URIHelper.getMetaclassURIFromFeatureURI((String)featureURI);
        String featureName = URIHelper.getFeatureNameFromFeatureURI((String)featureURI);
        Map infos = (Map)this.metaclassURIToFeatureMappingInfos.get(metaclassURI);
        if (infos != null) {
            info = (MappingInfo)infos.get(featureName);
        }
        return info;
    }

    private class MappingInfo {
        private int sqlType;
        private String featureName;
        private int positionIndex;
        private int maxColSize;

        public MappingInfo(String featureName, int maxColSize, int sqlType, int positionIndex) {
            this.featureName = featureName;
            this.maxColSize = maxColSize;
            this.sqlType = sqlType;
            this.positionIndex = positionIndex;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public int getSqlType() {
            return this.sqlType;
        }

        public int getPositionIndex() {
            return this.positionIndex;
        }

        public int getMaxColSize() {
            return this.maxColSize;
        }
    }
}

