/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.processing.helper;

import com.metamatrix.common.id.dbid.DBIDGenerator;
import com.metamatrix.common.id.dbid.DBIDGeneratorException;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.metamodels.db.core.URIHelper;
import com.metamatrix.metamodels.db.core.jdbc.JDBCTranslator;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.ShredderRequestKey;
import com.metamatrix.metamodels.db.model.exception.IDException;
import com.metamatrix.metamodels.db.model.exception.ResourceException;
import com.metamatrix.metamodels.db.model.pool.ConnectionPool;
import com.metamatrix.metamodels.db.model.processing.helper.IDHelper;
import com.metamatrix.metamodels.db.platform.api.IndexingServiceModelActionRequest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DBIDHelper
implements IDHelper {
    private final ConnectionPool pool;
    private static final String METACLASS_FEATURE_ID_CONTEXT = "DTFtreID";
    private static final String TRANSACTIONS_ID_CONTEXT = "DTTxnID";
    private static final String METACLASS_ID_CONTEXT = "DTMtaclsID";
    private static final String METAMODEL_ID_CONTEXT = "DTMtamdlID";
    private static final String SHREDQUEUE_ID_CONTEXT = "SHREDQUEUEID";
    private final Map featureURIToFeatureID;
    private final Map metaclassURIToMetaclassID;
    private final Map metamodelURIToMetamodelID;
    private boolean useShredQueue = false;

    public DBIDHelper(ConnectionPool pool) {
        if (pool == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("DBIDHelper.Connection_parameter_was_null"));
        }
        this.pool = pool;
        this.featureURIToFeatureID = new HashMap();
        this.metaclassURIToMetaclassID = new HashMap();
        this.metamodelURIToMetamodelID = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMetaClassFeatureID(String metaclassFeatureURI, String username) throws IDException {
        long id = -1L;
        Long longID = (Long)this.featureURIToFeatureID.get(metaclassFeatureURI);
        if (longID != null) {
            return longID;
        }
        Map map = this.featureURIToFeatureID;
        synchronized (map) {
            longID = (Long)this.featureURIToFeatureID.get(metaclassFeatureURI);
            if (longID != null) return longID;
            Connection connection = this.getConnection(username);
            try {
                try {
                    connection.setAutoCommit(false);
                    id = this.getFeatureDBIDFromDatabase(metaclassFeatureURI, connection);
                    if (id < 0L) {
                        id = this.getNextDBID(METACLASS_FEATURE_ID_CONTEXT);
                        longID = new Long(id);
                        this.loadFeatureURI(metaclassFeatureURI, id, connection, username);
                    }
                    connection.commit();
                }
                catch (SQLException e) {
                    try {
                        connection.rollback();
                        throw new IDException(e, DBModelPlugin.Util.getString("DBIDHelper.Error_getting_id", new Object[]{metaclassFeatureURI}));
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw new IDException(e, DBModelPlugin.Util.getString("DBIDHelper.Error_getting_id", new Object[]{metaclassFeatureURI}));
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.returnConnection(connection);
                throw throwable;
            }
            {
                Object var10_11 = null;
                this.returnConnection(connection);
                this.featureURIToFeatureID.put(metaclassFeatureURI, new Long(id));
            }
            return id;
        }
    }

    public long getMetaClassTypeID(String metamodelURI, String metaClassName, String username) throws IDException {
        String metaclassURI = URIHelper.getMetaClassURI((String)metamodelURI, (String)metaClassName);
        return this.getMetaClassTypeID(metaclassURI, username);
    }

    public synchronized List getMetaModelIDs(List metaModelURIList, String username) throws IDException {
        ArrayList<Long> metamodelIDs = new ArrayList<Long>();
        Iterator iter = metaModelURIList.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            metamodelIDs.add(new Long(this.getMetamodelID(element, username)));
        }
        return metamodelIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMetamodelID(String metamodelURI, String username) throws IDException {
        long id = -1L;
        Long longID = (Long)this.metamodelURIToMetamodelID.get(metamodelURI);
        if (longID != null) {
            return longID;
        }
        Map map = this.metamodelURIToMetamodelID;
        synchronized (map) {
            longID = (Long)this.metamodelURIToMetamodelID.get(metamodelURI);
            if (longID != null) return longID;
            Connection connection = this.getConnection(username);
            try {
                try {
                    connection.setAutoCommit(false);
                    id = this.getMetamodelDBIDFromDatabase(metamodelURI, connection);
                    if (id == -1L) {
                        id = this.loadMetamodelURI(metamodelURI, connection);
                    }
                    connection.commit();
                }
                catch (SQLException e) {
                    try {
                        connection.rollback();
                        throw new IDException(e, DBModelPlugin.Util.getString("DBIDHelper.Error_getting_id", new Object[]{metamodelURI}));
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw new IDException(e, DBModelPlugin.Util.getString("DBIDHelper.Error_getting_id", new Object[]{metamodelURI}));
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.returnConnection(connection);
                throw throwable;
            }
            {
                Object var10_11 = null;
                this.returnConnection(connection);
                this.metamodelURIToMetamodelID.put(metamodelURI, new Long(id));
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMetaClassTypeID(String metaclassURI, String username) throws IDException {
        long id = -1L;
        Object objectID = this.metaclassURIToMetaclassID.get(metaclassURI);
        if (objectID != null) {
            Long longID = (Long)objectID;
            return longID;
        }
        Map map = this.metaclassURIToMetaclassID;
        synchronized (map) {
            block13: {
                block12: {
                    objectID = this.metaclassURIToMetaclassID.get(metaclassURI);
                    if (objectID != null) break block12;
                    Connection connection = this.getConnection(username);
                    try {
                        try {
                            connection.setAutoCommit(false);
                            id = this.getMetaclassDBIDFromDatabase(metaclassURI, connection);
                            if (id == -1L) {
                                id = this.getNextDBID(METACLASS_ID_CONTEXT);
                                this.loadMetaclassURI(metaclassURI, id, connection, username);
                            }
                            connection.commit();
                        }
                        catch (SQLException e) {
                            try {
                                connection.rollback();
                                throw new IDException(e, DBModelPlugin.Util.getString("DBIDHelper.Error_getting_id", new Object[]{metaclassURI}));
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            throw new IDException(e, DBModelPlugin.Util.getString("DBIDHelper.Error_getting_id", new Object[]{metaclassURI}));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        this.returnConnection(connection);
                        throw throwable;
                    }
                    {
                        Object var10_13 = null;
                        this.returnConnection(connection);
                        this.metaclassURIToMetaclassID.put(metaclassURI, new Long(id));
                    }
                    break block13;
                }
                Long longID = (Long)objectID;
                return longID;
            }
            return id;
        }
    }

    public long getTransactionID() throws IDException {
        return this.getNextDBID(TRANSACTIONS_ID_CONTEXT);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createTransaction(String userName, String actionName, long timeSubmitted, long txnID) throws IDException {
        Connection connection = this.getConnection(userName);
        PreparedStatement statement = null;
        try {
            try {
                connection.setAutoCommit(false);
                statement = connection.prepareStatement(JDBCTranslator.INSERT_TRANS_TABLE);
                statement.setLong(1, txnID);
                statement.setString(5, actionName);
                statement.setString(2, userName);
                statement.setString(3, DateUtil.getDateAsString((long)timeSubmitted));
                statement.setNull(4, 12);
                statement.setNull(6, 5);
                statement.execute();
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                    throw new IDException(e, DBModelPlugin.Util.getString("DBIDHelper.Unable_to_load_a_new_Transaction_ID_into_the_database_1"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new IDException(e, DBModelPlugin.Util.getString("DBIDHelper.Unable_to_load_a_new_Transaction_ID_into_the_database_1"));
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.closeStatement(statement);
            this.returnConnection(connection);
            throw throwable;
        }
        {
            Object var11_11 = null;
            this.closeStatement(statement);
            this.returnConnection(connection);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long loadMetamodelURI(String metamodelURI, Connection connection) throws IDException {
        long id = this.getNextDBID(METAMODEL_ID_CONTEXT);
        String displayName = URIHelper.getMetamodelDisplayName((String)metamodelURI);
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement(JDBCTranslator.INSERT_METAMODELS_TABLE);
                statement.setString(3, displayName);
                statement.setString(2, metamodelURI);
                statement.setLong(1, id);
                statement.execute();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Object[] params = new Object[]{metamodelURI};
                String errorMessage = DBModelPlugin.Util.getString("DBIDHelper.Unable_to_insert_a_metamodel_with_URI__{0}_into_the_metamodels_table._1", params);
                DBModelPlugin.Util.log(4, (Throwable)e, errorMessage);
                throw new IDException(e, errorMessage);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        {
            Object var10_12 = null;
            this.closeStatement(statement);
            return id;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadMetaclassURI(String metaclassURI, long id, Connection connection, String username) throws IDException {
        String metamodelURI = URIHelper.getMetamodelURIFromMetaclassURI((String)metaclassURI);
        long metamodelID = this.getMetamodelID(metamodelURI, username);
        PreparedStatement statement = null;
        String metaclassDisplayName = URIHelper.getMetaclassDisplayName((String)metaclassURI);
        try {
            try {
                statement = connection.prepareStatement(JDBCTranslator.INSERT_METACLASS_TABLE);
                statement.setLong(1, id);
                statement.setString(4, metaclassDisplayName);
                statement.setString(2, metaclassURI);
                statement.setLong(3, metamodelID);
                statement.execute();
            }
            catch (SQLException e) {
                Object[] params = new Object[]{metaclassURI};
                String errorMessage = DBModelPlugin.Util.getString("DBIDHelper.Unable_to_load_the_metaclassURI__{0}_into_the_DTMS._2", params);
                DBModelPlugin.Util.log(4, (Throwable)e, errorMessage);
                throw new IDException(e, errorMessage);
            }
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        {
            Object var14_14 = null;
            this.closeStatement(statement);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadFeatureURI(String featureURI, long dbID, Connection connection, String username) throws IDException {
        String metamodelURI = URIHelper.getMetamodelURIFromFeatureURI((String)featureURI);
        long metamodelID = this.getMetamodelID(metamodelURI, username);
        String metaclassURI = URIHelper.getMetaclassURIFromFeatureURI((String)featureURI);
        long metaclassTypeID = this.getMetaClassTypeID(metaclassURI, username);
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement(JDBCTranslator.INSERT_FEATURES_TABLE);
                statement.setLong(1, dbID);
                statement.setString(2, featureURI);
                statement.setLong(3, metaclassTypeID);
                statement.setLong(4, metamodelID);
                statement.execute();
            }
            catch (SQLException e) {
                Object[] params = new Object[]{featureURI};
                String errorMessage = DBModelPlugin.Util.getString("DBIDHelper.Unable_to_load_the_featureURI__{0}_into_the_DTMS_DD_FTRE_table._3", params);
                DBModelPlugin.Util.log(4, (Throwable)e, errorMessage);
                throw new IDException(e, errorMessage);
            }
        }
        catch (Throwable throwable) {
            Object var16_14 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        {
            Object var16_15 = null;
            this.closeStatement(statement);
            return;
        }
    }

    public long getNextDBID(String context) throws IDException {
        long id;
        try {
            id = DBIDGenerator.getID((String)context);
        }
        catch (DBIDGeneratorException e) {
            throw new IDException(e, DBModelPlugin.Util.getString("DBIDHelper.DBIDGenerator_failed_to_initialize"));
        }
        return id;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getFeatureDBIDFromDatabase(String metaclassFeatureURI, Connection connection) throws SQLException {
        PreparedStatement statement;
        long id;
        block7: {
            id = -1L;
            statement = null;
            ResultSet set = null;
            try {
                statement = connection.prepareStatement(JDBCTranslator.SELECT_FROM_DD_FTRE_FOR_FTRE_URI);
                statement.setString(1, metaclassFeatureURI);
                statement.execute();
                set = statement.getResultSet();
                if (set.next()) {
                    id = set.getLong(1);
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (set != null) {
                    set.close();
                }
                this.closeStatement(statement);
                throw throwable;
            }
            {
                Object var8_9 = null;
                if (set == null) break block7;
            }
            set.close();
        }
        this.closeStatement(statement);
        return id;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMetaclassDBIDFromDatabase(String metaclassURI, Connection connection) throws SQLException {
        PreparedStatement statement;
        long id;
        block5: {
            id = -1L;
            statement = null;
            ResultSet set = null;
            try {
                statement = connection.prepareStatement(JDBCTranslator.SELECT_FROM_MTACLS_FOR_MTCLS_ID);
                statement.setString(1, metaclassURI);
                statement.execute();
                set = statement.getResultSet();
                if (set.next()) {
                    id = set.getLong(1);
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (set != null) {
                    set.close();
                }
                this.closeStatement(statement);
                throw throwable;
            }
            {
                Object var7_8 = null;
                if (set == null) break block5;
            }
            set.close();
        }
        this.closeStatement(statement);
        return id;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMetamodelDBIDFromDatabase(String metamodelURI, Connection connection) throws SQLException {
        PreparedStatement statement;
        long id;
        block5: {
            id = -1L;
            statement = null;
            ResultSet set = null;
            try {
                statement = connection.prepareStatement(JDBCTranslator.SELECT_FROM_MTAMDL_FOR_MTAMDL_ID);
                statement.setString(1, metamodelURI);
                statement.execute();
                set = statement.getResultSet();
                if (set.next()) {
                    id = set.getLong(1);
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (set != null) {
                    set.close();
                }
                this.closeStatement(statement);
                throw throwable;
            }
            {
                Object var7_8 = null;
                if (set == null) break block5;
            }
            set.close();
        }
        this.closeStatement(statement);
        return id;
    }

    private void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e2) {
                DBModelPlugin.Util.log(2, (Throwable)e2, DBModelPlugin.Util.getString("DBIDHelper.Unable_to_close_the_statement_in_the_DBIDHelper_class._4"));
            }
        }
    }

    public ShredderRequestKey addToShreddingQueue(IndexingServiceModelActionRequest requestMsg, String userName) throws IDException {
        long transactionID;
        ShredderRequestKey key;
        long queueid = this.getNextQueueID();
        boolean doesExist = this.isModelAlreadyQueued((key = ShredderRequestKey.createKey(requestMsg, queueid, transactionID = this.getTransactionID())).getUUID(), userName);
        key.setShredNow(!doesExist);
        if (this.useShredQueue) {
            this.addModelToQueue(userName, key);
        }
        return key;
    }

    private long getNextQueueID() throws IDException {
        return this.getNextDBID(SHREDQUEUE_ID_CONTEXT);
    }

    public ShredderRequestKey addModelToReQueue(String userName, ShredderRequestKey key) throws IDException {
        boolean doesExist = this.isModelAlreadyQueued(key.getUUID(), userName);
        key.setShredNow(!doesExist);
        if (this.useShredQueue) {
            this.addModelToQueue(userName, key);
        }
        return key;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ShredderRequestKey addModelToQueue(String userName, ShredderRequestKey key) throws IDException {
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            try {
                connection = this.getConnection(userName);
                statement = connection.prepareStatement(JDBCTranslator.INSERT_SHREDQUEUE_TABLE);
                statement.setLong(1, key.getQueueID());
                statement.setLong(2, key.getUUID1());
                statement.setLong(3, key.getUUID2());
                statement.setString(4, key.getUUID());
                statement.setString(5, key.getModelName());
                statement.setString(6, key.getVersion());
                statement.setString(7, key.getPath());
                statement.setInt(8, key.getAction());
                statement.setLong(9, key.getTransactionID());
                statement.setString(10, userName);
                statement.setString(11, DateUtil.getCurrentDateAsString());
                statement.execute();
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                    throw new IDException(e);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new IDException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeStatement(statement);
            this.returnConnection(connection);
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.closeStatement(statement);
            this.returnConnection(connection);
            return key;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isModelAlreadyQueued(String uuidString, String userName) throws IDException {
        if (!this.useShredQueue) {
            return false;
        }
        Connection connection = this.getConnection(userName);
        try {
            try {
                int cnt = this.doesModelExistInQueue(uuidString, connection);
                boolean bl = cnt > 0;
                Object var5_7 = null;
                this.returnConnection(connection);
                return bl;
            }
            catch (SQLException sq) {
                throw new IDException(sq);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.returnConnection(connection);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doesModelExistInQueue(String uuidString, Connection connection) throws SQLException {
        int cnt;
        PreparedStatement statement;
        block6: {
            if (!this.useShredQueue) {
                return 0;
            }
            statement = null;
            ResultSet set = null;
            cnt = 0;
            try {
                statement = connection.prepareStatement(JDBCTranslator.SELECT_FROM_SHREDQUEUE_BY_UUID);
                statement.setString(1, uuidString);
                statement.execute();
                set = statement.getResultSet();
                if (set.next()) {
                    ++cnt;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (set != null) {
                    set.close();
                }
                this.closeStatement(statement);
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (set == null) break block6;
            }
            set.close();
        }
        this.closeStatement(statement);
        return cnt;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFromShreddingQueue(ShredderRequestKey key) throws IDException {
        if (!this.useShredQueue) {
            return;
        }
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            try {
                connection = this.getConnection(key.getUserName());
                statement = connection.prepareStatement("DELETE  FROM DD_SHREDQUEUE WHERE TXN_ID = ?");
                statement.setLong(1, key.getTransactionID());
                statement.executeUpdate();
                connection.commit();
            }
            catch (SQLException sq) {
                try {
                    connection.rollback();
                    throw new IDException(sq);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new IDException(sq);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeStatement(statement);
            this.returnConnection(connection);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.closeStatement(statement);
            this.returnConnection(connection);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ShredderRequestKey getNextFromShreddingQueue(ShredderRequestKey key) throws IDException {
        block12: {
            if (!this.useShredQueue) {
                return null;
            }
            newKey = null;
            statement = null;
            set = null;
            connection = null;
            try {
                try {
                    connection = this.getConnection(key.getUserName());
                    statement = connection.prepareStatement(JDBCTranslator.SELECTNEXT_FROM_SHREDQUEUE);
                    statement.setString(1, key.getUUID());
                    statement.execute();
                    set = statement.getResultSet();
                    if (set.next()) {
                        queueid = set.getLong(1);
                        uuid1 = set.getLong(2);
                        uuid2 = set.getLong(3);
                        modelName = set.getString(5);
                        version = set.getString(6);
                        path = set.getString(7);
                        action = set.getInt(8);
                        txnid = set.getLong(9);
                        userName = set.getString(10);
                        newKey = ShredderRequestKey.createKey(queueid, uuid1, uuid2, modelName, version, path, txnid, userName, action);
                        newKey.setShredNow(true);
                    }
                    connection.commit();
                }
                catch (SQLException sq) {
                    throw new IDException(sq);
                }
            }
            catch (Throwable var20_16) {
                var19_17 = null;
                if (set != null) {
                    try {
                        set.close();
                    }
                    catch (SQLException var21_19) {
                        // empty catch block
                    }
                }
                this.closeStatement(statement);
                this.returnConnection(connection);
                throw var20_16;
            }
            {
                var19_18 = null;
                if (set == null) break block12;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 235->245)] { 
lbl47:
            // 1 sources

            set.close();
            break block12;
lbl49:
            // 1 sources

            catch (SQLException var21_20) {
                // empty catch block
            }
        }
        this.closeStatement(statement);
        this.returnConnection(connection);
        return newKey;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getKeysToRequeue(String calluserName) throws IDException {
        block14: {
            keys = new ArrayList<ShredderRequestKey>();
            if (!this.useShredQueue) {
                return keys;
            }
            newKey = null;
            statement = null;
            set = null;
            connection = null;
            try {
                try {
                    connection = this.getConnection(calluserName);
                    statement = connection.prepareStatement(JDBCTranslator.SELECTALL_FROM_SHREDQUEUE);
                    statement.execute();
                    set = statement.getResultSet();
                    while (true) {
                        block15: {
                            if (set.next()) break block15;
                            connection.commit();
                            break;
                        }
                        queueid = set.getLong(1);
                        uuid1 = set.getLong(2);
                        uuid2 = set.getLong(3);
                        modelName = set.getString(5);
                        version = set.getString(6);
                        path = set.getString(7);
                        action = set.getInt(8);
                        if (action == 0) {
                            action = 2;
                        }
                        txnid = this.getTransactionID();
                        newqueueid = this.getNextQueueID();
                        this.updateKeyInQueue(queueid, newqueueid, txnid, connection);
                        userName = set.getString(10);
                        minQueue = set.getLong("MIN_QUEUE_ID");
                        newKey = ShredderRequestKey.createKey(newqueueid, uuid1, uuid2, modelName, version, path, txnid, userName, action);
                        if (minQueue == 0L || queueid < minQueue) {
                            newKey.setShredNow(true);
                        }
                        keys.add(newKey);
                    }
                }
                catch (SQLException sq) {
                    throw new IDException(sq);
                }
            }
            catch (Throwable var25_19) {
                var24_20 = null;
                if (set != null) {
                    try {
                        set.close();
                    }
                    catch (SQLException var26_22) {
                        // empty catch block
                    }
                }
                this.closeStatement(statement);
                this.returnConnection(connection);
                throw var25_19;
            }
            {
                var24_21 = null;
                if (set == null) break block14;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 292->302)] { 
lbl58:
            // 1 sources

            set.close();
            break block14;
lbl60:
            // 1 sources

            catch (SQLException var26_23) {
                // empty catch block
            }
        }
        this.closeStatement(statement);
        this.returnConnection(connection);
        return keys;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getKeysToQueue(String userName) throws IDException {
        block12: {
            keys = new ArrayList<ShredderRequestKey>();
            if (!this.useShredQueue) {
                return keys;
            }
            statement = null;
            set = null;
            connection = null;
            try {
                try {
                    connection = this.getConnection(userName);
                    statement = connection.prepareStatement(JDBCTranslator.SELECT_MODELS_TO_REQUEUE);
                    statement.execute();
                    set = statement.getResultSet();
                    while (true) {
                        block13: {
                            if (set.next()) break block13;
                            connection.commit();
                            break;
                        }
                        uuid1 = set.getLong(1);
                        uuid2 = set.getLong(2);
                        modelName = set.getString(3);
                        version = set.getString(5);
                        action = set.getInt(7);
                        queueID = this.getNextQueueID();
                        transactionID = this.getTransactionID();
                        newKey = ShredderRequestKey.createKey(queueID, uuid1, uuid2, modelName, version, "", transactionID, userName, action);
                        newKey.setShredNow(true);
                        keys.add(newKey);
                    }
                }
                catch (SQLException sq) {
                    throw new IDException(sq);
                }
            }
            catch (Throwable var19_15) {
                var18_16 = null;
                if (set != null) {
                    try {
                        set.close();
                    }
                    catch (SQLException var20_18) {
                        // empty catch block
                    }
                }
                this.closeStatement(statement);
                this.returnConnection(connection);
                throw var19_15;
            }
            {
                var18_17 = null;
                if (set == null) break block12;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 209->219)] { 
lbl49:
            // 1 sources

            set.close();
            break block12;
lbl51:
            // 1 sources

            catch (SQLException var20_19) {
                // empty catch block
            }
        }
        this.closeStatement(statement);
        this.returnConnection(connection);
        return keys;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isShreddingQueueAvailable(String userName) {
        this.useShredQueue = false;
        Connection connection = null;
        try {
            try {
                connection = this.getConnection(userName);
                ResultSet set = connection.getMetaData().getTables(null, null, "DD_SHREDQUEUE", new String[]{"TABLE"});
                if (set.next()) {
                    this.useShredQueue = true;
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.returnConnection(connection);
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.returnConnection(connection);
            return this.useShredQueue;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateKeyInQueue(long origQueueID, long newQueueID, long newTxnID, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("UPDATE DD_SHREDQUEUE SET QUEUE_ID = ?, TXN_ID = ? WHERE QUEUE_ID = ?");
            statement.setLong(1, newQueueID);
            statement.setLong(2, newTxnID);
            statement.setLong(3, origQueueID);
            statement.executeUpdate();
            connection.commit();
            DBModelPlugin.Util.log(2, "UPDATE DD_SHREDQUEUE SET QUEUE_ID = ?, TXN_ID = ? WHERE QUEUE_ID = ?");
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        {
            Object var9_8 = null;
            this.closeStatement(statement);
            return;
        }
    }

    private Connection getConnection(String userName) throws IDException {
        try {
            return this.pool.getConnection(userName);
        }
        catch (ResourceException e1) {
            throw new IDException((Throwable)((Object)e1));
        }
    }

    private void returnConnection(Connection connection) {
        this.pool.returnConnection(connection);
    }
}

