/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.processing.command;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.UUID;
import com.metamatrix.metamodels.db.core.jdbc.JDBCTranslator;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.MetabaseRepositoryShredderConfigSource;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.exception.ProcessingException;
import com.metamatrix.metamodels.db.model.exception.ResourceException;
import com.metamatrix.metamodels.db.model.pool.ConnectionPool;
import com.metamatrix.metamodels.db.model.processing.command.Command;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeleteFileCommand
implements Command {
    private MetabaseRepositoryShredderComponentRequest message;
    private ConnectionPool pool;
    private MetabaseRepositoryShredderConfigSource config;
    private boolean notifyWhenFinishedProcessing = true;

    public DeleteFileCommand(ConnectionPool pool, MetabaseRepositoryShredderConfigSource config, MetabaseRepositoryShredderComponentRequest message) {
        if (pool == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("DeleteFileCommand.The_connection_pool_passed_into_the_Constructor_of_the_DeleteFileCommand_was_null.__Unable_to_instantiate_command._1"));
        }
        if (message == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("DeleteFileCommand.The_ResponseMessage_passed_into_the_Constructor_of_the_DeleteFileCommand_was_null.__Unable_to_instantiate_command._2"));
        }
        if (config == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("DeleteFileCommand.The_configuration_source_instance_used_to_instantiate_a_DeleteFileCommand_was_null.__Cannot_instantiate._1"));
        }
        this.config = config;
        this.pool = pool;
        this.message = message;
    }

    public DeleteFileCommand(ConnectionPool pool, MetabaseRepositoryShredderConfigSource config, MetabaseRepositoryShredderComponentRequest message, boolean notifyWhenFinished) {
        if (pool == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("DeleteFileCommand.The_connection_pool_passed_into_the_Constructor_of_the_DeleteFileCommand_was_null.__Unable_to_instantiate_command._1"));
        }
        if (message == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("DeleteFileCommand.The_ResponseMessage_passed_into_the_Constructor_of_the_DeleteFileCommand_was_null.__Unable_to_instantiate_command._2"));
        }
        if (config == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("DeleteFileCommand.The_configuration_source_instance_used_to_instantiate_a_DeleteFileCommand_was_null.__Cannot_instantiate._1"));
        }
        this.config = config;
        this.pool = pool;
        this.message = message;
        this.notifyWhenFinishedProcessing = notifyWhenFinished;
    }

    public void execute() throws ProcessingException {
        String username = this.message.getUserName();
        Object modelID = this.message.getModelID();
        String modelVersion = this.message.getModelVersion();
        if (modelID != null) {
            List txnIDs = this.getTxnIDsForModelID(modelID, modelVersion, username);
            Iterator iter = txnIDs.iterator();
            while (iter.hasNext()) {
                Long txnID = (Long)iter.next();
                this.deleteAllForTxnID(txnID, username);
            }
            if (this.notifyWhenFinishedProcessing) {
                this.message.setTransactionState(4);
            }
        } else {
            Object[] params = new String[]{};
            String message = DBModelPlugin.Util.getString("DeleteFileCommand.The_Model_ID_object_retreived_from_the_MetabaseRequest_for_the_DeleteFileCommand_was_null.__Cannot_process_this_command._1", params);
            DBModelPlugin.Util.log(4, message);
            throw new ProcessingException(message);
        }
    }

    private void deleteAllForTxnID(long txnID, String username) throws ProcessingException {
        this.deleteAllFromMetaclassTables(username, txnID);
        this.deleteAllFromIndexTable(username, txnID);
        this.deleteAllFromMetamodelsToMdlIntersect(username, txnID);
        this.deleteAllFromRelationshipsTable(username, txnID);
        this.deleteAllFromRelationshipsTable(username, txnID);
        this.deleteAllFromModelsTable(username, txnID);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAllFromMetaclassTables(String username, long txnID) throws ProcessingException {
        Connection connection = this.getConnection(username);
        List tablesToBeDeletedFrom = this.getTablesToBeDeletedFrom(txnID, username, connection);
        List deleteStatements = this.createDeleteStatements(tablesToBeDeletedFrom, txnID);
        Iterator iter = deleteStatements.iterator();
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {}
        block9: while (iter.hasNext()) {
            int i = 0;
            while (true) {
                Object var14_15;
                if (i >= this.config.getStatementBatchingSize() || !iter.hasNext()) {
                    this.pool.returnConnection(connection);
                    continue block9;
                }
                String sql = (String)iter.next();
                Statement statement = null;
                try {
                    try {
                        statement = connection.createStatement();
                        statement.execute(sql);
                        connection.commit();
                    }
                    catch (SQLException e) {
                        try {
                            connection.rollback();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        Object[] params = new String[]{sql};
                        String message = DBModelPlugin.Util.getString("DeleteFileCommand.There_was_an_error_executing_the_statement____{0}___for_a_DeleteFileCommand._4", params);
                        DBModelPlugin.Util.log(4, (Throwable)e, message);
                    }
                }
                catch (Throwable throwable) {
                    var14_15 = null;
                    this.closeStatement(statement);
                    throw throwable;
                }
                {
                    var14_15 = null;
                    this.closeStatement(statement);
                    ++i;
                    continue;
                }
                break;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAllFromIndexTable(String username, long txnID) throws ProcessingException {
        Connection connection = this.getConnection(username);
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("DELETE  FROM DD_INDEX WHERE TXN_ID = ?");
                statement.setLong(1, txnID);
                statement.execute();
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Object[] params = new String[]{String.valueOf(txnID)};
                String message = DBModelPlugin.Util.getString("DeleteFileCommand.Unable_to_delete_the_rows_from_the_index_table_for_the_transaction_id__{0}._1", params);
                DBModelPlugin.Util.log(4, (Throwable)e, message);
                throw new ProcessingException(e, message);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeStatement(statement);
            this.pool.returnConnection(connection);
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.closeStatement(statement);
            this.pool.returnConnection(connection);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAllFromMetamodelsToMdlIntersect(String username, long txnID) throws ProcessingException {
        Connection connection = this.getConnection(username);
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("DELETE  FROM DD_MDL_MTAMDL WHERE TXN_ID = ?");
                statement.setLong(1, txnID);
                statement.execute();
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Object[] params = new String[]{String.valueOf(txnID)};
                String message = DBModelPlugin.Util.getString("DeleteFileCommand.Unable_to_delete_the_rows_from_the_metamodels_to_models_intersect_table_for_the_transaction_id__{0}._2", params);
                DBModelPlugin.Util.log(4, (Throwable)e, message);
                throw new ProcessingException(e, message);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeStatement(statement);
            this.pool.returnConnection(connection);
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.closeStatement(statement);
            this.pool.returnConnection(connection);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAllFromRelationshipsTable(String username, long txnID) throws ProcessingException {
        Connection connection = this.getConnection(username);
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("DELETE  FROM DD_RELATIONSHIPS WHERE TXN_ID = ?");
                statement.setLong(1, txnID);
                statement.execute();
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Object[] params = new String[]{String.valueOf(txnID)};
                String message = DBModelPlugin.Util.getString("DeleteFileCommand.Unable_to_delete_the_rows_from_the_relationships_table_for_the_transaction_id__{0}._3", params);
                DBModelPlugin.Util.log(4, (Throwable)e, message);
                throw new ProcessingException(e, message);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeStatement(statement);
            this.pool.returnConnection(connection);
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.closeStatement(statement);
            this.pool.returnConnection(connection);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAllFromModelsTable(String username, long txnID) throws ProcessingException {
        Connection connection = this.getConnection(username);
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("DELETE  FROM DD_MDL WHERE TXN_ID = ?");
                statement.setLong(1, txnID);
                statement.execute();
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Object[] params = new String[]{String.valueOf(txnID)};
                String message = DBModelPlugin.Util.getString("DeleteFileCommand.Unable_to_delete_the_rows_from_the_models_table_for_the_transaction_id__{0}._4", params);
                DBModelPlugin.Util.log(4, (Throwable)e, message);
                throw new ProcessingException(e, message);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeStatement(statement);
            this.pool.returnConnection(connection);
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.closeStatement(statement);
            this.pool.returnConnection(connection);
            return;
        }
    }

    private List createDeleteStatements(List tablesToBeDeletedFrom, long txnID) {
        ArrayList<String> deleteStatements = new ArrayList<String>();
        Iterator iter = tablesToBeDeletedFrom.iterator();
        while (iter.hasNext()) {
            String tableName = (String)iter.next();
            String statement = "DELETE FROM " + tableName + " " + "WHERE" + " " + tableName + "." + "TXN_ID" + " = " + txnID;
            deleteStatements.add(statement);
        }
        return deleteStatements;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getTablesToBeDeletedFrom(long txnID, String username, Connection connection) throws ProcessingException {
        PreparedStatement statement = null;
        ArrayList<String> tablesList = new ArrayList<String>();
        try {
            try {
                statement = connection.prepareStatement(JDBCTranslator.SelectFromIndexForTxnID.SQL);
                statement.setLong(1, txnID);
                statement.execute();
                ResultSet set = statement.getResultSet();
                while (set.next()) {
                    String tableName = set.getString("DETAIL_TBLE_NME");
                    tablesList.add(tableName);
                }
            }
            catch (SQLException e) {
                Object[] params = new String[]{String.valueOf(txnID)};
                String message = DBModelPlugin.Util.getString("DeleteFileCommand.Unable_to_get_the_table_names_for_the_transaction__{0}_from_the_index_table._3", params);
                DBModelPlugin.Util.log(4, (Throwable)e, message);
                throw new ProcessingException(e, message);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.closeStatement(statement);
            this.pool.returnConnection(connection);
            throw throwable;
        }
        {
            Object var10_13 = null;
            this.closeStatement(statement);
            this.pool.returnConnection(connection);
            return tablesList;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getTxnIDsForModelID(Object modelID, String modelVersion, String username) throws ProcessingException {
        ArrayList<Long> ids = new ArrayList<Long>();
        Connection connection = this.getConnection(username);
        PreparedStatement statement = null;
        try {
            try {
                if (modelID instanceof UUID) {
                    UUID uuid = (UUID)modelID;
                    long uuid1 = UUID.getPart1((ObjectID)uuid);
                    long uuid2 = UUID.getPart2((ObjectID)uuid);
                    statement = connection.prepareStatement(JDBCTranslator.SelectFromMdlTableForModelUUID.SQL);
                    statement.setLong(1, uuid1);
                    statement.setLong(2, uuid2);
                    statement.execute();
                    ResultSet set = statement.getResultSet();
                    while (set.next()) {
                        long txnID = set.getLong("TXN_ID");
                        ids.add(new Long(txnID));
                    }
                } else {
                    String lgclID = modelID.toString();
                    statement = connection.prepareStatement(JDBCTranslator.SelectFromMdlTableForModelLgclID.SQL);
                    statement.setString(1, lgclID);
                    statement.setString(2, modelVersion);
                    statement.execute();
                    ResultSet set = statement.getResultSet();
                    while (set.next()) {
                        long txnID = set.getLong("TXN_ID");
                        ids.add(new Long(txnID));
                    }
                }
            }
            catch (SQLException e1) {
                Object[] params = new String[]{modelID.toString()};
                String message = DBModelPlugin.Util.getString("DeleteFileCommand.Failed_trying_to_get_the_transaction_id_for_the_modelID_{0}._Unable_to_process_the_DeleteFileCommand._5", params);
                DBModelPlugin.Util.log(4, (Throwable)e1, message);
                throw new ProcessingException(e1, message);
            }
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            this.closeStatement(statement);
            this.pool.returnConnection(connection);
            throw throwable;
        }
        {
            Object var15_20 = null;
            this.closeStatement(statement);
            this.pool.returnConnection(connection);
            return ids;
        }
    }

    private Connection getConnection(String username) throws ProcessingException {
        Connection connection;
        try {
            connection = this.pool.getConnection(username);
        }
        catch (ResourceException e1) {
            Object[] params = new String[]{};
            String message = DBModelPlugin.Util.getString("DeleteFileCommand.Unable_to_get_a_Connection_to_execute_a_DeleteFileCommand.__Cannot_execute_command._2", params);
            DBModelPlugin.Util.log(4, (Throwable)((Object)e1), message);
            throw new ProcessingException((Throwable)((Object)e1), message);
        }
        return connection;
    }

    private void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e2) {
                Object[] params = new String[]{};
                DBModelPlugin.Util.log(2, (Throwable)e2, DBModelPlugin.Util.getString("DeleteFileCommand.Unable_to_close_the_JDBC_statement_in_the_DeleteFileCommand._6", params));
            }
        }
    }
}

