/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.processing.command;

import com.metamatrix.metamodels.db.model.component.MetabaseRepositoryShredderConfigSource;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.pool.ConnectionPool;
import com.metamatrix.metamodels.db.model.processing.command.AddFileCommand;
import com.metamatrix.metamodels.db.model.processing.command.Command;
import com.metamatrix.metamodels.db.model.processing.command.DeleteFileCommand;
import com.metamatrix.metamodels.db.model.processing.command.ReplaceCommand;
import com.metamatrix.metamodels.db.model.processing.helper.IDHelper;
import com.metamatrix.metamodels.db.model.processing.helper.ObjectToDBMappingHelper;
import com.metamatrix.metamodels.db.model.processing.helper.PropertyObjectToDBMappingHelper;
import com.metamatrix.metamodels.db.model.statement.StatementTarget;
import com.metamatrix.metamodels.db.model.statement.StatementTargetFactory;

public class CommandFactory {
    private ConnectionPool pool;
    private IDHelper helper;
    private StatementTargetFactory factory;
    private MetabaseRepositoryShredderConfigSource config;
    private ObjectToDBMappingHelper mappingHelper;

    public CommandFactory(ConnectionPool pool, MetabaseRepositoryShredderConfigSource config, IDHelper helper, StatementTargetFactory factory) {
        this.pool = pool;
        this.config = config;
        this.factory = factory;
        this.helper = helper;
        this.mappingHelper = new PropertyObjectToDBMappingHelper(config.getInsertMappingProperties());
    }

    public Command createCommand(MetabaseRepositoryShredderComponentRequest message) {
        Command command = null;
        int commandType = message.getCommandType();
        if (commandType == 0) {
            StatementTarget target = this.factory.getStatementTarget(message.getUserName());
            command = new AddFileCommand(message, this.helper, target, this.mappingHelper);
        } else if (commandType == 1) {
            command = new DeleteFileCommand(this.pool, this.config, message);
        } else if (commandType == 2) {
            StatementTarget target = this.factory.getStatementTarget(message.getUserName());
            command = new ReplaceCommand(message, this.pool, this.config, this.helper, target, this.mappingHelper);
        }
        return command;
    }
}

