/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.processing.command;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.metabase.repository.api.BufferedInputStreamWrapper;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.exception.ProcessingException;
import com.metamatrix.metamodels.db.model.processing.MMUUIDXMIModelProcessorHandler;
import com.metamatrix.metamodels.db.model.processing.command.Command;
import com.metamatrix.metamodels.db.model.processing.helper.IDHelper;
import com.metamatrix.metamodels.db.model.processing.helper.ObjectToDBMappingHelper;
import com.metamatrix.metamodels.db.model.statement.StatementTarget;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AddFileCommand
implements Command {
    private IDHelper helper;
    private StatementTarget target;
    private IDGenerator generator = new IDGenerator();
    private ObjectToDBMappingHelper insertMappingHelper;
    private MetabaseRepositoryShredderComponentRequest message;

    public AddFileCommand(MetabaseRepositoryShredderComponentRequest message, IDHelper helper, StatementTarget target, ObjectToDBMappingHelper insertMappingHelper) {
        if (message == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("AddFileCommand.The_ResponseCommand_used_to_create_an_AddFileCommand_cannot_be_null._1"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("AddFileCommand.The_IDHelper_instance_used_to_create_an_AddFileCommand_cannot_be_null._2"));
        }
        if (target == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("AddFileCommand.The_StatementTarget_instance_used_to_create_an_AddFileCommand_cannot_be_null._3"));
        }
        if (insertMappingHelper == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("AddFileCommand.The_ObjectToDBMappingHelper_instance_used_to_create_an_AddFileCommand_cannot_be_null._4"));
        }
        this.helper = helper;
        this.message = message;
        this.target = target;
        this.insertMappingHelper = insertMappingHelper;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws ProcessingException {
        SAXParser parser = null;
        if (parser == null) {
            try {
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                saxFactory.setNamespaceAware(true);
                parser = saxFactory.newSAXParser();
            }
            catch (Exception e) {
                throw new ProcessingException(e, DBModelPlugin.Util.getString("ModelProcessor.Unable_to_initialize_SAXParser_instance"));
            }
        }
        MMUUIDXMIModelProcessorHandler handler = new MMUUIDXMIModelProcessorHandler(this.generator, this.helper, this.insertMappingHelper, this.message, this.target);
        if (parser == null) {
            this.message.setTransactionState(5);
            throw new ProcessingException(DBModelPlugin.Util.getString("ModelProcessor.Parser_was_null"));
        }
        this.message.setTransactionState(2);
        try {
            try {
                InputSource source = new InputSource(this.message.getModelStream().getInputStream());
                parser.parse(source, (DefaultHandler)handler);
                this.message.setTransactionState(3);
                this.message.getModelStream().close();
            }
            catch (SAXException e1) {
                this.message.setTransactionState(5);
                Exception e = e1.getException();
                if (e != null) {
                    e.printStackTrace();
                }
                throw new ProcessingException(e1, DBModelPlugin.Util.getString("ModelProcessor.model_parsing_error", new Object[]{this.message.getModelName()}));
            }
            catch (IOException e1) {
                this.message.setTransactionState(5);
                throw new ProcessingException(e1, DBModelPlugin.Util.getString("ModelProcessor.model_reading_error", new Object[]{this.message.getModelName()}));
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.target.flush();
            try {
                BufferedInputStreamWrapper stream = this.message.getModelStream();
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                DBModelPlugin.Util.log(2, DBModelPlugin.Util.getString("AddFileCommand.Unable_to_close_the_input_stream_for_the_input_model_that_was_being_indexed_by_the_Indexing_Service_7"));
            }
            throw throwable;
        }
        {
            Object var5_10 = null;
            this.target.flush();
            try {}
            catch (IOException e) {
                DBModelPlugin.Util.log(2, DBModelPlugin.Util.getString("AddFileCommand.Unable_to_close_the_input_stream_for_the_input_model_that_was_being_indexed_by_the_Indexing_Service_7"));
                return;
            }
            BufferedInputStreamWrapper stream = this.message.getModelStream();
            if (stream == null) return;
            stream.close();
            return;
        }
    }
}

