/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.processing;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class XMIStringUtil {
    public static final String HREF_VALUE_REFERENCE_DELIMITER = "#";
    public static final String PREFIX_LOCAL_NAME_SEPERATOR = ":";

    public static List parseXmlListAttributeValue(String attributeValue) {
        ArgCheck.isNotNull((Object)attributeValue);
        StringTokenizer tokenizer = new StringTokenizer(attributeValue, StringUtil.Constants.SPACE);
        LinkedList<String> items = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            items.add(tokenizer.nextToken());
        }
        return items;
    }

    public static boolean isAttributeValueAHref(String attributeValue) {
        ArgCheck.isNotNull((Object)attributeValue);
        return attributeValue.indexOf(HREF_VALUE_REFERENCE_DELIMITER) > 0;
    }

    public static String getUriFromHrefAttributeValue(String attributeValue) {
        if (XMIStringUtil.isAttributeValueAHref(attributeValue)) {
            return attributeValue.substring(0, attributeValue.indexOf(HREF_VALUE_REFERENCE_DELIMITER));
        }
        return null;
    }

    public static String getLocalXmiIdFromHrefAttributeValue(String attributeValue) {
        if (XMIStringUtil.isAttributeValueAHref(attributeValue)) {
            return attributeValue.substring(attributeValue.indexOf(HREF_VALUE_REFERENCE_DELIMITER) + 1);
        }
        return null;
    }

    public static boolean isAttributeValuePrefixed(String attributeValue) {
        ArgCheck.isNotNull((Object)attributeValue);
        return attributeValue.indexOf(PREFIX_LOCAL_NAME_SEPERATOR) > 0;
    }

    public static String getPrefixFromAttributeValue(String attributeValue) {
        if (XMIStringUtil.isAttributeValuePrefixed(attributeValue)) {
            return attributeValue.substring(0, attributeValue.indexOf(PREFIX_LOCAL_NAME_SEPERATOR));
        }
        return null;
    }

    public static String getLocalNameFromPrefixedAttributeValue(String attributeValue) {
        if (XMIStringUtil.isAttributeValuePrefixed(attributeValue)) {
            return attributeValue.substring(attributeValue.indexOf(PREFIX_LOCAL_NAME_SEPERATOR) + 1);
        }
        return null;
    }
}

