/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.processing;

import com.metamatrix.core.collection.NonSynchronizedStack;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.UUID;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.db.core.MetamodelsDBConstants;
import com.metamatrix.metamodels.db.core.URIHelper;
import com.metamatrix.metamodels.db.core.jdbc.JDBCNames;
import com.metamatrix.metamodels.db.core.jdbc.JDBCTranslator;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.exception.IDException;
import com.metamatrix.metamodels.db.model.exception.ProcessingException;
import com.metamatrix.metamodels.db.model.processing.FeatureInstance;
import com.metamatrix.metamodels.db.model.processing.MetaclassInstance;
import com.metamatrix.metamodels.db.model.processing.XMIStringUtil;
import com.metamatrix.metamodels.db.model.processing.helper.IDHelper;
import com.metamatrix.metamodels.db.model.processing.helper.ObjectToDBMappingHelper;
import com.metamatrix.metamodels.db.model.statement.StatementTarget;
import com.metamatrix.modeler.core.util.UriPathConverter;
import com.metamatrix.modeler.internal.core.util.BasicUriPathConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMIModelProcessorHandler
extends DefaultHandler {
    protected static final String ROOT_XMI_ELEMENT_NAME = "XMI";
    protected static final String XMI_UUID_ATTRIBUTE_NAME = "uuid";
    protected static final String XMI_ID_ATTRIBUTE_NAME = "id";
    protected static final String HREF_ATTRIBUTE_NAME = "href";
    protected static final String IDREF_ATTRIBUTE_NAME = "idref";
    protected static final String TYPE_ATTRIBUTE_NAME = "type";
    protected static final String NAME_ATTRIBUTE = "name";
    private static final String XMI_URI = "http://www.omg.org/XMI";
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final int INDEX_TABLE_COLUMN_COUNT = 16;
    private static final int RELATIONSHIPS_TABLE_COLUMN_COUNT = 11;
    private static final int MODEL_ID_DATA_LENGTH = 4;
    private static final Collection notFeaturesNamespaces = new ArrayList();
    private final Map lgclIDsToDBID;
    private final NonSynchronizedStack objectInstanceStack;
    private final StatementTarget target;
    private final IDGenerator idGenerator;
    private final IDHelper idHelper;
    private final ObjectToDBMappingHelper insertMappingHelper;
    private final Map prefixToURIMapping;
    private final MetabaseRepositoryShredderComponentRequest request;
    private final List metamodelIDs;
    private List modelIDData;
    private final UriPathConverter converter = new BasicUriPathConverter();

    static {
        notFeaturesNamespaces.add(XMI_URI);
        notFeaturesNamespaces.add(XSI_URI);
    }

    public XMIModelProcessorHandler(IDGenerator idGenerator, IDHelper idHelper, ObjectToDBMappingHelper insertMappingHelper, MetabaseRepositoryShredderComponentRequest request, StatementTarget target) {
        if (request == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("XMIModelProcessorHandler.Attempt_to_initialize_XMIModelProcessorHandler_with_a_null_ResponseMessage.__Unable_to_initialize_1"));
        }
        if (target == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("XMIModelProcessorHandler.The_target_instance_passed_to_the_initialize_method_of_the_XMIModelProcessorHandler_was_null.__Unable_to_initialize._1"));
        }
        if (idGenerator == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("XMIModelProcessorHandler.Constructor_args_null"));
        }
        if (idHelper == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("XMIModelProcessorHandler.Constructor_args_null"));
        }
        this.idGenerator = idGenerator;
        this.idHelper = idHelper;
        this.insertMappingHelper = insertMappingHelper;
        this.target = target;
        this.request = request;
        this.lgclIDsToDBID = new HashMap();
        this.prefixToURIMapping = new HashMap();
        this.metamodelIDs = new ArrayList();
        this.objectInstanceStack = new NonSynchronizedStack();
    }

    protected XMIModelProcessorHandler() {
        this.idGenerator = new IDGenerator();
        this.lgclIDsToDBID = new HashMap();
        this.prefixToURIMapping = new HashMap();
        this.metamodelIDs = new ArrayList();
        this.objectInstanceStack = new NonSynchronizedStack();
        this.target = null;
        this.idHelper = null;
        this.insertMappingHelper = null;
        this.request = null;
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        Object stackObject = this.objectInstanceStack.peek();
        if (stackObject instanceof FeatureInstance) {
            FeatureInstance featureInstance = (FeatureInstance)stackObject;
            StringBuffer buffer = new StringBuffer();
            buffer.append(arg0, arg1, arg2);
            featureInstance.addCharacterData(buffer.toString());
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.loadMetamodelsToModelsIntersectTable(this.getModelIDData());
        }
        catch (ProcessingException e) {
            Object[] params = new Object[]{this.request.getModelName()};
            String errorMessage = DBModelPlugin.Util.getString("XMIModelProcessorHandler.Unable_to_load_the_metamodels_for_the_model__{0}_1", params);
            DBModelPlugin.Util.log(4, (Throwable)((Object)e), errorMessage);
            this.request.addWarningStatus(errorMessage, (Throwable)((Object)e));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Object instance = this.objectInstanceStack.pop();
        if (instance instanceof MetaclassInstance) {
            MetaclassInstance metaclassInstance = (MetaclassInstance)instance;
            this.target.put(metaclassInstance.getStatement(), metaclassInstance.getInsertData(), metaclassInstance.getSQLTypesForValues(), this.request);
        } else if (instance instanceof FeatureInstance) {
            FeatureInstance featureInstance = (FeatureInstance)instance;
            Object parentObject = this.objectInstanceStack.peek();
            if (parentObject instanceof MetaclassInstance) {
                MetaclassInstance metaclassInstance = (MetaclassInstance)parentObject;
                metaclassInstance.setFeatureValue(featureInstance.getFeatureURI(), featureInstance.getFeatureValue());
            } else {
                Object[] params = new Object[]{featureInstance.getFeatureURI()};
                String errorMessage = String.valueOf(DBModelPlugin.Util.getString("XMIModelProcessorHandler.Unable_to_parse_the_model_file.__It_was_determined_that_there_was_1", params)) + DBModelPlugin.Util.getString("XMIModelProcessorHandler.a_feature_in_the_file__{0}_was_encountered_in_a_situation_where_it_appears_that_2", params) + DBModelPlugin.Util.getString("XMIModelProcessorHandler.its_parent_was_not_of_an_object_type_defined_as_a_metaclass_in_the_known_metamodels._3", params);
                DBModelPlugin.Util.log(4, errorMessage);
                throw new SAXException(errorMessage);
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        NonSynchronizedStack stack = (NonSynchronizedStack)this.prefixToURIMapping.get(prefix);
        if (stack != null) {
            stack.pop();
        }
    }

    public void startDocument() throws SAXException {
        this.loadModelsTable(this.getModelIDData());
    }

    public void startElement(String nsURI, String localName, String qName, Attributes attr) throws SAXException {
        Object stackObject = null;
        if (!ROOT_XMI_ELEMENT_NAME.equals(localName) || !XMI_URI.equals(nsURI)) {
            Object parentInstance = this.objectInstanceStack.peek();
            List parentIDData = null;
            String parentMetaclassURI = null;
            if (parentInstance == null) {
                parentIDData = this.getDBIDToInsertDataList(null, null);
            } else if (parentInstance instanceof MetaclassInstance) {
                MetaclassInstance metaclass = (MetaclassInstance)parentInstance;
                parentIDData = metaclass.getIDData();
                parentMetaclassURI = metaclass.getMetaclassURI();
            } else if (parentInstance instanceof FeatureInstance) {
                Object[] params = new Object[]{localName};
                String errorMessage = String.valueOf(DBModelPlugin.Util.getString("XMIModelProcessorHandler.Unable_to_parse_the_model_file.__The_element__{0}_was_determined_to_4", params)) + DBModelPlugin.Util.getString("XMIModelProcessorHandler.be_the_child_of_an_element_which_was_determined_to_be_a___feature__.__This_violates_5", params) + DBModelPlugin.Util.getString("XMIModelProcessorHandler.the_XMI_specification_for_a_model_file._6", params);
                DBModelPlugin.Util.log(4, errorMessage);
                this.request.addErrorStatus(errorMessage, null);
                throw new SAXException(errorMessage);
            }
            String metaClassURI = this.getMetaClassURIForElement(nsURI, localName, qName, attr);
            if (metaClassURI != null) {
                long metaClassURIID;
                try {
                    metaClassURIID = this.idHelper.getMetaClassTypeID(metaClassURI, this.request.getUserName());
                }
                catch (IDException e) {
                    throw new SAXException((Exception)((Object)e));
                }
                List idInsertData = this.getIDInsertData(attr);
                String insertStatement = this.insertMappingHelper.getInsertStatementForMetaclassURI(metaClassURI);
                try {
                    stackObject = this.createMetaclassInstance(metaClassURI, metaClassURIID, attr, idInsertData, insertStatement);
                }
                catch (ProcessingException e1) {
                    throw new SAXException((Exception)((Object)e1));
                }
                this.processElementForIndexTable(metaClassURI, metaClassURIID, attr, idInsertData, parentIDData);
            } else if (parentInstance == null) {
                Object[] params = new Object[]{localName};
                String errorMessage = String.valueOf(DBModelPlugin.Util.getString("XMIModelProcessorHandler.Unable_to_parse_the_model_file._The_element_{0}_was_determined_7", params)) + DBModelPlugin.Util.getString("XMIModelProcessorHandler.to_be_a_feature_of_an_entity,_but_its_parent_element_could_not_be_determined_to_be__8", params) + DBModelPlugin.Util.getString("XMIModelProcessorHandler.a_metaclass_instance._9", params);
                DBModelPlugin.Util.log(1, errorMessage);
                this.request.addInfoStatus(errorMessage, null);
            } else {
                String idString = null;
                String hrefAttrValue = this.getAttrValue(XMI_URI, HREF_ATTRIBUTE_NAME, attr);
                String idrefAttrValue = this.getAttrValue(XMI_URI, IDREF_ATTRIBUTE_NAME, attr);
                if (hrefAttrValue != null) {
                    idString = hrefAttrValue;
                } else if (idrefAttrValue != null) {
                    idString = idrefAttrValue;
                }
                MetaclassInstance metaclass = (MetaclassInstance)parentInstance;
                if (idString != null) {
                    long featureID;
                    String featureURI = URIHelper.getFeatureURI((String)parentMetaclassURI, (String)localName);
                    try {
                        featureID = this.idHelper.getMetaClassFeatureID(featureURI, this.request.getUserName());
                    }
                    catch (IDException e) {
                        throw new SAXException((Exception)((Object)e));
                    }
                    metaclass.setFeatureValue(featureURI, new Long(featureID));
                    this.processAttributeForRelationshipsTable(metaclass, parentIDData, idString, new Long(featureID), false);
                } else {
                    String metaclassURI = metaclass.getMetaclassURI();
                    String featureURI = URIHelper.getFeatureURI((String)metaclassURI, (String)localName);
                    stackObject = new FeatureInstance(featureURI);
                }
            }
            this.objectInstanceStack.push(stackObject);
        }
    }

    public void startPrefixMapping(String prefix, String url) throws SAXException {
        NonSynchronizedStack stack = (NonSynchronizedStack)this.prefixToURIMapping.get(prefix);
        if (stack == null) {
            stack = new NonSynchronizedStack();
            stack.push((Object)url);
            this.prefixToURIMapping.put(prefix, stack);
        } else {
            stack.push((Object)url);
        }
        if (!this.metamodelIDs.contains(url) && !XMI_URI.equals(url)) {
            this.metamodelIDs.add(url);
        }
    }

    public abstract List getDBIDToInsertDataList(Object var1, String var2);

    public abstract boolean representsADBID(String var1);

    public abstract Object getDBIDForString(String var1);

    private String getNamespace(String prefix) {
        String namespace = null;
        NonSynchronizedStack stack = (NonSynchronizedStack)this.prefixToURIMapping.get(prefix);
        if (stack != null && stack.size() > 0) {
            namespace = (String)stack.peek();
        }
        return namespace;
    }

    protected List getIDInsertData(Attributes attr) {
        if (attr == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("XMIModelProcessorHandler.The_Attributes_Object_instance_passed_into_the_getIDInsertData_method_was_null.__This_is_not_a_valid_parameter_value._1"));
        }
        String uuidString = this.getAttrValue(XMI_URI, XMI_UUID_ATTRIBUTE_NAME, attr);
        List idInsertData = null;
        if (uuidString == null) {
            ObjectID dbID = this.idGenerator.create();
            String logicalID = this.getLogicalIDFromAttributes(attr);
            if (logicalID != null) {
                this.lgclIDsToDBID.put(logicalID, dbID);
            } else {
                logicalID = dbID.toString();
            }
            idInsertData = this.getDBIDToInsertDataList(dbID, logicalID);
        } else if (this.representsADBID(uuidString)) {
            Object dbID = this.getDBIDForString(uuidString);
            String lgclID = this.getLogicalIDFromAttributes(attr);
            if (lgclID != null) {
                this.lgclIDsToDBID.put(lgclID, dbID);
            }
            idInsertData = this.getDBIDToInsertDataList(dbID, lgclID);
        } else {
            String logicalID;
            Object dbID = this.lgclIDsToDBID.get(uuidString);
            if (dbID == null && (dbID = this.lgclIDsToDBID.get(logicalID = this.getLogicalIDFromAttributes(attr))) == null) {
                dbID = this.idGenerator.create();
                this.lgclIDsToDBID.put(uuidString, dbID);
                if (logicalID != null) {
                    this.lgclIDsToDBID.put(logicalID, dbID);
                }
            }
            idInsertData = this.getDBIDToInsertDataList(dbID, uuidString);
        }
        return idInsertData;
    }

    protected String getLogicalIDFromAttributes(Attributes attr) {
        String logicalID = null;
        String uuidAttrValue = this.getAttrValue(XMI_URI, XMI_UUID_ATTRIBUTE_NAME, attr);
        if (uuidAttrValue == null && !this.representsADBID(uuidAttrValue)) {
            String idAttrValue = this.getAttrValue(XMI_URI, XMI_ID_ATTRIBUTE_NAME, attr);
            if (idAttrValue != null) {
                logicalID = this.makeRelativeReferenceLogicalIDAbsolute(idAttrValue, this.request.getModelRepositoryPath());
            }
        } else {
            logicalID = this.getDBIDForString(uuidAttrValue).toString();
        }
        return logicalID;
    }

    protected void processElementForIndexTable(String metaclassURI, long metaClassURIID, Attributes attr, List idInsertData, List parentIDData) {
        String nameValue = attr.getValue(NAME_ATTRIBUTE);
        ArrayList<Object> insertData = new ArrayList<Object>(16);
        insertData.addAll(idInsertData);
        insertData.add(nameValue);
        String insertStatement = JDBCTranslator.INSERT_INDEX_TABLE;
        String targetMetaclassSpecificTableName = this.insertMappingHelper.getTableNameForMetaclassURI(metaclassURI);
        insertData.add(targetMetaclassSpecificTableName);
        String targetMetaclassSpecificVirtualTableName = this.insertMappingHelper.getVirtualTableNameForMetaclassURI(metaclassURI);
        insertData.add(targetMetaclassSpecificVirtualTableName);
        List modelIDData = this.getModelIDData();
        insertData.addAll(modelIDData);
        insertData.add(new Long(metaClassURIID));
        insertData.addAll(parentIDData);
        insertData.add(new Long(this.request.getTransactionID()));
        this.target.put(insertStatement, insertData, JDBCNames.ObjectIndexTable.ALL_COLUMNS_SQLTYPE, this.request);
    }

    protected MetaclassInstance createMetaclassInstance(String metaclassURI, long metaclassURIID, Attributes attr, List idInsertData, String insertStatement) throws ProcessingException {
        MetaclassInstance instance = new MetaclassInstance(idInsertData, metaclassURI, insertStatement, this.insertMappingHelper, metaclassURIID, this.request);
        int length = attr.getLength();
        int i = 0;
        while (i != length) {
            String attrName = attr.getLocalName(i);
            String attrValue = attr.getValue(i);
            if (!notFeaturesNamespaces.contains(attr.getURI(i)) && !MetamodelsDBConstants.MM_SPECIFIC_FEATURES_EXCLUDED.contains(attrName)) {
                String featureURI = String.valueOf(metaclassURI) + "/" + attrName;
                if (this.insertMappingHelper.getFeatureDefaultEType(featureURI) != null) {
                    Long featureURIID;
                    try {
                        featureURIID = new Long(this.idHelper.getMetaClassFeatureID(featureURI, this.request.getUserName()));
                    }
                    catch (IDException e) {
                        throw new ProcessingException((Throwable)((Object)e));
                    }
                    instance.setFeatureValue(featureURI, featureURIID);
                    this.processAttributeForRelationshipsTable(instance, idInsertData, attrValue, featureURIID, true);
                } else {
                    instance.setFeatureValue(featureURI, attrValue);
                }
            }
            ++i;
        }
        return instance;
    }

    protected void processAttributeForRelationshipsTable(MetaclassInstance referrer, List referrerIDList, String value, Long featureURIID, boolean isValueNMTOKEN) {
        if (isValueNMTOKEN) {
            List values = XMIStringUtil.parseXmlListAttributeValue(value);
            Iterator iter = values.iterator();
            int i = 0;
            while (iter.hasNext()) {
                String token = (String)iter.next();
                this.processAttributeForRelationshipsTable(referrerIDList, token, featureURIID, i);
                ++i;
            }
        } else if (value != null) {
            if (value.indexOf(StringUtil.Constants.SPACE) != -1) {
                Object[] params = new Object[]{value};
                DBModelPlugin.Util.log(1, DBModelPlugin.Util.getString("XMIModelProcessorHandler.A_href_attribute_value_was_found_in_the_XMI", params));
            }
            int refPosition = referrer.getReferenceTypeFeaturePosition(featureURIID);
            this.processAttributeForRelationshipsTable(referrerIDList, value, featureURIID, refPosition);
        }
    }

    protected void processAttributeForRelationshipsTable(List referrerIDList, String token, Long featureURIID, int referencePosition) {
        String referreeStringID = null;
        if (XMIStringUtil.isAttributeValueAHref(token)) {
            referreeStringID = XMIStringUtil.getLocalXmiIdFromHrefAttributeValue(token);
        } else {
            if (token != null && token.startsWith("#")) {
                token = token.substring(1);
            }
            referreeStringID = token;
        }
        List referreeIDList = null;
        boolean representsADIBD = this.representsADBID(referreeStringID);
        if (representsADIBD) {
            Object referreeID = this.getDBIDForString(referreeStringID);
            referreeIDList = this.getDBIDToInsertDataList(referreeID, referreeID.toString());
        } else {
            token = this.makeRelativeReferenceLogicalIDAbsolute(token, this.request.getModelRepositoryPath());
            Object referreeID = this.getDBIDForLogicalID(referreeStringID);
            referreeIDList = this.getDBIDToInsertDataList(referreeID, token);
        }
        ArrayList<Number> insertData = new ArrayList<Number>(11);
        insertData.addAll(referrerIDList);
        insertData.addAll(referreeIDList);
        insertData.add(new Integer(referencePosition));
        insertData.add(featureURIID);
        insertData.add(new Long(this.request.getTransactionID()));
        this.target.put(JDBCTranslator.INSERT_RELATIONSIPS_TABLE, insertData, JDBCNames.RelationshipsTable.ALL_COLUMNS_SQLTYPE, this.request);
    }

    protected String makeRelativeReferenceLogicalIDAbsolute(String relativeLogicalID, String modelRepositoryPath) {
        boolean doesIDRepresentHREF = XMIStringUtil.isAttributeValueAHref(relativeLogicalID);
        String absoluteID = relativeLogicalID;
        if (doesIDRepresentHREF) {
            if (modelRepositoryPath != null) {
                String relativePathURI = XMIStringUtil.getUriFromHrefAttributeValue(relativeLogicalID);
                String objectID = XMIStringUtil.getLocalXmiIdFromHrefAttributeValue(relativeLogicalID);
                if (relativePathURI != null) {
                    String absoluteURI = this.converter.makeAbsolute(relativePathURI, modelRepositoryPath);
                    absoluteID = String.valueOf(absoluteURI) + "#" + objectID;
                }
            }
        } else {
            absoluteID = String.valueOf(modelRepositoryPath) + "#" + relativeLogicalID;
        }
        return absoluteID;
    }

    protected String getMetaClassURIForElement(String nsURI, String localName, String qName, Attributes attr) {
        String metaclassURI = null;
        if (this.getAttrValue(XMI_URI, HREF_ATTRIBUTE_NAME, attr) == null && this.getAttrValue(XMI_URI, IDREF_ATTRIBUTE_NAME, attr) == null) {
            String typeAttrValue = attr.getValue(XSI_URI, TYPE_ATTRIBUTE_NAME);
            if (typeAttrValue != null && typeAttrValue.length() > 0) {
                String localAttrName = null;
                String namespaceURI = null;
                String prefixName = XMIStringUtil.getPrefixFromAttributeValue(typeAttrValue);
                if (prefixName != null) {
                    localAttrName = XMIStringUtil.getLocalNameFromPrefixedAttributeValue(typeAttrValue);
                    namespaceURI = this.getNamespace(prefixName);
                } else {
                    namespaceURI = this.getCurrentDefaultNamespace();
                    localAttrName = typeAttrValue;
                }
                metaclassURI = URIHelper.getMetaClassURI((String)namespaceURI, (String)localAttrName);
            } else {
                Object stackObject = this.objectInstanceStack.peek();
                if (stackObject != null && stackObject instanceof MetaclassInstance) {
                    MetaclassInstance metaclassInstance = (MetaclassInstance)stackObject;
                    String parentMetaclassURI = metaclassInstance.getMetaclassURI();
                    String featureURI = URIHelper.getFeatureURI((String)parentMetaclassURI, (String)localName);
                    metaclassURI = this.insertMappingHelper.getFeatureDefaultEType(featureURI);
                } else {
                    if (nsURI == null) {
                        nsURI = this.getCurrentDefaultNamespace();
                    }
                    metaclassURI = URIHelper.getMetaClassURI((String)nsURI, (String)localName);
                }
            }
        }
        if (this.insertMappingHelper.getInsertStatementForMetaclassURI(metaclassURI) != null) {
            return metaclassURI;
        }
        return null;
    }

    protected Object getDBIDForLogicalID(String logicalID) {
        Object dbID = this.lgclIDsToDBID.get(logicalID);
        if (dbID == null) {
            dbID = this.idGenerator.create();
            this.lgclIDsToDBID.put(logicalID, dbID);
        }
        return dbID;
    }

    protected void loadMetamodelsToModelsIntersectTable(List idData) throws ProcessingException {
        List ids;
        try {
            ids = this.idHelper.getMetaModelIDs(this.metamodelIDs, this.request.getUserName());
        }
        catch (IDException e) {
            throw new ProcessingException((Throwable)((Object)e));
        }
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            Long metamodelID = (Long)iter.next();
            ArrayList<Long> insertData = new ArrayList<Long>(idData);
            insertData.add(metamodelID);
            insertData.add(new Long(this.request.getTransactionID()));
            this.target.put(JDBCTranslator.INSERT_MDL_METAMODEL_INTERSECT_TABLE, insertData, JDBCNames.ModelMetamodelIntersectTable.ALL_COLUMNS_SQLTYPE, this.request);
        }
    }

    protected void loadModelsTable(List idData) {
        ArrayList<Object> insertData = new ArrayList<Object>(idData);
        insertData.add(this.request.getModelName());
        insertData.add(new Long(this.request.getTransactionID()));
        insertData.add(this.request.getModelVersion());
        this.target.put(JDBCTranslator.INSERT_MDL_TABLE, insertData, JDBCNames.ModelsTable.ALL_COLUMNS_SQLTYPE, this.request);
        this.target.flush();
    }

    protected List getModelIDData() {
        if (this.modelIDData == null) {
            Object idObject = this.request.getModelID();
            this.modelIDData = new ArrayList();
            if (idObject != null) {
                int i = 0;
                while (i != 4) {
                    this.modelIDData.add(null);
                    ++i;
                }
                if (idObject instanceof UUID) {
                    UUID uuid = (UUID)idObject;
                    Long uuid1 = new Long(UUID.getPart1((ObjectID)uuid));
                    Long uuid2 = new Long(UUID.getPart2((ObjectID)uuid));
                    String uuidString = uuid.toString();
                    this.modelIDData.set(1, uuid1);
                    this.modelIDData.set(2, uuid2);
                    this.modelIDData.set(3, uuidString);
                } else {
                    String logicalID = idObject.toString();
                    this.modelIDData.set(0, logicalID);
                }
            }
        }
        return Collections.unmodifiableList(this.modelIDData);
    }

    protected String getAttrValue(String nsURI, String attrName, Attributes attr) {
        String value = attr.getValue(nsURI, attrName);
        if (value == null) {
            value = attr.getValue(attrName);
        }
        return value;
    }

    protected String getCurrentDefaultNamespace() {
        String ns = null;
        Object objectStack = this.prefixToURIMapping.get("");
        if (objectStack != null) {
            NonSynchronizedStack stack = (NonSynchronizedStack)objectStack;
            ns = (String)stack.peek();
        }
        return ns;
    }
}

